/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.content.Intent;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.net.wifi.NetworkUpdateResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiNative;
import android.net.wifi.WifiSsid;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.UserHandle;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WifiConfigStore {
    private Context mContext;
    private static final String TAG = "WifiConfigStore";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String SUPPLICANT_CONFIG_FILE = "/data/misc/wifi/wpa_supplicant.conf";
    private HashMap<Integer, WifiConfiguration> mConfiguredNetworks = new HashMap();
    private HashMap<Integer, Integer> mNetworkIds = new HashMap();
    private int mLastPriority = -1;
    private static final String ipConfigFile = Environment.getDataDirectory() + "/misc/wifi/ipconfig.txt";
    private static final int IPCONFIG_FILE_VERSION = 2;
    private static final String ID_KEY = "id";
    private static final String IP_ASSIGNMENT_KEY = "ipAssignment";
    private static final String LINK_ADDRESS_KEY = "linkAddress";
    private static final String GATEWAY_KEY = "gateway";
    private static final String DNS_KEY = "dns";
    private static final String PROXY_SETTINGS_KEY = "proxySettings";
    private static final String PROXY_HOST_KEY = "proxyHost";
    private static final String PROXY_PORT_KEY = "proxyPort";
    private static final String PROXY_PAC_FILE = "proxyPac";
    private static final String EXCLUSION_LIST_KEY = "exclusionList";
    private static final String EOS = "eos";
    private final LocalLog mLocalLog;
    private final WpaConfigFileObserver mFileObserver;
    private WifiNative mWifiNative;
    private final KeyStore mKeyStore = KeyStore.getInstance();

    WifiConfigStore(Context c, WifiNative wn) {
        this.mContext = c;
        this.mWifiNative = wn;
        this.mLocalLog = null;
        this.mFileObserver = null;
    }

    void loadAndEnableAllNetworks() {
        this.log("Loading config and enabling all networks");
        this.loadConfiguredNetworks();
        this.enableAllNetworks();
    }

    List<WifiConfiguration> getConfiguredNetworks() {
        ArrayList<WifiConfiguration> networks = new ArrayList<WifiConfiguration>();
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            networks.add(new WifiConfiguration(config));
        }
        return networks;
    }

    void enableAllNetworks() {
        boolean networkEnabledStateChanged = false;
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            if (config == null || config.status != 1) continue;
            if (this.mWifiNative.enableNetwork(config.networkId, false)) {
                networkEnabledStateChanged = true;
                config.status = 2;
                continue;
            }
            this.loge("Enable network failed on " + config.networkId);
        }
        if (networkEnabledStateChanged) {
            this.mWifiNative.saveConfig();
            this.sendConfiguredNetworksChangedBroadcast();
        }
    }

    boolean selectNetwork(int netId) {
        if (netId == -1) {
            return false;
        }
        if (this.mLastPriority == -1 || this.mLastPriority > 1000000) {
            for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
                if (config.networkId == -1) continue;
                config.priority = 0;
                this.addOrUpdateNetworkNative(config);
            }
            this.mLastPriority = 0;
        }
        WifiConfiguration config = new WifiConfiguration();
        config.networkId = netId;
        config.priority = ++this.mLastPriority;
        this.addOrUpdateNetworkNative(config);
        this.mWifiNative.saveConfig();
        this.enableNetworkWithoutBroadcast(netId, true);
        return true;
    }

    NetworkUpdateResult saveNetwork(WifiConfiguration config) {
        if (config == null || config.networkId == -1 && config.SSID == null) {
            return new NetworkUpdateResult(-1);
        }
        boolean newNetwork = config.networkId == -1;
        NetworkUpdateResult result = this.addOrUpdateNetworkNative(config);
        int netId = result.getNetworkId();
        if (newNetwork && netId != -1) {
            this.mWifiNative.enableNetwork(netId, false);
            this.mConfiguredNetworks.get((Object)Integer.valueOf((int)netId)).status = 2;
        }
        this.mWifiNative.saveConfig();
        this.sendConfiguredNetworksChangedBroadcast(config, result.isNewNetwork() ? 0 : 2);
        return result;
    }

    void updateStatus(int netId, NetworkInfo.DetailedState state) {
        if (netId != -1) {
            WifiConfiguration config = this.mConfiguredNetworks.get(netId);
            if (config == null) {
                return;
            }
            switch (state) {
                case CONNECTED: {
                    config.status = 0;
                    break;
                }
                case DISCONNECTED: {
                    if (config.status != 0) break;
                    config.status = 2;
                    break;
                }
            }
        }
    }

    boolean forgetNetwork(int netId) {
        if (this.mWifiNative.removeNetwork(netId)) {
            this.mWifiNative.saveConfig();
            this.removeConfigAndSendBroadcastIfNeeded(netId);
            return true;
        }
        this.loge("Failed to remove network " + netId);
        return false;
    }

    int addOrUpdateNetwork(WifiConfiguration config) {
        NetworkUpdateResult result = this.addOrUpdateNetworkNative(config);
        if (result.getNetworkId() != -1) {
            this.sendConfiguredNetworksChangedBroadcast(this.mConfiguredNetworks.get(result.getNetworkId()), result.isNewNetwork ? 0 : 2);
        }
        return result.getNetworkId();
    }

    boolean removeNetwork(int netId) {
        boolean ret = this.mWifiNative.removeNetwork(netId);
        if (ret) {
            this.removeConfigAndSendBroadcastIfNeeded(netId);
        }
        return ret;
    }

    private void removeConfigAndSendBroadcastIfNeeded(int netId) {
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null) {
            if (config.enterpriseConfig != null) {
                config.enterpriseConfig.removeKeys(this.mKeyStore);
            }
            this.mConfiguredNetworks.remove(netId);
            this.mNetworkIds.remove(WifiConfigStore.configKey(config));
            this.writeIpAndProxyConfigurations();
            this.sendConfiguredNetworksChangedBroadcast(config, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enableNetwork(int netId, boolean disableOthers) {
        boolean ret = this.enableNetworkWithoutBroadcast(netId, disableOthers);
        if (disableOthers) {
            this.sendConfiguredNetworksChangedBroadcast();
        } else {
            WifiConfiguration enabledNetwork = null;
            HashMap<Integer, WifiConfiguration> hashMap = this.mConfiguredNetworks;
            synchronized (hashMap) {
                enabledNetwork = this.mConfiguredNetworks.get(netId);
            }
            if (enabledNetwork != null) {
                this.sendConfiguredNetworksChangedBroadcast(enabledNetwork, 2);
            }
        }
        return ret;
    }

    boolean enableNetworkWithoutBroadcast(int netId, boolean disableOthers) {
        boolean ret = this.mWifiNative.enableNetwork(netId, disableOthers);
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null) {
            config.status = 2;
        }
        if (disableOthers) {
            this.markAllNetworksDisabledExcept(netId);
        }
        return ret;
    }

    void disableAllNetworks() {
        boolean networkDisabled = false;
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            if (config == null || config.status == 1) continue;
            if (this.mWifiNative.disableNetwork(config.networkId)) {
                networkDisabled = true;
                config.status = 1;
                continue;
            }
            this.loge("Disable network failed on " + config.networkId);
        }
        if (networkDisabled) {
            this.sendConfiguredNetworksChangedBroadcast();
        }
    }

    boolean disableNetwork(int netId) {
        return this.disableNetwork(netId, 0);
    }

    boolean disableNetwork(int netId, int reason) {
        boolean ret = this.mWifiNative.disableNetwork(netId);
        WifiConfiguration network = null;
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null && config.status != 1) {
            config.status = 1;
            config.disableReason = reason;
            network = config;
        }
        if (network != null) {
            this.sendConfiguredNetworksChangedBroadcast(network, 2);
        }
        return ret;
    }

    boolean saveConfig() {
        return this.mWifiNative.saveConfig();
    }

    WpsResult startWpsWithPinFromAccessPoint(WpsInfo config) {
        WpsResult result = new WpsResult();
        if (this.mWifiNative.startWpsRegistrar(config.BSSID, config.pin)) {
            this.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            this.loge("Failed to start WPS pin method configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    WpsResult startWpsWithPinFromDevice(WpsInfo config) {
        WpsResult result = new WpsResult();
        result.pin = this.mWifiNative.startWpsPinDisplay(config.BSSID);
        if (!TextUtils.isEmpty(result.pin)) {
            this.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            this.loge("Failed to start WPS pin method configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    WpsResult startWpsPbc(WpsInfo config) {
        WpsResult result = new WpsResult();
        if (this.mWifiNative.startWpsPbc(config.BSSID)) {
            this.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            this.loge("Failed to start WPS push button configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    LinkProperties getLinkProperties(int netId) {
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null) {
            return new LinkProperties(config.linkProperties);
        }
        return null;
    }

    void setLinkProperties(int netId, LinkProperties linkProperties) {
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null) {
            if (config.linkProperties != null) {
                linkProperties.setHttpProxy(config.linkProperties.getHttpProxy());
            }
            config.linkProperties = linkProperties;
        }
    }

    void clearLinkProperties(int netId) {
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        if (config != null && config.linkProperties != null) {
            ProxyProperties proxy = config.linkProperties.getHttpProxy();
            config.linkProperties.clear();
            config.linkProperties.setHttpProxy(proxy);
        }
    }

    ProxyProperties getProxyProperties(int netId) {
        LinkProperties linkProperties = this.getLinkProperties(netId);
        if (linkProperties != null) {
            return new ProxyProperties(linkProperties.getHttpProxy());
        }
        return null;
    }

    boolean isUsingStaticIp(int netId) {
        WifiConfiguration config = this.mConfiguredNetworks.get(netId);
        return config != null && config.ipAssignment == WifiConfiguration.IpAssignment.STATIC;
    }

    private void sendConfiguredNetworksChangedBroadcast(WifiConfiguration network, int reason) {
        Intent intent = new Intent("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        intent.addFlags(0x4000000);
        intent.putExtra("multipleChanges", false);
        intent.putExtra("wifiConfiguration", network);
        intent.putExtra("changeReason", reason);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void sendConfiguredNetworksChangedBroadcast() {
        Intent intent = new Intent("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        intent.addFlags(0x4000000);
        intent.putExtra("multipleChanges", true);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadConfiguredNetworks() {
        String listStr = this.mWifiNative.listNetworks();
        this.mLastPriority = 0;
        this.mConfiguredNetworks.clear();
        this.mNetworkIds.clear();
        if (listStr == null) {
            return;
        }
        String[] lines = listStr.split("\n");
        for (int i = 1; i < lines.length; ++i) {
            String[] result = lines[i].split("\t");
            WifiConfiguration config = new WifiConfiguration();
            try {
                config.networkId = Integer.parseInt(result[0]);
            }
            catch (NumberFormatException e) {
                this.loge("Failed to read network-id '" + result[0] + "'");
                continue;
            }
            config.status = result.length > 3 ? (result[3].indexOf("[CURRENT]") != -1 ? 0 : (result[3].indexOf("[DISABLED]") != -1 ? 1 : 2)) : 2;
            this.readNetworkVariables(config);
            if (config.priority > this.mLastPriority) {
                this.mLastPriority = config.priority;
            }
            config.ipAssignment = WifiConfiguration.IpAssignment.DHCP;
            config.proxySettings = WifiConfiguration.ProxySettings.NONE;
            if (this.mNetworkIds.containsKey(WifiConfigStore.configKey(config))) continue;
            this.mConfiguredNetworks.put(config.networkId, config);
            this.mNetworkIds.put(WifiConfigStore.configKey(config), config.networkId);
        }
        this.readIpAndProxyConfigurations();
        this.sendConfiguredNetworksChangedBroadcast();
        if (this.mNetworkIds.size() == 0) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(SUPPLICANT_CONFIG_FILE));
                String line = reader.readLine();
                while (line != null) {
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private void markAllNetworksDisabledExcept(int netId) {
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            if (config == null || config.networkId == netId || config.status == 1) continue;
            config.status = 1;
            config.disableReason = 0;
        }
    }

    private void markAllNetworksDisabled() {
        this.markAllNetworksDisabledExcept(-1);
    }

    boolean needsUnlockedKeyStore() {
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            if (!config.allowedKeyManagement.get(2) || !config.allowedKeyManagement.get(3) || !config.enterpriseConfig.needsSoftwareBackedKeyStore()) continue;
            return true;
        }
        return false;
    }

    private void writeIpAndProxyConfigurations() {
        ArrayList<WifiConfiguration> networks = new ArrayList<WifiConfiguration>();
        for (WifiConfiguration config : this.mConfiguredNetworks.values()) {
            networks.add(new WifiConfiguration(config));
        }
        DelayedDiskWrite.write(networks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIpAndProxyConfigurations() {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(ipConfigFile)));
            int version = ((DataInputStream)in).readInt();
            if (version != 2 && version != 1) {
                this.loge("Bad version on IP configuration file, ignore read");
                return;
            }
            try {
                while (true) {
                    int id2 = -1;
                    WifiConfiguration.IpAssignment ipAssignment = WifiConfiguration.IpAssignment.DHCP;
                    WifiConfiguration.ProxySettings proxySettings = WifiConfiguration.ProxySettings.NONE;
                    LinkProperties linkProperties = new LinkProperties();
                    String proxyHost = null;
                    String pacFileUrl = null;
                    int proxyPort = -1;
                    String exclusionList = null;
                    while (true) {
                        String key = ((DataInputStream)in).readUTF();
                        try {
                            if (key.equals(ID_KEY)) {
                                id2 = ((DataInputStream)in).readInt();
                                continue;
                            }
                            if (key.equals(IP_ASSIGNMENT_KEY)) {
                                ipAssignment = WifiConfiguration.IpAssignment.valueOf(((DataInputStream)in).readUTF());
                                continue;
                            }
                            if (key.equals(LINK_ADDRESS_KEY)) {
                                LinkAddress linkAddr = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                                linkProperties.addLinkAddress(linkAddr);
                                continue;
                            }
                            if (key.equals(GATEWAY_KEY)) {
                                LinkAddress dest = null;
                                InetAddress gateway = null;
                                if (version == 1) {
                                    gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                                } else {
                                    if (((DataInputStream)in).readInt() == 1) {
                                        dest = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                                    }
                                    if (((DataInputStream)in).readInt() == 1) {
                                        gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                                    }
                                }
                                linkProperties.addRoute(new RouteInfo(dest, gateway));
                                continue;
                            }
                            if (key.equals(DNS_KEY)) {
                                linkProperties.addDns(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()));
                                continue;
                            }
                            if (key.equals(PROXY_SETTINGS_KEY)) {
                                proxySettings = WifiConfiguration.ProxySettings.valueOf(((DataInputStream)in).readUTF());
                                continue;
                            }
                            if (key.equals(PROXY_HOST_KEY)) {
                                proxyHost = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(PROXY_PORT_KEY)) {
                                proxyPort = ((DataInputStream)in).readInt();
                                continue;
                            }
                            if (key.equals(PROXY_PAC_FILE)) {
                                pacFileUrl = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(EXCLUSION_LIST_KEY)) {
                                exclusionList = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(EOS)) break;
                            this.loge("Ignore unknown key " + key + "while reading");
                        }
                        catch (IllegalArgumentException e) {
                            this.loge("Ignore invalid address while reading" + e);
                        }
                    }
                    if (id2 != -1) {
                        WifiConfiguration config = this.mConfiguredNetworks.get(this.mNetworkIds.get(id2));
                        if (config == null) {
                            this.loge("configuration found for missing network, ignored");
                            continue;
                        }
                        config.linkProperties = linkProperties;
                        switch (ipAssignment) {
                            case STATIC: 
                            case DHCP: {
                                config.ipAssignment = ipAssignment;
                                break;
                            }
                            case UNASSIGNED: {
                                this.loge("BUG: Found UNASSIGNED IP on file, use DHCP");
                                config.ipAssignment = WifiConfiguration.IpAssignment.DHCP;
                                break;
                            }
                            default: {
                                this.loge("Ignore invalid ip assignment while reading");
                            }
                        }
                        switch (proxySettings) {
                            case STATIC: {
                                config.proxySettings = proxySettings;
                                ProxyProperties proxyProperties = new ProxyProperties(proxyHost, proxyPort, exclusionList);
                                linkProperties.setHttpProxy(proxyProperties);
                                break;
                            }
                            case PAC: {
                                config.proxySettings = proxySettings;
                                ProxyProperties proxyPacProperties = new ProxyProperties(pacFileUrl);
                                linkProperties.setHttpProxy(proxyPacProperties);
                                break;
                            }
                            case NONE: {
                                config.proxySettings = proxySettings;
                                break;
                            }
                            case UNASSIGNED: {
                                this.loge("BUG: Found UNASSIGNED proxy on file, use NONE");
                                config.proxySettings = WifiConfiguration.ProxySettings.NONE;
                                break;
                            }
                            default: {
                                this.loge("Ignore invalid proxy settings while reading");
                            }
                        }
                        continue;
                    }
                    this.log("Missing id while parsing configuration");
                }
            }
            catch (EOFException ignore) {
            }
            catch (IOException e) {
                this.loge("Error parsing configuration" + e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private NetworkUpdateResult addOrUpdateNetworkNative(WifiConfiguration config) {
        block18: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        netId = config.networkId;
                                                        newNetwork = false;
                                                        if (netId == -1) {
                                                            savedNetId = this.mNetworkIds.get(WifiConfigStore.configKey(config));
                                                            if (savedNetId != null) {
                                                                netId = savedNetId;
                                                            } else {
                                                                newNetwork = true;
                                                                netId = this.mWifiNative.addNetwork();
                                                                if (netId < 0) {
                                                                    this.loge("Failed to add a network!");
                                                                    return new NetworkUpdateResult(-1);
                                                                }
                                                            }
                                                        }
                                                        updateFailed = true;
                                                        if (config.SSID == null || this.mWifiNative.setNetworkVariable(netId, "ssid", config.SSID)) break block20;
                                                        this.loge("failed to set SSID: " + config.SSID);
                                                        break block18;
                                                    }
                                                    if (config.BSSID == null || this.mWifiNative.setNetworkVariable(netId, "bssid", config.BSSID)) break block21;
                                                    this.loge("failed to set BSSID: " + config.BSSID);
                                                    break block18;
                                                }
                                                allowedKeyManagementString = this.makeString(config.allowedKeyManagement, WifiConfiguration.KeyMgmt.strings);
                                                if (config.allowedKeyManagement.cardinality() == 0 || this.mWifiNative.setNetworkVariable(netId, "key_mgmt", allowedKeyManagementString)) break block22;
                                                this.loge("failed to set key_mgmt: " + allowedKeyManagementString);
                                                break block18;
                                            }
                                            allowedProtocolsString = this.makeString(config.allowedProtocols, WifiConfiguration.Protocol.strings);
                                            if (config.allowedProtocols.cardinality() == 0 || this.mWifiNative.setNetworkVariable(netId, "proto", allowedProtocolsString)) break block23;
                                            this.loge("failed to set proto: " + allowedProtocolsString);
                                            break block18;
                                        }
                                        allowedAuthAlgorithmsString = this.makeString(config.allowedAuthAlgorithms, WifiConfiguration.AuthAlgorithm.strings);
                                        if (config.allowedAuthAlgorithms.cardinality() == 0 || this.mWifiNative.setNetworkVariable(netId, "auth_alg", allowedAuthAlgorithmsString)) break block24;
                                        this.loge("failed to set auth_alg: " + allowedAuthAlgorithmsString);
                                        break block18;
                                    }
                                    allowedPairwiseCiphersString = this.makeString(config.allowedPairwiseCiphers, WifiConfiguration.PairwiseCipher.strings);
                                    if (config.allowedPairwiseCiphers.cardinality() == 0 || this.mWifiNative.setNetworkVariable(netId, "pairwise", allowedPairwiseCiphersString)) break block25;
                                    this.loge("failed to set pairwise: " + allowedPairwiseCiphersString);
                                    break block18;
                                }
                                allowedGroupCiphersString = this.makeString(config.allowedGroupCiphers, WifiConfiguration.GroupCipher.strings);
                                if (config.allowedGroupCiphers.cardinality() == 0 || this.mWifiNative.setNetworkVariable(netId, "group", allowedGroupCiphersString)) break block26;
                                this.loge("failed to set group: " + allowedGroupCiphersString);
                                break block18;
                            }
                            if (config.preSharedKey == null || config.preSharedKey.equals("*") || this.mWifiNative.setNetworkVariable(netId, "psk", config.preSharedKey)) break block27;
                            this.loge("failed to set psk");
                            break block18;
                        }
                        hasSetKey = false;
                        if (config.wepKeys != null) {
                            for (i = 0; i < config.wepKeys.length; ++i) {
                                if (config.wepKeys[i] == null || config.wepKeys[i].equals("*")) continue;
                                if (!this.mWifiNative.setNetworkVariable(netId, WifiConfiguration.wepKeyVarNames[i], config.wepKeys[i])) {
                                    this.loge("failed to set wep_key" + i + ": " + config.wepKeys[i]);
                                    break block18;
                                }
                                hasSetKey = true;
                            }
                        }
                        if (!hasSetKey || this.mWifiNative.setNetworkVariable(netId, "wep_tx_keyidx", Integer.toString(config.wepTxKeyIndex))) break block28;
                        this.loge("failed to set wep_tx_keyidx: " + config.wepTxKeyIndex);
                        break block18;
                    }
                    if (this.mWifiNative.setNetworkVariable(netId, "priority", Integer.toString(config.priority))) break block29;
                    this.loge(config.SSID + ": failed to set priority: " + config.priority);
                    break block18;
                }
                if (!config.hiddenSSID || this.mWifiNative.setNetworkVariable(netId, "scan_ssid", Integer.toString(config.hiddenSSID != false ? 1 : 0))) break block30;
                this.loge(config.SSID + ": failed to set hiddenSSID: " + config.hiddenSSID);
                break block18;
            }
            if (config.enterpriseConfig == null || config.enterpriseConfig.getEapMethod() == -1) ** GOTO lbl95
            enterpriseConfig = config.enterpriseConfig;
            if (enterpriseConfig.needsKeyStore()) {
                if (this.mKeyStore.state() != KeyStore.State.UNLOCKED) {
                    this.loge(config.SSID + ": key store is locked");
                } else {
                    try {
                        currentConfig = this.mConfiguredNetworks.get(netId);
                        keyId = config.getKeyIdForCredentials(currentConfig);
                        if (!enterpriseConfig.installKeys(this.mKeyStore, keyId)) {
                            this.loge(config.SSID + ": failed to install keys");
                        }
                        ** break block19
                    }
                    catch (IllegalStateException e) {
                        this.loge(config.SSID + " invalid config for key installation");
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                enterpriseFields = enterpriseConfig.getFields();
                for (String key : enterpriseFields.keySet()) {
                    if (this.mWifiNative.setNetworkVariable(netId, key, value = enterpriseFields.get(key))) continue;
                    enterpriseConfig.removeKeys(this.mKeyStore);
                    this.loge(config.SSID + ": failed to set " + key + ": " + value);
                    break block18;
                }
lbl95:
                // 2 sources

                updateFailed = false;
            }
        }
        if (updateFailed) {
            if (newNetwork) {
                this.mWifiNative.removeNetwork(netId);
                this.loge("Failed to set a network variable, removed network: " + netId);
            }
            return new NetworkUpdateResult(-1);
        }
        currentConfig = this.mConfiguredNetworks.get(netId);
        if (currentConfig == null) {
            currentConfig = new WifiConfiguration();
            currentConfig.ipAssignment = WifiConfiguration.IpAssignment.DHCP;
            currentConfig.proxySettings = WifiConfiguration.ProxySettings.NONE;
            currentConfig.networkId = netId;
        }
        this.readNetworkVariables(currentConfig);
        this.mConfiguredNetworks.put(netId, currentConfig);
        this.mNetworkIds.put(WifiConfigStore.configKey(currentConfig), netId);
        result = this.writeIpAndProxyConfigurationsOnChange(currentConfig, config);
        result.setIsNewNetwork(newNetwork);
        result.setNetworkId(netId);
        return result;
    }

    private NetworkUpdateResult writeIpAndProxyConfigurationsOnChange(WifiConfiguration currentConfig, WifiConfiguration newConfig) {
        boolean ipChanged = false;
        boolean proxyChanged = false;
        LinkProperties linkProperties = null;
        switch (newConfig.ipAssignment) {
            case STATIC: {
                boolean routesDiffer;
                Collection<LinkAddress> currentLinkAddresses = currentConfig.linkProperties.getLinkAddresses();
                Collection<LinkAddress> newLinkAddresses = newConfig.linkProperties.getLinkAddresses();
                Collection<InetAddress> currentDnses = currentConfig.linkProperties.getDnses();
                Collection<InetAddress> newDnses = newConfig.linkProperties.getDnses();
                Collection<RouteInfo> currentRoutes = currentConfig.linkProperties.getRoutes();
                Collection<RouteInfo> newRoutes = newConfig.linkProperties.getRoutes();
                boolean linkAddressesDiffer = currentLinkAddresses.size() != newLinkAddresses.size() || !currentLinkAddresses.containsAll(newLinkAddresses);
                boolean dnsesDiffer = currentDnses.size() != newDnses.size() || !currentDnses.containsAll(newDnses);
                boolean bl = routesDiffer = currentRoutes.size() != newRoutes.size() || !currentRoutes.containsAll(newRoutes);
                if (currentConfig.ipAssignment == newConfig.ipAssignment && !linkAddressesDiffer && !dnsesDiffer && !routesDiffer) break;
                ipChanged = true;
                break;
            }
            case DHCP: {
                if (currentConfig.ipAssignment == newConfig.ipAssignment) break;
                ipChanged = true;
                break;
            }
            case UNASSIGNED: {
                break;
            }
            default: {
                this.loge("Ignore invalid ip assignment during write");
            }
        }
        switch (newConfig.proxySettings) {
            case STATIC: 
            case PAC: {
                ProxyProperties newHttpProxy = newConfig.linkProperties.getHttpProxy();
                ProxyProperties currentHttpProxy = currentConfig.linkProperties.getHttpProxy();
                if (newHttpProxy != null) {
                    proxyChanged = !newHttpProxy.equals(currentHttpProxy);
                    break;
                }
                proxyChanged = currentHttpProxy != null;
                break;
            }
            case NONE: {
                if (currentConfig.proxySettings == newConfig.proxySettings) break;
                proxyChanged = true;
                break;
            }
            case UNASSIGNED: {
                break;
            }
            default: {
                this.loge("Ignore invalid proxy configuration during write");
            }
        }
        if (!ipChanged) {
            linkProperties = this.copyIpSettingsFromConfig(currentConfig);
        } else {
            currentConfig.ipAssignment = newConfig.ipAssignment;
            linkProperties = this.copyIpSettingsFromConfig(newConfig);
            this.log("IP config changed SSID = " + currentConfig.SSID + " linkProperties: " + linkProperties.toString());
        }
        if (!proxyChanged) {
            linkProperties.setHttpProxy(currentConfig.linkProperties.getHttpProxy());
        } else {
            currentConfig.proxySettings = newConfig.proxySettings;
            linkProperties.setHttpProxy(newConfig.linkProperties.getHttpProxy());
            this.log("proxy changed SSID = " + currentConfig.SSID);
            if (linkProperties.getHttpProxy() != null) {
                this.log(" proxyProperties: " + linkProperties.getHttpProxy().toString());
            }
        }
        if (ipChanged || proxyChanged) {
            currentConfig.linkProperties = linkProperties;
            this.writeIpAndProxyConfigurations();
            this.sendConfiguredNetworksChangedBroadcast(currentConfig, 2);
        }
        return new NetworkUpdateResult(ipChanged, proxyChanged);
    }

    private LinkProperties copyIpSettingsFromConfig(WifiConfiguration config) {
        LinkProperties linkProperties = new LinkProperties();
        linkProperties.setInterfaceName(config.linkProperties.getInterfaceName());
        for (LinkAddress linkAddr : config.linkProperties.getLinkAddresses()) {
            linkProperties.addLinkAddress(linkAddr);
        }
        for (RouteInfo route : config.linkProperties.getRoutes()) {
            linkProperties.addRoute(route);
        }
        for (InetAddress dns : config.linkProperties.getDnses()) {
            linkProperties.addDns(dns);
        }
        return linkProperties;
    }

    private void readNetworkVariables(WifiConfiguration config) {
        int index;
        int netId = config.networkId;
        if (netId < 0) {
            return;
        }
        String value = this.mWifiNative.getNetworkVariable(netId, "ssid");
        config.SSID = !TextUtils.isEmpty(value) ? (value.charAt(0) != '\"' ? "\"" + WifiSsid.createFromHex(value).toString() + "\"" : value) : null;
        value = this.mWifiNative.getNetworkVariable(netId, "bssid");
        config.BSSID = !TextUtils.isEmpty(value) ? value : null;
        value = this.mWifiNative.getNetworkVariable(netId, "priority");
        config.priority = -1;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.priority = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        value = this.mWifiNative.getNetworkVariable(netId, "scan_ssid");
        config.hiddenSSID = false;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.hiddenSSID = Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        value = this.mWifiNative.getNetworkVariable(netId, "wep_tx_keyidx");
        config.wepTxKeyIndex = -1;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.wepTxKeyIndex = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        for (int i = 0; i < 4; ++i) {
            value = this.mWifiNative.getNetworkVariable(netId, WifiConfiguration.wepKeyVarNames[i]);
            config.wepKeys[i] = !TextUtils.isEmpty(value) ? value : null;
        }
        value = this.mWifiNative.getNetworkVariable(netId, "psk");
        config.preSharedKey = !TextUtils.isEmpty(value) ? value : null;
        value = this.mWifiNative.getNetworkVariable(config.networkId, "proto");
        if (!TextUtils.isEmpty(value)) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = this.lookupString(val, WifiConfiguration.Protocol.strings);
                if (0 > index) continue;
                config.allowedProtocols.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = this.mWifiNative.getNetworkVariable(config.networkId, "key_mgmt"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = this.lookupString(val, WifiConfiguration.KeyMgmt.strings);
                if (0 > index) continue;
                config.allowedKeyManagement.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = this.mWifiNative.getNetworkVariable(config.networkId, "auth_alg"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = this.lookupString(val, WifiConfiguration.AuthAlgorithm.strings);
                if (0 > index) continue;
                config.allowedAuthAlgorithms.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = this.mWifiNative.getNetworkVariable(config.networkId, "pairwise"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = this.lookupString(val, WifiConfiguration.PairwiseCipher.strings);
                if (0 > index) continue;
                config.allowedPairwiseCiphers.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = this.mWifiNative.getNetworkVariable(config.networkId, "group"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = this.lookupString(val, WifiConfiguration.GroupCipher.strings);
                if (0 > index) continue;
                config.allowedGroupCiphers.set(index);
            }
        }
        if (config.enterpriseConfig == null) {
            config.enterpriseConfig = new WifiEnterpriseConfig();
        }
        HashMap<String, String> enterpriseFields = config.enterpriseConfig.getFields();
        for (String key : WifiEnterpriseConfig.getSupplicantKeys()) {
            value = this.mWifiNative.getNetworkVariable(netId, key);
            if (!TextUtils.isEmpty(value)) {
                enterpriseFields.put(key, this.removeDoubleQuotes(value));
                continue;
            }
            enterpriseFields.put(key, "NULL");
        }
        if (config.enterpriseConfig.migrateOldEapTlsNative(this.mWifiNative, netId)) {
            this.saveConfig();
        }
        config.enterpriseConfig.migrateCerts(this.mKeyStore);
        config.enterpriseConfig.initializeSoftwareKeystoreFlag(this.mKeyStore);
    }

    private String removeDoubleQuotes(String string2) {
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private String makeString(BitSet set, String[] strings) {
        StringBuffer buf = new StringBuffer();
        int nextSetBit = -1;
        set = set.get(0, strings.length);
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            buf.append(strings[nextSetBit].replace('_', '-')).append(' ');
        }
        if (set.cardinality() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private int lookupString(String string2, String[] strings) {
        int size = strings.length;
        string2 = string2.replace('-', '_');
        for (int i = 0; i < size; ++i) {
            if (!string2.equals(strings[i])) continue;
            return i;
        }
        this.loge("Failed to look-up a string: " + string2);
        return -1;
    }

    private static int configKey(WifiConfiguration config) {
        String key = config.allowedKeyManagement.get(1) ? config.SSID + WifiConfiguration.KeyMgmt.strings[1] : (config.allowedKeyManagement.get(2) || config.allowedKeyManagement.get(3) ? config.SSID + WifiConfiguration.KeyMgmt.strings[2] : (config.wepKeys[0] != null ? config.SSID + "WEP" : config.SSID + WifiConfiguration.KeyMgmt.strings[0]));
        return key.hashCode();
    }

    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(TAG);
        pw.println("mLastPriority " + this.mLastPriority);
        pw.println("Configured networks");
        for (WifiConfiguration conf : this.getConfiguredNetworks()) {
            pw.println(conf);
        }
        pw.println();
        if (this.mLocalLog != null) {
            pw.println("WifiConfigStore - Log Begin ----");
            this.mLocalLog.dump(fd, pw, args);
            pw.println("WifiConfigStore - Log End ----");
        }
    }

    public String getConfigFile() {
        return ipConfigFile;
    }

    private void loge(String s) {
        Log.e(TAG, s);
    }

    private void log(String s) {
        Log.d(TAG, s);
    }

    private void localLog(String s) {
        if (this.mLocalLog != null) {
            this.mLocalLog.log(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localLog(String s, int netId) {
        WifiConfiguration config;
        if (this.mLocalLog == null) {
            return;
        }
        HashMap<Integer, WifiConfiguration> hashMap = this.mConfiguredNetworks;
        synchronized (hashMap) {
            config = this.mConfiguredNetworks.get(netId);
        }
        if (config != null) {
            this.mLocalLog.log(s + " " + config.getPrintableSsid());
        } else {
            this.mLocalLog.log(s + " " + netId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedDiskWrite {
        private static HandlerThread sDiskWriteHandlerThread;
        private static Handler sDiskWriteHandler;
        private static int sWriteSequence;
        private static final String TAG = "DelayedDiskWrite";

        private DelayedDiskWrite() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void write(final List<WifiConfiguration> networks) {
            Class<DelayedDiskWrite> clazz = DelayedDiskWrite.class;
            synchronized (DelayedDiskWrite.class) {
                if (++sWriteSequence == 1) {
                    sDiskWriteHandlerThread = new HandlerThread("WifiConfigThread");
                    sDiskWriteHandlerThread.start();
                    sDiskWriteHandler = new Handler(sDiskWriteHandlerThread.getLooper());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                sDiskWriteHandler.post(new Runnable(){

                    public void run() {
                        DelayedDiskWrite.onWriteCalled(networks);
                    }
                });
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void onWriteCalled(List<WifiConfiguration> networks) {
            FilterOutputStream out = null;
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ipConfigFile)));
                ((DataOutputStream)out).writeInt(2);
                for (WifiConfiguration config : networks) {
                    boolean writeToFile = false;
                    try {
                        LinkProperties linkProperties = config.linkProperties;
                        switch (config.ipAssignment) {
                            case STATIC: {
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.IP_ASSIGNMENT_KEY);
                                ((DataOutputStream)out).writeUTF(config.ipAssignment.toString());
                                for (LinkAddress linkAddr : linkProperties.getLinkAddresses()) {
                                    ((DataOutputStream)out).writeUTF(WifiConfigStore.LINK_ADDRESS_KEY);
                                    ((DataOutputStream)out).writeUTF(linkAddr.getAddress().getHostAddress());
                                    ((DataOutputStream)out).writeInt(linkAddr.getNetworkPrefixLength());
                                }
                                for (RouteInfo route : linkProperties.getRoutes()) {
                                    ((DataOutputStream)out).writeUTF(WifiConfigStore.GATEWAY_KEY);
                                    LinkAddress dest = route.getDestination();
                                    if (dest != null) {
                                        ((DataOutputStream)out).writeInt(1);
                                        ((DataOutputStream)out).writeUTF(dest.getAddress().getHostAddress());
                                        ((DataOutputStream)out).writeInt(dest.getNetworkPrefixLength());
                                    } else {
                                        ((DataOutputStream)out).writeInt(0);
                                    }
                                    if (route.getGateway() != null) {
                                        ((DataOutputStream)out).writeInt(1);
                                        ((DataOutputStream)out).writeUTF(route.getGateway().getHostAddress());
                                        continue;
                                    }
                                    ((DataOutputStream)out).writeInt(0);
                                }
                                for (InetAddress inetAddr : linkProperties.getDnses()) {
                                    ((DataOutputStream)out).writeUTF(WifiConfigStore.DNS_KEY);
                                    ((DataOutputStream)out).writeUTF(inetAddr.getHostAddress());
                                }
                                writeToFile = true;
                                break;
                            }
                            case DHCP: {
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.IP_ASSIGNMENT_KEY);
                                ((DataOutputStream)out).writeUTF(config.ipAssignment.toString());
                                writeToFile = true;
                                break;
                            }
                            case UNASSIGNED: {
                                break;
                            }
                            default: {
                                DelayedDiskWrite.loge("Ignore invalid ip assignment while writing");
                            }
                        }
                        switch (config.proxySettings) {
                            case STATIC: {
                                ProxyProperties proxyProperties = linkProperties.getHttpProxy();
                                String exclusionList = proxyProperties.getExclusionList();
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_SETTINGS_KEY);
                                ((DataOutputStream)out).writeUTF(config.proxySettings.toString());
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_HOST_KEY);
                                ((DataOutputStream)out).writeUTF(proxyProperties.getHost());
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_PORT_KEY);
                                ((DataOutputStream)out).writeInt(proxyProperties.getPort());
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.EXCLUSION_LIST_KEY);
                                ((DataOutputStream)out).writeUTF(exclusionList);
                                writeToFile = true;
                                break;
                            }
                            case PAC: {
                                ProxyProperties proxyPacProperties = linkProperties.getHttpProxy();
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_SETTINGS_KEY);
                                ((DataOutputStream)out).writeUTF(config.proxySettings.toString());
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_PAC_FILE);
                                ((DataOutputStream)out).writeUTF(proxyPacProperties.getPacFileUrl());
                                writeToFile = true;
                                break;
                            }
                            case NONE: {
                                ((DataOutputStream)out).writeUTF(WifiConfigStore.PROXY_SETTINGS_KEY);
                                ((DataOutputStream)out).writeUTF(config.proxySettings.toString());
                                writeToFile = true;
                                break;
                            }
                            case UNASSIGNED: {
                                break;
                            }
                            default: {
                                DelayedDiskWrite.loge("Ignthisore invalid proxy settings while writing");
                            }
                        }
                        if (writeToFile) {
                            ((DataOutputStream)out).writeUTF(WifiConfigStore.ID_KEY);
                            ((DataOutputStream)out).writeInt(WifiConfigStore.configKey(config));
                        }
                    }
                    catch (NullPointerException e) {
                        DelayedDiskWrite.loge("Failure in writing " + config.linkProperties + e);
                    }
                    ((DataOutputStream)out).writeUTF(WifiConfigStore.EOS);
                }
            }
            catch (IOException e) {
                DelayedDiskWrite.loge("Error writing data file");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                Class<DelayedDiskWrite> clazz = DelayedDiskWrite.class;
                synchronized (DelayedDiskWrite.class) {
                    if (--sWriteSequence == 0) {
                        sDiskWriteHandler.getLooper().quit();
                        sDiskWriteHandler = null;
                        sDiskWriteHandlerThread = null;
                    }
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                }
            }
        }

        private static void loge(String s) {
            Log.e(TAG, s);
        }

        static {
            sWriteSequence = 0;
        }
    }

    class WpaConfigFileObserver
    extends FileObserver {
        public WpaConfigFileObserver() {
            super(WifiConfigStore.SUPPLICANT_CONFIG_FILE, 8);
        }

        public void onEvent(int event, String path) {
            if (event == 8) {
                File file = new File(WifiConfigStore.SUPPLICANT_CONFIG_FILE);
            }
        }
    }
}

