/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.net.IProxyService;
import com.google.android.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacProxySelector
extends ProxySelector {
    private static final String TAG = "PacProxySelector";
    public static final String PROXY_SERVICE = "com.android.net.IProxyService";
    private IProxyService mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService("com.android.net.IProxyService"));
    private final List<Proxy> mDefaultList;

    public PacProxySelector() {
        if (this.mProxyService == null) {
            Log.e(TAG, "PacManager: no proxy service");
        }
        this.mDefaultList = Lists.newArrayList(Proxy.NO_PROXY);
    }

    @Override
    public List<Proxy> select(URI uri) {
        String urlString;
        if (this.mProxyService == null) {
            this.mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService(PROXY_SERVICE));
        }
        if (this.mProxyService == null) {
            Log.e(TAG, "select: no proxy service return NO_PROXY");
            return Lists.newArrayList(Proxy.NO_PROXY);
        }
        String response = null;
        try {
            urlString = uri.toURL().toString();
        }
        catch (MalformedURLException e) {
            urlString = uri.getHost();
        }
        try {
            response = this.mProxyService.resolvePacFile(uri.getHost(), urlString);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (response == null) {
            return this.mDefaultList;
        }
        return PacProxySelector.parseResponse(response);
    }

    private static List<Proxy> parseResponse(String response) {
        String[] split = response.split(";");
        ArrayList<Proxy> ret = Lists.newArrayList();
        for (String s : split) {
            int port;
            String trimmed = s.trim();
            if (trimmed.equals("DIRECT")) {
                ret.add(Proxy.NO_PROXY);
                continue;
            }
            if (!trimmed.startsWith("PROXY ")) continue;
            String[] hostPort = trimmed.substring(6).split(":");
            String host = hostPort[0];
            try {
                port = Integer.parseInt(hostPort[1]);
            }
            catch (Exception e) {
                port = 8080;
            }
            ret.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        }
        if (ret.size() == 0) {
            ret.add(Proxy.NO_PROXY);
        }
        return ret;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress address, IOException failure) {
    }
}

