/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkProperties
implements Parcelable {
    private String mIfaceName;
    private Collection<LinkAddress> mLinkAddresses = new ArrayList<LinkAddress>();
    private Collection<InetAddress> mDnses = new ArrayList<InetAddress>();
    private String mDomains;
    private Collection<RouteInfo> mRoutes = new ArrayList<RouteInfo>();
    private ProxyProperties mHttpProxy;
    private int mMtu;
    private Hashtable<String, LinkProperties> mStackedLinks = new Hashtable();
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        @Override
        public LinkProperties createFromParcel(Parcel in) {
            int i;
            LinkProperties netProp = new LinkProperties();
            String iface = in.readString();
            if (iface != null) {
                netProp.setInterfaceName(iface);
            }
            int addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addDns(InetAddress.getByAddress(in.createByteArray()));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            netProp.setDomains(in.readString());
            netProp.setMtu(in.readInt());
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addRoute((RouteInfo)in.readParcelable(null));
            }
            if (in.readByte() == 1) {
                netProp.setHttpProxy((ProxyProperties)in.readParcelable(null));
            }
            ArrayList stackedLinks = new ArrayList();
            in.readList(stackedLinks, LinkProperties.class.getClassLoader());
            for (LinkProperties stackedLink : stackedLinks) {
                netProp.addStackedLink(stackedLink);
            }
            return netProp;
        }

        public LinkProperties[] newArray(int size) {
            return new LinkProperties[size];
        }
    };

    public LinkProperties() {
        this.clear();
    }

    public LinkProperties(LinkProperties source) {
        if (source != null) {
            this.mIfaceName = source.getInterfaceName();
            for (LinkAddress linkAddress : source.getLinkAddresses()) {
                this.mLinkAddresses.add(linkAddress);
            }
            for (InetAddress inetAddress : source.getDnses()) {
                this.mDnses.add(inetAddress);
            }
            this.mDomains = source.getDomains();
            for (RouteInfo routeInfo : source.getRoutes()) {
                this.mRoutes.add(routeInfo);
            }
            this.mHttpProxy = source.getHttpProxy() == null ? null : new ProxyProperties(source.getHttpProxy());
            for (LinkProperties linkProperties : source.mStackedLinks.values()) {
                this.addStackedLink(linkProperties);
            }
            this.setMtu(source.getMtu());
        }
    }

    public void setInterfaceName(String iface) {
        this.mIfaceName = iface;
        ArrayList<RouteInfo> newRoutes = new ArrayList<RouteInfo>(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            newRoutes.add(this.routeWithInterface(route));
        }
        this.mRoutes = newRoutes;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    public Collection<String> getAllInterfaceNames() {
        ArrayList<String> interfaceNames = new ArrayList<String>(this.mStackedLinks.size() + 1);
        if (this.mIfaceName != null) {
            interfaceNames.add(new String(this.mIfaceName));
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            interfaceNames.addAll(stacked.getAllInterfaceNames());
        }
        return interfaceNames;
    }

    public Collection<InetAddress> getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableCollection(addresses);
    }

    public Collection<InetAddress> getAllAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllAddresses());
        }
        return addresses;
    }

    public boolean addLinkAddress(LinkAddress address) {
        if (address != null && !this.mLinkAddresses.contains(address)) {
            this.mLinkAddresses.add(address);
            return true;
        }
        return false;
    }

    public boolean removeLinkAddress(LinkAddress toRemove) {
        return this.mLinkAddresses.remove(toRemove);
    }

    public Collection<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableCollection(this.mLinkAddresses);
    }

    public Collection<LinkAddress> getAllLinkAddresses() {
        ArrayList<LinkAddress> addresses = new ArrayList<LinkAddress>();
        addresses.addAll(this.mLinkAddresses);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllLinkAddresses());
        }
        return addresses;
    }

    public void setLinkAddresses(Collection<LinkAddress> addresses) {
        this.mLinkAddresses.clear();
        for (LinkAddress address : addresses) {
            this.addLinkAddress(address);
        }
    }

    public void addDns(InetAddress dns) {
        if (dns != null) {
            this.mDnses.add(dns);
        }
    }

    public Collection<InetAddress> getDnses() {
        return Collections.unmodifiableCollection(this.mDnses);
    }

    public String getDomains() {
        return this.mDomains;
    }

    public void setDomains(String domains) {
        this.mDomains = domains;
    }

    public void setMtu(int mtu) {
        this.mMtu = mtu;
    }

    public int getMtu() {
        return this.mMtu;
    }

    private RouteInfo routeWithInterface(RouteInfo route) {
        return new RouteInfo(route.getDestination(), route.getGateway(), this.mIfaceName);
    }

    public void addRoute(RouteInfo route) {
        if (route != null) {
            String routeIface = route.getInterface();
            if (routeIface != null && !routeIface.equals(this.mIfaceName)) {
                throw new IllegalArgumentException("Route added with non-matching interface: " + routeIface + " vs. " + this.mIfaceName);
            }
            this.mRoutes.add(this.routeWithInterface(route));
        }
    }

    public Collection<RouteInfo> getRoutes() {
        return Collections.unmodifiableCollection(this.mRoutes);
    }

    public Collection<RouteInfo> getAllRoutes() {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        routes.addAll(this.mRoutes);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            routes.addAll(stacked.getAllRoutes());
        }
        return routes;
    }

    public void setHttpProxy(ProxyProperties proxy) {
        this.mHttpProxy = proxy;
    }

    public ProxyProperties getHttpProxy() {
        return this.mHttpProxy;
    }

    public boolean addStackedLink(LinkProperties link) {
        if (link != null && link.getInterfaceName() != null) {
            this.mStackedLinks.put(link.getInterfaceName(), link);
            return true;
        }
        return false;
    }

    public boolean removeStackedLink(LinkProperties link) {
        if (link != null && link.getInterfaceName() != null) {
            LinkProperties removed = this.mStackedLinks.remove(link.getInterfaceName());
            return removed != null;
        }
        return false;
    }

    public Collection<LinkProperties> getStackedLinks() {
        ArrayList<LinkProperties> stacked = new ArrayList<LinkProperties>();
        for (LinkProperties link : this.mStackedLinks.values()) {
            stacked.add(new LinkProperties(link));
        }
        return Collections.unmodifiableCollection(stacked);
    }

    public void clear() {
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mDomains = null;
        this.mRoutes.clear();
        this.mHttpProxy = null;
        this.mStackedLinks.clear();
        this.mMtu = 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String ifaceName = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String linkAddresses = "LinkAddresses: [";
        for (LinkAddress addr : this.mLinkAddresses) {
            linkAddresses = linkAddresses + addr.toString() + ",";
        }
        linkAddresses = linkAddresses + "] ";
        String dns = "DnsAddresses: [";
        for (InetAddress addr : this.mDnses) {
            dns = dns + addr.getHostAddress() + ",";
        }
        dns = dns + "] ";
        String domainName = "Domains: " + this.mDomains;
        String mtu = "MTU: " + this.mMtu;
        String routes = " Routes: [";
        for (RouteInfo route : this.mRoutes) {
            routes = routes + route.toString() + ",";
        }
        routes = routes + "] ";
        String proxy = this.mHttpProxy == null ? "" : "HttpProxy: " + this.mHttpProxy.toString() + " ";
        String stacked = "";
        if (this.mStackedLinks.values().size() > 0) {
            stacked = stacked + " Stacked: [";
            for (LinkProperties link : this.mStackedLinks.values()) {
                stacked = stacked + " [" + link.toString() + " ],";
            }
            stacked = stacked + "] ";
        }
        return "{" + ifaceName + linkAddresses + routes + dns + domainName + mtu + proxy + stacked + "}";
    }

    public boolean hasIPv4Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv6Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    public boolean isIdenticalInterfaceName(LinkProperties target) {
        return TextUtils.equals(this.getInterfaceName(), target.getInterfaceName());
    }

    public boolean isIdenticalAddresses(LinkProperties target) {
        Collection<InetAddress> targetAddresses = target.getAddresses();
        Collection<InetAddress> sourceAddresses = this.getAddresses();
        return sourceAddresses.size() == targetAddresses.size() ? sourceAddresses.containsAll(targetAddresses) : false;
    }

    public boolean isIdenticalDnses(LinkProperties target) {
        Collection<InetAddress> targetDnses = target.getDnses();
        String targetDomains = target.getDomains();
        if (this.mDomains == null ? targetDomains != null : !this.mDomains.equals(targetDomains)) {
            return false;
        }
        return this.mDnses.size() == targetDnses.size() ? this.mDnses.containsAll(targetDnses) : false;
    }

    public boolean isIdenticalRoutes(LinkProperties target) {
        Collection<RouteInfo> targetRoutes = target.getRoutes();
        return this.mRoutes.size() == targetRoutes.size() ? this.mRoutes.containsAll(targetRoutes) : false;
    }

    public boolean isIdenticalHttpProxy(LinkProperties target) {
        return this.getHttpProxy() == null ? target.getHttpProxy() == null : this.getHttpProxy().equals(target.getHttpProxy());
    }

    public boolean isIdenticalStackedLinks(LinkProperties target) {
        if (!((Object)this.mStackedLinks.keySet()).equals(target.mStackedLinks.keySet())) {
            return false;
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            String iface;
            if (stacked.equals(target.mStackedLinks.get(iface = stacked.getInterfaceName()))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdenticalMtu(LinkProperties target) {
        return this.getMtu() == target.getMtu();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkProperties)) {
            return false;
        }
        LinkProperties target = (LinkProperties)obj;
        return this.isIdenticalInterfaceName(target) && this.isIdenticalAddresses(target) && this.isIdenticalDnses(target) && this.isIdenticalRoutes(target) && this.isIdenticalHttpProxy(target) && this.isIdenticalStackedLinks(target) && this.isIdenticalMtu(target);
    }

    public CompareResult<LinkAddress> compareAddresses(LinkProperties target) {
        CompareResult<LinkAddress> result = new CompareResult<LinkAddress>();
        result.removed = new ArrayList<LinkAddress>(this.mLinkAddresses);
        result.added.clear();
        if (target != null) {
            for (LinkAddress newAddress : target.getLinkAddresses()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<InetAddress> compareDnses(LinkProperties target) {
        CompareResult<InetAddress> result = new CompareResult<InetAddress>();
        result.removed = new ArrayList<InetAddress>(this.mDnses);
        result.added.clear();
        if (target != null) {
            for (InetAddress newAddress : target.getDnses()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<RouteInfo> compareAllRoutes(LinkProperties target) {
        CompareResult<RouteInfo> result = new CompareResult<RouteInfo>();
        result.removed = this.getAllRoutes();
        result.added.clear();
        if (target != null) {
            for (RouteInfo r : target.getAllRoutes()) {
                if (result.removed.remove(r)) continue;
                result.added.add(r);
            }
        }
        return result;
    }

    public int hashCode() {
        return (null == this.mIfaceName ? 0 : this.mIfaceName.hashCode() + this.mLinkAddresses.size() * 31 + this.mDnses.size() * 37 + (null == this.mDomains ? 0 : this.mDomains.hashCode()) + this.mRoutes.size() * 41 + (null == this.mHttpProxy ? 0 : this.mHttpProxy.hashCode()) + this.mStackedLinks.hashCode() * 47) + this.mMtu * 51;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable(linkAddress, flags);
        }
        dest.writeInt(this.mDnses.size());
        for (InetAddress d : this.mDnses) {
            dest.writeByteArray(d.getAddress());
        }
        dest.writeString(this.mDomains);
        dest.writeInt(this.mMtu);
        dest.writeInt(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            dest.writeParcelable(route, flags);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
        ArrayList<LinkProperties> stackedLinks = new ArrayList<LinkProperties>(this.mStackedLinks.values());
        dest.writeList(stackedLinks);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareResult<T> {
        public Collection<T> removed = new ArrayList<T>();
        public Collection<T> added = new ArrayList<T>();

        public String toString() {
            String retVal = "removed=[";
            for (T addr : this.removed) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "] added=[";
            for (T addr : this.added) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "]";
            return retVal;
        }
    }
}

