/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;

public class CaptivePortalTracker
extends StateMachine {
    private static final boolean DBG = true;
    private static final String TAG = "CaptivePortalTracker";
    private static final String DEFAULT_SERVER = "clients3.google.com";
    private static final int SOCKET_TIMEOUT_MS = 10000;
    public static final String ACTION_NETWORK_CONDITIONS_MEASURED = "android.net.conn.NETWORK_CONDITIONS_MEASURED";
    public static final String EXTRA_CONNECTIVITY_TYPE = "extra_connectivity_type";
    public static final String EXTRA_NETWORK_TYPE = "extra_network_type";
    public static final String EXTRA_RESPONSE_RECEIVED = "extra_response_received";
    public static final String EXTRA_IS_CAPTIVE_PORTAL = "extra_is_captive_portal";
    public static final String EXTRA_CELL_ID = "extra_cellid";
    public static final String EXTRA_SSID = "extra_ssid";
    public static final String EXTRA_BSSID = "extra_bssid";
    public static final String EXTRA_REQUEST_TIMESTAMP_MS = "extra_request_timestamp_ms";
    public static final String EXTRA_RESPONSE_TIMESTAMP_MS = "extra_response_timestamp_ms";
    private static final String PERMISSION_ACCESS_NETWORK_CONDITIONS = "android.permission.ACCESS_NETWORK_CONDITIONS";
    private String mServer;
    private String mUrl;
    private boolean mIsCaptivePortalCheckEnabled = false;
    private IConnectivityManager mConnService;
    private TelephonyManager mTelephonyManager;
    private WifiManager mWifiManager;
    private Context mContext;
    private NetworkInfo mNetworkInfo;
    private static final int CMD_DETECT_PORTAL = 0;
    private static final int CMD_CONNECTIVITY_CHANGE = 1;
    private static final int CMD_DELAYED_CAPTIVE_CHECK = 2;
    private static final int DELAYED_CHECK_INTERVAL_MS = 10000;
    private int mDelayedCheckToken = 0;
    private State mDefaultState = new DefaultState();
    private State mNoActiveNetworkState = new NoActiveNetworkState();
    private State mActiveNetworkState = new ActiveNetworkState();
    private State mDelayedCaptiveCheckState = new DelayedCaptiveCheckState();
    private static final String SETUP_WIZARD_PACKAGE = "com.google.android.setupwizard";
    private boolean mDeviceProvisioned = false;
    private ProvisioningObserver mProvisioningObserver;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (CaptivePortalTracker.this.mDeviceProvisioned && action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !CaptivePortalTracker.this.mDeviceProvisioned && action.equals("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE")) {
                NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                CaptivePortalTracker.this.sendMessage(CaptivePortalTracker.this.obtainMessage(1, info));
            }
        }
    };

    private CaptivePortalTracker(Context context, IConnectivityManager cs) {
        super(TAG);
        this.mContext = context;
        this.mConnService = cs;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mProvisioningObserver = new ProvisioningObserver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mServer = Settings.Global.getString(this.mContext.getContentResolver(), "captive_portal_server");
        if (this.mServer == null) {
            this.mServer = DEFAULT_SERVER;
        }
        this.mIsCaptivePortalCheckEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "captive_portal_detection_enabled", 1) == 1;
        this.addState(this.mDefaultState);
        this.addState(this.mNoActiveNetworkState, this.mDefaultState);
        this.addState(this.mActiveNetworkState, this.mDefaultState);
        this.addState(this.mDelayedCaptiveCheckState, this.mActiveNetworkState);
        this.setInitialState(this.mNoActiveNetworkState);
    }

    public static CaptivePortalTracker makeCaptivePortalTracker(Context context, IConnectivityManager cs) {
        CaptivePortalTracker captivePortal = new CaptivePortalTracker(context, cs);
        captivePortal.start();
        return captivePortal;
    }

    public void detectCaptivePortal(NetworkInfo info) {
        this.sendMessage(this.obtainMessage(0, info));
    }

    private void notifyPortalCheckComplete(NetworkInfo info) {
        if (info == null) {
            this.loge("notifyPortalCheckComplete on null");
            return;
        }
        try {
            this.log("notifyPortalCheckComplete: ni=" + info);
            this.mConnService.captivePortalCheckComplete(info);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void notifyPortalCheckCompleted(NetworkInfo info, boolean isCaptivePortal) {
        if (info == null) {
            this.loge("notifyPortalCheckComplete on null");
            return;
        }
        try {
            this.log("notifyPortalCheckCompleted: captive=" + isCaptivePortal + " ni=" + info);
            this.mConnService.captivePortalCheckCompleted(info, isCaptivePortal);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private boolean isActiveNetwork(NetworkInfo info) {
        try {
            NetworkInfo active = this.mConnService.getActiveNetworkInfo();
            if (active != null && active.getType() == info.getType()) {
                return true;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void setNotificationOff() {
        try {
            if (this.mNetworkInfo != null) {
                this.mConnService.setProvisioningNotificationVisible(false, this.mNetworkInfo.getType(), null, null);
            }
        }
        catch (RemoteException e) {
            this.log("setNotificationOff: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCaptivePortal(InetAddress server) {
        HttpURLConnection urlConnection = null;
        if (!this.mIsCaptivePortalCheckEnabled) {
            return false;
        }
        this.mUrl = "http://" + server.getHostAddress() + "/generate_204";
        this.log("Checking " + this.mUrl);
        long requestTimestamp = -1L;
        try {
            URL url = new URL(this.mUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(false);
            requestTimestamp = SystemClock.elapsedRealtime();
            urlConnection.getInputStream();
            long responseTimestamp = SystemClock.elapsedRealtime();
            int rspCode = urlConnection.getResponseCode();
            boolean isCaptivePortal = rspCode != 204;
            this.sendNetworkConditionsBroadcast(true, isCaptivePortal, requestTimestamp, responseTimestamp);
            this.log("isCaptivePortal: ret=" + isCaptivePortal + " rspCode=" + rspCode);
            boolean bl = isCaptivePortal;
            return bl;
        }
        catch (IOException e) {
            this.log("Probably not a portal: exception " + e);
            if (requestTimestamp != -1L) {
                this.sendFailedCaptivePortalCheckBroadcast(requestTimestamp);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private InetAddress lookupHost(String hostname) {
        InetAddress[] inetAddress;
        try {
            inetAddress = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            this.sendFailedCaptivePortalCheckBroadcast(SystemClock.elapsedRealtime());
            return null;
        }
        for (InetAddress a : inetAddress) {
            if (!(a instanceof Inet4Address)) continue;
            return a;
        }
        this.sendFailedCaptivePortalCheckBroadcast(SystemClock.elapsedRealtime());
        return null;
    }

    private void sendFailedCaptivePortalCheckBroadcast(long requestTimestampMs) {
        this.sendNetworkConditionsBroadcast(false, false, requestTimestampMs, 0L);
    }

    private void sendNetworkConditionsBroadcast(boolean responseReceived, boolean isCaptivePortal, long requestTimestampMs, long responseTimestampMs) {
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_scan_always_enabled", 0) == 0) {
            this.log("Don't send network conditions - lacking user consent.");
            return;
        }
        Intent latencyBroadcast = new Intent(ACTION_NETWORK_CONDITIONS_MEASURED);
        switch (this.mNetworkInfo.getType()) {
            case 1: {
                WifiInfo currentWifiInfo = this.mWifiManager.getConnectionInfo();
                if (currentWifiInfo != null) {
                    latencyBroadcast.putExtra(EXTRA_SSID, currentWifiInfo.getSSID());
                    latencyBroadcast.putExtra(EXTRA_BSSID, currentWifiInfo.getBSSID());
                    break;
                }
                this.logw("network info is TYPE_WIFI but no ConnectionInfo found");
                return;
            }
            case 0: {
                latencyBroadcast.putExtra(EXTRA_NETWORK_TYPE, this.mTelephonyManager.getNetworkType());
                List<CellInfo> info = this.mTelephonyManager.getAllCellInfo();
                if (info == null) {
                    return;
                }
                StringBuffer uniqueCellId = new StringBuffer();
                int numRegisteredCellInfo = 0;
                for (CellInfo cellInfo : info) {
                    Parcelable cellId;
                    if (!cellInfo.isRegistered()) continue;
                    if (++numRegisteredCellInfo > 1) {
                        this.log("more than one registered CellInfo.  Can't tell which is active.  Bailing.");
                        return;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        cellId = ((CellInfoCdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoGsm) {
                        cellId = ((CellInfoGsm)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        cellId = ((CellInfoLte)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoWcdma) {
                        cellId = ((CellInfoWcdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    this.logw("Registered cellinfo is unrecognized");
                    return;
                }
                break;
            }
            default: {
                return;
            }
        }
        latencyBroadcast.putExtra(EXTRA_CONNECTIVITY_TYPE, this.mNetworkInfo.getType());
        latencyBroadcast.putExtra(EXTRA_RESPONSE_RECEIVED, responseReceived);
        latencyBroadcast.putExtra(EXTRA_REQUEST_TIMESTAMP_MS, requestTimestampMs);
        if (responseReceived) {
            latencyBroadcast.putExtra(EXTRA_IS_CAPTIVE_PORTAL, isCaptivePortal);
            latencyBroadcast.putExtra(EXTRA_RESPONSE_TIMESTAMP_MS, responseTimestampMs);
        }
        this.mContext.sendBroadcast(latencyBroadcast, PERMISSION_ACCESS_NETWORK_CONDITIONS);
    }

    private class DelayedCaptiveCheckState
    extends State {
        private DelayedCaptiveCheckState() {
        }

        public void enter() {
            Message message = CaptivePortalTracker.this.obtainMessage(2, ++CaptivePortalTracker.this.mDelayedCheckToken, 0);
            if (CaptivePortalTracker.this.mDeviceProvisioned) {
                CaptivePortalTracker.this.sendMessageDelayed(message, 10000L);
            } else {
                CaptivePortalTracker.this.sendMessage(message);
            }
        }

        public boolean processMessage(Message message) {
            CaptivePortalTracker.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 2: {
                    boolean captive;
                    CaptivePortalTracker.this.setNotificationOff();
                    if (message.arg1 != CaptivePortalTracker.this.mDelayedCheckToken) break;
                    InetAddress server = CaptivePortalTracker.this.lookupHost(CaptivePortalTracker.this.mServer);
                    boolean bl = captive = server != null && CaptivePortalTracker.this.isCaptivePortal(server);
                    if (captive) {
                        CaptivePortalTracker.this.log("Captive network " + CaptivePortalTracker.this.mNetworkInfo);
                    } else {
                        CaptivePortalTracker.this.log("Not captive network " + CaptivePortalTracker.this.mNetworkInfo);
                    }
                    CaptivePortalTracker.this.notifyPortalCheckCompleted(CaptivePortalTracker.this.mNetworkInfo, captive);
                    if (CaptivePortalTracker.this.mDeviceProvisioned) {
                        if (captive) {
                            try {
                                CaptivePortalTracker.this.mConnService.setProvisioningNotificationVisible(true, CaptivePortalTracker.this.mNetworkInfo.getType(), CaptivePortalTracker.this.mNetworkInfo.getExtraInfo(), CaptivePortalTracker.this.mUrl);
                            }
                            catch (RemoteException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        Intent intent = new Intent("android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED");
                        intent.putExtra("captivePortal", captive);
                        intent.setPackage(CaptivePortalTracker.SETUP_WIZARD_PACKAGE);
                        CaptivePortalTracker.this.mContext.sendBroadcast(intent);
                    }
                    CaptivePortalTracker.this.transitionTo(CaptivePortalTracker.this.mActiveNetworkState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class ActiveNetworkState
    extends State {
        private ActiveNetworkState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 1: {
                    NetworkInfo info = (NetworkInfo)message.obj;
                    if (!info.isConnected() && info.getType() == CaptivePortalTracker.this.mNetworkInfo.getType()) {
                        CaptivePortalTracker.this.log("Disconnected from active network " + info);
                        CaptivePortalTracker.this.transitionTo(CaptivePortalTracker.this.mNoActiveNetworkState);
                        break;
                    }
                    if (info.getType() == CaptivePortalTracker.this.mNetworkInfo.getType() || !info.isConnected() || !CaptivePortalTracker.this.isActiveNetwork(info)) break;
                    CaptivePortalTracker.this.log("Active network switched " + info);
                    CaptivePortalTracker.this.deferMessage(message);
                    CaptivePortalTracker.this.transitionTo(CaptivePortalTracker.this.mNoActiveNetworkState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class NoActiveNetworkState
    extends State {
        private NoActiveNetworkState() {
        }

        public void enter() {
            CaptivePortalTracker.this.setNotificationOff();
            CaptivePortalTracker.this.mNetworkInfo = null;
        }

        public boolean processMessage(Message message) {
            CaptivePortalTracker.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 1: {
                    NetworkInfo info = (NetworkInfo)message.obj;
                    if (info.getType() == 1) {
                        if (!info.isConnected() || !CaptivePortalTracker.this.isActiveNetwork(info)) break;
                        CaptivePortalTracker.this.mNetworkInfo = info;
                        CaptivePortalTracker.this.transitionTo(CaptivePortalTracker.this.mDelayedCaptiveCheckState);
                        break;
                    }
                    CaptivePortalTracker.this.log(this.getName() + " not a wifi connectivity change, ignore");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        public boolean processMessage(Message message) {
            CaptivePortalTracker.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 0: {
                    NetworkInfo info = (NetworkInfo)message.obj;
                    CaptivePortalTracker.this.notifyPortalCheckComplete(info);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    CaptivePortalTracker.this.loge("Ignoring " + message);
                }
            }
            return true;
        }
    }

    private class ProvisioningObserver
    extends ContentObserver {
        ProvisioningObserver() {
            super(new Handler());
            CaptivePortalTracker.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, this);
            this.onChange(false);
        }

        public void onChange(boolean selfChange) {
            CaptivePortalTracker.this.mDeviceProvisioned = Settings.Global.getInt(CaptivePortalTracker.this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
        }
    }
}

