/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.IContentProvider;
import android.database.Cursor;
import android.mtp.MtpDatabase;
import android.mtp.MtpPropertyList;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.MediaStore;
import android.util.Log;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtpPropertyGroup {
    private static final String TAG = "MtpPropertyGroup";
    private final MtpDatabase mDatabase;
    private final IContentProvider mProvider;
    private final String mPackageName;
    private final String mVolumeName;
    private final Uri mUri;
    private final Property[] mProperties;
    private String[] mColumns;
    private static final String ID_WHERE = "_id=?";
    private static final String FORMAT_WHERE = "format=?";
    private static final String ID_FORMAT_WHERE = "_id=? AND format=?";
    private static final String PARENT_WHERE = "parent=?";
    private static final String PARENT_FORMAT_WHERE = "parent=? AND format=?";

    public MtpPropertyGroup(MtpDatabase database, IContentProvider provider, String packageName, String volume, int[] properties) {
        int i;
        this.mDatabase = database;
        this.mProvider = provider;
        this.mPackageName = packageName;
        this.mVolumeName = volume;
        this.mUri = MediaStore.Files.getMtpObjectsUri(volume);
        int count = properties.length;
        ArrayList<String> columns = new ArrayList<String>(count);
        columns.add("_id");
        this.mProperties = new Property[count];
        for (i = 0; i < count; ++i) {
            this.mProperties[i] = this.createProperty(properties[i], columns);
        }
        count = columns.size();
        this.mColumns = new String[count];
        for (i = 0; i < count; ++i) {
            this.mColumns[i] = columns.get(i);
        }
    }

    private Property createProperty(int code, ArrayList<String> columns) {
        int type;
        String column = null;
        switch (code) {
            case 56321: {
                column = "storage_id";
                type = 6;
                break;
            }
            case 56322: {
                column = "format";
                type = 4;
                break;
            }
            case 56323: {
                type = 4;
                break;
            }
            case 56324: {
                column = "_size";
                type = 8;
                break;
            }
            case 56327: {
                column = "_data";
                type = 65535;
                break;
            }
            case 56388: {
                column = "title";
                type = 65535;
                break;
            }
            case 56329: {
                column = "date_modified";
                type = 65535;
                break;
            }
            case 56398: {
                column = "date_added";
                type = 65535;
                break;
            }
            case 56473: {
                column = "year";
                type = 65535;
                break;
            }
            case 56331: {
                column = "parent";
                type = 6;
                break;
            }
            case 56385: {
                column = "storage_id";
                type = 10;
                break;
            }
            case 56457: {
                column = "duration";
                type = 6;
                break;
            }
            case 56459: {
                column = "track";
                type = 4;
                break;
            }
            case 56544: {
                column = "_display_name";
                type = 65535;
                break;
            }
            case 56390: {
                type = 65535;
                break;
            }
            case 56474: {
                type = 65535;
                break;
            }
            case 56475: {
                column = "album_artist";
                type = 65535;
                break;
            }
            case 56460: {
                type = 65535;
                break;
            }
            case 56470: {
                column = "composer";
                type = 65535;
                break;
            }
            case 56392: {
                column = "description";
                type = 65535;
                break;
            }
            default: {
                type = 0;
                Log.e(TAG, "unsupported property " + code);
            }
        }
        if (column != null) {
            columns.add(column);
            return new Property(code, type, columns.size() - 1);
        }
        return new Property(code, type, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryString(int id2, String column) {
        Cursor c = null;
        try {
            c = this.mProvider.query(this.mPackageName, this.mUri, new String[]{"_id", column}, ID_WHERE, new String[]{Integer.toString(id2)}, null, null);
            if (c != null && c.moveToNext()) {
                String string2 = c.getString(1);
                return string2;
            }
            String string3 = "";
            return string3;
        }
        catch (Exception e) {
            String string4 = null;
            return string4;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryAudio(int id2, String column) {
        Cursor c = null;
        try {
            c = this.mProvider.query(this.mPackageName, MediaStore.Audio.Media.getContentUri(this.mVolumeName), new String[]{"_id", column}, ID_WHERE, new String[]{Integer.toString(id2)}, null, null);
            if (c != null && c.moveToNext()) {
                String string2 = c.getString(1);
                return string2;
            }
            String string3 = "";
            return string3;
        }
        catch (Exception e) {
            String string4 = null;
            return string4;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryGenre(int id2) {
        Cursor c = null;
        try {
            Uri uri = MediaStore.Audio.Genres.getContentUriForAudioId(this.mVolumeName, id2);
            c = this.mProvider.query(this.mPackageName, uri, new String[]{"_id", "name"}, null, null, null, null);
            if (c != null && c.moveToNext()) {
                String string2 = c.getString(1);
                return string2;
            }
            String string3 = "";
            return string3;
        }
        catch (Exception e) {
            Log.e(TAG, "queryGenre exception", e);
            String string4 = null;
            return string4;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long queryLong(int id2, String column) {
        Cursor c = null;
        try {
            c = this.mProvider.query(this.mPackageName, this.mUri, new String[]{"_id", column}, ID_WHERE, new String[]{Integer.toString(id2)}, null, null);
            if (c != null && c.moveToNext()) {
                Long l = new Long(c.getLong(1));
                return l;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    private static String nameFromPath(String path) {
        int end;
        int start = 0;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            start = lastSlash + 1;
        }
        if ((end = path.length()) - start > 255) {
            end = start + 255;
        }
        return path.substring(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MtpPropertyList getPropertyList(int handle, int format, int depth) {
        String[] whereArgs;
        String where;
        if (depth > 1) {
            return new MtpPropertyList(0, 43016);
        }
        if (format == 0) {
            if (handle == -1) {
                where = null;
                whereArgs = null;
            } else {
                whereArgs = new String[]{Integer.toString(handle)};
                where = depth == 1 ? PARENT_WHERE : ID_WHERE;
            }
        } else if (handle == -1) {
            where = FORMAT_WHERE;
            whereArgs = new String[]{Integer.toString(format)};
        } else {
            whereArgs = new String[]{Integer.toString(handle), Integer.toString(format)};
            where = depth == 1 ? PARENT_FORMAT_WHERE : ID_FORMAT_WHERE;
        }
        Cursor c = null;
        try {
            if ((depth > 0 || handle == -1 || this.mColumns.length > 1) && (c = this.mProvider.query(this.mPackageName, this.mUri, this.mColumns, where, whereArgs, null, null)) == null) {
                MtpPropertyList mtpPropertyList = new MtpPropertyList(0, 8201);
                return mtpPropertyList;
            }
            int count = c == null ? 1 : c.getCount();
            MtpPropertyList result = new MtpPropertyList(count * this.mProperties.length, 8193);
            for (int objectIndex = 0; objectIndex < count; ++objectIndex) {
                if (c != null) {
                    c.moveToNext();
                    handle = (int)c.getLong(0);
                }
                block19: for (int propertyIndex = 0; propertyIndex < this.mProperties.length; ++propertyIndex) {
                    Property property = this.mProperties[propertyIndex];
                    int propertyCode = property.code;
                    int column = property.column;
                    switch (propertyCode) {
                        case 56323: {
                            result.append(handle, propertyCode, 4, 0L);
                            continue block19;
                        }
                        case 56327: {
                            String value = c.getString(column);
                            if (value != null) {
                                result.append(handle, propertyCode, MtpPropertyGroup.nameFromPath(value));
                                continue block19;
                            }
                            result.setResult(8201);
                            continue block19;
                        }
                        case 56388: {
                            String name = c.getString(column);
                            if (name == null) {
                                name = this.queryString(handle, "name");
                            }
                            if (name == null && (name = this.queryString(handle, "_data")) != null) {
                                name = MtpPropertyGroup.nameFromPath(name);
                            }
                            if (name != null) {
                                result.append(handle, propertyCode, name);
                                continue block19;
                            }
                            result.setResult(8201);
                            continue block19;
                        }
                        case 56329: 
                        case 56398: {
                            result.append(handle, propertyCode, this.format_date_time(c.getInt(column)));
                            continue block19;
                        }
                        case 56473: {
                            int year = c.getInt(column);
                            String dateTime = Integer.toString(year) + "0101T000000";
                            result.append(handle, propertyCode, dateTime);
                            continue block19;
                        }
                        case 56385: {
                            long puid = c.getLong(column);
                            puid <<= 32;
                            result.append(handle, propertyCode, 10, puid += (long)handle);
                            continue block19;
                        }
                        case 56459: {
                            result.append(handle, propertyCode, 4, c.getInt(column) % 1000);
                            continue block19;
                        }
                        case 56390: {
                            result.append(handle, propertyCode, this.queryAudio(handle, "artist"));
                            continue block19;
                        }
                        case 56474: {
                            result.append(handle, propertyCode, this.queryAudio(handle, "album"));
                            continue block19;
                        }
                        case 56460: {
                            String genre = this.queryGenre(handle);
                            if (genre != null) {
                                result.append(handle, propertyCode, genre);
                                continue block19;
                            }
                            result.setResult(8201);
                            continue block19;
                        }
                        default: {
                            if (property.type == 65535) {
                                result.append(handle, propertyCode, c.getString(column));
                                continue block19;
                            }
                            if (property.type == 0) {
                                result.append(handle, propertyCode, property.type, 0L);
                                continue block19;
                            }
                            result.append(handle, propertyCode, property.type, c.getLong(column));
                        }
                    }
                }
            }
            MtpPropertyList mtpPropertyList = result;
            return mtpPropertyList;
        }
        catch (RemoteException e) {
            MtpPropertyList mtpPropertyList = new MtpPropertyList(0, 8194);
            return mtpPropertyList;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    private native String format_date_time(long var1);

    private class Property {
        int code;
        int type;
        int column;

        Property(int code, int type, int column) {
            this.code = code;
            this.type = type;
            this.column = column;
        }
    }
}

