/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.graphics.Bitmap;
import android.media.videoeditor.Effect;
import android.media.videoeditor.EffectKenBurns;
import android.media.videoeditor.MediaArtistNativeHelper;
import android.media.videoeditor.MediaImageItem;
import android.media.videoeditor.MediaVideoItem;
import android.media.videoeditor.Overlay;
import android.media.videoeditor.OverlayFrame;
import android.media.videoeditor.Transition;
import android.media.videoeditor.VideoEditor;
import android.media.videoeditor.VideoEditorImpl;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaItem {
    public static final int END_OF_FILE = -1;
    public static final int RENDERING_MODE_BLACK_BORDER = 0;
    public static final int RENDERING_MODE_STRETCH = 1;
    public static final int RENDERING_MODE_CROPPING = 2;
    private final String mUniqueId;
    protected final String mFilename;
    private final List<Effect> mEffects;
    private final List<Overlay> mOverlays;
    private int mRenderingMode;
    private final MediaArtistNativeHelper mMANativeHelper;
    private final String mProjectPath;
    protected Transition mBeginTransition;
    protected Transition mEndTransition;
    protected String mGeneratedImageClip;
    protected boolean mRegenerateClip;
    private boolean mBlankFrameGenerated = false;
    private String mBlankFrameFilename = null;

    protected MediaItem(VideoEditor editor, String mediaItemId, String filename, int renderingMode) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("MediaItem : filename is null");
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException(filename + " not found ! ");
        }
        if (0x80000000L <= file.length()) {
            throw new IllegalArgumentException("File size is more than 2GB");
        }
        this.mUniqueId = mediaItemId;
        this.mFilename = filename;
        this.mRenderingMode = renderingMode;
        this.mEffects = new ArrayList<Effect>();
        this.mOverlays = new ArrayList<Overlay>();
        this.mBeginTransition = null;
        this.mEndTransition = null;
        this.mMANativeHelper = ((VideoEditorImpl)editor).getNativeContext();
        this.mProjectPath = editor.getPath();
        this.mRegenerateClip = false;
        this.mGeneratedImageClip = null;
    }

    public String getId() {
        return this.mUniqueId;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void setRenderingMode(int renderingMode) {
        switch (renderingMode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Rendering Mode");
            }
        }
        this.mMANativeHelper.setGeneratePreview(true);
        this.mRenderingMode = renderingMode;
        if (this.mBeginTransition != null) {
            this.mBeginTransition.invalidate();
        }
        if (this.mEndTransition != null) {
            this.mEndTransition.invalidate();
        }
        for (Overlay overlay : this.mOverlays) {
            ((OverlayFrame)overlay).invalidateGeneratedFiles();
        }
    }

    public int getRenderingMode() {
        return this.mRenderingMode;
    }

    void setBeginTransition(Transition transition) {
        this.mBeginTransition = transition;
    }

    public Transition getBeginTransition() {
        return this.mBeginTransition;
    }

    void setEndTransition(Transition transition) {
        this.mEndTransition = transition;
    }

    public Transition getEndTransition() {
        return this.mEndTransition;
    }

    public abstract long getTimelineDuration();

    public abstract long getDuration();

    public abstract int getFileType();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getAspectRatio();

    public void addEffect(Effect effect) {
        if (effect == null) {
            throw new IllegalArgumentException("NULL effect cannot be applied");
        }
        if (effect.getMediaItem() != this) {
            throw new IllegalArgumentException("Media item mismatch");
        }
        if (this.mEffects.contains(effect)) {
            throw new IllegalArgumentException("Effect already exists: " + effect.getId());
        }
        if (effect.getStartTime() + effect.getDuration() > this.getDuration()) {
            throw new IllegalArgumentException("Effect start time + effect duration > media clip duration");
        }
        this.mMANativeHelper.setGeneratePreview(true);
        this.mEffects.add(effect);
        this.invalidateTransitions(effect.getStartTime(), effect.getDuration());
        if (effect instanceof EffectKenBurns) {
            this.mRegenerateClip = true;
        }
    }

    public Effect removeEffect(String effectId) {
        for (Effect effect : this.mEffects) {
            if (!effect.getId().equals(effectId)) continue;
            this.mMANativeHelper.setGeneratePreview(true);
            this.mEffects.remove(effect);
            this.invalidateTransitions(effect.getStartTime(), effect.getDuration());
            if (effect instanceof EffectKenBurns) {
                if (this.mGeneratedImageClip != null) {
                    new File(this.mGeneratedImageClip).delete();
                    this.mGeneratedImageClip = null;
                }
                this.mRegenerateClip = false;
            }
            return effect;
        }
        return null;
    }

    void setGeneratedImageClip(String generatedFilePath) {
        this.mGeneratedImageClip = generatedFilePath;
    }

    String getGeneratedImageClip() {
        return this.mGeneratedImageClip;
    }

    public Effect getEffect(String effectId) {
        for (Effect effect : this.mEffects) {
            if (!effect.getId().equals(effectId)) continue;
            return effect;
        }
        return null;
    }

    public List<Effect> getAllEffects() {
        return this.mEffects;
    }

    public void addOverlay(Overlay overlay) throws FileNotFoundException, IOException {
        if (overlay == null) {
            throw new IllegalArgumentException("NULL Overlay cannot be applied");
        }
        if (overlay.getMediaItem() != this) {
            throw new IllegalArgumentException("Media item mismatch");
        }
        if (this.mOverlays.contains(overlay)) {
            throw new IllegalArgumentException("Overlay already exists: " + overlay.getId());
        }
        if (overlay.getStartTime() + overlay.getDuration() > this.getDuration()) {
            throw new IllegalArgumentException("Overlay start time + overlay duration > media clip duration");
        }
        if (overlay instanceof OverlayFrame) {
            int scaledHeight;
            int scaledWidth;
            OverlayFrame frame = (OverlayFrame)overlay;
            Bitmap bitmap = frame.getBitmap();
            if (bitmap == null) {
                throw new IllegalArgumentException("Overlay bitmap not specified");
            }
            if (this instanceof MediaVideoItem) {
                scaledWidth = this.getWidth();
                scaledHeight = this.getHeight();
            } else {
                scaledWidth = ((MediaImageItem)this).getScaledWidth();
                scaledHeight = ((MediaImageItem)this).getScaledHeight();
            }
            if (bitmap.getWidth() != scaledWidth || bitmap.getHeight() != scaledHeight) {
                throw new IllegalArgumentException("Bitmap dimensions must match media item dimensions");
            }
        } else {
            throw new IllegalArgumentException("Overlay not supported");
        }
        this.mMANativeHelper.setGeneratePreview(true);
        ((OverlayFrame)overlay).save(this.mProjectPath);
        this.mOverlays.add(overlay);
        this.invalidateTransitions(overlay.getStartTime(), overlay.getDuration());
    }

    void setRegenerateClip(boolean flag) {
        this.mRegenerateClip = flag;
    }

    boolean getRegenerateClip() {
        return this.mRegenerateClip;
    }

    public Overlay removeOverlay(String overlayId) {
        for (Overlay overlay : this.mOverlays) {
            if (!overlay.getId().equals(overlayId)) continue;
            this.mMANativeHelper.setGeneratePreview(true);
            this.mOverlays.remove(overlay);
            if (overlay instanceof OverlayFrame) {
                ((OverlayFrame)overlay).invalidate();
            }
            this.invalidateTransitions(overlay.getStartTime(), overlay.getDuration());
            return overlay;
        }
        return null;
    }

    public Overlay getOverlay(String overlayId) {
        for (Overlay overlay : this.mOverlays) {
            if (!overlay.getId().equals(overlayId)) continue;
            return overlay;
        }
        return null;
    }

    public List<Overlay> getAllOverlays() {
        return this.mOverlays;
    }

    public abstract Bitmap getThumbnail(int var1, int var2, long var3) throws IOException;

    public abstract void getThumbnailList(int var1, int var2, long var3, long var5, int var7, int[] var8, GetThumbnailListCallback var9) throws IOException;

    public Bitmap[] getThumbnailList(int width, int height, long startMs, long endMs, int thumbnailCount) throws IOException {
        final Bitmap[] bitmaps = new Bitmap[thumbnailCount];
        int[] indices = new int[thumbnailCount];
        for (int i = 0; i < thumbnailCount; ++i) {
            indices[i] = i;
        }
        this.getThumbnailList(width, height, startMs, endMs, thumbnailCount, indices, new GetThumbnailListCallback(){

            public void onThumbnail(Bitmap bitmap, int index) {
                bitmaps[index] = bitmap;
            }
        });
        return bitmaps;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MediaItem)) {
            return false;
        }
        return this.mUniqueId.equals(((MediaItem)object).mUniqueId);
    }

    public int hashCode() {
        return this.mUniqueId.hashCode();
    }

    abstract void invalidateTransitions(long var1, long var3);

    abstract void invalidateTransitions(long var1, long var3, long var5, long var7);

    protected boolean isOverlapping(long startTimeMs1, long durationMs1, long startTimeMs2, long durationMs2) {
        if (startTimeMs1 + durationMs1 <= startTimeMs2) {
            return false;
        }
        return startTimeMs1 < startTimeMs2 + durationMs2;
    }

    protected void adjustTransitions() {
        long maxDurationMs;
        if (this.mBeginTransition != null) {
            maxDurationMs = this.mBeginTransition.getMaximumDuration();
            if (this.mBeginTransition.getDuration() > maxDurationMs) {
                this.mBeginTransition.setDuration(maxDurationMs);
            }
        }
        if (this.mEndTransition != null) {
            maxDurationMs = this.mEndTransition.getMaximumDuration();
            if (this.mEndTransition.getDuration() > maxDurationMs) {
                this.mEndTransition.setDuration(maxDurationMs);
            }
        }
    }

    MediaArtistNativeHelper getNativeContext() {
        return this.mMANativeHelper;
    }

    void initClipSettings(MediaArtistNativeHelper.ClipSettings clipSettings) {
        clipSettings.clipPath = null;
        clipSettings.clipDecodedPath = null;
        clipSettings.clipOriginalPath = null;
        clipSettings.fileType = 0;
        clipSettings.endCutTime = 0;
        clipSettings.beginCutTime = 0;
        clipSettings.beginCutPercent = 0;
        clipSettings.endCutPercent = 0;
        clipSettings.panZoomEnabled = false;
        clipSettings.panZoomPercentStart = 0;
        clipSettings.panZoomTopLeftXStart = 0;
        clipSettings.panZoomTopLeftYStart = 0;
        clipSettings.panZoomPercentEnd = 0;
        clipSettings.panZoomTopLeftXEnd = 0;
        clipSettings.panZoomTopLeftYEnd = 0;
        clipSettings.mediaRendering = 0;
        clipSettings.rgbWidth = 0;
        clipSettings.rgbHeight = 0;
    }

    MediaArtistNativeHelper.ClipSettings getClipSettings() {
        MediaVideoItem mVI = null;
        MediaImageItem mII = null;
        MediaArtistNativeHelper.ClipSettings clipSettings = new MediaArtistNativeHelper.ClipSettings();
        this.initClipSettings(clipSettings);
        if (this instanceof MediaVideoItem) {
            mVI = (MediaVideoItem)this;
            clipSettings.clipPath = mVI.getFilename();
            clipSettings.fileType = this.mMANativeHelper.getMediaItemFileType(mVI.getFileType());
            clipSettings.beginCutTime = (int)mVI.getBoundaryBeginTime();
            clipSettings.endCutTime = (int)mVI.getBoundaryEndTime();
            clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(mVI.getRenderingMode());
        } else if (this instanceof MediaImageItem) {
            mII = (MediaImageItem)this;
            clipSettings = mII.getImageClipProperties();
        }
        return clipSettings;
    }

    void generateBlankFrame(MediaArtistNativeHelper.ClipSettings clipSettings) {
        if (!this.mBlankFrameGenerated) {
            int mWidth = 64;
            int mHeight = 64;
            this.mBlankFrameFilename = String.format(this.mProjectPath + "/" + "ghost.rgb", new Object[0]);
            FileOutputStream fl = null;
            try {
                fl = new FileOutputStream(this.mBlankFrameFilename);
            }
            catch (IOException e) {
                // empty catch block
            }
            DataOutputStream dos = new DataOutputStream(fl);
            int[] framingBuffer = new int[mWidth];
            ByteBuffer byteBuffer = ByteBuffer.allocate(framingBuffer.length * 4);
            byte[] array2 = byteBuffer.array();
            for (int tmp = 0; tmp < mHeight; ++tmp) {
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(framingBuffer, 0, mWidth);
                try {
                    dos.write(array2);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                fl.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.mBlankFrameGenerated = true;
        }
        clipSettings.clipPath = this.mBlankFrameFilename;
        clipSettings.fileType = 5;
        clipSettings.beginCutTime = 0;
        clipSettings.endCutTime = 0;
        clipSettings.mediaRendering = 0;
        clipSettings.rgbWidth = 64;
        clipSettings.rgbHeight = 64;
    }

    void invalidateBlankFrame() {
        if (this.mBlankFrameFilename != null && new File(this.mBlankFrameFilename).exists()) {
            new File(this.mBlankFrameFilename).delete();
            this.mBlankFrameFilename = null;
        }
    }

    public static interface GetThumbnailListCallback {
        public void onThumbnail(Bitmap var1, int var2);
    }
}

