/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.drm.DrmManagerClient;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaInserter;
import android.media.MediaScannerClient;
import android.mtp.MtpConstants;
import android.net.Uri;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.Element;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner {
    private static final String TAG = "MediaScanner";
    private static final String[] FILES_PRESCAN_PROJECTION;
    private static final String[] ID_PROJECTION;
    private static final int FILES_PRESCAN_ID_COLUMN_INDEX = 0;
    private static final int FILES_PRESCAN_PATH_COLUMN_INDEX = 1;
    private static final int FILES_PRESCAN_FORMAT_COLUMN_INDEX = 2;
    private static final int FILES_PRESCAN_DATE_MODIFIED_COLUMN_INDEX = 3;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final String ALARMS_DIR = "/alarms/";
    private static final String MUSIC_DIR = "/music/";
    private static final String PODCAST_DIR = "/podcasts/";
    private static final String[] ID3_GENRES;
    private int mNativeContext;
    private Context mContext;
    private String mPackageName;
    private IContentProvider mMediaProvider;
    private Uri mAudioUri;
    private Uri mVideoUri;
    private Uri mImagesUri;
    private Uri mThumbsUri;
    private Uri mPlaylistsUri;
    private Uri mFilesUri;
    private Uri mFilesUriNoNotify;
    private boolean mProcessPlaylists;
    private boolean mProcessGenres;
    private int mMtpObjectHandle;
    private final String mExternalStoragePath;
    private final boolean mExternalIsEmulated;
    private static final boolean ENABLE_BULK_INSERTS = true;
    private int mOriginalCount;
    private boolean mWasEmptyPriorToScan = false;
    private boolean mDefaultRingtoneSet;
    private boolean mDefaultNotificationSet;
    private boolean mDefaultAlarmSet;
    private String mDefaultRingtoneFilename;
    private String mDefaultNotificationFilename;
    private String mDefaultAlarmAlertFilename;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private boolean mCaseInsensitivePaths;
    private final BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    private ArrayList<PlaylistEntry> mPlaylistEntries = new ArrayList();
    private MediaInserter mMediaInserter;
    private ArrayList<FileEntry> mPlayLists;
    private DrmManagerClient mDrmManagerClient = null;
    private final MyMediaScannerClient mClient = new MyMediaScannerClient();

    public MediaScanner(Context c) {
        this.native_setup();
        this.mContext = c;
        this.mPackageName = c.getPackageName();
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
        this.mExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        this.mExternalIsEmulated = Environment.isExternalStorageEmulated();
    }

    private void setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
    }

    private boolean isDrmEnabled() {
        String prop = SystemProperties.get("drm.service.enabled");
        return prop != null && prop.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prescan(String filePath, boolean prescanFiles) throws RemoteException {
        Cursor c;
        block16: {
            c = null;
            String where = null;
            String[] selectionArgs = null;
            if (this.mPlayLists == null) {
                this.mPlayLists = new ArrayList();
            } else {
                this.mPlayLists.clear();
            }
            if (filePath != null) {
                where = "_id>? AND _data=?";
                selectionArgs = new String[]{"", filePath};
            } else {
                where = "_id>?";
                selectionArgs = new String[]{""};
            }
            Uri.Builder builder = this.mFilesUri.buildUpon();
            builder.appendQueryParameter("deletedata", "false");
            MediaBulkDeleter deleter = new MediaBulkDeleter(this.mMediaProvider, this.mPackageName, builder.build());
            try {
                if (!prescanFiles) break block16;
                long lastId = Long.MIN_VALUE;
                Uri limitUri = this.mFilesUri.buildUpon().appendQueryParameter("limit", "1000").build();
                this.mWasEmptyPriorToScan = true;
                block5: while (true) {
                    selectionArgs[0] = "" + lastId;
                    if (c != null) {
                        c.close();
                        c = null;
                    }
                    if ((c = this.mMediaProvider.query(this.mPackageName, limitUri, FILES_PRESCAN_PROJECTION, where, selectionArgs, "_id", null)) == null) {
                        break;
                    }
                    int num = c.getCount();
                    if (num == 0) {
                        break;
                    }
                    this.mWasEmptyPriorToScan = false;
                    while (true) {
                        MediaFile.MediaFileType mediaFileType;
                        int fileType;
                        if (!c.moveToNext()) continue block5;
                        long rowId = c.getLong(0);
                        String path = c.getString(1);
                        int format = c.getInt(2);
                        long lastModified = c.getLong(3);
                        lastId = rowId;
                        if (path == null || !path.startsWith("/")) continue;
                        boolean exists = false;
                        try {
                            exists = Libcore.os.access(path, OsConstants.F_OK);
                        }
                        catch (ErrnoException e1) {
                            // empty catch block
                        }
                        if (exists || MtpConstants.isAbstractObject(format) || MediaFile.isPlayListFileType(fileType = (mediaFileType = MediaFile.getFileType(path)) == null ? 0 : mediaFileType.fileType)) continue;
                        deleter.delete(rowId);
                        if (!path.toLowerCase(Locale.US).endsWith("/.nomedia")) continue;
                        deleter.flush();
                        String parent = new File(path).getParent();
                        this.mMediaProvider.call(this.mPackageName, "unhide", parent, null);
                    }
                    break;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
                deleter.flush();
            }
        }
        this.mOriginalCount = 0;
        c = this.mMediaProvider.query(this.mPackageName, this.mImagesUri, ID_PROJECTION, null, null, null, null);
        if (c != null) {
            this.mOriginalCount = c.getCount();
            c.close();
        }
    }

    private boolean inScanDirectory(String path, String[] directories) {
        for (int i = 0; i < directories.length; ++i) {
            String directory = directories[i];
            if (!path.startsWith(directory)) continue;
            return true;
        }
        return false;
    }

    private void pruneDeadThumbnailFiles() {
        String fullPathString;
        HashSet<String> existingFiles = new HashSet<String>();
        String directory = "/sdcard/DCIM/.thumbnails";
        String[] files = new File(directory).list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            fullPathString = directory + "/" + files[i];
            existingFiles.add(fullPathString);
        }
        try {
            Cursor c = this.mMediaProvider.query(this.mPackageName, this.mThumbsUri, new String[]{"_data"}, null, null, null, null);
            Log.v(TAG, "pruneDeadThumbnailFiles... " + c);
            if (c != null && c.moveToFirst()) {
                do {
                    fullPathString = c.getString(0);
                    existingFiles.remove(fullPathString);
                } while (c.moveToNext());
            }
            for (String fileToDelete : existingFiles) {
                try {
                    new File(fileToDelete).delete();
                }
                catch (SecurityException ex) {}
            }
            Log.v(TAG, "/pruneDeadThumbnailFiles... " + c);
            if (c != null) {
                c.close();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void postscan(String[] directories) throws RemoteException {
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && this.mImagesUri.equals(MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mPlayLists = null;
        this.mMediaProvider = null;
    }

    private void initialize(String volumeName) {
        this.mMediaProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(volumeName);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(volumeName);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(volumeName);
        this.mThumbsUri = MediaStore.Images.Thumbnails.getContentUri(volumeName);
        this.mFilesUri = MediaStore.Files.getContentUri(volumeName);
        this.mFilesUriNoNotify = this.mFilesUri.buildUpon().appendQueryParameter("nonotify", "1").build();
        if (!volumeName.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(volumeName);
            this.mCaseInsensitivePaths = true;
        }
    }

    public void scanDirectories(String[] directories, String volumeName) {
        try {
            long start = System.currentTimeMillis();
            this.initialize(volumeName);
            this.prescan(null, true);
            long prescan = System.currentTimeMillis();
            this.mMediaInserter = new MediaInserter(this.mMediaProvider, this.mPackageName, 500);
            for (int i = 0; i < directories.length; ++i) {
                this.processDirectory(directories[i], this.mClient);
            }
            this.mMediaInserter.flushAll();
            this.mMediaInserter = null;
            long scan = System.currentTimeMillis();
            this.postscan(directories);
            long end = System.currentTimeMillis();
        }
        catch (SQLException e) {
            Log.e(TAG, "SQLException in MediaScanner.scan()", e);
        }
        catch (UnsupportedOperationException e) {
            Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", e);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scan()", e);
        }
    }

    public Uri scanSingleFile(String path, String volumeName, String mimeType) {
        try {
            this.initialize(volumeName);
            this.prescan(path, true);
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            long lastModifiedSeconds = file.lastModified() / 1000L;
            return this.mClient.doScanFile(path, mimeType, lastModifiedSeconds, file.length(), false, true, MediaScanner.isNoMediaPath(path));
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
            return null;
        }
    }

    private static boolean isNoMediaFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return false;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash + 2 < path.length()) {
            if (path.regionMatches(lastSlash + 1, "._", 0, 2)) {
                return true;
            }
            if (path.regionMatches(true, path.length() - 4, ".jpg", 0, 4)) {
                if (path.regionMatches(true, lastSlash + 1, "AlbumArt_{", 0, 10) || path.regionMatches(true, lastSlash + 1, "AlbumArt.", 0, 9)) {
                    return true;
                }
                int length = path.length() - lastSlash - 1;
                if (length == 17 && path.regionMatches(true, lastSlash + 1, "AlbumArtSmall", 0, 13) || length == 10 && path.regionMatches(true, lastSlash + 1, "Folder", 0, 6)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNoMediaPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        int offset = 1;
        while (offset >= 0) {
            File file;
            int slashIndex = path.indexOf(47, offset);
            if (slashIndex > offset && (file = new File(path.substring(0, ++slashIndex) + ".nomedia")).exists()) {
                return true;
            }
            offset = slashIndex;
        }
        return MediaScanner.isNoMediaFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMtpFile(String path, String volumeName, int objectHandle, int format) {
        this.initialize(volumeName);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        File file = new File(path);
        long lastModifiedSeconds = file.lastModified() / 1000L;
        if (!(MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isImageFileType(fileType) || MediaFile.isPlayListFileType(fileType) || MediaFile.isDrmFileType(fileType))) {
            ContentValues values = new ContentValues();
            values.put("_size", file.length());
            values.put("date_modified", lastModifiedSeconds);
            try {
                String[] whereArgs = new String[]{Integer.toString(objectHandle)};
                this.mMediaProvider.update(this.mPackageName, MediaStore.Files.getMtpObjectsUri(volumeName), values, "_id=?", whereArgs);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in scanMtpFile", e);
            }
            return;
        }
        this.mMtpObjectHandle = objectHandle;
        Cursor fileList = null;
        try {
            if (MediaFile.isPlayListFileType(fileType)) {
                this.prescan(null, true);
                FileEntry entry = this.makeEntryFor(path);
                if (entry != null) {
                    fileList = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, null, null, null, null);
                    this.processPlayList(entry, fileList);
                }
            } else {
                this.prescan(path, false);
                this.mClient.doScanFile(path, mediaFileType.mimeType, lastModifiedSeconds, file.length(), format == 12289, true, MediaScanner.isNoMediaPath(path));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
        }
        finally {
            this.mMtpObjectHandle = 0;
            if (fileList != null) {
                fileList.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry makeEntryFor(String path) {
        Cursor c = null;
        try {
            String where = "_data=?";
            String[] selectionArgs = new String[]{path};
            c = this.mMediaProvider.query(this.mPackageName, this.mFilesUriNoNotify, FILES_PRESCAN_PROJECTION, where, selectionArgs, null, null);
            if (c.moveToFirst()) {
                long rowId = c.getLong(0);
                int format = c.getInt(2);
                long lastModified = c.getLong(3);
                FileEntry fileEntry = new FileEntry(rowId, path, lastModified, format);
                return fileEntry;
            }
        }
        catch (RemoteException e) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    private int matchPaths(String path1, String path2) {
        int result = 0;
        int end1 = path1.length();
        int end2 = path2.length();
        while (end1 > 0 && end2 > 0) {
            int start2;
            int slash1 = path1.lastIndexOf(47, end1 - 1);
            int slash2 = path2.lastIndexOf(47, end2 - 1);
            int backSlash1 = path1.lastIndexOf(92, end1 - 1);
            int backSlash2 = path2.lastIndexOf(92, end2 - 1);
            int start1 = slash1 > backSlash1 ? slash1 : backSlash1;
            int n = start2 = slash2 > backSlash2 ? slash2 : backSlash2;
            start1 = start1 < 0 ? 0 : ++start1;
            start2 = start2 < 0 ? 0 : ++start2;
            int length = end1 - start1;
            if (end2 - start2 != length || !path1.regionMatches(true, start1, path2, start2, length)) break;
            ++result;
            end1 = start1 - 1;
            end2 = start2 - 1;
        }
        return result;
    }

    private boolean matchEntries(long rowId, String data) {
        int len = this.mPlaylistEntries.size();
        boolean done = true;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel == Integer.MAX_VALUE) continue;
            done = false;
            if (data.equalsIgnoreCase(entry.path)) {
                entry.bestmatchid = rowId;
                entry.bestmatchlevel = Integer.MAX_VALUE;
                continue;
            }
            int matchLength = this.matchPaths(data, entry.path);
            if (matchLength <= entry.bestmatchlevel) continue;
            entry.bestmatchid = rowId;
            entry.bestmatchlevel = matchLength;
        }
        return done;
    }

    private void cachePlaylistEntry(String line, String playListDirectory) {
        char ch1;
        boolean fullPath;
        int entryLength;
        PlaylistEntry entry = new PlaylistEntry();
        for (entryLength = line.length(); entryLength > 0 && Character.isWhitespace(line.charAt(entryLength - 1)); --entryLength) {
        }
        if (entryLength < 3) {
            return;
        }
        if (entryLength < line.length()) {
            line = line.substring(0, entryLength);
        }
        boolean bl = fullPath = (ch1 = line.charAt(0)) == '/' || Character.isLetter(ch1) && line.charAt(1) == ':' && line.charAt(2) == '\\';
        if (!fullPath) {
            line = playListDirectory + line;
        }
        entry.path = line;
        this.mPlaylistEntries.add(entry);
    }

    private void processCachedPlaylist(Cursor fileList, ContentValues values, Uri playlistUri) {
        String data;
        long rowId;
        fileList.moveToPosition(-1);
        while (fileList.moveToNext() && !this.matchEntries(rowId = fileList.getLong(0), data = fileList.getString(1))) {
        }
        int len = this.mPlaylistEntries.size();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel <= 0) continue;
            try {
                values.clear();
                values.put("play_order", index);
                values.put("audio_id", entry.bestmatchid);
                this.mMediaProvider.insert(this.mPackageName, playlistUri, values);
                ++index;
                continue;
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in MediaScanner.processCachedPlaylist()", e);
                return;
            }
        }
        this.mPlaylistEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processM3uPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        this.cachePlaylistEntry(line, playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlsPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    int equals;
                    if (line.startsWith("File") && (equals = line.indexOf(61)) > 0) {
                        this.cachePlaylistEntry(line.substring(equals + 1), playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWplPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        FileInputStream fis = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                fis = new FileInputStream(f);
                this.mPlaylistEntries.clear();
                Xml.parse(fis, Xml.findEncodingByName("UTF-8"), new WplHandler(playListDirectory, uri, fileList).getContentHandler());
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processWplPlayList()", e);
            }
        }
    }

    private void processPlayList(FileEntry entry, Cursor fileList) throws RemoteException {
        int fileType;
        Uri membersUri;
        String path = entry.mPath;
        ContentValues values = new ContentValues();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            throw new IllegalArgumentException("bad path " + path);
        }
        long rowId = entry.mRowId;
        String name = values.getAsString("name");
        if (name == null && (name = values.getAsString("title")) == null) {
            int lastDot = path.lastIndexOf(46);
            name = lastDot < 0 ? path.substring(lastSlash + 1) : path.substring(lastSlash + 1, lastDot);
        }
        values.put("name", name);
        values.put("date_modified", entry.mLastModified);
        if (rowId == 0L) {
            values.put("_data", path);
            Uri uri = this.mMediaProvider.insert(this.mPackageName, this.mPlaylistsUri, values);
            rowId = ContentUris.parseId(uri);
            membersUri = Uri.withAppendedPath(uri, "members");
        } else {
            Uri uri = ContentUris.withAppendedId(this.mPlaylistsUri, rowId);
            this.mMediaProvider.update(this.mPackageName, uri, values, null, null);
            membersUri = Uri.withAppendedPath(uri, "members");
            this.mMediaProvider.delete(this.mPackageName, membersUri, null, null);
        }
        String playListDirectory = path.substring(0, lastSlash + 1);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int n = fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        if (fileType == 41) {
            this.processM3uPlayList(path, playListDirectory, membersUri, values, fileList);
        } else if (fileType == 42) {
            this.processPlsPlayList(path, playListDirectory, membersUri, values, fileList);
        } else if (fileType == 43) {
            this.processWplPlayList(path, playListDirectory, membersUri, values, fileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlayLists() throws RemoteException {
        Iterator<FileEntry> iterator = this.mPlayLists.iterator();
        Cursor fileList = null;
        try {
            fileList = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, "media_type=2", null, null, null);
            while (iterator.hasNext()) {
                FileEntry entry = iterator.next();
                if (!entry.mLastModifiedChanged) continue;
                this.processPlayList(entry, fileList);
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            if (fileList != null) {
                fileList.close();
            }
        }
    }

    private native void processDirectory(String var1, MediaScannerClient var2);

    private native void processFile(String var1, String var2, MediaScannerClient var3);

    public native void setLocale(String var1);

    public native byte[] extractAlbumArt(FileDescriptor var1);

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    public void release() {
        this.native_finalize();
    }

    protected void finalize() {
        this.mContext.getContentResolver().releaseProvider(this.mMediaProvider);
        this.native_finalize();
    }

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        FILES_PRESCAN_PROJECTION = new String[]{"_id", "_data", "format", "date_modified"};
        ID_PROJECTION = new String[]{"_id"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", null, "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};
    }

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        String playListDirectory;

        public WplHandler(String playListDirectory, Uri uri, Cursor fileList) {
            this.playListDirectory = playListDirectory;
            RootElement root = new RootElement("smil");
            Element body = root.getChild("body");
            Element seq = body.getChild("seq");
            Element media = seq.getChild("media");
            media.setElementListener(this);
            this.handler = root.getContentHandler();
        }

        public void start(Attributes attributes) {
            String path = attributes.getValue("", "src");
            if (path != null) {
                MediaScanner.this.cachePlaylistEntry(path, this.playListDirectory);
            }
        }

        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }
    }

    static class MediaBulkDeleter {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<String> whereArgs = new ArrayList(100);
        final IContentProvider mProvider;
        final String mPackageName;
        final Uri mBaseUri;

        public MediaBulkDeleter(IContentProvider provider, String packageName, Uri baseUri) {
            this.mProvider = provider;
            this.mPackageName = packageName;
            this.mBaseUri = baseUri;
        }

        public void delete(long id2) throws RemoteException {
            if (this.whereClause.length() != 0) {
                this.whereClause.append(",");
            }
            this.whereClause.append("?");
            this.whereArgs.add("" + id2);
            if (this.whereArgs.size() > 100) {
                this.flush();
            }
        }

        public void flush() throws RemoteException {
            int size = this.whereArgs.size();
            if (size > 0) {
                String[] foo = new String[size];
                foo = this.whereArgs.toArray(foo);
                int numrows = this.mProvider.delete(this.mPackageName, this.mBaseUri, "_id IN (" + this.whereClause.toString() + ")", foo);
                this.whereClause.setLength(0);
                this.whereArgs.clear();
            }
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mArtist;
        private String mAlbumArtist;
        private String mAlbum;
        private String mTitle;
        private String mComposer;
        private String mGenre;
        private String mMimeType;
        private int mFileType;
        private int mTrack;
        private int mYear;
        private int mDuration;
        private String mPath;
        private long mLastModified;
        private long mFileSize;
        private String mWriter;
        private int mCompilation;
        private boolean mIsDrm;
        private boolean mNoMedia;
        private int mWidth;
        private int mHeight;

        private MyMediaScannerClient() {
        }

        public FileEntry beginFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            boolean wasModified;
            FileEntry entry;
            this.mMimeType = mimeType;
            this.mFileType = 0;
            this.mFileSize = fileSize;
            this.mIsDrm = false;
            if (!isDirectory) {
                MediaFile.MediaFileType mediaFileType;
                if (!noMedia && MediaScanner.isNoMediaFile(path)) {
                    noMedia = true;
                }
                this.mNoMedia = noMedia;
                if (mimeType != null) {
                    this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
                }
                if (this.mFileType == 0 && (mediaFileType = MediaFile.getFileType(path)) != null) {
                    this.mFileType = mediaFileType.fileType;
                    if (this.mMimeType == null) {
                        this.mMimeType = mediaFileType.mimeType;
                    }
                }
                if (MediaScanner.this.isDrmEnabled() && MediaFile.isDrmFileType(this.mFileType)) {
                    this.mFileType = this.getFileTypeFromDrm(path);
                }
            }
            long delta = (entry = MediaScanner.this.makeEntryFor(path)) != null ? lastModified - entry.mLastModified : 0L;
            boolean bl = wasModified = delta > 1L || delta < -1L;
            if (entry == null || wasModified) {
                if (wasModified) {
                    entry.mLastModified = lastModified;
                } else {
                    entry = new FileEntry(0L, path, lastModified, isDirectory ? 12289 : 0);
                }
                entry.mLastModifiedChanged = true;
            }
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                MediaScanner.this.mPlayLists.add(entry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mWriter = null;
            this.mCompilation = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            return entry;
        }

        public void scanFile(String path, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            this.doScanFile(path, null, lastModified, fileSize, isDirectory, false, noMedia);
        }

        public Uri doScanFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean scanAlways, boolean noMedia) {
            Uri result = null;
            try {
                FileEntry entry = this.beginFile(path, mimeType, lastModified, fileSize, isDirectory, noMedia);
                if (MediaScanner.this.mMtpObjectHandle != 0) {
                    entry.mRowId = 0L;
                }
                if (entry != null && (entry.mLastModifiedChanged || scanAlways)) {
                    if (noMedia) {
                        result = this.endFile(entry, false, false, false, false, false);
                    } else {
                        String directPath;
                        File f;
                        String lowpath = path.toLowerCase(Locale.ROOT);
                        boolean ringtones = lowpath.indexOf(MediaScanner.RINGTONES_DIR) > 0;
                        boolean notifications = lowpath.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                        boolean alarms = lowpath.indexOf(MediaScanner.ALARMS_DIR) > 0;
                        boolean podcasts = lowpath.indexOf(MediaScanner.PODCAST_DIR) > 0;
                        boolean music = lowpath.indexOf(MediaScanner.MUSIC_DIR) > 0 || !ringtones && !notifications && !alarms && !podcasts;
                        boolean isaudio = MediaFile.isAudioFileType(this.mFileType);
                        boolean isvideo = MediaFile.isVideoFileType(this.mFileType);
                        boolean isimage = MediaFile.isImageFileType(this.mFileType);
                        if ((isaudio || isvideo || isimage) && MediaScanner.this.mExternalIsEmulated && path.startsWith(MediaScanner.this.mExternalStoragePath) && (f = new File(directPath = Environment.getMediaStorageDirectory() + path.substring(MediaScanner.this.mExternalStoragePath.length()))).exists()) {
                            path = directPath;
                        }
                        if (isaudio || isvideo) {
                            MediaScanner.this.processFile(path, mimeType, this);
                        }
                        if (isimage) {
                            this.processImageFile(path);
                        }
                        result = this.endFile(entry, ringtones, notifications, alarms, music, podcasts);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", e);
            }
            return result;
        }

        private int parseSubstring(String s, int start, int defaultValue) {
            char ch;
            int length = s.length();
            if (start == length) {
                return defaultValue;
            }
            if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                return defaultValue;
            }
            int result = ch - 48;
            while (start < length) {
                if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                    return result;
                }
                result = result * 10 + (ch - 48);
            }
            return result;
        }

        public void handleStringTag(String name, String value) {
            if (name.equalsIgnoreCase("title") || name.startsWith("title;")) {
                this.mTitle = value;
            } else if (name.equalsIgnoreCase("artist") || name.startsWith("artist;")) {
                this.mArtist = value.trim();
            } else if (name.equalsIgnoreCase("albumartist") || name.startsWith("albumartist;") || name.equalsIgnoreCase("band") || name.startsWith("band;")) {
                this.mAlbumArtist = value.trim();
            } else if (name.equalsIgnoreCase("album") || name.startsWith("album;")) {
                this.mAlbum = value.trim();
            } else if (name.equalsIgnoreCase("composer") || name.startsWith("composer;")) {
                this.mComposer = value.trim();
            } else if (MediaScanner.this.mProcessGenres && (name.equalsIgnoreCase("genre") || name.startsWith("genre;"))) {
                this.mGenre = this.getGenreName(value);
            } else if (name.equalsIgnoreCase("year") || name.startsWith("year;")) {
                this.mYear = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("tracknumber") || name.startsWith("tracknumber;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = this.mTrack / 1000 * 1000 + num;
            } else if (name.equalsIgnoreCase("discnumber") || name.equals("set") || name.startsWith("set;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = num * 1000 + this.mTrack % 1000;
            } else if (name.equalsIgnoreCase("duration")) {
                this.mDuration = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("writer") || name.startsWith("writer;")) {
                this.mWriter = value.trim();
            } else if (name.equalsIgnoreCase("compilation")) {
                this.mCompilation = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("isdrm")) {
                this.mIsDrm = this.parseSubstring(value, 0, 0) == 1;
            } else if (name.equalsIgnoreCase("width")) {
                this.mWidth = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("height")) {
                this.mHeight = this.parseSubstring(value, 0, 0);
            }
        }

        private boolean convertGenreCode(String input, String expected) {
            String output = this.getGenreName(input);
            if (output.equals(expected)) {
                return true;
            }
            Log.d(MediaScanner.TAG, "'" + input + "' -> '" + output + "', expected '" + expected + "'");
            return false;
        }

        private void testGenreNameConverter() {
            this.convertGenreCode("2", "Country");
            this.convertGenreCode("(2)", "Country");
            this.convertGenreCode("(2", "(2");
            this.convertGenreCode("2 Foo", "Country");
            this.convertGenreCode("(2) Foo", "Country");
            this.convertGenreCode("(2 Foo", "(2 Foo");
            this.convertGenreCode("2Foo", "2Foo");
            this.convertGenreCode("(2)Foo", "Country");
            this.convertGenreCode("200 Foo", "Foo");
            this.convertGenreCode("(200) Foo", "Foo");
            this.convertGenreCode("200Foo", "200Foo");
            this.convertGenreCode("(200)Foo", "Foo");
            this.convertGenreCode("200)Foo", "200)Foo");
            this.convertGenreCode("200) Foo", "200) Foo");
        }

        public String getGenreName(String genreTagValue) {
            block12: {
                if (genreTagValue == null) {
                    return null;
                }
                int length = genreTagValue.length();
                if (length > 0) {
                    char charAfterNumber;
                    int i;
                    boolean parenthesized = false;
                    StringBuffer number = new StringBuffer();
                    for (i = 0; i < length; ++i) {
                        char c = genreTagValue.charAt(i);
                        if (i == 0 && c == '(') {
                            parenthesized = true;
                            continue;
                        }
                        if (!Character.isDigit(c)) break;
                        number.append(c);
                    }
                    char c = charAfterNumber = i < length ? (char)genreTagValue.charAt(i) : (char)' ';
                    if (parenthesized && charAfterNumber == ')' || !parenthesized && Character.isWhitespace(charAfterNumber)) {
                        try {
                            short genreIndex = Short.parseShort(number.toString());
                            if (genreIndex < 0) break block12;
                            if (genreIndex < ID3_GENRES.length && ID3_GENRES[genreIndex] != null) {
                                return ID3_GENRES[genreIndex];
                            }
                            if (genreIndex == 255) {
                                return null;
                            }
                            if (genreIndex < 255 && i + 1 < length) {
                                String ret;
                                if (parenthesized && charAfterNumber == ')') {
                                    ++i;
                                }
                                if ((ret = genreTagValue.substring(i).trim()).length() != 0) {
                                    return ret;
                                }
                                break block12;
                            }
                            return number.toString();
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
            }
            return genreTagValue;
        }

        private void processImageFile(String path) {
            try {
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth = 0;
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight = 0;
                BitmapFactory.decodeFile(path, MediaScanner.this.mBitmapOptions);
                this.mWidth = ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth;
                this.mHeight = ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setMimeType(String mimeType) {
            if ("audio/mp4".equals(this.mMimeType) && mimeType.startsWith("video")) {
                return;
            }
            this.mMimeType = mimeType;
            this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
        }

        private ContentValues toValues() {
            ContentValues map = new ContentValues();
            map.put("_data", this.mPath);
            map.put("title", this.mTitle);
            map.put("date_modified", this.mLastModified);
            map.put("_size", this.mFileSize);
            map.put("mime_type", this.mMimeType);
            map.put("is_drm", this.mIsDrm);
            String resolution = null;
            if (this.mWidth > 0 && this.mHeight > 0) {
                map.put("width", this.mWidth);
                map.put("height", this.mHeight);
                resolution = this.mWidth + "x" + this.mHeight;
            }
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("duration", this.mDuration);
                    if (resolution != null) {
                        map.put("resolution", resolution);
                    }
                } else if (!MediaFile.isImageFileType(this.mFileType) && MediaFile.isAudioFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album_artist", this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null);
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("composer", this.mComposer);
                    map.put("genre", this.mGenre);
                    if (this.mYear != 0) {
                        map.put("year", this.mYear);
                    }
                    map.put("track", this.mTrack);
                    map.put("duration", this.mDuration);
                    map.put("compilation", this.mCompilation);
                }
            }
            return map;
        }

        private Uri endFile(FileEntry entry, boolean ringtones, boolean notifications, boolean alarms, boolean music, boolean podcasts) throws RemoteException {
            int lastSlash;
            String album;
            ContentValues values;
            String title;
            if (this.mArtist == null || this.mArtist.length() == 0) {
                this.mArtist = this.mAlbumArtist;
            }
            if ((title = (values = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(title.trim())) {
                title = MediaFile.getFileTitle(values.getAsString("_data"));
                values.put("title", title);
            }
            if ("<unknown>".equals(album = values.getAsString("album")) && (lastSlash = (album = values.getAsString("_data")).lastIndexOf(47)) >= 0) {
                int idx;
                int previousSlash = 0;
                while ((idx = album.indexOf(47, previousSlash + 1)) >= 0 && idx < lastSlash) {
                    previousSlash = idx;
                }
                if (previousSlash != 0) {
                    album = album.substring(previousSlash + 1, lastSlash);
                    values.put("album", album);
                }
            }
            long rowId = entry.mRowId;
            if (MediaFile.isAudioFileType(this.mFileType) && (rowId == 0L || MediaScanner.this.mMtpObjectHandle != 0)) {
                values.put("is_ringtone", ringtones);
                values.put("is_notification", notifications);
                values.put("is_alarm", alarms);
                values.put("is_music", music);
                values.put("is_podcast", podcasts);
            } else if (this.mFileType == 31 && !this.mNoMedia) {
                ExifInterface exif = null;
                try {
                    exif = new ExifInterface(entry.mPath);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (exif != null) {
                    long time;
                    float[] latlng = new float[2];
                    if (exif.getLatLong(latlng)) {
                        values.put("latitude", Float.valueOf(latlng[0]));
                        values.put("longitude", Float.valueOf(latlng[1]));
                    }
                    if ((time = exif.getGpsDateTime()) != -1L) {
                        values.put("datetaken", time);
                    } else {
                        time = exif.getDateTime();
                        if (time != -1L && Math.abs(this.mLastModified * 1000L - time) >= 86400000L) {
                            values.put("datetaken", time);
                        }
                    }
                    int orientation = exif.getAttributeInt("Orientation", -1);
                    if (orientation != -1) {
                        int degree;
                        switch (orientation) {
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                                break;
                            }
                            default: {
                                degree = 0;
                            }
                        }
                        values.put("orientation", degree);
                    }
                }
            }
            Uri tableUri = MediaScanner.this.mFilesUri;
            MediaInserter inserter = MediaScanner.this.mMediaInserter;
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mVideoUri;
                } else if (MediaFile.isImageFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mImagesUri;
                } else if (MediaFile.isAudioFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mAudioUri;
                }
            }
            Uri result = null;
            boolean needToSetSettings = false;
            if (rowId == 0L) {
                if (MediaScanner.this.mMtpObjectHandle != 0) {
                    values.put("media_scanner_new_object_id", MediaScanner.this.mMtpObjectHandle);
                }
                if (tableUri == MediaScanner.this.mFilesUri) {
                    int format = entry.mFormat;
                    if (format == 0) {
                        format = MediaFile.getFormatCode(entry.mPath, this.mMimeType);
                    }
                    values.put("format", format);
                }
                if (MediaScanner.this.mWasEmptyPriorToScan) {
                    if (notifications && !MediaScanner.this.mDefaultNotificationSet) {
                        if (TextUtils.isEmpty(MediaScanner.this.mDefaultNotificationFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultNotificationFilename)) {
                            needToSetSettings = true;
                        }
                    } else if (ringtones && !MediaScanner.this.mDefaultRingtoneSet) {
                        if (TextUtils.isEmpty(MediaScanner.this.mDefaultRingtoneFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultRingtoneFilename)) {
                            needToSetSettings = true;
                        }
                    } else if (alarms && !MediaScanner.this.mDefaultAlarmSet && (TextUtils.isEmpty(MediaScanner.this.mDefaultAlarmAlertFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultAlarmAlertFilename))) {
                        needToSetSettings = true;
                    }
                }
                if (inserter == null || needToSetSettings) {
                    if (inserter != null) {
                        inserter.flushAll();
                    }
                    result = MediaScanner.this.mMediaProvider.insert(MediaScanner.this.mPackageName, tableUri, values);
                } else if (entry.mFormat == 12289) {
                    inserter.insertwithPriority(tableUri, values);
                } else {
                    inserter.insert(tableUri, values);
                }
                if (result != null) {
                    entry.mRowId = rowId = ContentUris.parseId(result);
                }
            } else {
                result = ContentUris.withAppendedId(tableUri, rowId);
                values.remove("_data");
                int mediaType = 0;
                if (!MediaScanner.isNoMediaPath(entry.mPath)) {
                    int fileType = MediaFile.getFileTypeForMimeType(this.mMimeType);
                    if (MediaFile.isAudioFileType(fileType)) {
                        mediaType = 2;
                    } else if (MediaFile.isVideoFileType(fileType)) {
                        mediaType = 3;
                    } else if (MediaFile.isImageFileType(fileType)) {
                        mediaType = 1;
                    } else if (MediaFile.isPlayListFileType(fileType)) {
                        mediaType = 4;
                    }
                    values.put("media_type", mediaType);
                }
                MediaScanner.this.mMediaProvider.update(MediaScanner.this.mPackageName, result, values, null, null);
            }
            if (needToSetSettings) {
                if (notifications) {
                    this.setSettingIfNotSet("notification_sound", tableUri, rowId);
                    MediaScanner.this.mDefaultNotificationSet = true;
                } else if (ringtones) {
                    this.setSettingIfNotSet("ringtone", tableUri, rowId);
                    MediaScanner.this.mDefaultRingtoneSet = true;
                } else if (alarms) {
                    this.setSettingIfNotSet("alarm_alert", tableUri, rowId);
                    MediaScanner.this.mDefaultAlarmSet = true;
                }
            }
            return result;
        }

        private boolean doesPathHaveFilename(String path, String filename) {
            int filenameLength;
            int pathFilenameStart = path.lastIndexOf(File.separatorChar) + 1;
            return path.regionMatches(pathFilenameStart, filename, 0, filenameLength = filename.length()) && pathFilenameStart + filenameLength == path.length();
        }

        private void setSettingIfNotSet(String settingName, Uri uri, long rowId) {
            String existingSettingValue = Settings.System.getString(MediaScanner.this.mContext.getContentResolver(), settingName);
            if (TextUtils.isEmpty(existingSettingValue)) {
                Settings.System.putString(MediaScanner.this.mContext.getContentResolver(), settingName, ContentUris.withAppendedId(uri, rowId).toString());
            }
        }

        private int getFileTypeFromDrm(String path) {
            if (!MediaScanner.this.isDrmEnabled()) {
                return 0;
            }
            int resultFileType = 0;
            if (MediaScanner.this.mDrmManagerClient == null) {
                MediaScanner.this.mDrmManagerClient = new DrmManagerClient(MediaScanner.this.mContext);
            }
            if (MediaScanner.this.mDrmManagerClient.canHandle(path, null)) {
                this.mIsDrm = true;
                String drmMimetype = MediaScanner.this.mDrmManagerClient.getOriginalMimeType(path);
                if (drmMimetype != null) {
                    this.mMimeType = drmMimetype;
                    resultFileType = MediaFile.getFileTypeForMimeType(drmMimetype);
                }
            }
            return resultFileType;
        }
    }

    private static class PlaylistEntry {
        String path;
        long bestmatchid;
        int bestmatchlevel;

        private PlaylistEntry() {
        }
    }

    private static class FileEntry {
        long mRowId;
        String mPath;
        long mLastModified;
        int mFormat;
        boolean mLastModifiedChanged;

        FileEntry(long rowId, String path, long lastModified, int format) {
            this.mRowId = rowId;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mFormat = format;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath + " mRowId: " + this.mRowId;
        }
    }
}

