/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioTimestamp;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public class AudioTrack {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 1.0f;
    private static final int SAMPLE_RATE_HZ_MIN = 4000;
    private static final int SAMPLE_RATE_HZ_MAX = 48000;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    private static final String TAG = "android.media.AudioTrack";
    private int mState = 0;
    private int mPlayState = 1;
    private final Object mPlayStateLock = new Object();
    private int mNativeBufferSizeInBytes = 0;
    private int mNativeBufferSizeInFrames = 0;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private final Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount = 1;
    private int mChannels = 4;
    private int mStreamType = 3;
    private int mDataLoadMode = 1;
    private int mChannelConfiguration = 4;
    private int mAudioFormat = 2;
    private int mSessionId = 0;
    private int mNativeTrackInJavaObj;
    private int mJniData;
    private static final int SUPPORTED_OUT_CHANNELS = 1276;

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
        this(streamType, sampleRateInHz, channelConfig, audioFormat, bufferSizeInBytes, mode, 0);
    }

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.mInitializationLooper = looper;
        this.audioParamCheck(streamType, sampleRateInHz, channelConfig, audioFormat, mode);
        this.audioBuffSizeCheck(bufferSizeInBytes);
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mStreamType, this.mSampleRate, this.mChannels, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSessionId = session[0];
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
    }

    private void audioParamCheck(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int mode) {
        if (streamType != 4 && streamType != 3 && streamType != 2 && streamType != 1 && streamType != 0 && streamType != 5 && streamType != 6 && streamType != 8) {
            throw new IllegalArgumentException("Invalid stream type.");
        }
        this.mStreamType = streamType;
        if (sampleRateInHz < 4000 || sampleRateInHz > 48000) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannels = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannels = 12;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannels = channelConfig;
                this.mChannelCount = Integer.bitCount(channelConfig);
            }
        }
        switch (audioFormat) {
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: {
                this.mAudioFormat = audioFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
        }
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static boolean isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x4FC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        return true;
    }

    private void audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = this.mChannelCount * (this.mAudioFormat == 3 ? 1 : 2);
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return this.native_get_native_frame_count();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    public int getLatency() {
        return this.native_get_latency();
    }

    public static int getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if ((channelConfig & 0x4FC) != channelConfig) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = Integer.bitCount(channelConfig);
            }
        }
        if (audioFormat != 2 && audioFormat != 3) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 48000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public boolean getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativeEventHandlerDelegate(this, listener, handler) : null;
    }

    public int setStereoVolume(float leftVolume, float rightVolume) {
        if (this.mState == 0) {
            return -3;
        }
        if (leftVolume < AudioTrack.getMinVolume()) {
            leftVolume = AudioTrack.getMinVolume();
        }
        if (leftVolume > AudioTrack.getMaxVolume()) {
            leftVolume = AudioTrack.getMaxVolume();
        }
        if (rightVolume < AudioTrack.getMinVolume()) {
            rightVolume = AudioTrack.getMinVolume();
        }
        if (rightVolume > AudioTrack.getMaxVolume()) {
            rightVolume = AudioTrack.getMaxVolume();
        }
        this.native_setVolume(leftVolume, rightVolume);
        return 0;
    }

    public int setVolume(float volume) {
        return this.setStereoVolume(volume, volume);
    }

    public int setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    public int setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    public int setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    @Deprecated
    protected void setState(int state) {
        this.mState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_start();
            this.mPlayState = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mPlayState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.mPlayState = 2;
        }
    }

    public void flush() {
        if (this.mState == 1) {
            this.native_flush();
        }
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        if (this.mState == 0) {
            return -3;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        if (this.mState == 0) {
            return -3;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    public int attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    public int setAuxEffectSendLevel(float level) {
        if (this.mState == 0) {
            return -3;
        }
        if (level < AudioTrack.getMinVolume()) {
            level = AudioTrack.getMinVolume();
        }
        if (level > AudioTrack.getMaxVolume()) {
            level = AudioTrack.getMaxVolume();
        }
        this.native_setAuxEffectSendLevel(level);
        return 0;
    }

    private static void postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        NativeEventHandlerDelegate delegate = track.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private final native int native_setup(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    private final native void native_finalize();

    private final native void native_release();

    private final native void native_start();

    private final native void native_stop();

    private final native void native_pause();

    private final native void native_flush();

    private final native int native_write_byte(byte[] var1, int var2, int var3, int var4);

    private final native int native_write_short(short[] var1, int var2, int var3, int var4);

    private final native int native_reload_static();

    private final native int native_get_native_frame_count();

    private final native void native_setVolume(float var1, float var2);

    private final native int native_set_playback_rate(int var1);

    private final native int native_get_playback_rate();

    private final native int native_set_marker_pos(int var1);

    private final native int native_get_marker_pos();

    private final native int native_set_pos_update_period(int var1);

    private final native int native_get_pos_update_period();

    private final native int native_set_position(int var1);

    private final native int native_get_position();

    private final native int native_get_latency();

    private final native int native_get_timestamp(long[] var1);

    private final native int native_set_loop(int var1, int var2, int var3);

    private static final native int native_get_output_sample_rate(int var0);

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_attachAuxEffect(int var1);

    private final native void native_setAuxEffectSendLevel(float var1);

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        NativeEventHandlerDelegate(final AudioTrack track, final OnPlaybackPositionUpdateListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            this.mHandler = looper != null ? new Handler(looper){

                public void handleMessage(Message msg) {
                    if (track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (listener == null) break;
                            listener.onMarkerReached(track);
                            break;
                        }
                        case 4: {
                            if (listener == null) break;
                            listener.onPeriodicNotification(track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }
}

