/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.Decorator;
import android.hardware.camera2.utils.UncheckedThrow;
import android.os.DeadObjectException;
import android.os.RemoteException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraBinderDecorator {
    public static final int NO_ERROR = 0;
    public static final int PERMISSION_DENIED = -1;
    public static final int ALREADY_EXISTS = -17;
    public static final int BAD_VALUE = -22;
    public static final int DEAD_OBJECT = -32;
    public static final int EACCES = -13;
    public static final int EBUSY = -16;
    public static final int ENODEV = -19;
    public static final int EOPNOTSUPP = -95;
    public static final int EUSERS = -87;

    public static <T> T newInstance(T obj) {
        return Decorator.newInstance(obj, new CameraBinderDecoratorListener());
    }

    private static class CameraBinderDecoratorListener
    implements Decorator.DecoratorListener {
        private CameraBinderDecoratorListener() {
        }

        public void onBeforeInvocation(Method m, Object[] args) {
        }

        public void onAfterInvocation(Method m, Object[] args, Object result) {
            if (m.getReturnType() == Integer.TYPE) {
                int returnValue = (Integer)result;
                switch (returnValue) {
                    case 0: {
                        return;
                    }
                    case -1: {
                        throw new SecurityException("Lacking privileges to access camera service");
                    }
                    case -17: {
                        return;
                    }
                    case -22: {
                        throw new IllegalArgumentException("Bad argument passed to camera service");
                    }
                    case -32: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(2));
                    }
                    case -13: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(1));
                    }
                    case -16: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(4));
                    }
                    case -87: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(5));
                    }
                    case -19: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(2));
                    }
                    case -95: {
                        UncheckedThrow.throwAnyException(new CameraRuntimeException(1000));
                    }
                }
                if (returnValue < 0) {
                    throw new UnsupportedOperationException(String.format("Unknown error %d", returnValue));
                }
            }
        }

        public boolean onCatchException(Method m, Object[] args, Throwable t) {
            if (t instanceof DeadObjectException) {
                UncheckedThrow.throwAnyException(new CameraRuntimeException(2, "Process hosting the camera service has died unexpectedly", t));
            } else if (t instanceof RemoteException) {
                throw new UnsupportedOperationException("An unknown RemoteException was thrown which should never happen.", t);
            }
            return false;
        }

        public void onFinally(Method m, Object[] args) {
        }
    }
}

