/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.Size;
import android.hardware.camera2.impl.MetadataMarshalClass;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMarshalSize
implements MetadataMarshalClass<Size> {
    private static final int SIZE = 8;

    @Override
    public int marshal(Size value, ByteBuffer buffer, int nativeType, boolean sizeOnly) {
        if (sizeOnly) {
            return 8;
        }
        buffer.putInt(value.getWidth());
        buffer.putInt(value.getHeight());
        return 8;
    }

    @Override
    public Size unmarshal(ByteBuffer buffer, int nativeType) {
        int width = buffer.getInt();
        int height = buffer.getInt();
        return new Size(width, height);
    }

    @Override
    public Class<Size> getMarshalingClass() {
        return Size.class;
    }

    @Override
    public boolean isNativeTypeSupported(int nativeType) {
        return nativeType == 1;
    }

    @Override
    public int getNativeSize(int nativeType) {
        return 8;
    }
}

