/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

public final class Rational {
    private final int mNumerator;
    private final int mDenominator;

    public Rational(int numerator, int denominator) {
        if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        this.mNumerator = numerator;
        this.mDenominator = denominator;
    }

    public int getNumerator() {
        if (this.mDenominator == 0) {
            return 0;
        }
        return this.mNumerator;
    }

    public int getDenominator() {
        return this.mDenominator;
    }

    private boolean isNaN() {
        return this.mDenominator == 0 && this.mNumerator == 0;
    }

    private boolean isInf() {
        return this.mDenominator == 0 && this.mNumerator > 0;
    }

    private boolean isNegInf() {
        return this.mDenominator == 0 && this.mNumerator < 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Rational) {
            Rational other = (Rational)obj;
            if (this.mDenominator == 0 || other.mDenominator == 0) {
                if (this.isNaN() && other.isNaN()) {
                    return true;
                }
                return this.isInf() && other.isInf() || this.isNegInf() && other.isNegInf();
            }
            if (this.mNumerator == other.mNumerator && this.mDenominator == other.mDenominator) {
                return true;
            }
            int thisGcd = this.gcd();
            int otherGcd = other.gcd();
            int thisNumerator = this.mNumerator / thisGcd;
            int thisDenominator = this.mDenominator / thisGcd;
            int otherNumerator = other.mNumerator / otherGcd;
            int otherDenominator = other.mDenominator / otherGcd;
            return thisNumerator == otherNumerator && thisDenominator == otherDenominator;
        }
        return false;
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInf()) {
            return "Infinity";
        }
        if (this.isNegInf()) {
            return "-Infinity";
        }
        return this.mNumerator + "/" + this.mDenominator;
    }

    public float toFloat() {
        return (float)this.mNumerator / (float)this.mDenominator;
    }

    public int hashCode() {
        long INT_MASK = 0xFFFFFFFFL;
        long asLong = 0xFFFFFFFFL & (long)this.mNumerator;
        asLong <<= 32;
        return Long.valueOf(asLong |= 0xFFFFFFFFL & (long)this.mDenominator).hashCode();
    }

    public int gcd() {
        int a = this.mNumerator;
        int b = this.mDenominator;
        while (b != 0) {
            int oldB = b;
            b = a % b;
            a = oldB;
        }
        return Math.abs(a);
    }
}

