/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import dalvik.system.CloseGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemSensorManager
extends SensorManager {
    private static boolean sSensorModuleInitialized = false;
    private static final Object sSensorModuleLock = new Object();
    private static final ArrayList<Sensor> sFullSensorsList = new ArrayList();
    private static final SparseArray<Sensor> sHandleToSensor = new SparseArray();
    private final HashMap<SensorEventListener, SensorEventQueue> mSensorListeners = new HashMap();
    private final HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners = new HashMap();
    private final Looper mMainLooper;
    private final int mTargetSdkLevel;

    private static native void nativeClassInit();

    private static native int nativeGetNextSensor(Sensor var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemSensorManager(Context context, Looper mainLooper) {
        this.mMainLooper = mainLooper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        Object object = sSensorModuleLock;
        synchronized (object) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SystemSensorManager.nativeClassInit();
                ArrayList<Sensor> fullList = sFullSensorsList;
                int i = 0;
                do {
                    Sensor sensor;
                    if ((i = SystemSensorManager.nativeGetNextSensor(sensor = new Sensor(), i)) < 0) continue;
                    fullList.add(sensor);
                    sHandleToSensor.append(sensor.getHandle(), sensor);
                } while (i > 0);
            }
        }
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return sFullSensorsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
        if (listener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (Sensor.getReportingMode(sensor) == Sensor.REPORTING_MODE_ONE_SHOT) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
                queue = new SensorEventQueue(listener, looper, this);
                if (!queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags)) {
                    queue.dispose();
                    return false;
                }
                this.mSensorListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
        if (sensor != null && Sensor.getReportingMode(sensor) == Sensor.REPORTING_MODE_ONE_SHOT) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean result;
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue != null && (result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, true)) && !queue.hasSensors()) {
                this.mSensorListeners.remove(listener);
                queue.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (Sensor.getReportingMode(sensor) != Sensor.REPORTING_MODE_ONE_SHOT) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue == null) {
                queue = new TriggerEventQueue(listener, this.mMainLooper, this);
                if (!queue.addSensor(sensor, 0, 0, 0)) {
                    queue.dispose();
                    return false;
                }
                this.mTriggerListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
        if (sensor != null && Sensor.getReportingMode(sensor) != Sensor.REPORTING_MODE_ONE_SHOT) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue != null) {
                boolean result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, disable);
                if (result && !queue.hasSensors()) {
                    this.mTriggerListeners.remove(listener);
                    queue.dispose();
                }
                return result;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushImpl(SensorEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                return false;
            }
            return queue.flush() == 0;
        }
    }

    static final class TriggerEventQueue
    extends BaseEventQueue {
        private final TriggerEventListener mListener;
        private final SparseArray<TriggerEvent> mTriggerEvents = new SparseArray();

        public TriggerEventQueue(TriggerEventListener listener, Looper looper, SystemSensorManager manager) {
            super(looper, manager);
            this.mListener = listener;
        }

        public void addSensorEvent(Sensor sensor) {
            TriggerEvent t = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            this.mTriggerEvents.put(sensor.getHandle(), t);
        }

        public void removeSensorEvent(Sensor sensor) {
            this.mTriggerEvents.delete(sensor.getHandle());
        }

        protected void dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
            Sensor sensor = (Sensor)sHandleToSensor.get(handle);
            TriggerEvent t = this.mTriggerEvents.get(handle);
            if (t == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            System.arraycopy(values, 0, t.values, 0, t.values.length);
            t.timestamp = timestamp;
            t.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(t);
        }

        protected void dispatchFlushCompleteEvent(int handle) {
        }
    }

    static final class SensorEventQueue
    extends BaseEventQueue {
        private final SensorEventListener mListener;
        private final SparseArray<SensorEvent> mSensorsEvents = new SparseArray();

        public SensorEventQueue(SensorEventListener listener, Looper looper, SystemSensorManager manager) {
            super(looper, manager);
            this.mListener = listener;
        }

        public void addSensorEvent(Sensor sensor) {
            SensorEvent t = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            this.mSensorsEvents.put(sensor.getHandle(), t);
        }

        public void removeSensorEvent(Sensor sensor) {
            this.mSensorsEvents.delete(sensor.getHandle());
        }

        protected void dispatchSensorEvent(int handle, float[] values, int inAccuracy, long timestamp) {
            Sensor sensor = (Sensor)sHandleToSensor.get(handle);
            SensorEvent t = this.mSensorsEvents.get(handle);
            if (t == null) {
                Log.e("SensorManager", "Error: Sensor Event is null for Sensor: " + sensor);
                return;
            }
            System.arraycopy(values, 0, t.values, 0, t.values.length);
            t.timestamp = timestamp;
            t.accuracy = inAccuracy;
            t.sensor = sensor;
            switch (t.sensor.getType()) {
                case 2: 
                case 3: {
                    int accuracy = this.mSensorAccuracies.get(handle);
                    if (t.accuracy < 0 || accuracy == t.accuracy) break;
                    this.mSensorAccuracies.put(handle, t.accuracy);
                    this.mListener.onAccuracyChanged(t.sensor, t.accuracy);
                    break;
                }
                default: {
                    if (this.mFirstEvent.get(handle)) break;
                    this.mFirstEvent.put(handle, true);
                    this.mListener.onAccuracyChanged(t.sensor, 3);
                }
            }
            this.mListener.onSensorChanged(t);
        }

        protected void dispatchFlushCompleteEvent(int handle) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)sHandleToSensor.get(handle);
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }
    }

    private static abstract class BaseEventQueue {
        private int nSensorEventQueue;
        private final SparseBooleanArray mActiveSensors = new SparseBooleanArray();
        protected final SparseIntArray mSensorAccuracies = new SparseIntArray();
        protected final SparseBooleanArray mFirstEvent = new SparseBooleanArray();
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private final float[] mScratch = new float[16];
        protected final SystemSensorManager mManager;

        private native int nativeInitBaseEventQueue(BaseEventQueue var1, MessageQueue var2, float[] var3);

        private static native int nativeEnableSensor(int var0, int var1, int var2, int var3, int var4);

        private static native int nativeDisableSensor(int var0, int var1);

        private static native void nativeDestroySensorEventQueue(int var0);

        private static native int nativeFlushSensor(int var0);

        BaseEventQueue(Looper looper, SystemSensorManager manager) {
            this.nSensorEventQueue = this.nativeInitBaseEventQueue(this, looper.getQueue(), this.mScratch);
            this.mCloseGuard.open("dispose");
            this.mManager = manager;
        }

        public void dispose() {
            this.dispose(false);
        }

        public boolean addSensor(Sensor sensor, int delayUs, int maxBatchReportLatencyUs, int reservedFlags) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                return false;
            }
            this.mActiveSensors.put(handle, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags) != 0 && (maxBatchReportLatencyUs == 0 || maxBatchReportLatencyUs > 0 && this.enableSensor(sensor, delayUs, 0, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        public boolean removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int handle = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)sHandleToSensor.get(handle);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(handle, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        public boolean removeSensor(Sensor sensor, boolean disable) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                if (disable) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                return true;
            }
            return false;
        }

        public int flush() {
            if (this.nSensorEventQueue == 0) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.nSensorEventQueue);
        }

        public boolean hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.dispose(true);
            }
            finally {
                super.finalize();
            }
        }

        private void dispose(boolean finalized) {
            if (this.mCloseGuard != null) {
                if (finalized) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.nSensorEventQueue != 0) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.nSensorEventQueue);
                this.nSensorEventQueue = 0;
            }
        }

        private int enableSensor(Sensor sensor, int rateUs, int maxBatchReportLatencyUs, int reservedFlags) {
            if (this.nSensorEventQueue == 0) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.nSensorEventQueue, sensor.getHandle(), rateUs, maxBatchReportLatencyUs, reservedFlags);
        }

        private int disableSensor(Sensor sensor) {
            if (this.nSensorEventQueue == 0) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.nSensorEventQueue, sensor.getHandle());
        }

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void removeSensorEvent(Sensor var1);
    }
}

