/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;

public class ComposeShader
extends Shader {
    private static final int TYPE_XFERMODE = 1;
    private static final int TYPE_PORTERDUFFMODE = 2;
    private int mType;
    private Xfermode mXferMode;
    private PorterDuff.Mode mPorterDuffMode;
    private final Shader mShaderA;
    private final Shader mShaderB;

    public ComposeShader(Shader shaderA, Shader shaderB, Xfermode mode) {
        this.mType = 1;
        this.mShaderA = shaderA;
        this.mShaderB = shaderB;
        this.mXferMode = mode;
        this.native_instance = ComposeShader.nativeCreate1(shaderA.native_instance, shaderB.native_instance, mode != null ? mode.native_instance : 0);
        if (mode instanceof PorterDuffXfermode) {
            PorterDuff.Mode pdMode = ((PorterDuffXfermode)mode).mode;
            this.native_shader = ComposeShader.nativePostCreate2(this.native_instance, shaderA.native_shader, shaderB.native_shader, pdMode != null ? pdMode.nativeInt : 0);
        } else {
            this.native_shader = ComposeShader.nativePostCreate1(this.native_instance, shaderA.native_shader, shaderB.native_shader, mode != null ? mode.native_instance : 0);
        }
    }

    public ComposeShader(Shader shaderA, Shader shaderB, PorterDuff.Mode mode) {
        this.mType = 2;
        this.mShaderA = shaderA;
        this.mShaderB = shaderB;
        this.mPorterDuffMode = mode;
        this.native_instance = ComposeShader.nativeCreate2(shaderA.native_instance, shaderB.native_instance, mode.nativeInt);
        this.native_shader = ComposeShader.nativePostCreate2(this.native_instance, shaderA.native_shader, shaderB.native_shader, mode.nativeInt);
    }

    protected Shader copy() {
        ComposeShader copy;
        switch (this.mType) {
            case 1: {
                copy = new ComposeShader(this.mShaderA.copy(), this.mShaderB.copy(), this.mXferMode);
                break;
            }
            case 2: {
                copy = new ComposeShader(this.mShaderA.copy(), this.mShaderB.copy(), this.mPorterDuffMode);
                break;
            }
            default: {
                throw new IllegalArgumentException("ComposeShader should be created with either Xfermode or PorterDuffMode");
            }
        }
        this.copyLocalMatrix(copy);
        return copy;
    }

    private static native int nativeCreate1(int var0, int var1, int var2);

    private static native int nativeCreate2(int var0, int var1, int var2);

    private static native int nativePostCreate1(int var0, int var1, int var2, int var3);

    private static native int nativePostCreate2(int var0, int var1, int var2, int var3);
}

