/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Matrix;

public class Camera {
    private Matrix mMatrix;
    int native_instance;

    public Camera() {
        this.nativeConstructor();
    }

    public native void save();

    public native void restore();

    public native void translate(float var1, float var2, float var3);

    public native void rotateX(float var1);

    public native void rotateY(float var1);

    public native void rotateZ(float var1);

    public native void rotate(float var1, float var2, float var3);

    public native float getLocationX();

    public native float getLocationY();

    public native float getLocationZ();

    public native void setLocation(float var1, float var2, float var3);

    public void getMatrix(Matrix matrix) {
        this.nativeGetMatrix(matrix.native_instance);
    }

    public void applyToCanvas(Canvas canvas) {
        if (canvas.isHardwareAccelerated()) {
            if (this.mMatrix == null) {
                this.mMatrix = new Matrix();
            }
            this.getMatrix(this.mMatrix);
            canvas.concat(this.mMatrix);
        } else {
            this.nativeApplyToCanvas(canvas.mNativeCanvas);
        }
    }

    public native float dotWithNormal(float var1, float var2, float var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.nativeDestructor();
        }
        finally {
            super.finalize();
        }
    }

    private native void nativeConstructor();

    private native void nativeDestructor();

    private native void nativeGetMatrix(int var1);

    private native void nativeApplyToCanvas(int var1);
}

