/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.performance;

public class Throughput {
    private final int mTotalFrames;
    private final int mPeriodFrames;
    private final int mPeriodTime;
    private final int mPixels;

    public Throughput(int totalFrames, int periodFrames, int periodTime, int pixels) {
        this.mTotalFrames = totalFrames;
        this.mPeriodFrames = periodFrames;
        this.mPeriodTime = periodTime;
        this.mPixels = pixels;
    }

    public int getTotalFrameCount() {
        return this.mTotalFrames;
    }

    public int getPeriodFrameCount() {
        return this.mPeriodFrames;
    }

    public int getPeriodTime() {
        return this.mPeriodTime;
    }

    public float getFramesPerSecond() {
        return (float)this.mPeriodFrames / (float)this.mPeriodTime;
    }

    public float getNanosPerPixel() {
        double frameTimeInNanos = (double)this.mPeriodTime / (double)this.mPeriodFrames * 1000000.0;
        return (float)(frameTimeInNanos / (double)this.mPixels);
    }

    public String toString() {
        return this.getFramesPerSecond() + " FPS";
    }
}

