/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ImageFormat;
import android.graphics.Bitmap;

public class BitmapSource
extends Filter {
    @GenerateFieldPort(name="target")
    String mTargetString;
    @GenerateFieldPort(name="bitmap")
    private Bitmap mBitmap;
    @GenerateFieldPort(name="recycleBitmap", hasDefault=true)
    private boolean mRecycleBitmap = true;
    @GenerateFieldPort(name="repeatFrame", hasDefault=true)
    boolean mRepeatFrame = false;
    private int mTarget;
    private Frame mImageFrame;

    public BitmapSource(String name) {
        super(name);
    }

    public void setupPorts() {
        MutableFrameFormat outputFormat = ImageFormat.create(3, 0);
        this.addOutputPort("image", outputFormat);
    }

    public void loadImage(FilterContext filterContext) {
        this.mTarget = FrameFormat.readTargetString(this.mTargetString);
        MutableFrameFormat outputFormat = ImageFormat.create(this.mBitmap.getWidth(), this.mBitmap.getHeight(), 3, this.mTarget);
        this.mImageFrame = filterContext.getFrameManager().newFrame(outputFormat);
        this.mImageFrame.setBitmap(this.mBitmap);
        this.mImageFrame.setTimestamp(-1L);
        if (this.mRecycleBitmap) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
    }

    public void fieldPortValueUpdated(String name, FilterContext context) {
        if ((name.equals("bitmap") || name.equals("target")) && this.mImageFrame != null) {
            this.mImageFrame.release();
            this.mImageFrame = null;
        }
    }

    public void process(FilterContext context) {
        if (this.mImageFrame == null) {
            this.loadImage(context);
        }
        this.pushOutput("image", this.mImageFrame);
        if (!this.mRepeatFrame) {
            this.closeOutputPort("image");
        }
    }

    public void tearDown(FilterContext env) {
        if (this.mImageFrame != null) {
            this.mImageFrame.release();
            this.mImageFrame = null;
        }
    }
}

