/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmEvent;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrmErrorEvent
extends DrmEvent {
    public static final int TYPE_RIGHTS_NOT_INSTALLED = 2001;
    public static final int TYPE_RIGHTS_RENEWAL_NOT_ALLOWED = 2002;
    public static final int TYPE_NOT_SUPPORTED = 2003;
    public static final int TYPE_OUT_OF_MEMORY = 2004;
    public static final int TYPE_NO_INTERNET_CONNECTION = 2005;
    public static final int TYPE_PROCESS_DRM_INFO_FAILED = 2006;
    public static final int TYPE_REMOVE_ALL_RIGHTS_FAILED = 2007;
    public static final int TYPE_ACQUIRE_DRM_INFO_FAILED = 2008;

    public DrmErrorEvent(int uniqueId, int type, String message) {
        super(uniqueId, type, message);
        this.checkTypeValidity(type);
    }

    public DrmErrorEvent(int uniqueId, int type, String message, HashMap<String, Object> attributes) {
        super(uniqueId, type, message, attributes);
        this.checkTypeValidity(type);
    }

    private void checkTypeValidity(int type) {
        if (type < 2001 || type > 2008) {
            String msg = "Unsupported type: " + type;
            throw new IllegalArgumentException(msg);
        }
    }
}

