/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.harmony.security.fortress.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Services {
    private static final Map<String, Provider.Service> services = new HashMap<String, Provider.Service>(600);
    private static Provider.Service cachedSecureRandomService;
    private static boolean needRefresh;
    private static int cacheVersion;
    private static final List<Provider> providers;
    private static final Map<String, Provider> providersNames;

    public static synchronized Provider[] getProviders() {
        return providers.toArray(new Provider[providers.size()]);
    }

    public static synchronized List<Provider> getProvidersList() {
        return new ArrayList<Provider>(providers);
    }

    public static synchronized Provider getProvider(String name) {
        if (name == null) {
            return null;
        }
        return providersNames.get(name);
    }

    public static synchronized int insertProviderAt(Provider provider, int position) {
        int size = providers.size();
        if (position < 1 || position > size) {
            position = size + 1;
        }
        providers.add(position - 1, provider);
        providersNames.put(provider.getName(), provider);
        Services.setNeedRefresh();
        return position;
    }

    public static synchronized void removeProvider(int providerNumber) {
        Provider p = providers.remove(providerNumber - 1);
        providersNames.remove(p.getName());
        Services.setNeedRefresh();
    }

    public static synchronized void initServiceInfo(Provider p) {
        for (Provider.Service service : p.getServices()) {
            String key;
            String type = service.getType();
            if (cachedSecureRandomService == null && type.equals("SecureRandom")) {
                cachedSecureRandomService = service;
            }
            if (!services.containsKey(key = type + "." + service.getAlgorithm().toUpperCase(Locale.US))) {
                services.put(key, service);
            }
            for (String alias : Engine.door.getAliases(service)) {
                key = type + "." + alias.toUpperCase(Locale.US);
                if (services.containsKey(key)) continue;
                services.put(key, service);
            }
        }
    }

    public static synchronized boolean isEmpty() {
        return services.isEmpty();
    }

    public static synchronized Provider.Service getService(String key) {
        return services.get(key);
    }

    public static synchronized Provider.Service getSecureRandomService() {
        Services.getCacheVersion();
        return cachedSecureRandomService;
    }

    public static synchronized void setNeedRefresh() {
        needRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getCacheVersion() {
        if (needRefresh) {
            ++cacheVersion;
            Map<String, Provider.Service> map = services;
            synchronized (map) {
                services.clear();
            }
            cachedSecureRandomService = null;
            for (Provider p : providers) {
                Services.initServiceInfo(p);
            }
            needRefresh = false;
        }
        return cacheVersion;
    }

    static {
        cacheVersion = 1;
        providers = new ArrayList<Provider>(20);
        providersNames = new HashMap<String, Provider>(20);
        String providerClassName = null;
        int i = 1;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        while ((providerClassName = Security.getProperty("security.provider." + i++)) != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassName.trim(), true, cl);
                Provider p = (Provider)providerClass.newInstance();
                providers.add(p);
                providersNames.put(p.getName(), p);
                Services.initServiceInfo(p);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InstantiationException instantiationException) {}
        }
        Engine.door.renumProviders();
    }
}

