/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import libcore.net.UriCodec;

public class FileURLConnection
extends URLConnection {
    private String filename;
    private InputStream is;
    private int length = -1;
    private boolean isDir;
    private FilePermission permission;

    public FileURLConnection(URL url) {
        super(url);
        this.filename = url.getFile();
        if (this.filename == null) {
            this.filename = "";
        }
        this.filename = UriCodec.decode(this.filename);
    }

    public void connect() throws IOException {
        File f = new File(this.filename);
        if (f.isDirectory()) {
            this.isDir = true;
            this.is = this.getDirectoryListing(f);
        } else {
            this.is = new BufferedInputStream(new FileInputStream(f));
            long lengthAsLong = f.length();
            this.length = lengthAsLong <= Integer.MAX_VALUE ? (int)lengthAsLong : Integer.MAX_VALUE;
        }
        this.connected = true;
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.length;
    }

    public String getContentType() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException e) {
            return "content/unknown";
        }
        if (this.isDir) {
            return "text/plain";
        }
        String result = FileURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result != null) {
            return result;
        }
        try {
            result = FileURLConnection.guessContentTypeFromStream(this.is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        return "content/unknown";
    }

    private InputStream getDirectoryListing(File f) {
        String[] fileList = f.list();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        out.print("<title>Directory Listing</title>\n");
        out.print("<base href=\"file:");
        out.print(f.getPath().replace('\\', '/') + "/\"><h1>" + f.getPath() + "</h1>\n<hr>\n");
        for (int i = 0; i < fileList.length; ++i) {
            out.print(fileList[i] + "<br>\n");
        }
        out.close();
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String path = this.filename;
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            this.permission = new FilePermission(path, "read");
        }
        return this.permission;
    }
}

