/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.validation.SchemaFactory;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SchemaFactoryFinder {
    private static final String W3C_XML_SCHEMA10_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.0";
    private static final String W3C_XML_SCHEMA11_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public SchemaFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        if (this.classLoader == Thread.currentThread().getContextClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
            return;
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String schemaLanguage) {
        if (schemaLanguage == null) {
            throw new NullPointerException("schemaLanguage == null");
        }
        SchemaFactory f = this._newFactory(schemaLanguage);
        if (debug) {
            if (f != null) {
                SchemaFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + schemaLanguage);
            } else {
                SchemaFactoryFinder.debugPrintln("unable to find a factory for " + schemaLanguage);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String schemaLanguage) {
        SchemaFactory sf;
        block31: {
            String propertyName;
            block30: {
                propertyName = SERVICE_CLASS.getName() + ":" + schemaLanguage;
                try {
                    String r;
                    if (debug) {
                        SchemaFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    }
                    if ((r = System.getProperty(propertyName)) != null && r.length() > 0) {
                        if (debug) {
                            SchemaFactoryFinder.debugPrintln("The value is '" + r + "'");
                        }
                        if ((sf = this.createInstance(r)) != null) {
                            return sf;
                        }
                    } else if (debug) {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (VirtualMachineError vme) {
                    throw vme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (!debug) break block30;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (f.exists()) {
                                if (debug) {
                                    SchemaFactoryFinder.debugPrintln("Read properties file " + f);
                                }
                                cacheProps.load(new FileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                }
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block31;
                ex.printStackTrace();
            }
        }
        for (URL resource : this.createServiceFileIterator()) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("looking into " + resource);
            }
            try {
                sf = this.loadFromServicesFile(schemaLanguage, resource.toExternalForm(), resource.openStream());
                if (sf == null) continue;
                return sf;
            }
            catch (IOException e) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || schemaLanguage.equals(W3C_XML_SCHEMA10_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.0 validator");
            }
            return this.createInstance("org.apache.xerces.jaxp.validation.XMLSchemaFactory");
        }
        if (schemaLanguage.equals(W3C_XML_SCHEMA11_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.1 validator");
            }
            return this.createInstance("org.apache.xerces.jaxp.validation.XMLSchema11Factory");
        }
        if (debug) {
            SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    SchemaFactory createInstance(String className) {
        block8: {
            try {
                Object o;
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("instantiating " + className);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("loaded it from " + SchemaFactoryFinder.which(clazz));
                }
                if ((o = clazz.newInstance()) instanceof SchemaFactory) {
                    return (SchemaFactory)o;
                }
                if (debug) {
                    SchemaFactoryFinder.debugPrintln(className + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                SchemaFactoryFinder.debugPrintln("failed to instantiate " + className);
                if (!debug) break block8;
                t.printStackTrace();
            }
        }
        return null;
    }

    private Iterable<URL> createServiceFileIterator() {
        if (this.classLoader == null) {
            ClassLoader classLoader = SchemaFactoryFinder.class.getClassLoader();
            return Collections.singleton(classLoader.getResource(SERVICE_ID));
        }
        try {
            Enumeration<URL> e = this.classLoader.getResources(SERVICE_ID);
            if (debug && !e.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return Collections.list(e);
        }
        catch (IOException e) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private SchemaFactory loadFromServicesFile(String schemaLanguage, String resourceName, InputStream in) {
        BufferedReader rd;
        if (debug) {
            SchemaFactoryFinder.debugPrintln("Reading " + resourceName);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(in, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(in), 80);
        }
        String factoryClassName = null;
        SchemaFactory resultFactory = null;
        while (true) {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException x) {
                break;
            }
            if (factoryClassName == null) break;
            int hashIndex = factoryClassName.indexOf(35);
            if (hashIndex != -1) {
                factoryClassName = factoryClassName.substring(0, hashIndex);
            }
            if ((factoryClassName = factoryClassName.trim()).length() == 0) continue;
            try {
                SchemaFactory foundFactory = this.createInstance(factoryClassName);
                if (!foundFactory.isSchemaLanguageSupported(schemaLanguage)) continue;
                resultFactory = foundFactory;
            }
            catch (Exception ignored) {
                continue;
            }
            break;
        }
        IoUtils.closeQuietly(rd);
        return resultFactory;
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return (it = loader.getResource(classnameAsResource)) != null ? it.toString() : null;
    }

    static {
        String val = System.getProperty("jaxp.debug");
        debug = val != null && !"false".equals(val);
        SERVICE_CLASS = SchemaFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }
}

