/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;
import javax.net.ssl.SSLContext;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static ServerSocketFactory defaultServerSocketFactory;
    private static String defaultName;

    public static synchronized ServerSocketFactory getDefault() {
        if (defaultServerSocketFactory != null) {
            return defaultServerSocketFactory;
        }
        if (defaultName == null && (defaultName = Security.getProperty("ssl.ServerSocketFactory.provider")) != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> ssfc = Class.forName(defaultName, true, cl);
                defaultServerSocketFactory = (ServerSocketFactory)ssfc.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (defaultServerSocketFactory == null) {
            SSLContext context;
            try {
                context = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                context = null;
            }
            if (context != null) {
                defaultServerSocketFactory = context.getServerSocketFactory();
            }
        }
        if (defaultServerSocketFactory == null) {
            defaultServerSocketFactory = new DefaultSSLServerSocketFactory("No ServerSocketFactory installed");
        }
        return defaultServerSocketFactory;
    }

    protected SSLServerSocketFactory() {
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

