/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger();
    transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
            Object var3_2 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            takeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
            Object var3_2 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            putLock.unlock();
            throw throwable;
        }
    }

    private void enqueue(Node<E> node) {
        this.last.next = node;
        this.last = this.last.next;
    }

    private E dequeue() {
        Node<E> h = this.head;
        Node first = h.next;
        h.next = h;
        this.head = first;
        Object x = first.item;
        first.item = null;
        return x;
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue(Collection<? extends E> c) {
        this(Integer.MAX_VALUE);
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            int n = 0;
            for (E e : c) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (n == this.capacity) {
                    throw new IllegalStateException("Queue full");
                }
                super.enqueue(new Node<E>(e));
                ++n;
            }
            this.count.set(n);
            Object var7_6 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            putLock.unlock();
            throw throwable;
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int c = -1;
        Node<E> node = new Node<E>(e);
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            while (count.get() == this.capacity) {
                this.notFull.await();
            }
            this.enqueue(node);
            c = count.getAndIncrement();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
            Object var7_6 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            putLock.unlock();
            throw throwable;
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        int c = -1;
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        putLock.lockInterruptibly();
        try {
            while (count.get() == this.capacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    Object var12_9 = null;
                    putLock.unlock();
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.enqueue(new Node<E>(e));
            c = count.getAndIncrement();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            putLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        putLock.unlock();
        if (c == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int c = -1;
        Node<E> node = new Node<E>(e);
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (count.get() < this.capacity) {
                this.enqueue(node);
                c = count.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
            Object var7_6 = null;
            putLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            putLock.unlock();
            throw throwable;
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E x;
        int c = -1;
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                this.notEmpty.await();
            }
            x = this.dequeue();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            Object var6_5 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            takeLock.unlock();
            throw throwable;
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E x = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    Object var12_9 = null;
                    takeLock.unlock();
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            x = this.dequeue();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            takeLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        takeLock.unlock();
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        E x = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                x = this.dequeue();
                c = count.getAndDecrement();
                if (c > 1) {
                    this.notEmpty.signal();
                }
            }
            Object var6_5 = null;
            takeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            takeLock.unlock();
            throw throwable;
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Node first;
        ReentrantLock takeLock;
        block4: {
            E e;
            if (this.count.get() == 0) {
                return null;
            }
            takeLock = this.takeLock;
            takeLock.lock();
            try {
                first = this.head.next;
                if (first != null) break block4;
                e = null;
                Object var5_5 = null;
                takeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                takeLock.unlock();
                throw throwable;
            }
            return e;
        }
        Object e = first.item;
        Object var5_6 = null;
        takeLock.unlock();
        return e;
    }

    void unlink(Node<E> p, Node<E> trail) {
        p.item = null;
        trail.next = p.next;
        if (this.last == p) {
            this.last = trail;
        }
        if (this.count.getAndDecrement() == this.capacity) {
            this.notFull.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node<E> trail = this.head;
            Node p = trail.next;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p, trail);
                    boolean bl2 = true;
                    Object var6_6 = null;
                    this.fullyUnlock();
                    return bl2;
                }
                trail = p;
                p = p.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fullyUnlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.fullyUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node p = this.head.next;
            while (p != null) {
                if (o.equals(p.item)) {
                    boolean bl2 = true;
                    Object var5_5 = null;
                    this.fullyUnlock();
                    return bl2;
                }
                p = p.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fullyUnlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.fullyUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int size = this.count.get();
            Object[] a = new Object[size];
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            Object[] objectArray = a;
            Object var6_5 = null;
            this.fullyUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.fullyLock();
        try {
            int size = this.count.get();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            if (a.length > k) {
                a[k] = null;
            }
            Object[] objectArray = a;
            Object var6_5 = null;
            this.fullyUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        String string2;
        this.fullyLock();
        try {
            Node p = this.head.next;
            if (p == null) {
                String string3 = "[]";
                Object var6_4 = null;
                this.fullyUnlock();
                return string3;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Object e;
                sb.append((Object)((e = p.item) == this ? "(this Collection)" : e));
                p = p.next;
                if (p == null) {
                    string2 = sb.append(']').toString();
                    break;
                }
                sb.append(',').append(' ');
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
        Object var6_5 = null;
        this.fullyUnlock();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            Node p;
            Node<E> h = this.head;
            while ((p = h.next) != null) {
                h.next = h;
                p.item = null;
                h = p;
            }
            this.head = this.last;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signal();
            }
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        boolean signalNotFull = false;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            int n;
            block8: {
                boolean bl;
                int i;
                int n2 = Math.min(maxElements, this.count.get());
                Node<E> h = this.head;
                try {
                    for (i = 0; i < n2; ++i) {
                        Node p = h.next;
                        c.add(p.item);
                        p.item = null;
                        h.next = h;
                        h = p;
                    }
                    n = n2;
                    Object var10_10 = null;
                    if (i <= 0) break block8;
                    this.head = h;
                    bl = this.count.getAndAdd(-i) == this.capacity;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (i <= 0) throw throwable;
                    this.head = h;
                    signalNotFull = this.count.getAndAdd(-i) == this.capacity;
                    throw throwable;
                }
                signalNotFull = bl;
            }
            Object var12_12 = null;
            takeLock.unlock();
            if (!signalNotFull) return n;
            this.signalNotFull();
            return n;
        }
        catch (Throwable throwable2) {
            Object var12_13 = null;
            takeLock.unlock();
            if (!signalNotFull) throw throwable2;
            this.signalNotFull();
            throw throwable2;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fullyLock();
        try {
            s.defaultWriteObject();
            Node p = this.head.next;
            while (p != null) {
                s.writeObject(p.item);
                p = p.next;
            }
            s.writeObject(null);
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.count.set(0);
        this.head = new Node<Object>(null);
        this.last = this.head;
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            LinkedBlockingQueue.this.fullyLock();
            try {
                this.current = LinkedBlockingQueue.this.head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                Object var3_2 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        private Node<E> nextNode(Node<E> p) {
            Node s;
            while ((s = p.next) != p) {
                if (s == null || s.item != null) {
                    return s;
                }
                p = s;
            }
            return LinkedBlockingQueue.this.head.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e;
            LinkedBlockingQueue.this.fullyLock();
            try {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object x = this.currentElement;
                this.lastRet = this.current;
                this.current = this.nextNode(this.current);
                this.currentElement = this.current == null ? null : this.current.item;
                e = x;
                Object var4_3 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LinkedBlockingQueue.this.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node trail = LinkedBlockingQueue.this.head;
                Node p = trail.next;
                while (p != null) {
                    if (p == node) {
                        LinkedBlockingQueue.this.unlink(p, trail);
                        break;
                    }
                    trail = p;
                    p = p.next;
                }
                Object var5_4 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<E> {
        E item;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }
}

