/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Date;
import java.util.Grego;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private static final long serialVersionUID = -403250971215465050L;
    private int rawOffset;
    private int startYear;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startMode;
    private int endMode;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    public static final int UTC_TIME = 2;
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    private boolean useDaylight;
    private int dstSavings = 3600000;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("dstSavings", Integer.TYPE), new ObjectStreamField("endDay", Integer.TYPE), new ObjectStreamField("endDayOfWeek", Integer.TYPE), new ObjectStreamField("endMode", Integer.TYPE), new ObjectStreamField("endMonth", Integer.TYPE), new ObjectStreamField("endTime", Integer.TYPE), new ObjectStreamField("monthLength", byte[].class), new ObjectStreamField("rawOffset", Integer.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE), new ObjectStreamField("startDay", Integer.TYPE), new ObjectStreamField("startDayOfWeek", Integer.TYPE), new ObjectStreamField("startMode", Integer.TYPE), new ObjectStreamField("startMonth", Integer.TYPE), new ObjectStreamField("startTime", Integer.TYPE), new ObjectStreamField("startYear", Integer.TYPE), new ObjectStreamField("useDaylight", Boolean.TYPE)};

    public SimpleTimeZone(int offset, String name) {
        this.setID(name);
        this.rawOffset = offset;
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(offset, name, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, 3600000);
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int daylightSavings) {
        this(offset, name);
        if (daylightSavings <= 0) {
            throw new IllegalArgumentException("Invalid daylightSavings: " + daylightSavings);
        }
        this.dstSavings = daylightSavings;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.setStartMode();
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.setEndMode();
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int daylightSavings) {
        this(offset, name, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, daylightSavings);
        this.startMode = startTimeMode;
        this.endMode = endTimeMode;
    }

    public Object clone() {
        SimpleTimeZone zone = (SimpleTimeZone)super.clone();
        return zone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone tz = (SimpleTimeZone)object;
        return this.getID().equals(tz.getID()) && this.rawOffset == tz.rawOffset && this.useDaylight == tz.useDaylight && (!this.useDaylight || this.startYear == tz.startYear && this.startMonth == tz.startMonth && this.startDay == tz.startDay && this.startMode == tz.startMode && this.startDayOfWeek == tz.startDayOfWeek && this.startTime == tz.startTime && this.endMonth == tz.endMonth && this.endDay == tz.endDay && this.endDayOfWeek == tz.endDayOfWeek && this.endTime == tz.endTime && this.endMode == tz.endMode && this.dstSavings == tz.dstSavings);
    }

    public int getDSTSavings() {
        if (!this.useDaylight) {
            return 0;
        }
        return this.dstSavings;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        int daysInMonth;
        if (era != 0 && era != 1) {
            throw new IllegalArgumentException("Invalid era: " + era);
        }
        this.checkRange(month, dayOfWeek, time);
        if (month != 1 || day != 29 || !this.isLeapYear(year)) {
            this.checkDay(month, day);
        }
        if (!this.useDaylightTime() || era != 1 || year < this.startYear) {
            return this.rawOffset;
        }
        if (this.endMonth < this.startMonth ? month > this.endMonth && month < this.startMonth : month < this.startMonth || month > this.endMonth) {
            return this.rawOffset;
        }
        int ruleDay = 0;
        int firstDayOfMonth = this.mod7(dayOfWeek - day);
        if (month == this.startMonth) {
            switch (this.startMode) {
                case 1: {
                    ruleDay = this.startDay;
                    break;
                }
                case 2: {
                    if (this.startDay >= 0) {
                        ruleDay = this.mod7(this.startDayOfWeek - firstDayOfMonth) + 1 + (this.startDay - 1) * 7;
                        break;
                    }
                    daysInMonth = GregorianCalendar.DaysInMonth[this.startMonth];
                    if (this.startMonth == 1 && this.isLeapYear(year)) {
                        ++daysInMonth;
                    }
                    ruleDay = daysInMonth + 1 + this.mod7(this.startDayOfWeek - (firstDayOfMonth + daysInMonth)) + this.startDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    if (ruleDay == this.startDay) break;
                    ruleDay -= 7;
                }
            }
            if (ruleDay > day || ruleDay == day && time < this.startTime) {
                return this.rawOffset;
            }
        }
        int ruleTime = this.endTime - this.dstSavings;
        int nextMonth = (month + 1) % 12;
        if (month == this.endMonth || ruleTime < 0 && nextMonth == this.endMonth) {
            switch (this.endMode) {
                case 1: {
                    ruleDay = this.endDay;
                    break;
                }
                case 2: {
                    if (this.endDay >= 0) {
                        ruleDay = this.mod7(this.endDayOfWeek - firstDayOfMonth) + 1 + (this.endDay - 1) * 7;
                        break;
                    }
                    daysInMonth = GregorianCalendar.DaysInMonth[this.endMonth];
                    if (this.endMonth == 1 && this.isLeapYear(year)) {
                        ++daysInMonth;
                    }
                    ruleDay = daysInMonth + 1 + this.mod7(this.endDayOfWeek - (firstDayOfMonth + daysInMonth)) + this.endDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    if (ruleDay == this.endDay) break;
                    ruleDay -= 7;
                }
            }
            int ruleMonth = this.endMonth;
            if (ruleTime < 0) {
                int changeDays = 1 - ruleTime / 86400000;
                ruleTime = ruleTime % 86400000 + 86400000;
                if ((ruleDay -= changeDays) <= 0) {
                    if (--ruleMonth < 0) {
                        ruleMonth = 11;
                    }
                    ruleDay += GregorianCalendar.DaysInMonth[ruleMonth];
                    if (ruleMonth == 1 && this.isLeapYear(year)) {
                        ++ruleDay;
                    }
                }
            }
            if (month == ruleMonth ? ruleDay < day || ruleDay == day && time >= ruleTime : nextMonth != ruleMonth) {
                return this.rawOffset;
            }
        }
        return this.rawOffset + this.dstSavings;
    }

    public int getOffset(long time) {
        if (!this.useDaylightTime()) {
            return this.rawOffset;
        }
        int[] fields = Grego.timeToFields(time + (long)this.rawOffset, null);
        return this.getOffset(1, fields[0], fields[1], fields[2], fields[3], fields[5]);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public synchronized int hashCode() {
        int hashCode = this.getID().hashCode() + this.rawOffset;
        if (this.useDaylight) {
            hashCode += this.startYear + this.startMonth + this.startDay + this.startDayOfWeek + this.startTime + this.startMode + this.endMonth + this.endDay + this.endDayOfWeek + this.endTime + this.endMode + this.dstSavings;
        }
        return hashCode;
    }

    public boolean hasSameRules(TimeZone zone) {
        if (!(zone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone tz = (SimpleTimeZone)zone;
        if (this.useDaylight != tz.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return this.rawOffset == tz.rawOffset;
        }
        return this.rawOffset == tz.rawOffset && this.dstSavings == tz.dstSavings && this.startYear == tz.startYear && this.startMonth == tz.startMonth && this.startDay == tz.startDay && this.startMode == tz.startMode && this.startDayOfWeek == tz.startDayOfWeek && this.startTime == tz.startTime && this.endMonth == tz.endMonth && this.endDay == tz.endDay && this.endDayOfWeek == tz.endDayOfWeek && this.endTime == tz.endTime && this.endMode == tz.endMode;
    }

    public boolean inDaylightTime(Date time) {
        return this.useDaylightTime() && this.getOffset(time.getTime()) != this.getRawOffset();
    }

    private boolean isLeapYear(int year) {
        if (year > 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private int mod7(int num1) {
        int rem = num1 % 7;
        return num1 < 0 && rem < 0 ? 7 + rem : rem;
    }

    public void setDSTSavings(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("milliseconds <= 0: " + milliseconds);
        }
        this.dstSavings = milliseconds;
    }

    private void checkRange(int month, int dayOfWeek, int time) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("Invalid day of week: " + dayOfWeek);
        }
        if (time < 0 || time >= 86400000) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
    }

    private void checkDay(int month, int day) {
        if (day <= 0 || day > GregorianCalendar.DaysInMonth[month]) {
            throw new IllegalArgumentException("Invalid day of month: " + day);
        }
    }

    private void setEndMode() {
        if (this.endDayOfWeek == 0) {
            this.endMode = 1;
        } else if (this.endDayOfWeek < 0) {
            this.endDayOfWeek = -this.endDayOfWeek;
            if (this.endDay < 0) {
                this.endDay = -this.endDay;
                this.endMode = 4;
            } else {
                this.endMode = 3;
            }
        } else {
            this.endMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            this.checkRange(this.endMonth, this.endMode == 1 ? 1 : this.endDayOfWeek, this.endTime);
            if (this.endMode != 2) {
                this.checkDay(this.endMonth, this.endDay);
            } else if (this.endDay < -5 || this.endDay > 5) {
                throw new IllegalArgumentException("Day of week in month: " + this.endDay);
            }
        }
        if (this.endMode != 1) {
            --this.endDayOfWeek;
        }
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.endMonth = month;
        this.endDay = dayOfMonth;
        this.endDayOfWeek = 0;
        this.endTime = time;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time) {
        this.endMonth = month;
        this.endDay = day;
        this.endDayOfWeek = dayOfWeek;
        this.endTime = time;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.endMonth = month;
        this.endDay = after ? day : -day;
        this.endDayOfWeek = -dayOfWeek;
        this.endTime = time;
        this.setEndMode();
    }

    public void setRawOffset(int offset) {
        this.rawOffset = offset;
    }

    private void setStartMode() {
        if (this.startDayOfWeek == 0) {
            this.startMode = 1;
        } else if (this.startDayOfWeek < 0) {
            this.startDayOfWeek = -this.startDayOfWeek;
            if (this.startDay < 0) {
                this.startDay = -this.startDay;
                this.startMode = 4;
            } else {
                this.startMode = 3;
            }
        } else {
            this.startMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            this.checkRange(this.startMonth, this.startMode == 1 ? 1 : this.startDayOfWeek, this.startTime);
            if (this.startMode != 2) {
                this.checkDay(this.startMonth, this.startDay);
            } else if (this.startDay < -5 || this.startDay > 5) {
                throw new IllegalArgumentException("Day of week in month: " + this.startDay);
            }
        }
        if (this.startMode != 1) {
            --this.startDayOfWeek;
        }
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.startMonth = month;
        this.startDay = dayOfMonth;
        this.startDayOfWeek = 0;
        this.startTime = time;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time) {
        this.startMonth = month;
        this.startDay = day;
        this.startDayOfWeek = dayOfWeek;
        this.startTime = time;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.startMonth = month;
        this.startDay = after ? day : -day;
        this.startDayOfWeek = -dayOfWeek;
        this.startTime = time;
        this.setStartMode();
    }

    public void setStartYear(int year) {
        this.startYear = year;
        this.useDaylight = true;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + (this.useDaylight && this.startMode != 1 ? this.startDayOfWeek + 1 : 0) + ",startTime=" + this.startTime + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + (this.useDaylight && this.endMode != 1 ? this.endDayOfWeek + 1 : 0) + ",endTime=" + this.endTime + "]";
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int sEndDay = this.endDay;
        int sEndDayOfWeek = this.endDayOfWeek + 1;
        int sStartDay = this.startDay;
        int sStartDayOfWeek = this.startDayOfWeek + 1;
        if (this.useDaylight && (this.startMode != 2 || this.endMode != 2)) {
            GregorianCalendar cal = new GregorianCalendar(this);
            if (this.endMode != 2) {
                cal.set(2, this.endMonth);
                cal.set(5, this.endDay);
                sEndDay = cal.get(8);
                if (this.endMode == 1) {
                    sEndDayOfWeek = cal.getFirstDayOfWeek();
                }
            }
            if (this.startMode != 2) {
                cal.set(2, this.startMonth);
                cal.set(5, this.startDay);
                sStartDay = cal.get(8);
                if (this.startMode == 1) {
                    sStartDayOfWeek = cal.getFirstDayOfWeek();
                }
            }
        }
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("dstSavings", this.dstSavings);
        fields.put("endDay", sEndDay);
        fields.put("endDayOfWeek", sEndDayOfWeek);
        fields.put("endMode", this.endMode);
        fields.put("endMonth", this.endMonth);
        fields.put("endTime", this.endTime);
        fields.put("monthLength", GregorianCalendar.DaysInMonth);
        fields.put("rawOffset", this.rawOffset);
        fields.put("serialVersionOnStream", 1);
        fields.put("startDay", sStartDay);
        fields.put("startDayOfWeek", sStartDayOfWeek);
        fields.put("startMode", this.startMode);
        fields.put("startMonth", this.startMonth);
        fields.put("startTime", this.startTime);
        fields.put("startYear", this.startYear);
        fields.put("useDaylight", this.useDaylight);
        stream.writeFields();
        stream.writeInt(4);
        byte[] values = new byte[]{(byte)this.startDay, (byte)(this.startMode == 1 ? 0 : this.startDayOfWeek + 1), (byte)this.endDay, (byte)(this.endMode == 1 ? 0 : this.endDayOfWeek + 1)};
        stream.write(values);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.rawOffset = fields.get("rawOffset", 0);
        this.useDaylight = fields.get("useDaylight", false);
        if (this.useDaylight) {
            this.endMonth = fields.get("endMonth", 0);
            this.endTime = fields.get("endTime", 0);
            this.startMonth = fields.get("startMonth", 0);
            this.startTime = fields.get("startTime", 0);
            this.startYear = fields.get("startYear", 0);
        }
        if (fields.get("serialVersionOnStream", 0) == 0) {
            if (this.useDaylight) {
                this.endMode = 2;
                this.startMode = 2;
                this.endDay = fields.get("endDay", 0);
                this.endDayOfWeek = fields.get("endDayOfWeek", 0) - 1;
                this.startDay = fields.get("startDay", 0);
                this.startDayOfWeek = fields.get("startDayOfWeek", 0) - 1;
            }
        } else {
            this.dstSavings = fields.get("dstSavings", 0);
            if (this.useDaylight) {
                this.endMode = fields.get("endMode", 0);
                this.startMode = fields.get("startMode", 0);
                int length = stream.readInt();
                byte[] values = new byte[length];
                stream.readFully(values);
                if (length >= 4) {
                    this.startDay = values[0];
                    this.startDayOfWeek = values[1];
                    if (this.startMode != 1) {
                        --this.startDayOfWeek;
                    }
                    this.endDay = values[2];
                    this.endDayOfWeek = values[3];
                    if (this.endMode != 1) {
                        --this.endDayOfWeek;
                    }
                }
            }
        }
    }
}

