/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.MissingResourceException;
import libcore.icu.ICU;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale CANADA = new Locale(true, "en", "CA");
    public static final Locale CANADA_FRENCH = new Locale(true, "fr", "CA");
    public static final Locale CHINA = new Locale(true, "zh", "CN");
    public static final Locale CHINESE = new Locale(true, "zh", "");
    public static final Locale ENGLISH = new Locale(true, "en", "");
    public static final Locale FRANCE = new Locale(true, "fr", "FR");
    public static final Locale FRENCH = new Locale(true, "fr", "");
    public static final Locale GERMAN = new Locale(true, "de", "");
    public static final Locale GERMANY = new Locale(true, "de", "DE");
    public static final Locale ITALIAN = new Locale(true, "it", "");
    public static final Locale ITALY = new Locale(true, "it", "IT");
    public static final Locale JAPAN = new Locale(true, "ja", "JP");
    public static final Locale JAPANESE = new Locale(true, "ja", "");
    public static final Locale KOREA = new Locale(true, "ko", "KR");
    public static final Locale KOREAN = new Locale(true, "ko", "");
    public static final Locale PRC = new Locale(true, "zh", "CN");
    public static final Locale ROOT = new Locale(true, "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale(true, "zh", "CN");
    public static final Locale TAIWAN = new Locale(true, "zh", "TW");
    public static final Locale TRADITIONAL_CHINESE = new Locale(true, "zh", "TW");
    public static final Locale UK = new Locale(true, "en", "GB");
    public static final Locale US;
    private static Locale defaultLocale;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;
    private transient String cachedToStringResult;
    private static final ObjectStreamField[] serialPersistentFields;

    private Locale(boolean unused, String lowerCaseLanguageCode, String upperCaseCountryCode) {
        this.languageCode = lowerCaseLanguageCode;
        this.countryCode = upperCaseCountryCode;
        this.variantCode = "";
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException("language=" + language + ",country=" + country + ",variant=" + variant);
        }
        if (language.isEmpty() && country.isEmpty()) {
            this.languageCode = "";
            this.countryCode = "";
            this.variantCode = variant;
            return;
        }
        this.languageCode = language.toLowerCase(US);
        if (this.languageCode.equals("he")) {
            this.languageCode = "iw";
        } else if (this.languageCode.equals("id")) {
            this.languageCode = "in";
        } else if (this.languageCode.equals("yi")) {
            this.languageCode = "ji";
        }
        this.countryCode = country.toUpperCase(US);
        this.variantCode = variant;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Locale) {
            Locale o = (Locale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode);
        }
        return false;
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableLocales();
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        if (this.countryCode.isEmpty()) {
            return "";
        }
        String result = ICU.getDisplayCountryNative(this.toString(), locale.toString());
        if (result == null) {
            result = ICU.getDisplayCountryNative(this.toString(), Locale.getDefault().toString());
        }
        return result;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        String result;
        if (this.languageCode.isEmpty()) {
            return "";
        }
        String localeString = this.toString();
        if (this.languageCode.equals("tl")) {
            localeString = Locale.toNewString("fil", this.countryCode, this.variantCode);
        }
        if ((result = ICU.getDisplayLanguageNative(localeString, locale.toString())) == null) {
            result = ICU.getDisplayLanguageNative(localeString, Locale.getDefault().toString());
        }
        return result;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (!this.languageCode.isEmpty()) {
            String displayLanguage = this.getDisplayLanguage(locale);
            buffer.append(displayLanguage.isEmpty() ? this.languageCode : displayLanguage);
            ++count;
        }
        if (!this.countryCode.isEmpty()) {
            String displayCountry;
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append((displayCountry = this.getDisplayCountry(locale)).isEmpty() ? this.countryCode : displayCountry);
            ++count;
        }
        if (!this.variantCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            String displayVariant = this.getDisplayVariant(locale);
            buffer.append(displayVariant.isEmpty() ? this.variantCode : displayVariant);
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        if (this.variantCode.length() == 0) {
            return this.variantCode;
        }
        String result = ICU.getDisplayVariantNative(this.toString(), locale.toString());
        if (result == null) {
            result = ICU.getDisplayVariantNative(this.toString(), Locale.getDefault().toString());
        }
        return result;
    }

    public String getISO3Country() {
        String code = ICU.getISO3CountryNative(this.toString());
        if (!this.countryCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter country code for locale: " + this, "FormatData_" + this, "ShortCountry");
        }
        return code;
    }

    public String getISO3Language() {
        String code = ICU.getISO3LanguageNative(this.toString());
        if (!this.languageCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter language code for locale: " + this, "FormatData_" + this, "ShortLanguage");
        }
        return code;
    }

    public static String[] getISOCountries() {
        return ICU.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return ICU.getISOLanguages();
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public synchronized int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode();
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        defaultLocale = locale;
    }

    public final String toString() {
        String result = this.cachedToStringResult;
        if (result == null) {
            result = this.cachedToStringResult = Locale.toNewString(this.languageCode, this.countryCode, this.variantCode);
        }
        return result;
    }

    private static String toNewString(String languageCode, String countryCode, String variantCode) {
        if (languageCode.length() == 0 && countryCode.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(11);
        result.append(languageCode);
        if (countryCode.length() > 0 || variantCode.length() > 0) {
            result.append('_');
        }
        result.append(countryCode);
        if (variantCode.length() > 0) {
            result.append('_');
        }
        result.append(variantCode);
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("country", this.countryCode);
        fields.put("hashcode", -1);
        fields.put("language", this.languageCode);
        fields.put("variant", this.variantCode);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.countryCode = (String)fields.get("country", "");
        this.languageCode = (String)fields.get("language", "");
        this.variantCode = (String)fields.get("variant", "");
    }

    static {
        defaultLocale = US = new Locale(true, "en", "US");
        String language = System.getProperty("user.language", "en");
        String region = System.getProperty("user.region", "US");
        String variant = System.getProperty("user.variant", "");
        defaultLocale = new Locale(language, region, variant);
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("country", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("language", String.class), new ObjectStreamField("variant", String.class)};
    }
}

