/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V> {
    transient LinkedEntry<K, V> header;
    private final boolean accessOrder;
    private static final long serialVersionUID = 3801124242820219131L;

    public LinkedHashMap() {
        this.init();
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.init();
        this.accessOrder = accessOrder;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        this(LinkedHashMap.capacityForInitSize(map.size()));
        this.constructorPutAll(map);
    }

    @Override
    void init() {
        this.header = new LinkedEntry();
    }

    public Map.Entry<K, V> eldest() {
        LinkedEntry eldest = this.header.nxt;
        return eldest != this.header ? eldest : null;
    }

    @Override
    void addNewEntry(K key, V value, int hash, int index) {
        LinkedEntry<K, V> header;
        LinkedEntry eldest = header.nxt;
        header = this.header;
        if (eldest != header && this.removeEldestEntry(eldest)) {
            this.remove(eldest.key);
        }
        LinkedEntry oldTail = header.prv;
        LinkedEntry<K, V> newTail = new LinkedEntry<K, V>(key, value, hash, this.table[index], header, oldTail);
        header.prv = newTail;
        oldTail.nxt = header.prv;
        this.table[index] = header.prv;
    }

    @Override
    void addNewEntryForNullKey(V value) {
        LinkedEntry<K, V> header;
        LinkedEntry eldest = header.nxt;
        header = this.header;
        if (eldest != header && this.removeEldestEntry(eldest)) {
            this.remove(eldest.key);
        }
        LinkedEntry oldTail = header.prv;
        LinkedEntry<Object, V> newTail = new LinkedEntry<Object, V>(null, value, 0, null, header, oldTail);
        header.prv = newTail;
        oldTail.nxt = header.prv;
        this.entryForNullKey = header.prv;
    }

    @Override
    HashMap.HashMapEntry<K, V> constructorNewEntry(K key, V value, int hash, HashMap.HashMapEntry<K, V> next) {
        LinkedEntry<K, V> header = this.header;
        LinkedEntry oldTail = header.prv;
        LinkedEntry<K, V> newTail = new LinkedEntry<K, V>(key, value, hash, next, header, oldTail);
        header.prv = newTail;
        oldTail.nxt = header.prv;
        return header.prv;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            HashMap.HashMapEntry e = this.entryForNullKey;
            if (e == null) {
                return null;
            }
            if (this.accessOrder) {
                this.makeTail((LinkedEntry)e);
            }
            return e.value;
        }
        int hash = LinkedHashMap.secondaryHash(key);
        HashMap.HashMapEntry[] tab = this.table;
        HashMap.HashMapEntry e = tab[hash & tab.length - 1];
        while (e != null) {
            Object eKey = e.key;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                if (this.accessOrder) {
                    this.makeTail((LinkedEntry)e);
                }
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void makeTail(LinkedEntry<K, V> e) {
        e.prv.nxt = e.nxt;
        e.nxt.prv = e.prv;
        LinkedEntry<K, V> header = this.header;
        LinkedEntry oldTail = header.prv;
        e.nxt = header;
        e.prv = oldTail;
        header.prv = e;
        oldTail.nxt = header.prv;
        ++this.modCount;
    }

    @Override
    void preModify(HashMap.HashMapEntry<K, V> e) {
        if (this.accessOrder) {
            this.makeTail((LinkedEntry)e);
        }
    }

    @Override
    void postRemove(HashMap.HashMapEntry<K, V> e) {
        LinkedEntry le = (LinkedEntry)e;
        le.prv.nxt = le.nxt;
        le.nxt.prv = le.prv;
        le.prv = null;
        le.nxt = null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            LinkedEntry<K, V> header = this.header;
            LinkedEntry e = header.nxt;
            while (e != header) {
                if (e.value == null) {
                    return true;
                }
                e = e.nxt;
            }
            return false;
        }
        LinkedEntry<K, V> header = this.header;
        LinkedEntry e = header.nxt;
        while (e != header) {
            if (value.equals(e.value)) {
                return true;
            }
            e = e.nxt;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        LinkedEntry<K, V> header = this.header;
        LinkedEntry e = header.nxt;
        while (e != header) {
            LinkedEntry nxt = e.nxt;
            e.prv = null;
            e.nxt = null;
            e = nxt;
        }
        header.prv = header;
        header.nxt = header.prv;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        LinkedEntry<K, V> next;
        LinkedEntry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.next = LinkedHashMap.this.header.nxt;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != LinkedHashMap.this.header;
        }

        final LinkedEntry<K, V> nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedEntry e = this.next;
            if (e == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.next = e.nxt;
            this.lastReturned = e;
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkedEntry<K, V>
    extends HashMap.HashMapEntry<K, V> {
        LinkedEntry<K, V> nxt;
        LinkedEntry<K, V> prv;

        LinkedEntry() {
            super(null, null, 0, null);
            this.nxt = this.prv = this;
        }

        LinkedEntry(K key, V value, int hash, HashMap.HashMapEntry<K, V> next, LinkedEntry<K, V> nxt, LinkedEntry<K, V> prv) {
            super(key, value, hash, next);
            this.nxt = nxt;
            this.prv = prv;
        }
    }
}

