/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetDecoderICU;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharsetEncoderICU;
import libcore.icu.NativeConverter;

final class CharsetICU
extends Charset {
    private final String icuCanonicalName;

    protected CharsetICU(String canonicalName, String icuCanonName, String[] aliases) {
        super(canonicalName, aliases);
        this.icuCanonicalName = icuCanonName;
    }

    public CharsetDecoder newDecoder() {
        return CharsetDecoderICU.newInstance(this, this.icuCanonicalName);
    }

    public CharsetEncoder newEncoder() {
        return CharsetEncoderICU.newInstance(this, this.icuCanonicalName);
    }

    public boolean contains(Charset cs) {
        if (cs == null) {
            return false;
        }
        if (this.equals(cs)) {
            return true;
        }
        return NativeConverter.contains(this.name(), cs.name());
    }
}

