/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelector
extends Selector {
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private SelectorProvider provider = null;
    private final Set<SelectionKey> cancelledKeysSet = new HashSet<SelectionKey>();
    private final Runnable wakeupRunnable = new Runnable(){

        public void run() {
            AbstractSelector.this.wakeup();
        }
    };

    protected AbstractSelector(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    @Override
    public final void close() throws IOException {
        if (this.isOpen.getAndSet(false)) {
            this.implCloseSelector();
        }
    }

    protected abstract void implCloseSelector() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set<SelectionKey> cancelledKeys() {
        return this.cancelledKeysSet;
    }

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey key) {
        ((AbstractSelectableChannel)key.channel()).deregister(key);
        key.isValid = false;
    }

    protected final void begin() {
        Thread.currentThread().pushInterruptAction$(this.wakeupRunnable);
    }

    protected final void end() {
        Thread.currentThread().popInterruptAction$(this.wakeupRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(SelectionKey key) {
        Set<SelectionKey> set = this.cancelledKeysSet;
        synchronized (set) {
            this.cancelledKeysSet.add(key);
        }
    }
}

