/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

final class LongArrayBuffer
extends LongBuffer {
    private final long[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    LongArrayBuffer(long[] array2) {
        this(array2.length, array2, 0, false);
    }

    private LongArrayBuffer(int capacity, long[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static LongArrayBuffer copy(LongArrayBuffer other, int markOfOther, boolean isReadOnly) {
        LongArrayBuffer buf = new LongArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public LongBuffer asReadOnlyBuffer() {
        return LongArrayBuffer.copy(this, this.mark, true);
    }

    public LongBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(this.backingArray, this.position + this.arrayOffset, this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public LongBuffer duplicate() {
        return LongArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public LongBuffer slice() {
        return new LongArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    long[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    public final long get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    public final long get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    public final LongBuffer get(long[] dst, int dstOffset, int longCount) {
        if (longCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.arrayOffset + this.position, dst, dstOffset, longCount);
        this.position += longCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public LongBuffer put(long c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    public LongBuffer put(int index, long c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    public LongBuffer put(long[] src, int srcOffset, int longCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (longCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.arrayOffset + this.position, longCount);
        this.position += longCount;
        return this;
    }
}

