/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import libcore.io.ErrnoException;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructGroupReq;
import libcore.util.EmptyArray;

public class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private volatile boolean isNativeConnected;
    private final CloseGuard guard = CloseGuard.get();
    private InetAddress connectedAddress;
    private int connectedPort = -1;

    public PlainDatagramSocketImpl(FileDescriptor fd, int localPort) {
        this.fd = fd;
        this.localPort = localPort;
        if (fd.valid()) {
            this.guard.open("close");
        }
    }

    public PlainDatagramSocketImpl() {
        this.fd = new FileDescriptor();
    }

    public void bind(int port, InetAddress address) throws SocketException {
        IoBridge.bind(this.fd, address, port);
        this.localPort = port != 0 ? port : IoBridge.getSocketLocalPort(this.fd);
        try {
            this.setOption(32, Boolean.TRUE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() {
        this.guard.close();
        try {
            IoBridge.closeSocket(this.fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void create() throws SocketException {
        this.fd = IoBridge.socket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public Object getOption(int option) throws SocketException {
        return IoBridge.getSocketOption(this.fd, option);
    }

    public int getTimeToLive() throws IOException {
        return (Integer)this.getOption(17);
    }

    public byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    private static StructGroupReq makeGroupReq(InetAddress gr_group, NetworkInterface networkInterface) {
        int gr_interface = networkInterface != null ? networkInterface.getIndex() : 0;
        return new StructGroupReq(gr_interface, gr_group);
    }

    public void join(InetAddress addr) throws IOException {
        this.setOption(19, PlainDatagramSocketImpl.makeGroupReq(addr, null));
    }

    public void joinGroup(SocketAddress addr, NetworkInterface netInterface) throws IOException {
        if (addr instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)addr).getAddress();
            this.setOption(19, PlainDatagramSocketImpl.makeGroupReq(groupAddr, netInterface));
        }
    }

    public void leave(InetAddress addr) throws IOException {
        this.setOption(20, PlainDatagramSocketImpl.makeGroupReq(addr, null));
    }

    public void leaveGroup(SocketAddress addr, NetworkInterface netInterface) throws IOException {
        if (addr instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)addr).getAddress();
            this.setOption(20, PlainDatagramSocketImpl.makeGroupReq(groupAddr, netInterface));
        }
    }

    protected int peek(InetAddress sender) throws IOException {
        DatagramPacket packet = new DatagramPacket(EmptyArray.BYTE, 0);
        int result = this.peekData(packet);
        sender.ipaddress = packet.getAddress().getAddress();
        return result;
    }

    private void doRecv(DatagramPacket pack, int flags) throws IOException {
        IoBridge.recvfrom(false, this.fd, pack.getData(), pack.getOffset(), pack.getLength(), flags, pack, this.isNativeConnected);
        if (this.isNativeConnected) {
            this.updatePacketRecvAddress(pack);
        }
    }

    public void receive(DatagramPacket pack) throws IOException {
        this.doRecv(pack, 0);
    }

    public int peekData(DatagramPacket pack) throws IOException {
        this.doRecv(pack, OsConstants.MSG_PEEK);
        return pack.getPort();
    }

    public void send(DatagramPacket packet) throws IOException {
        int port = this.isNativeConnected ? 0 : packet.getPort();
        InetAddress address = this.isNativeConnected ? null : packet.getAddress();
        IoBridge.sendto(this.fd, packet.getData(), packet.getOffset(), packet.getLength(), 0, address, port);
    }

    public void setOption(int option, Object value) throws SocketException {
        IoBridge.setSocketOption(this.fd, option, value);
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.setOption(17, ttl);
    }

    public void setTTL(byte ttl) throws IOException {
        this.setTimeToLive(ttl & 0xFF);
    }

    public void connect(InetAddress inetAddr, int port) throws SocketException {
        IoBridge.connect(this.fd, inetAddr, port);
        try {
            this.connectedAddress = InetAddress.getByAddress(inetAddr.getAddress());
        }
        catch (UnknownHostException e) {
            throw new SocketException("Host is unresolved: " + inetAddr.getHostName());
        }
        this.connectedPort = port;
        this.isNativeConnected = true;
    }

    public void disconnect() {
        try {
            Libcore.os.connect(this.fd, InetAddress.UNSPECIFIED, 0);
        }
        catch (ErrnoException errnoException) {
            throw new AssertionError((Object)errnoException);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.connectedPort = -1;
        this.connectedAddress = null;
        this.isNativeConnected = false;
    }

    private void updatePacketRecvAddress(DatagramPacket packet) {
        packet.setAddress(this.connectedAddress);
        packet.setPort(this.connectedPort);
    }
}

