/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CookieStoreImpl
implements CookieStore {
    private final Map<URI, List<HttpCookie>> map = new HashMap<URI, List<HttpCookie>>();

    CookieStoreImpl() {
    }

    @Override
    public synchronized void add(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie == null");
        }
        List<HttpCookie> cookies = this.map.get(uri = this.cookiesUri(uri));
        if (cookies == null) {
            cookies = new ArrayList<HttpCookie>();
            this.map.put(uri, cookies);
        } else {
            cookies.remove(cookie);
        }
        cookies.add(cookie);
    }

    private URI cookiesUri(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI("http", uri.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    @Override
    public synchronized List<HttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        List<HttpCookie> cookiesForUri = this.map.get(uri);
        if (cookiesForUri != null) {
            Iterator<HttpCookie> i = cookiesForUri.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                result.add(cookie);
            }
        }
        for (Map.Entry<URI, List<HttpCookie>> entry : this.map.entrySet()) {
            if (uri.equals(entry.getKey())) continue;
            List<HttpCookie> entryCookies = entry.getValue();
            Iterator<HttpCookie> i = entryCookies.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (!HttpCookie.domainMatches(cookie.getDomain(), uri.getHost())) continue;
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                if (result.contains(cookie)) continue;
                result.add(cookie);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        for (List<HttpCookie> list : this.map.values()) {
            Iterator<HttpCookie> i = list.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                if (result.contains(cookie)) continue;
                result.add(cookie);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized List<URI> getURIs() {
        ArrayList<URI> result = new ArrayList<URI>(this.map.keySet());
        result.remove(null);
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized boolean remove(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie == null");
        }
        List<HttpCookie> cookies = this.map.get(this.cookiesUri(uri));
        if (cookies != null) {
            return cookies.remove(cookie);
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll() {
        boolean result = !this.map.isEmpty();
        this.map.clear();
        return result;
    }
}

