/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamField
implements Comparable<Object> {
    private String name;
    private Object type;
    int offset;
    private String typeString;
    private boolean unshared;
    private boolean isDeserialized;

    public ObjectStreamField(String name, Class<?> cl) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (cl == null) {
            throw new NullPointerException("cl == null");
        }
        this.name = name;
        this.type = new WeakReference(cl);
    }

    public ObjectStreamField(String name, Class<?> cl, boolean unshared) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (cl == null) {
            throw new NullPointerException("cl == null");
        }
        this.name = name;
        this.type = cl.getClassLoader() == null ? cl : new WeakReference(cl);
        this.unshared = unshared;
    }

    ObjectStreamField(String signature, String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.name = name;
        this.typeString = signature.replace('.', '/').intern();
        this.defaultResolve();
        this.isDeserialized = true;
    }

    @Override
    public int compareTo(Object o) {
        boolean fPrimitive;
        ObjectStreamField f = (ObjectStreamField)o;
        boolean thisPrimitive = this.isPrimitive();
        if (thisPrimitive != (fPrimitive = f.isPrimitive())) {
            return thisPrimitive ? -1 : 1;
        }
        return this.getName().compareTo(f.getName());
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    Class<?> getTypeInternal() {
        if (this.type instanceof WeakReference) {
            return (Class)((WeakReference)this.type).get();
        }
        return (Class)this.type;
    }

    public Class<?> getType() {
        Class<?> cl = this.getTypeInternal();
        if (this.isDeserialized && !cl.isPrimitive()) {
            return Object.class;
        }
        return cl;
    }

    public char getTypeCode() {
        return this.typeCodeOf(this.getTypeInternal());
    }

    private char typeCodeOf(Class<?> type) {
        if (type == Integer.TYPE) {
            return 'I';
        }
        if (type == Byte.TYPE) {
            return 'B';
        }
        if (type == Character.TYPE) {
            return 'C';
        }
        if (type == Short.TYPE) {
            return 'S';
        }
        if (type == Boolean.TYPE) {
            return 'Z';
        }
        if (type == Long.TYPE) {
            return 'J';
        }
        if (type == Float.TYPE) {
            return 'F';
        }
        if (type == Double.TYPE) {
            return 'D';
        }
        if (type.isArray()) {
            return '[';
        }
        return 'L';
    }

    public String getTypeString() {
        if (this.isPrimitive()) {
            return null;
        }
        if (this.typeString == null) {
            Class<?> t = this.getTypeInternal();
            String typeName = t.getName().replace('.', '/');
            String str = t.isArray() ? typeName : "L" + typeName + ';';
            this.typeString = str.intern();
        }
        return this.typeString;
    }

    public boolean isPrimitive() {
        Class<?> t = this.getTypeInternal();
        return t != null && t.isPrimitive();
    }

    boolean writeField(DataOutputStream out) throws IOException {
        Class<?> t = this.getTypeInternal();
        out.writeByte(this.typeCodeOf(t));
        out.writeUTF(this.name);
        return t != null && t.isPrimitive();
    }

    protected void setOffset(int newValue) {
        this.offset = newValue;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getName() + ':' + this.getTypeInternal() + ')';
    }

    void resolve(ClassLoader loader) {
        if (this.typeString == null && this.isPrimitive()) {
            this.typeString = String.valueOf(this.getTypeCode());
        }
        if (this.typeString.length() == 1 && this.defaultResolve()) {
            return;
        }
        String className = this.typeString.replace('/', '.');
        if (className.charAt(0) == 'L') {
            className = className.substring(1, className.length() - 1);
        }
        try {
            Class<?> cl = Class.forName(className, false, loader);
            this.type = cl.getClassLoader() == null ? cl : new WeakReference(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    void setUnshared(boolean unshared) {
        this.unshared = unshared;
    }

    private boolean defaultResolve() {
        switch (this.typeString.charAt(0)) {
            case 'I': {
                this.type = Integer.TYPE;
                return true;
            }
            case 'B': {
                this.type = Byte.TYPE;
                return true;
            }
            case 'C': {
                this.type = Character.TYPE;
                return true;
            }
            case 'S': {
                this.type = Short.TYPE;
                return true;
            }
            case 'Z': {
                this.type = Boolean.TYPE;
                return true;
            }
            case 'J': {
                this.type = Long.TYPE;
                return true;
            }
            case 'F': {
                this.type = Float.TYPE;
                return true;
            }
            case 'D': {
                this.type = Double.TYPE;
                return true;
            }
        }
        this.type = Object.class;
        return false;
    }
}

