/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageParser {
    public static final String musicNote = "\u266b ";
    private String text;
    private int nextChar;
    private int nextClass;
    private ArrayList<Part> parts;
    private ArrayList<Token> tokens;
    private HashMap<Character, Format> formatStart;
    private boolean parseSmilies;
    private boolean parseAcronyms;
    private boolean parseFormatting;
    private boolean parseUrls;
    private boolean parseMeText;
    private boolean parseMusic;

    protected abstract Resources getResources();

    public AbstractMessageParser(String text) {
        this(text, true, true, true, true, true, true);
    }

    public AbstractMessageParser(String text, boolean parseSmilies, boolean parseAcronyms, boolean parseFormatting, boolean parseUrls, boolean parseMusic, boolean parseMeText) {
        this.text = text;
        this.nextChar = 0;
        this.nextClass = 10;
        this.parts = new ArrayList();
        this.tokens = new ArrayList();
        this.formatStart = new HashMap();
        this.parseSmilies = parseSmilies;
        this.parseAcronyms = parseAcronyms;
        this.parseFormatting = parseFormatting;
        this.parseUrls = parseUrls;
        this.parseMusic = parseMusic;
        this.parseMeText = parseMeText;
    }

    public final String getRawText() {
        return this.text;
    }

    public final int getPartCount() {
        return this.parts.size();
    }

    public final Part getPart(int index) {
        return this.parts.get(index);
    }

    public final List<Part> getParts() {
        return this.parts;
    }

    public void parse() {
        int i;
        if (this.parseMusicTrack()) {
            this.buildParts(null);
            return;
        }
        String meText = null;
        if (this.parseMeText && this.text.startsWith("/me") && this.text.length() > 3 && Character.isWhitespace(this.text.charAt(3))) {
            meText = this.text.substring(0, 4);
            this.text = this.text.substring(4);
        }
        boolean wasSmiley = false;
        while (this.nextChar < this.text.length()) {
            if (!(this.isWordBreak(this.nextChar) || wasSmiley && this.isSmileyBreak(this.nextChar))) {
                throw new AssertionError((Object)"last chunk did not end at word break");
            }
            if (this.parseSmiley()) {
                wasSmiley = true;
                continue;
            }
            wasSmiley = false;
            if (this.parseAcronym() || this.parseURL() || this.parseFormatting()) continue;
            this.parseText();
        }
        for (i = 0; i < this.tokens.size(); ++i) {
            if (!this.tokens.get(i).isMedia()) continue;
            if (i > 0 && this.tokens.get(i - 1) instanceof Html) {
                ((Html)this.tokens.get(i - 1)).trimLeadingWhitespace();
            }
            if (i + 1 >= this.tokens.size() || !(this.tokens.get(i + 1) instanceof Html)) continue;
            ((Html)this.tokens.get(i + 1)).trimTrailingWhitespace();
        }
        for (i = 0; i < this.tokens.size(); ++i) {
            if (!this.tokens.get(i).isHtml() || this.tokens.get(i).toHtml(true).length() != 0) continue;
            this.tokens.remove(i);
            --i;
        }
        this.buildParts(meText);
    }

    public static Token tokenForUrl(String url, String text) {
        if (url == null) {
            return null;
        }
        Video video = Video.matchURL(url, text);
        if (video != null) {
            return video;
        }
        YouTubeVideo ytVideo = YouTubeVideo.matchURL(url, text);
        if (ytVideo != null) {
            return ytVideo;
        }
        Photo photo = Photo.matchURL(url, text);
        if (photo != null) {
            return photo;
        }
        FlickrPhoto flickrPhoto = FlickrPhoto.matchURL(url, text);
        if (flickrPhoto != null) {
            return flickrPhoto;
        }
        return new Link(url, text);
    }

    private void buildParts(String meText) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.isMedia() || this.parts.size() == 0 || this.lastPart().isMedia()) {
                this.parts.add(new Part());
            }
            this.lastPart().add(token);
        }
        if (this.parts.size() > 0) {
            this.parts.get(0).setMeText(meText);
        }
    }

    private Part lastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    private boolean parseMusicTrack() {
        if (this.parseMusic && this.text.startsWith(musicNote)) {
            this.addToken(new MusicTrack(this.text.substring(musicNote.length())));
            this.nextChar = this.text.length();
            return true;
        }
        return false;
    }

    private void parseText() {
        StringBuilder buf = new StringBuilder();
        int start = this.nextChar;
        do {
            char ch = this.text.charAt(this.nextChar++);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\n': {
                    buf.append("<br>");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
        } while (!this.isWordBreak(this.nextChar));
        this.addToken(new Html(this.text.substring(start, this.nextChar), buf.toString()));
    }

    private boolean parseSmiley() {
        if (!this.parseSmilies) {
            return false;
        }
        TrieNode match = AbstractMessageParser.longestMatch(this.getResources().getSmileys(), this, this.nextChar, true);
        if (match == null) {
            return false;
        }
        int previousCharClass = this.getCharClass(this.nextChar - 1);
        int nextCharClass = this.getCharClass(this.nextChar + match.getText().length());
        if (!(previousCharClass != 2 && previousCharClass != 3 || nextCharClass != 2 && nextCharClass != 3)) {
            return false;
        }
        this.addToken(new Smiley(match.getText()));
        this.nextChar += match.getText().length();
        return true;
    }

    private boolean parseAcronym() {
        if (!this.parseAcronyms) {
            return false;
        }
        TrieNode match = AbstractMessageParser.longestMatch(this.getResources().getAcronyms(), this, this.nextChar);
        if (match == null) {
            return false;
        }
        this.addToken(new Acronym(match.getText(), match.getValue()));
        this.nextChar += match.getText().length();
        return true;
    }

    private boolean isDomainChar(char c) {
        return c == '-' || Character.isLetter(c) || Character.isDigit(c);
    }

    private boolean isValidDomain(String domain) {
        return AbstractMessageParser.matches(this.getResources().getDomainSuffixes(), AbstractMessageParser.reverse(domain));
    }

    private boolean parseURL() {
        int start;
        int index;
        if (!this.parseUrls || !this.isURLBreak(this.nextChar)) {
            return false;
        }
        for (index = start = this.nextChar; index < this.text.length() && this.isDomainChar(this.text.charAt(index)); ++index) {
        }
        String url = "";
        boolean done = false;
        if (index == this.text.length()) {
            return false;
        }
        if (this.text.charAt(index) == ':') {
            String scheme = this.text.substring(this.nextChar, index);
            if (!this.getResources().getSchemes().contains(scheme)) {
                return false;
            }
        } else if (this.text.charAt(index) == '.') {
            char ch;
            char ch2;
            while (index < this.text.length() && ((ch2 = this.text.charAt(index)) == '.' || this.isDomainChar(ch2))) {
                ++index;
            }
            String domain = this.text.substring(this.nextChar, index);
            if (!this.isValidDomain(domain)) {
                return false;
            }
            if (index + 1 < this.text.length() && this.text.charAt(index) == ':' && Character.isDigit(ch = this.text.charAt(index + 1))) {
                ++index;
                while (index < this.text.length() && Character.isDigit(this.text.charAt(index))) {
                    ++index;
                }
            }
            if (index == this.text.length()) {
                done = true;
            } else {
                ch = this.text.charAt(index);
                if (ch == '?') {
                    if (index + 1 == this.text.length()) {
                        done = true;
                    } else {
                        char ch22 = this.text.charAt(index + 1);
                        if (Character.isWhitespace(ch22) || AbstractMessageParser.isPunctuation(ch22)) {
                            done = true;
                        }
                    }
                } else if (AbstractMessageParser.isPunctuation(ch)) {
                    done = true;
                } else if (Character.isWhitespace(ch)) {
                    done = true;
                } else if (ch != '/' && ch != '#') {
                    return false;
                }
            }
            url = "http://";
        } else {
            return false;
        }
        if (!done) {
            while (index < this.text.length() && !Character.isWhitespace(this.text.charAt(index))) {
                ++index;
            }
        }
        String urlText = this.text.substring(start, index);
        url = url + urlText;
        this.addURLToken(url, urlText);
        this.nextChar = index;
        return true;
    }

    private void addURLToken(String url, String text) {
        this.addToken(AbstractMessageParser.tokenForUrl(url, text));
    }

    private boolean parseFormatting() {
        int endChar;
        if (!this.parseFormatting) {
            return false;
        }
        for (endChar = this.nextChar; endChar < this.text.length() && AbstractMessageParser.isFormatChar(this.text.charAt(endChar)); ++endChar) {
        }
        if (endChar == this.nextChar || !this.isWordBreak(endChar)) {
            return false;
        }
        LinkedHashMap<Character, Boolean> seenCharacters = new LinkedHashMap<Character, Boolean>();
        for (int index = this.nextChar; index < endChar; ++index) {
            char ch = this.text.charAt(index);
            Character key = Character.valueOf(ch);
            if (seenCharacters.containsKey(key)) {
                this.addToken(new Format(ch, false));
                continue;
            }
            Format start = this.formatStart.get(key);
            if (start != null) {
                start.setMatched(true);
                this.formatStart.remove(key);
                seenCharacters.put(key, Boolean.TRUE);
                continue;
            }
            start = new Format(ch, true);
            this.formatStart.put(key, start);
            this.addToken(start);
            seenCharacters.put(key, Boolean.FALSE);
        }
        for (Character key : seenCharacters.keySet()) {
            if (seenCharacters.get(key) != Boolean.TRUE) continue;
            Format end = new Format(key.charValue(), false);
            end.setMatched(true);
            this.addToken(end);
        }
        this.nextChar = endChar;
        return true;
    }

    private boolean isWordBreak(int index) {
        return this.getCharClass(index - 1) != this.getCharClass(index);
    }

    private boolean isSmileyBreak(int index) {
        return index > 0 && index < this.text.length() && AbstractMessageParser.isSmileyBreak(this.text.charAt(index - 1), this.text.charAt(index));
    }

    private boolean isURLBreak(int index) {
        switch (this.getCharClass(index - 1)) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    private int getCharClass(int index) {
        if (index < 0 || this.text.length() <= index) {
            return 0;
        }
        char ch = this.text.charAt(index);
        if (Character.isWhitespace(ch)) {
            return 1;
        }
        if (Character.isLetter(ch)) {
            return 2;
        }
        if (Character.isDigit(ch)) {
            return 3;
        }
        if (AbstractMessageParser.isPunctuation(ch)) {
            return ++this.nextClass;
        }
        return 4;
    }

    private static boolean isSmileyBreak(char c1, char c2) {
        switch (c1) {
            case '$': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': 
            case '}': 
            case '~': {
                switch (c2) {
                    case '#': 
                    case '$': 
                    case '%': 
                    case '*': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '[': 
                    case '\\': 
                    case '^': 
                    case '~': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isPunctuation(char ch) {
        switch (ch) {
            case '!': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    private static boolean isFormatChar(char ch) {
        switch (ch) {
            case '*': 
            case '^': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private void addToken(Token token) {
        this.tokens.add(token);
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder();
        for (Part part : this.parts) {
            boolean caps = false;
            html.append("<p>");
            for (Token token : part.getTokens()) {
                if (token.isHtml()) {
                    html.append(token.toHtml(caps));
                } else {
                    switch (token.getType()) {
                        case LINK: {
                            html.append("<a href=\"");
                            html.append(((Link)token).getURL());
                            html.append("\">");
                            html.append(token.getRawText());
                            html.append("</a>");
                            break;
                        }
                        case SMILEY: {
                            html.append(token.getRawText());
                            break;
                        }
                        case ACRONYM: {
                            html.append(token.getRawText());
                            break;
                        }
                        case MUSIC: {
                            html.append(((MusicTrack)token).getTrack());
                            break;
                        }
                        case GOOGLE_VIDEO: {
                            html.append("<a href=\"");
                            Video cfr_ignored_0 = (Video)token;
                            html.append(Video.getURL(((Video)token).getDocID()));
                            html.append("\">");
                            html.append(token.getRawText());
                            html.append("</a>");
                            break;
                        }
                        case YOUTUBE_VIDEO: {
                            html.append("<a href=\"");
                            YouTubeVideo cfr_ignored_1 = (YouTubeVideo)token;
                            html.append(YouTubeVideo.getURL(((YouTubeVideo)token).getDocID()));
                            html.append("\">");
                            html.append(token.getRawText());
                            html.append("</a>");
                            break;
                        }
                        case PHOTO: {
                            html.append("<a href=\"");
                            html.append(Photo.getAlbumURL(((Photo)token).getUser(), ((Photo)token).getAlbum()));
                            html.append("\">");
                            html.append(token.getRawText());
                            html.append("</a>");
                            break;
                        }
                        case FLICKR: {
                            Photo p = (Photo)token;
                            html.append("<a href=\"");
                            html.append(((FlickrPhoto)token).getUrl());
                            html.append("\">");
                            html.append(token.getRawText());
                            html.append("</a>");
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown token type: " + (Object)((Object)token.getType())));
                        }
                    }
                }
                if (!token.controlCaps()) continue;
                caps = token.setCaps();
            }
            html.append("</p>\n");
        }
        return html.toString();
    }

    protected static String reverse(String str) {
        StringBuilder buf = new StringBuilder();
        for (int i = str.length() - 1; i >= 0; --i) {
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    private static boolean matches(TrieNode root, String str) {
        int index = 0;
        while (index < str.length() && (root = root.getChild(str.charAt(index++))) != null) {
            if (!root.exists()) continue;
            return true;
        }
        return false;
    }

    private static TrieNode longestMatch(TrieNode root, AbstractMessageParser p, int start) {
        return AbstractMessageParser.longestMatch(root, p, start, false);
    }

    private static TrieNode longestMatch(TrieNode root, AbstractMessageParser p, int start, boolean smiley) {
        int index = start;
        TrieNode bestMatch = null;
        while (index < p.getRawText().length() && (root = root.getChild(p.getRawText().charAt(index++))) != null) {
            if (!root.exists()) continue;
            if (p.isWordBreak(index)) {
                bestMatch = root;
                continue;
            }
            if (!smiley || !p.isSmileyBreak(index)) continue;
            bestMatch = root;
        }
        return bestMatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Part {
        private String meText;
        private ArrayList<Token> tokens = new ArrayList();

        public String getType(boolean isSend) {
            return (isSend ? "s" : "r") + this.getPartType();
        }

        private String getPartType() {
            if (this.isMedia()) {
                return "d";
            }
            if (this.meText != null) {
                return "m";
            }
            return "";
        }

        public boolean isMedia() {
            return this.tokens.size() == 1 && this.tokens.get(0).isMedia();
        }

        public Token getMediaToken() {
            if (this.isMedia()) {
                return this.tokens.get(0);
            }
            return null;
        }

        public void add(Token token) {
            if (this.isMedia()) {
                throw new AssertionError((Object)"media ");
            }
            this.tokens.add(token);
        }

        public void setMeText(String meText) {
            this.meText = meText;
        }

        public String getRawText() {
            StringBuilder buf = new StringBuilder();
            if (this.meText != null) {
                buf.append(this.meText);
            }
            for (int i = 0; i < this.tokens.size(); ++i) {
                buf.append(this.tokens.get(i).getRawText());
            }
            return buf.toString();
        }

        public ArrayList<Token> getTokens() {
            return this.tokens;
        }
    }

    public static class TrieNode {
        private final HashMap<Character, TrieNode> children = new HashMap();
        private String text;
        private String value;

        public TrieNode() {
            this("");
        }

        public TrieNode(String text) {
            this.text = text;
        }

        public final boolean exists() {
            return this.value != null;
        }

        public final String getText() {
            return this.text;
        }

        public final String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public TrieNode getChild(char ch) {
            return this.children.get(Character.valueOf(ch));
        }

        public TrieNode getOrCreateChild(char ch) {
            Character key = Character.valueOf(ch);
            TrieNode node = this.children.get(key);
            if (node == null) {
                node = new TrieNode(this.text + String.valueOf(ch));
                this.children.put(key, node);
            }
            return node;
        }

        public static void addToTrie(TrieNode root, String str, String value) {
            int index = 0;
            while (index < str.length()) {
                root = root.getOrCreateChild(str.charAt(index++));
            }
            root.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Format
    extends Token {
        private char ch;
        private boolean start;
        private boolean matched;

        public Format(char ch, boolean start) {
            super(Token.Type.FORMAT, String.valueOf(ch));
            this.ch = ch;
            this.start = start;
        }

        public void setMatched(boolean matched) {
            this.matched = matched;
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        @Override
        public String toHtml(boolean caps) {
            if (this.matched) {
                return this.start ? this.getFormatStart(this.ch) : this.getFormatEnd(this.ch);
            }
            return this.ch == '\"' ? "&quot;" : String.valueOf(this.ch);
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean controlCaps() {
            return this.ch == '^';
        }

        @Override
        public boolean setCaps() {
            return this.start;
        }

        private String getFormatStart(char ch) {
            switch (ch) {
                case '*': {
                    return "<b>";
                }
                case '_': {
                    return "<i>";
                }
                case '^': {
                    return "<b><font color=\"#005FFF\">";
                }
                case '\"': {
                    return "<font color=\"#999999\">\u201c";
                }
            }
            throw new AssertionError((Object)("unknown format '" + ch + "'"));
        }

        private String getFormatEnd(char ch) {
            switch (ch) {
                case '*': {
                    return "</b>";
                }
                case '_': {
                    return "</i>";
                }
                case '^': {
                    return "</font></b>";
                }
                case '\"': {
                    return "\u201d</font>";
                }
            }
            throw new AssertionError((Object)("unknown format '" + ch + "'"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Acronym
    extends Token {
        private String value;

        public Acronym(String text, String value) {
            super(Token.Type.ACRONYM, text);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(this.getRawText());
            info.add(this.getValue());
            return info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Smiley
    extends Token {
        public Smiley(String text) {
            super(Token.Type.SMILEY, text);
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(this.getRawText());
            return info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlickrPhoto
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/?([^/?#&]+)?/?.*");
        private static final Pattern GROUPING_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/(tags|sets)/([^/?#&]+)/?");
        private static final String SETS = "sets";
        private static final String TAGS = "tags";
        private String user;
        private String photo;
        private String grouping;
        private String groupingId;

        public FlickrPhoto(String user, String photo, String grouping, String groupingId, String text) {
            super(Token.Type.FLICKR, text);
            if (!TAGS.equals(user)) {
                this.user = user;
                this.photo = !"show".equals(photo) ? photo : null;
                this.grouping = grouping;
                this.groupingId = groupingId;
            } else {
                this.user = null;
                this.photo = null;
                this.grouping = TAGS;
                this.groupingId = photo;
            }
        }

        public String getUser() {
            return this.user;
        }

        public String getPhoto() {
            return this.photo;
        }

        public String getGrouping() {
            return this.grouping;
        }

        public String getGroupingId() {
            return this.groupingId;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }

        public static FlickrPhoto matchURL(String url, String text) {
            Matcher m = GROUPING_PATTERN.matcher(url);
            if (m.matches()) {
                return new FlickrPhoto(m.group(1), null, m.group(2), m.group(3), text);
            }
            m = URL_PATTERN.matcher(url);
            if (m.matches()) {
                return new FlickrPhoto(m.group(1), m.group(2), null, null, text);
            }
            return null;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(this.getUrl());
            info.add(this.getUser() != null ? this.getUser() : "");
            info.add(this.getPhoto() != null ? this.getPhoto() : "");
            info.add(this.getGrouping() != null ? this.getGrouping() : "");
            info.add(this.getGroupingId() != null ? this.getGroupingId() : "");
            return info;
        }

        public String getUrl() {
            if (SETS.equals(this.grouping)) {
                return FlickrPhoto.getUserSetsURL(this.user, this.groupingId);
            }
            if (TAGS.equals(this.grouping)) {
                if (this.user != null) {
                    return FlickrPhoto.getUserTagsURL(this.user, this.groupingId);
                }
                return FlickrPhoto.getTagsURL(this.groupingId);
            }
            if (this.photo != null) {
                return FlickrPhoto.getPhotoURL(this.user, this.photo);
            }
            return FlickrPhoto.getUserURL(this.user);
        }

        public static String getRssUrl(String user) {
            return null;
        }

        public static String getTagsURL(String tag) {
            return "http://flickr.com/photos/tags/" + tag;
        }

        public static String getUserURL(String user) {
            return "http://flickr.com/photos/" + user;
        }

        public static String getPhotoURL(String user, String photo) {
            return "http://flickr.com/photos/" + user + "/" + photo;
        }

        public static String getUserTagsURL(String user, String tagId) {
            return "http://flickr.com/photos/" + user + "/tags/" + tagId;
        }

        public static String getUserSetsURL(String user, String setId) {
            return "http://flickr.com/photos/" + user + "/sets/" + setId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Photo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("http://picasaweb.google.com/([^/?#&]+)/+((?!searchbrowse)[^/?#&]+)(?:/|/photo)?(?:\\?[^#]*)?(?:#(.*))?");
        private String user;
        private String album;
        private String photo;

        public Photo(String user, String album, String photo, String text) {
            super(Token.Type.PHOTO, text);
            this.user = user;
            this.album = album;
            this.photo = photo;
        }

        public String getUser() {
            return this.user;
        }

        public String getAlbum() {
            return this.album;
        }

        public String getPhoto() {
            return this.photo;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }

        public static Photo matchURL(String url, String text) {
            Matcher m = URL_PATTERN.matcher(url);
            if (m.matches()) {
                return new Photo(m.group(1), m.group(2), m.group(3), text);
            }
            return null;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(Photo.getRssUrl(this.getUser()));
            info.add(Photo.getAlbumURL(this.getUser(), this.getAlbum()));
            if (this.getPhoto() != null) {
                info.add(Photo.getPhotoURL(this.getUser(), this.getAlbum(), this.getPhoto()));
            } else {
                info.add(null);
            }
            return info;
        }

        public static String getRssUrl(String user) {
            return "http://picasaweb.google.com/data/feed/api/user/" + user + "?category=album&alt=rss";
        }

        public static String getAlbumURL(String user, String album) {
            return "http://picasaweb.google.com/" + user + "/" + album;
        }

        public static String getPhotoURL(String user, String album, String photo) {
            return "http://picasaweb.google.com/" + user + "/" + album + "/photo#" + photo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class YouTubeVideo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://(?:[a-z0-9]+\\.)?youtube\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/watch\\?.*\\bv=([-_a-zA-Z0-9=]+).*");
        private String docid;

        public YouTubeVideo(String docid, String text) {
            super(Token.Type.YOUTUBE_VIDEO, text);
            this.docid = docid;
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }

        public static YouTubeVideo matchURL(String url, String text) {
            Matcher m = URL_PATTERN.matcher(url);
            if (m.matches()) {
                return new YouTubeVideo(m.group(1), text);
            }
            return null;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(YouTubeVideo.getRssUrl(this.docid));
            info.add(YouTubeVideo.getURL(this.docid));
            return info;
        }

        public static String getRssUrl(String docid) {
            return "http://youtube.com/watch?v=" + docid;
        }

        public static String getURL(String docid) {
            return YouTubeVideo.getURL(docid, null);
        }

        public static String getURL(String docid, String extraParams) {
            if (extraParams == null) {
                extraParams = "";
            } else if (extraParams.length() > 0) {
                extraParams = extraParams + "&";
            }
            return "http://youtube.com/watch?" + extraParams + "v=" + docid;
        }

        public static String getPrefixedURL(boolean http, String prefix, String docid, String extraParams) {
            String protocol = "";
            if (http) {
                protocol = "http://";
            }
            if (prefix == null) {
                prefix = "";
            }
            if (extraParams == null) {
                extraParams = "";
            } else if (extraParams.length() > 0) {
                extraParams = extraParams + "&";
            }
            return protocol + prefix + "youtube.com/watch?" + extraParams + "v=" + docid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Video
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://video\\.google\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/videoplay\\?.*?\\bdocid=(-?\\d+).*");
        private String docid;

        public Video(String docid, String text) {
            super(Token.Type.GOOGLE_VIDEO, text);
            this.docid = docid;
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }

        public static Video matchURL(String url, String text) {
            Matcher m = URL_PATTERN.matcher(url);
            if (m.matches()) {
                return new Video(m.group(1), text);
            }
            return null;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(Video.getRssUrl(this.docid));
            info.add(Video.getURL(this.docid));
            return info;
        }

        public static String getRssUrl(String docid) {
            return "http://video.google.com/videofeed?type=docid&output=rss&sourceid=gtalk&docid=" + docid;
        }

        public static String getURL(String docid) {
            return Video.getURL(docid, null);
        }

        public static String getURL(String docid, String extraParams) {
            if (extraParams == null) {
                extraParams = "";
            } else if (extraParams.length() > 0) {
                extraParams = extraParams + "&";
            }
            return "http://video.google.com/videoplay?" + extraParams + "docid=" + docid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Token {
        private String url;

        public Link(String url, String text) {
            super(Token.Type.LINK, text);
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(this.getURL());
            info.add(this.getRawText());
            return info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MusicTrack
    extends Token {
        private String track;

        public MusicTrack(String track) {
            super(Token.Type.MUSIC, track);
            this.track = track;
        }

        public String getTrack() {
            return this.track;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public List<String> getInfo() {
            List<String> info = super.getInfo();
            info.add(this.getTrack());
            return info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Html
    extends Token {
        private String html;

        public Html(String text, String html) {
            super(Token.Type.HTML, text);
            this.html = html;
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        @Override
        public String toHtml(boolean caps) {
            return caps ? this.html.toUpperCase() : this.html;
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        public void trimLeadingWhitespace() {
            this.text = Html.trimLeadingWhitespace(this.text);
            this.html = Html.trimLeadingWhitespace(this.html);
        }

        public void trimTrailingWhitespace() {
            this.text = Html.trimTrailingWhitespace(this.text);
            this.html = Html.trimTrailingWhitespace(this.html);
        }

        private static String trimLeadingWhitespace(String text) {
            int index;
            for (index = 0; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
            }
            return text.substring(index);
        }

        public static String trimTrailingWhitespace(String text) {
            int index;
            for (index = text.length(); index > 0 && Character.isWhitespace(text.charAt(index - 1)); --index) {
            }
            return text.substring(0, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Token {
        protected Type type;
        protected String text;

        protected Token(Type type, String text) {
            this.type = type;
            this.text = text;
        }

        public Type getType() {
            return this.type;
        }

        public List<String> getInfo() {
            ArrayList<String> info = new ArrayList<String>();
            info.add(this.getType().toString());
            return info;
        }

        public String getRawText() {
            return this.text;
        }

        public boolean isMedia() {
            return false;
        }

        public abstract boolean isHtml();

        public boolean isArray() {
            return !this.isHtml();
        }

        public String toHtml(boolean caps) {
            throw new AssertionError((Object)"not html");
        }

        public boolean controlCaps() {
            return false;
        }

        public boolean setCaps() {
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            HTML("html"),
            FORMAT("format"),
            LINK("l"),
            SMILEY("e"),
            ACRONYM("a"),
            MUSIC("m"),
            GOOGLE_VIDEO("v"),
            YOUTUBE_VIDEO("yt"),
            PHOTO("p"),
            FLICKR("f");

            private String stringRep;

            private Type(String stringRep) {
                this.stringRep = stringRep;
            }

            public String toString() {
                return this.stringRep;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Resources {
        public Set<String> getSchemes();

        public TrieNode getDomainSuffixes();

        public TrieNode getSmileys();

        public TrieNode getAcronyms();
    }
}

