/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.FloatMath;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.TypedValue;
import android.view.Choreographer;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.IApplicationToken;
import android.view.IInputFilter;
import android.view.IMagnificationCallbacks;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import com.android.internal.R;
import com.android.internal.app.IBatteryStats;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.AttributeCache;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import com.android.server.display.DisplayManagerService;
import com.android.server.input.InputManagerService;
import com.android.server.power.PowerManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayContentList;
import com.android.server.wm.DisplayMagnifier;
import com.android.server.wm.DisplaySettings;
import com.android.server.wm.DragState;
import com.android.server.wm.FakeWindowImpl;
import com.android.server.wm.FocusedStackFrame;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.KeyguardDisableHandler;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StackBox;
import com.android.server.wm.StackTapPointerEventListener;
import com.android.server.wm.StartingData;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.Task;
import com.android.server.wm.TaskGroup;
import com.android.server.wm.TaskStack;
import com.android.server.wm.ViewServer;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs,
DisplayManagerService.WindowManagerFuncs,
DisplayManager.DisplayListener {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean DEBUG_ADD_REMOVE = false;
    static final boolean DEBUG_FOCUS = false;
    static final boolean DEBUG_FOCUS_LIGHT = false;
    static final boolean DEBUG_ANIM = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_RESIZE = false;
    static final boolean DEBUG_LAYERS = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_INPUT_METHOD = false;
    static final boolean DEBUG_VISIBILITY = false;
    static final boolean DEBUG_WINDOW_MOVEMENT = false;
    static final boolean DEBUG_TOKEN_MOVEMENT = false;
    static final boolean DEBUG_ORIENTATION = false;
    static final boolean DEBUG_APP_ORIENTATION = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_APP_TRANSITIONS = false;
    static final boolean DEBUG_STARTING_WINDOW = false;
    static final boolean DEBUG_REORDER = false;
    static final boolean DEBUG_WALLPAPER = false;
    static final boolean DEBUG_WALLPAPER_LIGHT = false;
    static final boolean DEBUG_DRAG = false;
    static final boolean DEBUG_SCREEN_ON = false;
    static final boolean DEBUG_SCREENSHOT = false;
    static final boolean DEBUG_BOOT = false;
    static final boolean DEBUG_LAYOUT_REPEATS = true;
    static final boolean DEBUG_SURFACE_TRACE = false;
    static final boolean DEBUG_WINDOW_TRACE = false;
    static final boolean DEBUG_TASK_MOVEMENT = false;
    static final boolean DEBUG_STACK = false;
    static final boolean SHOW_SURFACE_ALLOC = false;
    static final boolean SHOW_TRANSACTIONS = false;
    static final boolean SHOW_LIGHT_TRANSACTIONS = false;
    static final boolean HIDE_STACK_CRAWLS = true;
    static final int LAYOUT_REPEAT_THRESHOLD = 4;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_BLUR = 2;
    static final int LAYER_OFFSET_FOCUSED_STACK = 1;
    static final int LAYER_OFFSET_THUMBNAIL = 4;
    static final int FREEZE_LAYER = 2000001;
    static final int MASK_LAYER = 2000000;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int DEFAULT_FADE_IN_OUT_DURATION = 400;
    static final int WINDOW_FREEZE_TIMEOUT_DURATION = 2000;
    static final int STARTING_WINDOW_TIMEOUT_DURATION = 10000;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    public static final float STACK_WEIGHT_MIN = 0.2f;
    public static final float STACK_WEIGHT_MAX = 0.8f;
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private static final String DENSITY_OVERRIDE = "ro.config.density_override";
    private static final String SIZE_OVERRIDE = "ro.config.size_override";
    private static final int MAX_SCREENSHOT_RETRIES = 3;
    private final KeyguardDisableHandler mKeyguardDisableHandler;
    private final boolean mHeadless;
    final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                WindowManagerService.this.mKeyguardDisableHandler.sendEmptyMessage(3);
            }
        }
    };
    int mCurrentUserId;
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final WindowManagerPolicy mPolicy = PolicyManager.makeNewWindowManager();
    final IActivityManager mActivityManager;
    final IBatteryStats mBatteryStats;
    final AppOpsManager mAppOps;
    final DisplaySettings mDisplaySettings;
    final HashSet<Session> mSessions = new HashSet();
    final HashMap<IBinder, WindowState> mWindowMap = new HashMap();
    final HashMap<IBinder, WindowToken> mTokenMap = new HashMap();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    final ArrayList<FakeWindowImpl> mFakeWindows = new ArrayList();
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    ArrayList<WindowState> mForceRemoves;
    ArrayList<Pair<WindowState, IRemoteCallback>> mWaitingForDrawn = new ArrayList();
    final ArrayList<WindowState> mRelayoutWhileAnimating = new ArrayList();
    WindowState[] mRebuildTmp = new WindowState[20];
    IInputMethodManager mInputMethodManager;
    DisplayMagnifier mDisplayMagnifier;
    final SurfaceSession mFxSession;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    FocusedStackFrame mFocusedStackFrame;
    int mFocusedStackLayer;
    final float[] mTmpFloats = new float[9];
    final Rect mTmpContentRect = new Rect();
    boolean mDisplayReady;
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    String mLastANRState;
    SparseArray<DisplayContent> mDisplayContents = new SparseArray(2);
    int mRotation = 0;
    int mForcedAppOrientation = -1;
    boolean mAltOrientation = false;
    ArrayList<IRotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    int mSystemDecorLayer = 0;
    final Rect mScreenRect = new Rect();
    boolean mTraversalScheduled = false;
    boolean mDisplayFrozen = false;
    long mDisplayFreezeTime = 0L;
    int mLastDisplayFreezeDuration = 0;
    Object mLastFinishedFreezeSource = null;
    boolean mWaitingForConfig = false;
    boolean mWindowsFreezingScreen = false;
    boolean mClientFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastWindowForcedOrientation = -1;
    int mLayoutSeq = 0;
    int mLastStatusBarVisibility = 0;
    boolean mFocusMayChange;
    Configuration mCurConfiguration = new Configuration();
    private final PowerManager.WakeLock mScreenFrozenLock;
    final AppTransition mAppTransition;
    boolean mStartingIconInTransition = false;
    boolean mSkipAppTransitionAnimation = false;
    final ArrayList<AppWindowToken> mOpeningApps = new ArrayList();
    final ArrayList<AppWindowToken> mClosingApps = new ArrayList();
    boolean mIsTouchDevice;
    final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mRealDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mTmpDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mCompatDisplayMetrics = new DisplayMetrics();
    final H mH = new H();
    final Choreographer mChoreographer = Choreographer.getInstance();
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    int mInputMethodAnimLayerAdjustment;
    WindowState mInputMethodWindow = null;
    final ArrayList<WindowState> mInputMethodDialogs = new ArrayList();
    boolean mHardKeyboardAvailable;
    boolean mHardKeyboardEnabled;
    OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    final ArrayList<WindowToken> mWallpaperTokens = new ArrayList();
    WindowState mWallpaperTarget = null;
    WindowState mLowerWallpaperTarget = null;
    WindowState mUpperWallpaperTarget = null;
    int mWallpaperAnimLayerAdjustment;
    float mLastWallpaperX = -1.0f;
    float mLastWallpaperY = -1.0f;
    float mLastWallpaperXStep = -1.0f;
    float mLastWallpaperYStep = -1.0f;
    WindowState mWaitingOnWallpaper;
    long mLastWallpaperTimeoutTime;
    static final long WALLPAPER_TIMEOUT = 150L;
    static final long WALLPAPER_TIMEOUT_RECOVERY = 10000L;
    AppWindowToken mFocusedApp = null;
    PowerManagerService mPowerManager;
    float mWindowAnimationScale = 1.0f;
    float mTransitionAnimationScale = 1.0f;
    float mAnimatorDurationScale = 1.0f;
    final InputManagerService mInputManager;
    final DisplayManagerService mDisplayManagerService;
    final DisplayManager mDisplayManager;
    Session mHoldingScreenOn;
    PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mTurnOnScreen;
    DragState mDragState = null;
    int mExitAnimId;
    int mEnterAnimId;
    final LayoutFields mInnerFields = new LayoutFields();
    boolean mAnimationScheduled;
    private int mTransactionSequence;
    private int mLayoutRepeatCount;
    final WindowAnimator mAnimator;
    SparseArray<Task> mTaskIdToTask = new SparseArray();
    SparseArray<TaskStack> mStackIdToStack = new SparseArray();
    private final PointerEventDispatcher mPointerEventDispatcher;
    boolean mInTouchMode = true;
    private ViewServer mViewServer;
    private final ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    private boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    float mCompatibleScreenScale;
    final boolean mOnlyCore;
    static final int ADJUST_WALLPAPER_LAYERS_CHANGED = 2;
    static final int ADJUST_WALLPAPER_VISIBILITY_CHANGED = 4;
    final InputMonitor mInputMonitor = new InputMonitor(this);
    private boolean mEventDispatchingEnabled;
    private boolean mInLayout = false;

    public static WindowManagerService main(final Context context, final PowerManagerService pm, final DisplayManagerService dm, final InputManagerService im, Handler wmHandler, final boolean haveInputMethods, final boolean showBootMsgs, final boolean onlyCore) {
        final WindowManagerService[] holder = new WindowManagerService[1];
        wmHandler.runWithScissors(new Runnable(){

            public void run() {
                holder[0] = new WindowManagerService(context, pm, dm, im, haveInputMethods, showBootMsgs, onlyCore);
            }
        }, 0L);
        return holder[0];
    }

    private void initPolicy(Handler uiHandler) {
        uiHandler.runWithScissors(new Runnable(){

            public void run() {
                WindowManagerPolicyThread.set(Thread.currentThread(), Looper.myLooper());
                WindowManagerService.this.mPolicy.init(WindowManagerService.this.mContext, WindowManagerService.this, WindowManagerService.this);
                WindowManagerService.this.mAnimator.mAboveUniverseLayer = WindowManagerService.this.mPolicy.getAboveUniverseLayer() * 10000 + 1000;
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowManagerService(Context context, PowerManagerService pm, DisplayManagerService displayManager, InputManagerService inputManager, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore) {
        Display[] displays;
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mOnlyCore = onlyCore;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(0x111000E);
        this.mInputManager = inputManager;
        this.mDisplayManagerService = displayManager;
        this.mHeadless = displayManager.isHeadless();
        this.mDisplaySettings = new DisplaySettings(context);
        this.mDisplaySettings.readSettingsLocked();
        this.mPointerEventDispatcher = new PointerEventDispatcher(this.mInputManager.monitorInput(TAG));
        this.mFxSession = new SurfaceSession();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        this.mDisplayManager.registerDisplayListener(this, null);
        for (Display display : displays = this.mDisplayManager.getDisplays()) {
            this.createDisplayContentLocked(display);
        }
        this.mKeyguardDisableHandler = new KeyguardDisableHandler(this.mContext, this.mPolicy);
        this.mPowerManager = pm;
        this.mPowerManager.setPolicy(this.mPolicy);
        PowerManager pmc = (PowerManager)context.getSystemService("power");
        this.mScreenFrozenLock = pmc.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mAppTransition = new AppTransition(context, this.mH);
        this.mActivityManager = ActivityManagerNative.getDefault();
        this.mBatteryStats = BatteryStatsService.getService();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mAppOps.startWatchingMode(24, null, (AppOpsManager.OnOpChangedListener)new AppOpsManager.OnOpChangedInternalListener(){

            public void onOpChanged(int op, String packageName) {
                WindowManagerService.this.updateAppOpsState();
            }
        });
        this.mWindowAnimationScale = Settings.Global.getFloat(context.getContentResolver(), "window_animation_scale", this.mWindowAnimationScale);
        this.mTransitionAnimationScale = Settings.Global.getFloat(context.getContentResolver(), "transition_animation_scale", this.mTransitionAnimationScale);
        this.setAnimatorDurationScale(Settings.Global.getFloat(context.getContentResolver(), "animator_duration_scale", this.mAnimatorDurationScale));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mHoldingScreenWakeLock = pmc.newWakeLock(0x2000000A, TAG);
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mAnimator = new WindowAnimator(this);
        this.initPolicy(UiThread.getHandler());
        Watchdog.getInstance().addMonitor(this);
        SurfaceControl.openTransaction();
        try {
            this.createWatermarkInTransaction();
            this.mFocusedStackFrame = new FocusedStackFrame(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    public InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Window Manager Crash", e);
            }
            throw e;
        }
    }

    private void placeWindowAfter(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        windows.add(i + 1, window);
        this.mWindowsChanged = true;
    }

    private void placeWindowBefore(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        if (i < 0) {
            Slog.w(TAG, "placeWindowBefore: Unable to find " + pos + " in " + windows);
            i = 0;
        }
        windows.add(i, window);
        this.mWindowsChanged = true;
    }

    private int findIdxBasedOnAppTokens(WindowState win) {
        WindowList windows = win.getWindowList();
        for (int j = windows.size() - 1; j >= 0; --j) {
            WindowState wentry = (WindowState)windows.get(j);
            if (wentry.mAppToken != win.mAppToken) continue;
            return j;
        }
        return -1;
    }

    WindowList getTokenWindowsOnDisplay(WindowToken token, DisplayContent displayContent) {
        WindowList windowList = new WindowList();
        int count = token.windows.size();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            if (win.mDisplayContent != displayContent) continue;
            windowList.add(win);
        }
        return windowList;
    }

    private int indexOfWinInWindowList(WindowState targetWin, WindowList windows) {
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w == targetWin) {
                return i;
            }
            if (w.mChildWindows.isEmpty() || this.indexOfWinInWindowList(targetWin, w.mChildWindows) < 0) continue;
            return i;
        }
        return -1;
    }

    private int addAppWindowToListLocked(WindowState win) {
        int i;
        WindowToken atoken;
        AppWindowToken t;
        AppTokenList tokens;
        int taskNdx;
        IWindow client = win.mClient;
        WindowToken token = win.mToken;
        DisplayContent displayContent = win.mDisplayContent;
        WindowList windows = win.getWindowList();
        int N = windows.size();
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int tokenWindowsPos = 0;
        int windowListPos = tokenWindowList.size();
        if (!tokenWindowList.isEmpty()) {
            if (win.mAttrs.type == 1) {
                WindowState lowestWindow = (WindowState)tokenWindowList.get(0);
                this.placeWindowBefore(lowestWindow, win);
                tokenWindowsPos = this.indexOfWinInWindowList(lowestWindow, token.windows);
            } else {
                AppWindowToken atoken2 = win.mAppToken;
                WindowState lastWindow = (WindowState)tokenWindowList.get(windowListPos - 1);
                if (atoken2 != null && lastWindow == atoken2.startingWindow) {
                    this.placeWindowBefore(lastWindow, win);
                    tokenWindowsPos = this.indexOfWinInWindowList(lastWindow, token.windows);
                } else {
                    int newIdx = this.findIdxBasedOnAppTokens(win);
                    windows.add(newIdx + 1, win);
                    tokenWindowsPos = newIdx < 0 ? 0 : this.indexOfWinInWindowList((WindowState)windows.get(newIdx), token.windows) + 1;
                    this.mWindowsChanged = true;
                }
            }
            return tokenWindowsPos;
        }
        WindowState pos = null;
        ArrayList<Task> tasks = displayContent.getTasks();
        int tokenNdx = -1;
        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            for (tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                if (t == token) {
                    if (--tokenNdx >= 0 || --taskNdx < 0) break;
                    tokenNdx = tasks.get((int)taskNdx).mAppTokens.size() - 1;
                    break;
                }
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                if (t.sendingToBottom || tokenWindowList.size() <= 0) continue;
                pos = (WindowState)tokenWindowList.get(0);
            }
            if (tokenNdx >= 0) break;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = (tokenWindowList = this.getTokenWindowsOnDisplay(atoken, displayContent)).size()) > 0) {
                WindowState bottom = (WindowState)tokenWindowList.get(0);
                if (bottom.mSubLayer < 0) {
                    pos = bottom;
                }
            }
            this.placeWindowBefore(pos, win);
            return tokenWindowsPos;
        }
        while (taskNdx >= 0) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            while (tokenNdx >= 0) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                int NW = tokenWindowList.size();
                if (NW > 0) {
                    pos = (WindowState)tokenWindowList.get(NW - 1);
                    break;
                }
                --tokenNdx;
            }
            if (tokenNdx >= 0) break;
            --taskNdx;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = atoken.windows.size()) > 0) {
                WindowState top = (WindowState)atoken.windows.get(NC - 1);
                if (top.mSubLayer >= 0) {
                    pos = top;
                }
            }
            this.placeWindowAfter(pos, win);
            return tokenWindowsPos;
        }
        int myLayer = win.mBaseLayer;
        for (i = 0; i < N; ++i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mBaseLayer > myLayer) break;
        }
        windows.add(i, win);
        this.mWindowsChanged = true;
        return tokenWindowsPos;
    }

    private void addFreeWindowToListLocked(WindowState win) {
        int i;
        WindowList windows = win.getWindowList();
        int myLayer = win.mBaseLayer;
        for (i = windows.size() - 1; i >= 0 && ((WindowState)windows.get((int)i)).mBaseLayer > myLayer; --i) {
        }
        windows.add(++i, win);
        this.mWindowsChanged = true;
    }

    private void addAttachedWindowToListLocked(WindowState win, boolean addToToken) {
        int i;
        WindowToken token = win.mToken;
        DisplayContent displayContent = win.mDisplayContent;
        WindowState attached = win.mAttachedWindow;
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int NA = tokenWindowList.size();
        int sublayer = win.mSubLayer;
        int largestSublayer = Integer.MIN_VALUE;
        WindowState windowWithLargestSublayer = null;
        for (i = 0; i < NA; ++i) {
            WindowState w = (WindowState)tokenWindowList.get(i);
            int wSublayer = w.mSubLayer;
            if (wSublayer >= largestSublayer) {
                largestSublayer = wSublayer;
                windowWithLargestSublayer = w;
            }
            if (sublayer < 0) {
                if (wSublayer < sublayer) continue;
                if (addToToken) {
                    token.windows.add(i, win);
                }
                this.placeWindowBefore(wSublayer >= 0 ? attached : w, win);
                break;
            }
            if (wSublayer <= sublayer) continue;
            if (addToToken) {
                token.windows.add(i, win);
            }
            this.placeWindowBefore(w, win);
            break;
        }
        if (i >= NA) {
            if (addToToken) {
                token.windows.add(win);
            }
            if (sublayer < 0) {
                this.placeWindowBefore(attached, win);
            } else {
                this.placeWindowAfter(largestSublayer >= 0 ? windowWithLargestSublayer : attached, win);
            }
        }
    }

    private void addWindowToListInOrderLocked(WindowState win, boolean addToToken) {
        if (win.mAttachedWindow == null) {
            WindowToken token = win.mToken;
            int tokenWindowsPos = 0;
            if (token.appWindowToken != null) {
                tokenWindowsPos = this.addAppWindowToListLocked(win);
            } else {
                this.addFreeWindowToListLocked(win);
            }
            if (addToToken) {
                token.windows.add(tokenWindowsPos, win);
            }
        } else {
            this.addAttachedWindowToListLocked(win, addToToken);
        }
        if (win.mAppToken != null && addToToken) {
            win.mAppToken.allAppWindows.add(win);
        }
    }

    static boolean canBeImeTarget(WindowState w) {
        int fl = w.mAttrs.flags & 0x20008;
        if (fl == 0 || fl == 131080 || w.mAttrs.type == 3) {
            return w.isVisibleOrAdding();
        }
        return false;
    }

    int findDesiredInputMethodWindowIndexLocked(boolean willMove) {
        WindowState curTarget;
        int i;
        WindowList windows = this.getDefaultWindowListLocked();
        WindowState w = null;
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (!WindowManagerService.canBeImeTarget(win)) continue;
            w = win;
            if (willMove || w.mAttrs.type != 3 || i <= 0) break;
            WindowState wb = (WindowState)windows.get(i - 1);
            if (wb.mAppToken != w.mAppToken || !WindowManagerService.canBeImeTarget(wb)) break;
            --i;
            w = wb;
            break;
        }
        if ((curTarget = this.mInputMethodTarget) != null && curTarget.isDisplayedLw() && curTarget.isClosing() && (w == null || curTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer)) {
            return windows.indexOf(curTarget) + 1;
        }
        if (willMove && w != null) {
            AppWindowToken token;
            AppWindowToken appWindowToken = token = curTarget == null ? null : curTarget.mAppToken;
            if (token != null) {
                WindowState highestTarget = null;
                int highestPos = 0;
                if (token.mAppAnimator.animating || token.mAppAnimator.animation != null) {
                    WindowList curWindows = curTarget.getWindowList();
                    for (int pos = curWindows.indexOf(curTarget); pos >= 0; --pos) {
                        WindowState win = (WindowState)curWindows.get(pos);
                        if (win.mAppToken != token) break;
                        if (win.mRemoved || highestTarget != null && win.mWinAnimator.mAnimLayer <= highestTarget.mWinAnimator.mAnimLayer) continue;
                        highestTarget = win;
                        highestPos = pos;
                    }
                }
                if (highestTarget != null) {
                    if (this.mAppTransition.isTransitionSet()) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                    if (highestTarget.mWinAnimator.isAnimating() && highestTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                }
            }
        }
        if (w != null) {
            if (willMove) {
                this.mInputMethodTarget = w;
                this.mInputMethodTargetWaitingAnim = false;
                if (w.mAppToken != null) {
                    this.setInputMethodAnimLayerAdjustment(w.mAppToken.mAppAnimator.animLayerAdjustment);
                } else {
                    this.setInputMethodAnimLayerAdjustment(0);
                }
            }
            return i + 1;
        }
        if (willMove) {
            this.mInputMethodTarget = null;
            this.setInputMethodAnimLayerAdjustment(0);
        }
        return -1;
    }

    void addInputMethodWindowToListLocked(WindowState win) {
        int pos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (pos >= 0) {
            win.mTargetAppToken = this.mInputMethodTarget.mAppToken;
            this.getDefaultWindowListLocked().add(pos, win);
            this.mWindowsChanged = true;
            this.moveInputMethodDialogsLocked(pos + 1);
            return;
        }
        win.mTargetAppToken = null;
        this.addWindowToListInOrderLocked(win, true);
        this.moveInputMethodDialogsLocked(pos);
    }

    void setInputMethodAnimLayerAdjustment(int adj) {
        this.mInputMethodAnimLayerAdjustment = adj;
        WindowState imw = this.mInputMethodWindow;
        if (imw != null) {
            imw.mWinAnimator.mAnimLayer = imw.mLayer + adj;
            int wi = imw.mChildWindows.size();
            while (wi > 0) {
                WindowState cw = (WindowState)imw.mChildWindows.get(--wi);
                cw.mWinAnimator.mAnimLayer = cw.mLayer + adj;
            }
        }
        int di = this.mInputMethodDialogs.size();
        while (di > 0) {
            imw = this.mInputMethodDialogs.get(--di);
            imw.mWinAnimator.mAnimLayer = imw.mLayer + adj;
        }
    }

    private int tmpRemoveWindowLocked(int interestingPos, WindowState win) {
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            if (wpos < interestingPos) {
                --interestingPos;
            }
            windows.remove(wpos);
            this.mWindowsChanged = true;
            int NC = win.mChildWindows.size();
            while (NC > 0) {
                WindowState cw;
                int cpos;
                if ((cpos = windows.indexOf(cw = (WindowState)win.mChildWindows.get(--NC))) < 0) continue;
                if (cpos < interestingPos) {
                    --interestingPos;
                }
                windows.remove(cpos);
            }
        }
        return interestingPos;
    }

    private void reAddWindowToListInOrderLocked(WindowState win) {
        this.addWindowToListInOrderLocked(win, false);
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            windows.remove(wpos);
            this.mWindowsChanged = true;
            this.reAddWindowLocked(wpos, win);
        }
    }

    void logWindowList(WindowList windows, String prefix) {
        int N = windows.size();
        while (N > 0) {
            Slog.v(TAG, prefix + "#" + --N + ": " + windows.get(N));
        }
    }

    void moveInputMethodDialogsLocked(int pos) {
        int i;
        ArrayList<WindowState> dialogs = this.mInputMethodDialogs;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = dialogs.size();
        for (i = 0; i < N; ++i) {
            pos = this.tmpRemoveWindowLocked(pos, dialogs.get(i));
        }
        if (pos >= 0) {
            WindowState wp;
            AppWindowToken targetAppToken = this.mInputMethodTarget.mAppToken;
            if (pos < windows.size() && (wp = (WindowState)windows.get(pos)) == this.mInputMethodWindow) {
                ++pos;
            }
            for (int i2 = 0; i2 < N; ++i2) {
                WindowState win = dialogs.get(i2);
                win.mTargetAppToken = targetAppToken;
                pos = this.reAddWindowLocked(pos, win);
            }
            return;
        }
        for (i = 0; i < N; ++i) {
            WindowState win = dialogs.get(i);
            win.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(win);
        }
    }

    boolean moveInputMethodWindowsIfNeededLocked(boolean needAssignLayers) {
        WindowState imWin = this.mInputMethodWindow;
        int DN = this.mInputMethodDialogs.size();
        if (imWin == null && DN == 0) {
            return false;
        }
        WindowList windows = this.getDefaultWindowListLocked();
        int imPos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (imPos >= 0) {
            WindowState baseImWin;
            int N = windows.size();
            WindowState firstImWin = imPos < N ? (WindowState)windows.get(imPos) : null;
            WindowState windowState = baseImWin = imWin != null ? imWin : this.mInputMethodDialogs.get(0);
            if (baseImWin.mChildWindows.size() > 0) {
                WindowState cw = (WindowState)baseImWin.mChildWindows.get(0);
                if (cw.mSubLayer < 0) {
                    baseImWin = cw;
                }
            }
            if (firstImWin == baseImWin) {
                int pos;
                for (pos = imPos + 1; pos < N && ((WindowState)windows.get((int)pos)).mIsImWindow; ++pos) {
                }
                ++pos;
                while (pos < N && !((WindowState)windows.get((int)pos)).mIsImWindow) {
                    ++pos;
                }
                if (pos >= N) {
                    if (imWin != null) {
                        imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                    }
                    return false;
                }
            }
            if (imWin != null) {
                imPos = this.tmpRemoveWindowLocked(imPos, imWin);
                imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                this.reAddWindowLocked(imPos, imWin);
                if (DN > 0) {
                    this.moveInputMethodDialogsLocked(imPos + 1);
                }
            } else {
                this.moveInputMethodDialogsLocked(imPos);
            }
        } else if (imWin != null) {
            this.tmpRemoveWindowLocked(0, imWin);
            imWin.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(imWin);
            if (DN > 0) {
                this.moveInputMethodDialogsLocked(-1);
            }
        } else {
            this.moveInputMethodDialogsLocked(-1);
        }
        if (needAssignLayers) {
            this.assignLayersLocked(windows);
        }
        return true;
    }

    final boolean isWallpaperVisible(WindowState wallpaperTarget) {
        return wallpaperTarget != null && (!wallpaperTarget.mObscured || wallpaperTarget.mAppToken != null && wallpaperTarget.mAppToken.mAppAnimator.animation != null) || this.mUpperWallpaperTarget != null || this.mLowerWallpaperTarget != null;
    }

    int adjustWallpaperWindowsLocked() {
        boolean visible;
        this.mInnerFields.mWallpaperMayChange = false;
        boolean targetChanged = false;
        DisplayInfo displayInfo = this.getDefaultDisplayContentLocked().getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        WindowState w = null;
        WindowState foundW = null;
        int foundI = 0;
        WindowState topCurW = null;
        int topCurI = 0;
        int windowDetachedI = -1;
        int i = N;
        while (i > 0) {
            w = (WindowState)windows.get(--i);
            if (w.mAttrs.type == 2013) {
                if (topCurW != null) continue;
                topCurW = w;
                topCurI = i;
                continue;
            }
            topCurW = null;
            if (w != this.mAnimator.mWindowDetachedWallpaper && w.mAppToken != null && w.mAppToken.hidden && w.mAppToken.mAppAnimator.animation == null) continue;
            if ((w.mAttrs.flags & 0x100000) != 0 && w.isOnScreen() && (this.mWallpaperTarget == w || w.isDrawFinishedLw())) {
                foundW = w;
                foundI = i;
                if (w != this.mWallpaperTarget || !w.mWinAnimator.isAnimating()) break;
                continue;
            }
            if (w != this.mAnimator.mWindowDetachedWallpaper) continue;
            windowDetachedI = i;
        }
        if (foundW == null && windowDetachedI >= 0) {
            foundW = w;
            foundI = windowDetachedI;
        }
        if (this.mWallpaperTarget != foundW && (this.mLowerWallpaperTarget == null || this.mLowerWallpaperTarget != foundW)) {
            this.mLowerWallpaperTarget = null;
            this.mUpperWallpaperTarget = null;
            WindowState oldW = this.mWallpaperTarget;
            this.mWallpaperTarget = foundW;
            targetChanged = true;
            if (foundW != null && oldW != null) {
                int oldI;
                boolean oldAnim = oldW.isAnimatingLw();
                boolean foundAnim = foundW.isAnimatingLw();
                if (foundAnim && oldAnim && (oldI = windows.indexOf(oldW)) >= 0) {
                    if (foundW.mAppToken != null && foundW.mAppToken.hiddenRequested) {
                        this.mWallpaperTarget = oldW;
                        foundW = oldW;
                        foundI = oldI;
                    } else if (foundI > oldI) {
                        this.mUpperWallpaperTarget = foundW;
                        this.mLowerWallpaperTarget = oldW;
                        foundW = oldW;
                        foundI = oldI;
                    } else {
                        this.mUpperWallpaperTarget = oldW;
                        this.mLowerWallpaperTarget = foundW;
                    }
                }
            }
        } else if (!(this.mLowerWallpaperTarget == null || this.mLowerWallpaperTarget.isAnimatingLw() && this.mUpperWallpaperTarget.isAnimatingLw())) {
            this.mLowerWallpaperTarget = null;
            this.mUpperWallpaperTarget = null;
            this.mWallpaperTarget = foundW;
            targetChanged = true;
        }
        boolean bl = visible = foundW != null;
        if (visible) {
            visible = this.isWallpaperVisible(foundW);
            this.mWallpaperAnimLayerAdjustment = this.mLowerWallpaperTarget == null && foundW.mAppToken != null ? foundW.mAppToken.mAppAnimator.animLayerAdjustment : 0;
            int maxLayer = this.mPolicy.getMaxWallpaperLayer() * 10000 + 1000;
            while (foundI > 0) {
                WindowState wb = (WindowState)windows.get(foundI - 1);
                if (!(wb.mBaseLayer >= maxLayer || wb.mAttachedWindow == foundW || foundW.mAttachedWindow != null && wb.mAttachedWindow == foundW.mAttachedWindow || wb.mAttrs.type == 3 && foundW.mToken != null && wb.mToken == foundW.mToken)) break;
                foundW = wb;
                --foundI;
            }
        }
        if (foundW == null && topCurW != null) {
            foundW = topCurW;
            foundI = topCurI + 1;
        } else {
            WindowState windowState = foundW = foundI > 0 ? (WindowState)windows.get(foundI - 1) : null;
        }
        if (visible) {
            if (this.mWallpaperTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = this.mWallpaperTarget.mWallpaperX;
                this.mLastWallpaperXStep = this.mWallpaperTarget.mWallpaperXStep;
            }
            if (this.mWallpaperTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = this.mWallpaperTarget.mWallpaperY;
                this.mLastWallpaperYStep = this.mWallpaperTarget.mWallpaperYStep;
            }
        }
        int changed = 0;
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            if (token.hidden == visible) {
                changed |= 4;
                token.hidden = !visible;
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
            }
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                int type;
                WindowState wallpaper = (WindowState)token.windows.get(--curWallpaperIndex);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                this.dispatchWallpaperVisibility(wallpaper, visible);
                wallpaper.mWinAnimator.mAnimLayer = wallpaper.mLayer + this.mWallpaperAnimLayerAdjustment;
                if (wallpaper == foundW) {
                    foundW = --foundI > 0 ? (WindowState)windows.get(foundI - 1) : null;
                    continue;
                }
                int oldIndex = windows.indexOf(wallpaper);
                if (oldIndex >= 0) {
                    windows.remove(oldIndex);
                    this.mWindowsChanged = true;
                    if (oldIndex < foundI) {
                        --foundI;
                    }
                }
                int insertionIndex = 0;
                if (visible && foundW != null && ((type = foundW.mAttrs.type) == 2004 || type == 2029)) {
                    insertionIndex = windows.indexOf(foundW);
                }
                windows.add(insertionIndex, wallpaper);
                this.mWindowsChanged = true;
                changed |= 2;
            }
        }
        if (targetChanged) {
            // empty if block
        }
        return changed;
    }

    void setWallpaperAnimLayerAdjustmentLocked(int adj) {
        this.mWallpaperAnimLayerAdjustment = adj;
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper = (WindowState)token.windows.get(--curWallpaperIndex);
                wallpaper.mWinAnimator.mAnimLayer = wallpaper.mLayer + adj;
            }
        }
    }

    boolean updateWallpaperOffsetLocked(WindowState wallpaperWin, int dw, int dh, boolean sync) {
        boolean changed;
        block12: {
            changed = false;
            boolean rawChanged = false;
            float wpx = this.mLastWallpaperX >= 0.0f ? this.mLastWallpaperX : 0.5f;
            float wpxs = this.mLastWallpaperXStep >= 0.0f ? this.mLastWallpaperXStep : -1.0f;
            int availw = wallpaperWin.mFrame.right - wallpaperWin.mFrame.left - dw;
            int offset = availw > 0 ? -((int)((float)availw * wpx + 0.5f)) : 0;
            boolean bl = changed = wallpaperWin.mXOffset != offset;
            if (changed) {
                wallpaperWin.mXOffset = offset;
            }
            if (wallpaperWin.mWallpaperX != wpx || wallpaperWin.mWallpaperXStep != wpxs) {
                wallpaperWin.mWallpaperX = wpx;
                wallpaperWin.mWallpaperXStep = wpxs;
                rawChanged = true;
            }
            float wpy = this.mLastWallpaperY >= 0.0f ? this.mLastWallpaperY : 0.5f;
            float wpys = this.mLastWallpaperYStep >= 0.0f ? this.mLastWallpaperYStep : -1.0f;
            int availh = wallpaperWin.mFrame.bottom - wallpaperWin.mFrame.top - dh;
            int n = offset = availh > 0 ? -((int)((float)availh * wpy + 0.5f)) : 0;
            if (wallpaperWin.mYOffset != offset) {
                changed = true;
                wallpaperWin.mYOffset = offset;
            }
            if (wallpaperWin.mWallpaperY != wpy || wallpaperWin.mWallpaperYStep != wpys) {
                wallpaperWin.mWallpaperY = wpy;
                wallpaperWin.mWallpaperYStep = wpys;
                rawChanged = true;
            }
            if (rawChanged && (wallpaperWin.mAttrs.privateFlags & 4) != 0) {
                try {
                    if (sync) {
                        this.mWaitingOnWallpaper = wallpaperWin;
                    }
                    wallpaperWin.mClient.dispatchWallpaperOffsets(wallpaperWin.mWallpaperX, wallpaperWin.mWallpaperY, wallpaperWin.mWallpaperXStep, wallpaperWin.mWallpaperYStep, sync);
                    if (!sync || this.mWaitingOnWallpaper == null) break block12;
                    long start = SystemClock.uptimeMillis();
                    if (this.mLastWallpaperTimeoutTime + 10000L < start) {
                        try {
                            this.mWindowMap.wait(150L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (start + 150L < SystemClock.uptimeMillis()) {
                            Slog.i(TAG, "Timeout waiting for wallpaper to offset: " + wallpaperWin);
                            this.mLastWallpaperTimeoutTime = start;
                        }
                    }
                    this.mWaitingOnWallpaper = null;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperOffsetsComplete(IBinder window) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    void updateWallpaperOffsetLocked(WindowState changingTarget, boolean sync) {
        DisplayContent displayContent = changingTarget.mDisplayContent;
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        WindowState target = this.mWallpaperTarget;
        if (target != null) {
            if (target.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = target.mWallpaperX;
            } else if (changingTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = changingTarget.mWallpaperX;
            }
            if (target.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = target.mWallpaperY;
            } else if (changingTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = changingTarget.mWallpaperY;
            }
        }
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper;
                if (!this.updateWallpaperOffsetLocked(wallpaper = (WindowState)token.windows.get(--curWallpaperIndex), dw, dh, sync)) continue;
                WindowStateAnimator winAnimator = wallpaper.mWinAnimator;
                winAnimator.computeShownFrameLocked();
                winAnimator.setWallpaperOffset(wallpaper.mShownFrame);
                sync = false;
            }
        }
    }

    void dispatchWallpaperVisibility(WindowState wallpaper, boolean visible) {
        if (wallpaper.mWallpaperVisible != visible) {
            wallpaper.mWallpaperVisible = visible;
            try {
                wallpaper.mClient.dispatchAppVisibility(visible);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void updateWallpaperVisibilityLocked() {
        boolean visible = this.isWallpaperVisible(this.mWallpaperTarget);
        DisplayContent displayContent = this.mWallpaperTarget.mDisplayContent;
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        int curTokenIndex = this.mWallpaperTokens.size();
        while (curTokenIndex > 0) {
            WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
            if (token.hidden == visible) {
                token.hidden = !visible;
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
            }
            int curWallpaperIndex = token.windows.size();
            while (curWallpaperIndex > 0) {
                WindowState wallpaper = (WindowState)token.windows.get(--curWallpaperIndex);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                this.dispatchWallpaperVisibility(wallpaper, visible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, InputChannel outInputChannel) {
        long origId;
        int[] appOp = new int[1];
        int res = this.mPolicy.checkAddPermission(attrs, appOp);
        if (res != 0) {
            return res;
        }
        boolean reportNewConfig = false;
        WindowState attachedWindow = null;
        WindowState win = null;
        int type = attrs.type;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mDisplayReady) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent == null) {
                Slog.w(TAG, "Attempted to add window to a display that does not exist: " + displayId + ".  Aborting.");
                return -9;
            }
            if (!displayContent.hasAccess(session.mUid)) {
                Slog.w(TAG, "Attempted to add window to a display for which the application does not have access: " + displayId + ".  Aborting.");
                return -9;
            }
            if (this.mWindowMap.containsKey(client.asBinder())) {
                Slog.w(TAG, "Window " + client + " is already added");
                return -5;
            }
            if (type >= 1000 && type <= 1999) {
                attachedWindow = this.windowForClientLocked(null, attrs.token, false);
                if (attachedWindow == null) {
                    Slog.w(TAG, "Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
                if (attachedWindow.mAttrs.type >= 1000 && attachedWindow.mAttrs.type <= 1999) {
                    Slog.w(TAG, "Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
            }
            if (type == 2030 && !displayContent.isPrivate()) {
                Slog.w(TAG, "Attempted to add private presentation window to a non-private display.  Aborting.");
                return -8;
            }
            boolean addToken = false;
            WindowToken token = this.mTokenMap.get(attrs.token);
            if (token == null) {
                if (type >= 1 && type <= 99) {
                    Slog.w(TAG, "Attempted to add application window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2011) {
                    Slog.w(TAG, "Attempted to add input method window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                token = new WindowToken(this, attrs.token, -1, false);
                addToken = true;
            } else if (type >= 1 && type <= 99) {
                AppWindowToken atoken = token.appWindowToken;
                if (atoken == null) {
                    Slog.w(TAG, "Attempted to add window with non-application token " + token + ".  Aborting.");
                    return -3;
                }
                if (atoken.removed) {
                    Slog.w(TAG, "Attempted to add window with exiting application token " + token + ".  Aborting.");
                    return -4;
                }
                if (type == 3 && atoken.firstWindowDrawn) {
                    return -6;
                }
            } else if (type == 2011) {
                if (token.windowType != 2011) {
                    Slog.w(TAG, "Attempted to add input method window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2013) {
                if (token.windowType != 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2023 && token.windowType != 2023) {
                Slog.w(TAG, "Attempted to add Dream window with bad token " + attrs.token + ".  Aborting.");
                return -1;
            }
            win = new WindowState(this, session, client, token, attachedWindow, appOp[0], seq, attrs, viewVisibility, displayContent);
            if (win.mDeathRecipient == null) {
                Slog.w(TAG, "Adding window client " + client.asBinder() + " that is dead, aborting.");
                return -4;
            }
            this.mPolicy.adjustWindowParamsLw(win.mAttrs);
            win.setShowToOwnerOnlyLocked(this.mPolicy.checkShowToOwnerOnly(attrs));
            res = this.mPolicy.prepareAddWindowLw(win, attrs);
            if (res != 0) {
                return res;
            }
            if (outInputChannel != null && (attrs.inputFeatures & 2) == 0) {
                String name = win.makeInputChannelName();
                InputChannel[] inputChannels = InputChannel.openInputChannelPair(name);
                win.setInputChannel(inputChannels[0]);
                inputChannels[1].transferTo(outInputChannel);
                this.mInputManager.registerInputChannel(win.mInputChannel, win.mInputWindowHandle);
            }
            res = 0;
            origId = Binder.clearCallingIdentity();
            if (addToken) {
                this.mTokenMap.put(attrs.token, token);
            }
            win.attach();
            this.mWindowMap.put(client.asBinder(), win);
            if (win.mAppOp != -1 && this.mAppOps.startOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage()) != 0) {
                win.setAppOpVisibilityLw(false);
            }
            if (type == 3 && token.appWindowToken != null) {
                token.appWindowToken.startingWindow = win;
                Message m = this.mH.obtainMessage(33, token.appWindowToken);
                this.mH.sendMessageDelayed(m, 10000L);
            }
            boolean imMayMove = true;
            if (type == 2011) {
                win.mGivenInsetsPending = true;
                this.mInputMethodWindow = win;
                this.addInputMethodWindowToListLocked(win);
                imMayMove = false;
            } else if (type == 2012) {
                this.mInputMethodDialogs.add(win);
                this.addWindowToListInOrderLocked(win, true);
                this.moveInputMethodDialogsLocked(this.findDesiredInputMethodWindowIndexLocked(true));
                imMayMove = false;
            } else {
                this.addWindowToListInOrderLocked(win, true);
                if (type == 2013) {
                    this.mLastWallpaperTimeoutTime = 0L;
                    displayContent.pendingLayoutChanges |= 4;
                } else if ((attrs.flags & 0x100000) != 0) {
                    displayContent.pendingLayoutChanges |= 4;
                } else if (this.mWallpaperTarget != null && this.mWallpaperTarget.mLayer >= win.mBaseLayer) {
                    displayContent.pendingLayoutChanges |= 4;
                }
            }
            win.mWinAnimator.mEnterAnimationPending = true;
            if (displayContent.isDefaultDisplay) {
                this.mPolicy.getContentInsetHintLw(attrs, outContentInsets);
            } else {
                outContentInsets.setEmpty();
            }
            if (this.mInTouchMode) {
                res |= 1;
            }
            if (win.mAppToken == null || !win.mAppToken.clientHidden) {
                res |= 2;
            }
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            boolean focusChanged = false;
            if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                imMayMove = false;
            }
            if (imMayMove) {
                this.moveInputMethodWindowsIfNeededLocked(false);
            }
            this.assignLayersLocked(displayContent.getWindowList());
            if (focusChanged) {
                this.finishUpdateFocusedWindowAfterAssignLayersLocked(false);
            }
            this.mInputMonitor.updateInputWindowsLw(false);
            if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(false)) {
                reportNewConfig = true;
            }
        }
        if (reportNewConfig) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Session session, IWindow client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return;
            }
            this.removeWindowLocked(session, win);
        }
    }

    public void removeWindowLocked(Session session, WindowState win) {
        if (win.mAttrs.type == 3) {
            this.removeStartingWindowTimeout(win.mAppToken);
        }
        long origId = Binder.clearCallingIdentity();
        win.disposeInputChannel();
        boolean wasVisible = false;
        if (win.mHasSurface && this.okToDisplay()) {
            wasVisible = win.isWinVisibleLw();
            if (wasVisible) {
                int transit = 2;
                if (win.mAttrs.type == 3) {
                    transit = 5;
                }
                if (win.mWinAnimator.applyAnimationLocked(transit, false)) {
                    win.mExiting = true;
                }
                if (this.mDisplayMagnifier != null && win.getDisplayId() == 0) {
                    this.mDisplayMagnifier.onWindowTransitionLocked(win, transit);
                }
            }
            if (win.mExiting || win.mWinAnimator.isAnimating()) {
                win.mExiting = true;
                win.mRemoveOnExit = true;
                win.mDisplayContent.layoutNeeded = true;
                this.updateFocusedWindowLocked(3, false);
                this.performLayoutAndPlaceSurfacesLocked();
                if (win.mAppToken != null) {
                    win.mAppToken.updateReportedVisibilityLocked();
                }
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        this.removeWindowInnerLocked(session, win);
        if (wasVisible && this.updateOrientationFromAppTokensLocked(false)) {
            this.mH.sendEmptyMessage(18);
        }
        this.updateFocusedWindowLocked(0, true);
        Binder.restoreCallingIdentity(origId);
    }

    private void removeWindowInnerLocked(Session session, WindowState win) {
        if (win.mRemoved) {
            return;
        }
        for (int i = win.mChildWindows.size() - 1; i >= 0; --i) {
            WindowState cwin = (WindowState)win.mChildWindows.get(i);
            Slog.w(TAG, "Force-removing child win " + cwin + " from container " + win);
            this.removeWindowInnerLocked(cwin.mSession, cwin);
        }
        win.mRemoved = true;
        if (this.mInputMethodTarget == win) {
            this.moveInputMethodWindowsIfNeededLocked(false);
        }
        this.mPolicy.removeWindowLw(win);
        win.removeLocked();
        this.mWindowMap.remove(win.mClient.asBinder());
        if (win.mAppOp != -1) {
            this.mAppOps.finishOp(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
        }
        WindowList windows = win.getWindowList();
        windows.remove(win);
        this.mPendingRemove.remove(win);
        this.mResizingWindows.remove(win);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.mInputMethodWindow = null;
        } else if (win.mAttrs.type == 2012) {
            this.mInputMethodDialogs.remove(win);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        token.windows.remove(win);
        if (atoken != null) {
            atoken.allAppWindows.remove(win);
        }
        if (token.windows.size() == 0) {
            if (!token.explicit) {
                this.mTokenMap.remove(token.token);
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
            }
        }
        if (atoken != null) {
            if (atoken.startingWindow == win) {
                this.removeStartingWindowTimeout(atoken);
                atoken.startingWindow = null;
            } else if (atoken.allAppWindows.size() == 0 && atoken.startingData != null) {
                atoken.startingData = null;
            } else if (atoken.allAppWindows.size() == 1 && atoken.startingView != null) {
                this.scheduleRemoveStartingWindow(atoken);
            }
        }
        if (win.mAttrs.type == 2013) {
            this.mLastWallpaperTimeoutTime = 0L;
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        }
        if (!this.mInLayout) {
            this.assignLayersLocked(windows);
            win.mDisplayContent.layoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppOpsState() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (win.mAppOp == -1) continue;
                    int mode = this.mAppOps.checkOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
                    win.setAppOpVisibilityLw(mode == 0);
                }
            }
        }
    }

    static void logSurface(WindowState w, String msg, RuntimeException where) {
        String str = "  SURFACE " + msg + ": " + w;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    static void logSurface(SurfaceControl s, String title, String msg, RuntimeException where) {
        String str = "  SURFACE " + s + ": " + msg + " / " + title;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null && w.mHasSurface) {
                    w.mWinAnimator.setTransparentRegionHintLocked(region);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null) {
                    w.mGivenInsetsPending = false;
                    w.mGivenContentInsets.set(contentInsets);
                    w.mGivenVisibleInsets.set(visibleInsets);
                    w.mGivenTouchableRegion.set(touchableRegion);
                    w.mTouchableInsets = touchableInsets;
                    if (w.mGlobalScale != 1.0f) {
                        w.mGivenContentInsets.scale(w.mGlobalScale);
                        w.mGivenVisibleInsets.scale(w.mGlobalScale);
                        w.mGivenTouchableRegion.scale(w.mGlobalScale);
                    }
                    w.mDisplayContent.layoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                outDisplayFrame.setEmpty();
                return;
            }
            outDisplayFrame.set(win.mDisplayFrame);
        }
    }

    public void setWindowWallpaperPositionLocked(WindowState window, float x, float y, float xStep, float yStep) {
        if (window.mWallpaperX != x || window.mWallpaperY != y) {
            window.mWallpaperX = x;
            window.mWallpaperY = y;
            window.mWallpaperXStep = xStep;
            window.mWallpaperYStep = yStep;
            this.updateWallpaperOffsetLocked(window, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperCommandComplete(IBinder window, Bundle result) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    public Bundle sendWindowWallpaperCommandLocked(WindowState window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        if (window == this.mWallpaperTarget || window == this.mLowerWallpaperTarget || window == this.mUpperWallpaperTarget) {
            boolean doWait = sync;
            int curTokenIndex = this.mWallpaperTokens.size();
            while (curTokenIndex > 0) {
                WindowToken token = this.mWallpaperTokens.get(--curTokenIndex);
                int curWallpaperIndex = token.windows.size();
                while (curWallpaperIndex > 0) {
                    WindowState wallpaper = (WindowState)token.windows.get(--curWallpaperIndex);
                    try {
                        wallpaper.mClient.dispatchWallpaperCommand(action, x, y, z, extras, sync);
                        sync = false;
                    }
                    catch (RemoteException e) {}
                }
            }
            if (doWait) {
                // empty if block
            }
        }
        return null;
    }

    public void setUniverseTransformLocked(WindowState window, float alpha, float offx, float offy, float dsdx, float dtdx, float dsdy, float dtdy) {
        Transformation transform = window.mWinAnimator.mUniverseTransform;
        transform.setAlpha(alpha);
        Matrix matrix = transform.getMatrix();
        matrix.getValues(this.mTmpFloats);
        this.mTmpFloats[2] = offx;
        this.mTmpFloats[5] = offy;
        this.mTmpFloats[0] = dsdx;
        this.mTmpFloats[3] = dtdx;
        this.mTmpFloats[1] = dsdy;
        this.mTmpFloats[4] = dtdy;
        matrix.setValues(this.mTmpFloats);
        DisplayInfo displayInfo = window.mDisplayContent.getDisplayInfo();
        RectF dispRect = new RectF(0.0f, 0.0f, displayInfo.logicalWidth, displayInfo.logicalHeight);
        matrix.mapRect(dispRect);
        window.mGivenTouchableRegion.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        window.mGivenTouchableRegion.op((int)dispRect.left, (int)dispRect.top, (int)dispRect.right, (int)dispRect.bottom, Region.Op.DIFFERENCE);
        window.mTouchableInsets = 3;
        window.mDisplayContent.layoutNeeded = true;
        this.performLayoutAndPlaceSurfacesLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle, boolean immediate) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window;
            if (this.mDisplayMagnifier != null && (window = this.mWindowMap.get(token)) != null && window.getDisplayId() == 0) {
                this.mDisplayMagnifier.onRectangleOnScreenRequestedLocked(rectangle, immediate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWindowId getWindowId(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.mWindowMap.get(token);
            return window != null ? window.mWindowId : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Configuration outConfig, Surface outSurface) {
        boolean animating;
        boolean inTouchMode;
        boolean configChanged;
        boolean toBeDisplayed = false;
        boolean surfaceChanged = false;
        int systemUiVisibility = 0;
        if (attrs != null && ((systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility) & 0x3FF0000) != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            systemUiVisibility &= 0xFC00FFFF;
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean scaledWindow;
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return 0;
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (win.mRequestedWidth != requestedWidth || win.mRequestedHeight != requestedHeight) {
                win.mLayoutNeeded = true;
                win.mRequestedWidth = requestedWidth;
                win.mRequestedHeight = requestedHeight;
            }
            if (attrs != null && seq == win.mSeq) {
                win.mSystemUiVisibility = systemUiVisibility;
            }
            if (attrs != null) {
                this.mPolicy.adjustWindowParamsLw(attrs);
            }
            winAnimator.mSurfaceDestroyDeferred = (flags & 2) != 0;
            int attrChanges = 0;
            int flagChanges = 0;
            if (attrs != null) {
                if (win.mAttrs.type != attrs.type) {
                    throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                }
                flagChanges = win.mAttrs.flags ^= attrs.flags;
                attrChanges = win.mAttrs.copyFrom(attrs);
                if ((attrChanges & 0x4001) != 0) {
                    win.mLayoutNeeded = true;
                }
            }
            boolean bl = win.mEnforceSizeCompat = (win.mAttrs.privateFlags & 0x80) != 0;
            if ((attrChanges & 0x80) != 0) {
                winAnimator.mAlpha = attrs.alpha;
            }
            boolean bl2 = scaledWindow = (win.mAttrs.flags & 0x4000) != 0;
            if (scaledWindow) {
                win.mHScale = attrs.width != requestedWidth ? (float)attrs.width / (float)requestedWidth : 1.0f;
                win.mVScale = attrs.height != requestedHeight ? (float)attrs.height / (float)requestedHeight : 1.0f;
            } else {
                win.mVScale = 1.0f;
                win.mHScale = 1.0f;
            }
            boolean imMayMove = (flagChanges & 0x20008) != 0;
            boolean isDefaultDisplay = win.isDefaultDisplay();
            boolean focusMayChange = isDefaultDisplay && (win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || !win.mRelayoutCalled);
            boolean wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
            wallpaperMayMove |= (flagChanges & 0x100000) != 0;
            win.mRelayoutCalled = true;
            int oldVisibility = win.mViewVisibility;
            win.mViewVisibility = viewVisibility;
            if (!(viewVisibility != 0 || win.mAppToken != null && win.mAppToken.clientHidden)) {
                boolean bl3 = toBeDisplayed = !win.isVisibleLw();
                if (win.mExiting) {
                    winAnimator.cancelExitAnimationForNextAnimationLocked();
                    win.mExiting = false;
                }
                if (win.mDestroying) {
                    win.mDestroying = false;
                    this.mDestroySurface.remove(win);
                }
                if (oldVisibility == 8) {
                    winAnimator.mEnterAnimationPending = true;
                }
                if (toBeDisplayed) {
                    if (win.isDrawnLw() && this.okToDisplay()) {
                        winAnimator.applyEnterAnimationLocked();
                    }
                    if ((win.mAttrs.flags & 0x200000) != 0) {
                        win.mTurnOnScreen = true;
                    }
                    if (win.isConfigChanged()) {
                        outConfig.setTo(this.mCurConfiguration);
                    }
                }
                if ((attrChanges & 8) != 0) {
                    winAnimator.destroySurfaceLocked();
                    toBeDisplayed = true;
                    surfaceChanged = true;
                }
                try {
                    SurfaceControl surfaceControl;
                    if (!win.mHasSurface) {
                        surfaceChanged = true;
                    }
                    if ((surfaceControl = winAnimator.createSurfaceLocked()) != null) {
                        outSurface.copyFrom(surfaceControl);
                    } else {
                        outSurface.release();
                    }
                }
                catch (Exception e) {
                    this.mInputMonitor.updateInputWindowsLw(true);
                    Slog.w(TAG, "Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")", e);
                    Binder.restoreCallingIdentity(origId);
                    return 0;
                }
                if (toBeDisplayed) {
                    focusMayChange = isDefaultDisplay;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.mInputMethodWindow = win;
                    imMayMove = true;
                }
                if (win.mAttrs.type == 1 && win.mAppToken != null && win.mAppToken.startingWindow != null) {
                    int mask = 4718593;
                    WindowManager.LayoutParams sa = win.mAppToken.startingWindow.mAttrs;
                    sa.flags = sa.flags & 0xFFB7FFFE | win.mAttrs.flags & 0x480001;
                }
            } else {
                winAnimator.mEnterAnimationPending = false;
                if (winAnimator.mSurfaceControl != null && !win.mExiting) {
                    surfaceChanged = true;
                    int transit = 2;
                    if (win.mAttrs.type == 3) {
                        transit = 5;
                    }
                    if (win.isWinVisibleLw() && winAnimator.applyAnimationLocked(transit, false)) {
                        focusMayChange = isDefaultDisplay;
                        win.mExiting = true;
                    } else if (win.mWinAnimator.isAnimating()) {
                        win.mExiting = true;
                    } else if (win == this.mWallpaperTarget) {
                        win.mExiting = true;
                        win.mWinAnimator.mAnimating = true;
                    } else {
                        if (this.mInputMethodWindow == win) {
                            this.mInputMethodWindow = null;
                        }
                        winAnimator.destroySurfaceLocked();
                    }
                    if (this.mDisplayMagnifier != null && win.getDisplayId() == 0) {
                        this.mDisplayMagnifier.onWindowTransitionLocked(win, transit);
                    }
                }
                outSurface.release();
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            if (imMayMove && (this.moveInputMethodWindowsIfNeededLocked(false) || toBeDisplayed)) {
                this.assignLayersLocked(win.getWindowList());
            }
            if (wallpaperMayMove) {
                this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
            }
            win.mDisplayContent.layoutNeeded = true;
            win.mGivenInsetsPending = (flags & 1) != 0;
            configChanged = this.updateOrientationFromAppTokensLocked(false);
            this.performLayoutAndPlaceSurfacesLocked();
            if (toBeDisplayed && win.mIsWallpaper) {
                DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
                this.updateWallpaperOffsetLocked(win, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            outFrame.set(win.mCompatFrame);
            outOverscanInsets.set(win.mOverscanInsets);
            outContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            inTouchMode = this.mInTouchMode;
            boolean bl4 = animating = this.mAnimator.mAnimating && win.mWinAnimator.isAnimating();
            if (animating && !this.mRelayoutWhileAnimating.contains(win)) {
                this.mRelayoutWhileAnimating.add(win);
            }
            this.mInputMonitor.updateInputWindowsLw(true);
        }
        if (configChanged) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return (inTouchMode ? 1 : 0) | (toBeDisplayed ? 2 : 0) | (surfaceChanged ? 4 : 0) | (animating ? 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDeferredDestroyWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block8: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null) break block8;
                    return;
                }
                win.mWinAnimator.destroyDeferredSurfaceLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        WindowState win;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                // MONITORENTER : hashMap
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block6;
                bl = false;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean bl = this.reclaimSomeSurfaceMemoryLocked(win.mWinAnimator, "from-client", false);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win = this.windowForClientLocked(session, client, false);
                if (win != null && win.mWinAnimator.finishDrawingLocked()) {
                    if ((win.mAttrs.flags & 0x100000) != 0) {
                        this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
                    }
                    win.mDisplayContent.layoutNeeded = true;
                    this.requestTraversalLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getWindowFrame(IBinder token, Rect outBounds) {
        if (!this.checkCallingPermission("android.permission.RETRIEVE_WINDOW_INFO", "getWindowInfo()")) {
            throw new SecurityException("Requires RETRIEVE_WINDOW_INFO permission.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState != null) {
                outBounds.set(windowState.mFrame);
            } else {
                outBounds.setEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMagnificationSpec(MagnificationSpec spec) {
        if (!this.checkCallingPermission("android.permission.MAGNIFY_DISPLAY", "setMagnificationSpec()")) {
            throw new SecurityException("Requires MAGNIFY_DISPLAY permission.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayMagnifier == null) {
                throw new IllegalStateException("Magnification callbacks not set!");
            }
            this.mDisplayMagnifier.setMagnificationSpecLocked(spec);
        }
        if (Binder.getCallingPid() != Process.myPid()) {
            spec.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder windowToken) {
        if (!this.checkCallingPermission("android.permission.MAGNIFY_DISPLAY", "getCompatibleMagnificationSpecForWindow()")) {
            throw new SecurityException("Requires MAGNIFY_DISPLAY permission.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(windowToken);
            if (windowState == null) {
                return null;
            }
            MagnificationSpec spec = null;
            if (this.mDisplayMagnifier != null) {
                spec = this.mDisplayMagnifier.getMagnificationSpecForWindowLocked(windowState);
            }
            if ((spec == null || spec.isNop()) && windowState.mGlobalScale == 1.0f) {
                return null;
            }
            spec = spec == null ? MagnificationSpec.obtain() : MagnificationSpec.obtain(spec);
            spec.scale *= windowState.mGlobalScale;
            return spec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMagnificationCallbacks(IMagnificationCallbacks callbacks) {
        if (!this.checkCallingPermission("android.permission.MAGNIFY_DISPLAY", "setMagnificationCallbacks()")) {
            throw new SecurityException("Requires MAGNIFY_DISPLAY permission.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayMagnifier == null) {
                this.mDisplayMagnifier = new DisplayMagnifier(this, callbacks);
            } else if (callbacks == null) {
                if (this.mDisplayMagnifier != null) {
                    this.mDisplayMagnifier.destroyLocked();
                    this.mDisplayMagnifier = null;
                }
            } else {
                throw new IllegalStateException("Magnification callbacks already set!");
            }
        }
    }

    private boolean applyAnimationLocked(AppWindowToken atoken, WindowManager.LayoutParams lp, int transit, boolean enter) {
        if (this.okToDisplay()) {
            DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
            int width = displayInfo.appWidth;
            int height = displayInfo.appHeight;
            Animation a = this.mAppTransition.loadAnimation(lp, transit, enter, width, height);
            if (a != null) {
                atoken.mAppAnimator.setAnimation(a, width, height);
            }
        } else {
            atoken.mAppAnimator.clearAnimation();
        }
        return atoken.mAppAnimator.animation != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAppTokens(int stackId, List<TaskGroup> tasks) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int taskNdx;
            int t = tasks.size() - 1;
            if (t < 0) {
                Slog.w(TAG, "validateAppTokens: empty task list");
                return;
            }
            TaskGroup task = tasks.get(0);
            int taskId = task.taskId;
            Task targetTask = this.mTaskIdToTask.get(taskId);
            DisplayContent displayContent = targetTask.getDisplayContent();
            if (displayContent == null) {
                Slog.w(TAG, "validateAppTokens: no Display for taskId=" + taskId);
                return;
            }
            ArrayList<Task> localTasks = this.mStackIdToStack.get(stackId).getTasks();
            for (taskNdx = localTasks.size() - 1; taskNdx >= 0 && t >= 0; --taskNdx, --t) {
                AppTokenList localTokens = localTasks.get((int)taskNdx).mAppTokens;
                task = tasks.get(t);
                ArrayList<IApplicationToken> tokens = task.tokens;
                DisplayContent lastDisplayContent = displayContent;
                displayContent = this.mTaskIdToTask.get(taskId).getDisplayContent();
                if (displayContent != lastDisplayContent) {
                    Slog.w(TAG, "validateAppTokens: displayContent changed in TaskGroup list!");
                    return;
                }
                int tokenNdx = localTokens.size() - 1;
                int v = task.tokens.size() - 1;
                while (tokenNdx >= 0 && v >= 0) {
                    AppWindowToken atoken = (AppWindowToken)localTokens.get(tokenNdx);
                    if (atoken.removed) {
                        --tokenNdx;
                        continue;
                    }
                    if (tokens.get(v) != atoken.token) break;
                    --tokenNdx;
                    --v;
                }
                if (tokenNdx >= 0 || v >= 0) break;
            }
            if (taskNdx >= 0 || t >= 0) {
                Slog.w(TAG, "validateAppTokens: Mismatch! ActivityManager=" + tasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! WindowManager=" + localTasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! Callers=" + Debug.getCallers(4));
            }
        }
    }

    public void validateStackOrder(Integer[] remoteStackIds) {
    }

    boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    boolean okToDisplay() {
        return !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOnFully();
    }

    AppWindowToken findAppWindowToken(IBinder token) {
        WindowToken wtoken = this.mTokenMap.get(token);
        if (wtoken == null) {
            return null;
        }
        return wtoken.appWindowToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWindowToken(IBinder token, int type) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken wtoken = this.mTokenMap.get(token);
            if (wtoken != null) {
                Slog.w(TAG, "Attempted to add existing input method token: " + token);
                return;
            }
            wtoken = new WindowToken(this, token, type, true);
            this.mTokenMap.put(token, wtoken);
            if (type == 2013) {
                this.mWallpaperTokens.add(wtoken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWindowToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = null;
            WindowToken wtoken = this.mTokenMap.remove(token);
            if (wtoken != null) {
                boolean delayed = false;
                if (!wtoken.hidden) {
                    int N = wtoken.windows.size();
                    boolean changed = false;
                    for (int i = 0; i < N; ++i) {
                        WindowState win = (WindowState)wtoken.windows.get(i);
                        displayContent = win.mDisplayContent;
                        if (win.mWinAnimator.isAnimating()) {
                            delayed = true;
                        }
                        if (!win.isVisibleNow()) continue;
                        win.mWinAnimator.applyAnimationLocked(2, false);
                        if (this.mDisplayMagnifier != null && win.isDefaultDisplay()) {
                            this.mDisplayMagnifier.onWindowTransitionLocked(win, 2);
                        }
                        changed = true;
                        displayContent.layoutNeeded = true;
                    }
                    wtoken.hidden = true;
                    if (changed) {
                        this.performLayoutAndPlaceSurfacesLocked();
                        this.updateFocusedWindowLocked(0, false);
                    }
                    if (delayed) {
                        displayContent.mExitingTokens.add(wtoken);
                    } else if (wtoken.windowType == 2013) {
                        this.mWallpaperTokens.remove(wtoken);
                    }
                }
                this.mInputMonitor.updateInputWindowsLw(true);
            } else {
                Slog.w(TAG, "Attempted to remove non-existing token: " + token);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    private Task createTask(int taskId, int stackId, int userId, AppWindowToken atoken) {
        TaskStack stack = this.mStackIdToStack.get(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("addAppToken: invalid stackId=" + stackId);
        }
        Task task = new Task(atoken, stack, userId);
        this.mTaskIdToTask.put(taskId, task);
        stack.addTask(task, true);
        stack.getDisplayContent().moveStack(stack, true);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppToken(int addPos, IApplicationToken token, int taskId, int stackId, int requestedOrientation, boolean fullscreen, boolean showWhenLocked, int userId) {
        long inputDispatchingTimeoutNanos;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        try {
            inputDispatchingTimeoutNanos = token.getKeyDispatchingTimeout() * 1000000L;
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "Could not get dispatching timeout.", ex);
            inputDispatchingTimeoutNanos = 5000000000L;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken != null) {
                Slog.w(TAG, "Attempted to add existing app token: " + token);
                return;
            }
            atoken = new AppWindowToken(this, token);
            atoken.inputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
            atoken.groupId = taskId;
            atoken.appFullscreen = fullscreen;
            atoken.showWhenLocked = showWhenLocked;
            atoken.requestedOrientation = requestedOrientation;
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                task = this.createTask(taskId, stackId, userId, atoken);
            } else {
                task.addAppToken(addPos, atoken);
            }
            this.mTokenMap.put(token.asBinder(), atoken);
            atoken.hidden = true;
            atoken.hiddenRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppGroupId(IBinder token, int groupId) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppGroupId()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token);
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set group id of non-existing app token: " + token);
                return;
            }
            Task oldTask = this.mTaskIdToTask.get(atoken.groupId);
            oldTask.removeAppToken(atoken);
            atoken.groupId = groupId;
            Task newTask = this.mTaskIdToTask.get(groupId);
            if (newTask == null) {
                newTask = this.createTask(groupId, oldTask.mStack.mStackId, oldTask.mUserId, atoken);
            }
            newTask.mAppTokens.add(atoken);
        }
    }

    public int getOrientationFromWindowsLocked() {
        if (this.mDisplayFrozen || this.mOpeningApps.size() > 0 || this.mClosingApps.size() > 0) {
            return this.mLastWindowForcedOrientation;
        }
        WindowList windows = this.getDefaultWindowListLocked();
        for (int pos = windows.size() - 1; pos >= 0; --pos) {
            WindowState win = (WindowState)windows.get(pos);
            if (win.mAppToken == null) continue;
            this.mLastWindowForcedOrientation = -1;
            return -1;
        }
        this.mLastWindowForcedOrientation = -1;
        return -1;
    }

    public int getOrientationFromAppTokensLocked() {
        int lastOrientation = -1;
        boolean findingBehind = false;
        boolean lastFullscreen = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        ArrayList<Task> tasks = displayContent.getTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            int firstToken;
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            for (int tokenNdx = firstToken = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                AppWindowToken atoken = (AppWindowToken)tokens.get(tokenNdx);
                if (!findingBehind && !atoken.hidden && atoken.hiddenRequested) continue;
                if (tokenNdx == firstToken && lastOrientation != 3 && lastFullscreen) {
                    return lastOrientation;
                }
                if (atoken.hiddenRequested || atoken.willBeHidden) continue;
                if (tokenNdx == 0) {
                    lastOrientation = atoken.requestedOrientation;
                }
                int or = atoken.requestedOrientation;
                lastFullscreen = atoken.appFullscreen;
                if (lastFullscreen && or != 3) {
                    return or;
                }
                if (or != -1 && or != 3) {
                    return or;
                }
                findingBehind |= or == 3;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        Configuration config = null;
        long ident = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded);
        }
        Binder.restoreCallingIdentity(ident);
        return config;
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(false)) {
            AppWindowToken atoken;
            if (freezeThisOneIfNeeded != null && (atoken = this.findAppWindowToken(freezeThisOneIfNeeded)) != null) {
                this.startAppFreezingScreenLocked(atoken, 128);
            }
            config = this.computeNewConfigurationLocked();
        } else if (currentConfig != null) {
            this.mTempConfiguration.setToDefaults();
            this.mTempConfiguration.fontScale = currentConfig.fontScale;
            if (this.computeScreenConfigurationLocked(this.mTempConfiguration) && currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                displayContent.layoutNeeded = true;
                int[] anim2 = new int[2];
                if (displayContent.isDimming()) {
                    anim2[1] = 0;
                    anim2[0] = 0;
                } else {
                    this.mPolicy.selectRotationAnimationLw(anim2);
                }
                this.startFreezingDisplayLocked(false, anim2[0], anim2[1]);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(boolean inTransaction) {
        long ident = Binder.clearCallingIdentity();
        try {
            int req = this.getOrientationFromWindowsLocked();
            if (req == -1) {
                req = this.getOrientationFromAppTokensLocked();
            }
            if (req != this.mForcedAppOrientation) {
                this.mForcedAppOrientation = req;
                this.mPolicy.setCurrentOrientationLw(req);
                if (this.updateRotationUncheckedLocked(inTransaction)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewConfiguration(Configuration config) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurConfiguration = new Configuration(config);
            if (this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.mLastFinishedFreezeSource = "new-config";
            }
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppOrientation(IApplicationToken token, int requestedOrientation) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppOrientation()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set orientation of non-existing app token: " + token);
                return;
            }
            atoken.requestedOrientation = requestedOrientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAppOrientation(IApplicationToken token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken == null) {
                return -1;
            }
            return wtoken.requestedOrientation;
        }
    }

    void setFocusedStackLayer() {
        this.mFocusedStackLayer = 0;
        if (this.mFocusedApp != null) {
            WindowList windows = this.mFocusedApp.allAppWindows;
            for (int i = windows.size() - 1; i >= 0; --i) {
                WindowState win = (WindowState)windows.get(i);
                int animLayer = win.mWinAnimator.mAnimLayer;
                if (win.mAttachedWindow != null || !win.isVisibleLw() || animLayer <= this.mFocusedStackLayer) continue;
                this.mFocusedStackLayer = animLayer + 1;
            }
        }
        this.mFocusedStackFrame.setLayer(this.mFocusedStackLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocusedStackFrame() {
        TaskStack stack;
        if (this.mFocusedApp != null) {
            Task task = this.mTaskIdToTask.get(this.mFocusedApp.groupId);
            stack = task.mStack;
            task.getDisplayContent().setTouchExcludeRegion(stack);
        } else {
            stack = null;
        }
        SurfaceControl.openTransaction();
        try {
            if (stack == null) {
                this.mFocusedStackFrame.setVisibility(false);
            } else {
                StackBox box = stack.mStackBox;
                Rect bounds = box.mBounds;
                boolean multipleStacks = box.mParent != null;
                this.mFocusedStackFrame.setBounds(bounds);
                this.mFocusedStackFrame.setVisibility(multipleStacks);
            }
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean changed = false;
            if (token == null) {
                changed = this.mFocusedApp != null;
                this.mFocusedApp = null;
                if (changed) {
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                AppWindowToken newFocus = this.findAppWindowToken(token);
                if (newFocus == null) {
                    Slog.w(TAG, "Attempted to set focus to non-existing app token: " + token);
                    return;
                }
                changed = this.mFocusedApp != newFocus;
                this.mFocusedApp = newFocus;
                if (changed) {
                    this.mInputMonitor.setFocusedAppLw(newFocus);
                }
            }
            if (moveFocusNow && changed) {
                long origId = Binder.clearCallingIdentity();
                this.updateFocusedWindowLocked(0, true);
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.okToDisplay()) {
                if (!this.mAppTransition.isTransitionSet() || this.mAppTransition.isTransitionNone()) {
                    this.mAppTransition.setAppTransition(transit);
                } else if (!alwaysKeepCurrent) {
                    if (transit == 4104 && this.mAppTransition.isTransitionEqual(8201)) {
                        this.mAppTransition.setAppTransition(transit);
                    } else if (transit == 4102 && this.mAppTransition.isTransitionEqual(8199)) {
                        this.mAppTransition.setAppTransition(transit);
                    }
                }
                this.mAppTransition.prepare();
                this.mStartingIconInTransition = false;
                this.mSkipAppTransitionAnimation = false;
                this.mH.removeMessages(13);
                this.mH.sendEmptyMessageDelayed(13, 5000L);
            }
        }
    }

    @Override
    public int getPendingAppTransition() {
        return this.mAppTransition.getAppTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransition(packageName, enterAnim, exitAnim, startedCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionScaleUp(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionThumb(srcThumb, startX, startY, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mAppTransition.isTransitionSet()) {
                this.mAppTransition.setReady();
                long origId = Binder.clearCallingIdentity();
                this.performLayoutAndPlaceSurfacesLocked();
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppStartingWindow(IBinder token, String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean createIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppStartingWindow()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken ttoken;
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set icon of non-existing app token: " + token);
                return;
            }
            if (!this.okToDisplay()) {
                return;
            }
            if (wtoken.startingData != null) {
                return;
            }
            if (transferFrom != null && (ttoken = this.findAppWindowToken(transferFrom)) != null) {
                WindowState startingWindow = ttoken.startingWindow;
                if (startingWindow != null) {
                    if (this.mStartingIconInTransition) {
                        this.mSkipAppTransitionAnimation = true;
                    }
                    long origId = Binder.clearCallingIdentity();
                    wtoken.startingData = ttoken.startingData;
                    wtoken.startingView = ttoken.startingView;
                    wtoken.startingDisplayed = ttoken.startingDisplayed;
                    ttoken.startingDisplayed = false;
                    wtoken.startingWindow = startingWindow;
                    wtoken.reportedVisible = ttoken.reportedVisible;
                    ttoken.startingData = null;
                    ttoken.startingView = null;
                    ttoken.startingWindow = null;
                    ttoken.startingMoved = true;
                    startingWindow.mToken = wtoken;
                    startingWindow.mRootToken = wtoken;
                    startingWindow.mAppToken = wtoken;
                    startingWindow.mWinAnimator.mAppAnimator = wtoken.mAppAnimator;
                    this.removeStartingWindowTimeout(ttoken);
                    startingWindow.getWindowList().remove(startingWindow);
                    this.mWindowsChanged = true;
                    ttoken.windows.remove(startingWindow);
                    ttoken.allAppWindows.remove(startingWindow);
                    this.addWindowToListInOrderLocked(startingWindow, true);
                    if (ttoken.allDrawn) {
                        wtoken.allDrawn = true;
                        wtoken.deferClearAllDrawn = ttoken.deferClearAllDrawn;
                    }
                    if (ttoken.firstWindowDrawn) {
                        wtoken.firstWindowDrawn = true;
                    }
                    if (!ttoken.hidden) {
                        wtoken.hidden = false;
                        wtoken.hiddenRequested = false;
                        wtoken.willBeHidden = false;
                    }
                    if (wtoken.clientHidden != ttoken.clientHidden) {
                        wtoken.clientHidden = ttoken.clientHidden;
                        wtoken.sendAppVisibilityToClients();
                    }
                    AppWindowAnimator tAppAnimator = ttoken.mAppAnimator;
                    AppWindowAnimator wAppAnimator = wtoken.mAppAnimator;
                    if (tAppAnimator.animation != null) {
                        wAppAnimator.animation = tAppAnimator.animation;
                        wAppAnimator.animating = tAppAnimator.animating;
                        wAppAnimator.animLayerAdjustment = tAppAnimator.animLayerAdjustment;
                        tAppAnimator.animation = null;
                        tAppAnimator.animLayerAdjustment = 0;
                        wAppAnimator.updateLayers();
                        tAppAnimator.updateLayers();
                    }
                    this.updateFocusedWindowLocked(3, true);
                    this.getDefaultDisplayContentLocked().layoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                    Binder.restoreCallingIdentity(origId);
                    return;
                }
                if (ttoken.startingData != null) {
                    wtoken.startingData = ttoken.startingData;
                    ttoken.startingData = null;
                    ttoken.startingMoved = true;
                    Message m = this.mH.obtainMessage(5, wtoken);
                    this.mH.sendMessageAtFrontOfQueue(m);
                    return;
                }
                AppWindowAnimator tAppAnimator = ttoken.mAppAnimator;
                AppWindowAnimator wAppAnimator = wtoken.mAppAnimator;
                if (tAppAnimator.thumbnail != null) {
                    if (wAppAnimator.thumbnail != null) {
                        wAppAnimator.thumbnail.destroy();
                    }
                    wAppAnimator.thumbnail = tAppAnimator.thumbnail;
                    wAppAnimator.thumbnailX = tAppAnimator.thumbnailX;
                    wAppAnimator.thumbnailY = tAppAnimator.thumbnailY;
                    wAppAnimator.thumbnailLayer = tAppAnimator.thumbnailLayer;
                    wAppAnimator.thumbnailAnimation = tAppAnimator.thumbnailAnimation;
                    tAppAnimator.thumbnail = null;
                }
            }
            if (!createIfNeeded) {
                return;
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mCurrentUserId);
                if (ent == null) {
                    return;
                }
                if (ent.array.getBoolean(5, false)) {
                    return;
                }
                if (ent.array.getBoolean(4, false)) {
                    return;
                }
                if (ent.array.getBoolean(14, false)) {
                    if (this.mWallpaperTarget == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return;
                    }
                }
            }
            this.mStartingIconInTransition = true;
            wtoken.startingData = new StartingData(pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags);
            Message m = this.mH.obtainMessage(5, wtoken);
            this.mH.sendMessageAtFrontOfQueue(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppWillBeHidden(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppWillBeHidden()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set will be hidden of non-existing app token: " + token);
                return;
            }
            wtoken.willBeHidden = true;
        }
    }

    public void setAppFullscreen(IBinder token, boolean toOpaque) {
        AppWindowToken atoken = this.findAppWindowToken(token);
        if (atoken != null) {
            atoken.appFullscreen = toOpaque;
            this.requestTraversal();
        }
    }

    boolean setTokenVisibilityLocked(AppWindowToken wtoken, WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout) {
        boolean delayed = false;
        if (wtoken.clientHidden == visible) {
            wtoken.clientHidden = !visible;
            wtoken.sendAppVisibilityToClients();
        }
        wtoken.willBeHidden = false;
        if (wtoken.hidden == visible) {
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                WindowState window;
                if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                    wtoken.mAppAnimator.animation = null;
                }
                if (this.applyAnimationLocked(wtoken, lp, transit, visible)) {
                    runningAppAnimation = true;
                    delayed = true;
                }
                if ((window = wtoken.findMainWindow()) != null && this.mDisplayMagnifier != null && window.getDisplayId() == 0) {
                    this.mDisplayMagnifier.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int N = wtoken.allAppWindows.size();
            for (int i = 0; i < N; ++i) {
                WindowState win = (WindowState)wtoken.allAppWindows.get(i);
                if (win == wtoken.startingWindow) continue;
                if (visible) {
                    if (win.isVisibleNow()) continue;
                    if (!runningAppAnimation) {
                        win.mWinAnimator.applyAnimationLocked(1, true);
                        if (this.mDisplayMagnifier != null && win.getDisplayId() == 0) {
                            this.mDisplayMagnifier.onWindowTransitionLocked(win, 1);
                        }
                    }
                    changed = true;
                    win.mDisplayContent.layoutNeeded = true;
                    continue;
                }
                if (!win.isVisibleNow()) continue;
                if (!runningAppAnimation) {
                    win.mWinAnimator.applyAnimationLocked(2, false);
                    if (this.mDisplayMagnifier != null && win.getDisplayId() == 0) {
                        this.mDisplayMagnifier.onWindowTransitionLocked(win, 2);
                    }
                }
                changed = true;
                win.mDisplayContent.layoutNeeded = true;
            }
            wtoken.hiddenRequested = !visible;
            wtoken.hidden = wtoken.hiddenRequested;
            if (!visible) {
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
            } else {
                WindowState swin = wtoken.startingWindow;
                if (swin != null && !swin.isDrawnLw()) {
                    swin.mPolicyVisibility = false;
                    swin.mPolicyVisibilityAfterAnim = false;
                }
            }
            if (changed) {
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.updateFocusedWindowLocked(3, false);
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (wtoken.mAppAnimator.animation != null) {
            delayed = true;
        }
        for (int i = wtoken.allAppWindows.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)wtoken.allAppWindows.get((int)i)).mWinAnimator.isWindowAnimating()) continue;
            delayed = true;
        }
        return delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppVisibility(IBinder token, boolean visible) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppVisibility()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set visibility of non-existing app token: " + token);
                return;
            }
            if (this.okToDisplay() && this.mAppTransition.isTransitionSet()) {
                if (wtoken.hiddenRequested != visible) {
                    return;
                }
                boolean bl = wtoken.hiddenRequested = !visible;
                if (!wtoken.startingDisplayed) {
                    wtoken.mAppAnimator.setDummyAnimation();
                }
                this.mOpeningApps.remove(wtoken);
                this.mClosingApps.remove(wtoken);
                wtoken.waitingToHide = false;
                wtoken.waitingToShow = false;
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mOpeningApps.add(wtoken);
                    wtoken.startingMoved = false;
                    if (wtoken.hidden) {
                        wtoken.allDrawn = false;
                        wtoken.deferClearAllDrawn = false;
                        wtoken.waitingToShow = true;
                        if (wtoken.clientHidden) {
                            wtoken.clientHidden = false;
                            wtoken.sendAppVisibilityToClients();
                        }
                    }
                } else {
                    this.mClosingApps.add(wtoken);
                    if (!wtoken.hidden) {
                        wtoken.waitingToHide = true;
                    }
                }
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.setTokenVisibilityLocked(wtoken, null, visible, -1, true);
            wtoken.updateReportedVisibilityLocked();
            Binder.restoreCallingIdentity(origId);
        }
    }

    void unsetAppFreezingScreenLocked(AppWindowToken wtoken, boolean unfreezeSurfaceNow, boolean force) {
        if (wtoken.mAppAnimator.freezingScreen) {
            int N = wtoken.allAppWindows.size();
            boolean unfrozeWindows = false;
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                if (!w.mAppFreezing) continue;
                w.mAppFreezing = false;
                if (w.mHasSurface && !w.mOrientationChanging) {
                    w.mOrientationChanging = true;
                    this.mInnerFields.mOrientationChangeComplete = false;
                }
                w.mLastFreezeDuration = 0;
                unfrozeWindows = true;
                w.mDisplayContent.layoutNeeded = true;
            }
            if (force || unfrozeWindows) {
                wtoken.mAppAnimator.freezingScreen = false;
                wtoken.mAppAnimator.lastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
                --this.mAppsFreezingScreen;
                this.mLastFinishedFreezeSource = wtoken;
            }
            if (unfreezeSurfaceNow) {
                if (unfrozeWindows) {
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.stopFreezingDisplayLocked();
            }
        }
    }

    public void startAppFreezingScreenLocked(AppWindowToken wtoken, int configChanges) {
        if (!wtoken.hiddenRequested) {
            if (!wtoken.mAppAnimator.freezingScreen) {
                wtoken.mAppAnimator.freezingScreen = true;
                wtoken.mAppAnimator.lastFreezeDuration = 0;
                ++this.mAppsFreezingScreen;
                if (this.mAppsFreezingScreen == 1) {
                    this.startFreezingDisplayLocked(false, 0, 0);
                    this.mH.removeMessages(17);
                    this.mH.sendEmptyMessageDelayed(17, 5000L);
                }
            }
            int N = wtoken.allAppWindows.size();
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                w.mAppFreezing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAppFreezingScreen(IBinder token, int configChanges) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (configChanges == 0 && this.okToDisplay()) {
                return;
            }
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                Slog.w(TAG, "Attempted to freeze screen with non-existing app token: " + wtoken);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.startAppFreezingScreenLocked(wtoken, configChanges);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppFreezingScreen(IBinder token, boolean force) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.unsetAppFreezingScreenLocked(wtoken, true, force);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        AppWindowToken wtoken = null;
        AppWindowToken startingToken = null;
        boolean delayed = false;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken basewtoken = this.mTokenMap.remove(token);
            if (basewtoken != null && (wtoken = basewtoken.appWindowToken) != null) {
                delayed = this.setTokenVisibilityLocked(wtoken, null, false, -1, true);
                wtoken.inPendingTransaction = false;
                this.mOpeningApps.remove(wtoken);
                wtoken.waitingToShow = false;
                if (this.mClosingApps.contains(wtoken)) {
                    delayed = true;
                } else if (this.mAppTransition.isTransitionSet()) {
                    this.mClosingApps.add(wtoken);
                    wtoken.waitingToHide = true;
                    delayed = true;
                }
                Task task = this.mTaskIdToTask.get(wtoken.groupId);
                DisplayContent displayContent = task.getDisplayContent();
                if (delayed) {
                    displayContent.mExitingAppTokens.add(wtoken);
                } else {
                    wtoken.mAppAnimator.clearAnimation();
                    wtoken.mAppAnimator.animating = false;
                }
                if (task.removeAppToken(wtoken)) {
                    this.mTaskIdToTask.delete(wtoken.groupId);
                }
                wtoken.removed = true;
                if (wtoken.startingData != null) {
                    startingToken = wtoken;
                }
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
                if (this.mFocusedApp == wtoken) {
                    this.mFocusedApp = null;
                    this.updateFocusedWindowLocked(0, true);
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                Slog.w(TAG, "Attempted to remove non-existing app token: " + token);
            }
            if (!delayed && wtoken != null) {
                wtoken.updateReportedVisibilityLocked();
            }
        }
        Binder.restoreCallingIdentity(origId);
        this.scheduleRemoveStartingWindow(startingToken);
    }

    void removeStartingWindowTimeout(AppWindowToken wtoken) {
        if (wtoken != null) {
            this.mH.removeMessages(33, wtoken);
        }
    }

    void scheduleRemoveStartingWindow(AppWindowToken wtoken) {
        if (wtoken != null && wtoken.startingWindow != null) {
            this.removeStartingWindowTimeout(wtoken);
            Message m = this.mH.obtainMessage(6, wtoken);
            this.mH.sendMessage(m);
        }
    }

    private boolean tmpRemoveAppWindowsLocked(WindowToken token) {
        int NW = token.windows.size();
        if (NW > 0) {
            this.mWindowsChanged = true;
        }
        for (int i = 0; i < NW; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            win.getWindowList().remove(win);
            int j = win.mChildWindows.size();
            while (j > 0) {
                WindowState cwin = (WindowState)win.mChildWindows.get(--j);
                cwin.getWindowList().remove(cwin);
            }
        }
        return NW > 0;
    }

    void dumpAppTokensLocked() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            Slog.v(TAG, "  Display " + displayContent.getDisplayId());
            ArrayList<Task> tasks = displayContent.getTasks();
            int i = displayContent.numTokens();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    Slog.v(TAG, "  #" + --i + ": " + wtoken.token);
                }
            }
        }
    }

    void dumpWindowsLocked() {
        int i = 0;
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
            for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                Slog.v(TAG, "  #" + i++ + ": " + windows.get(winNdx));
            }
        }
    }

    private int findAppWindowInsertionPointLocked(AppWindowToken target) {
        int taskId = target.groupId;
        Task targetTask = this.mTaskIdToTask.get(taskId);
        if (targetTask == null) {
            Slog.w(TAG, "findAppWindowInsertionPointLocked: no Task for " + target + " taskId=" + taskId);
            return 0;
        }
        DisplayContent displayContent = targetTask.getDisplayContent();
        if (displayContent == null) {
            Slog.w(TAG, "findAppWindowInsertionPointLocked: no DisplayContent for " + target);
            return 0;
        }
        WindowList windows = displayContent.getWindowList();
        int NW = windows.size();
        boolean found = false;
        ArrayList<Task> tasks = displayContent.getTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = tasks.get(taskNdx);
            if (!found && task.taskId != taskId) continue;
            AppTokenList tokens = task.mAppTokens;
            for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                if (!found && wtoken == target) {
                    found = true;
                }
                if (!found || wtoken.sendingToBottom) continue;
                for (int i = wtoken.windows.size() - 1; i >= 0; --i) {
                    WindowState win = (WindowState)wtoken.windows.get(i);
                    for (int j = win.mChildWindows.size() - 1; j >= 0; --j) {
                        WindowState cwin = (WindowState)win.mChildWindows.get(j);
                        if (cwin.mSubLayer < 0) continue;
                        for (int pos = NW - 1; pos >= 0; --pos) {
                            if (windows.get(pos) != cwin) continue;
                            return pos + 1;
                        }
                    }
                    for (int pos = NW - 1; pos >= 0; --pos) {
                        if (windows.get(pos) != win) continue;
                        return pos + 1;
                    }
                }
            }
        }
        for (int pos = NW - 1; pos >= 0; --pos) {
            if (!((WindowState)windows.get((int)pos)).mIsWallpaper) continue;
            return pos + 1;
        }
        return 0;
    }

    private final int reAddWindowLocked(int index, WindowState win) {
        WindowList windows = win.getWindowList();
        int NCW = win.mChildWindows.size();
        boolean added = false;
        for (int j = 0; j < NCW; ++j) {
            WindowState cwin = (WindowState)win.mChildWindows.get(j);
            if (!added && cwin.mSubLayer >= 0) {
                win.mRebuilding = false;
                windows.add(index, win);
                ++index;
                added = true;
            }
            cwin.mRebuilding = false;
            windows.add(index, cwin);
            ++index;
        }
        if (!added) {
            win.mRebuilding = false;
            windows.add(index, win);
            ++index;
        }
        this.mWindowsChanged = true;
        return index;
    }

    private final int reAddAppWindowsLocked(DisplayContent displayContent, int index, WindowToken token) {
        int NW = token.windows.size();
        for (int i = 0; i < NW; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            if (win.mDisplayContent != displayContent) continue;
            index = this.reAddWindowLocked(index, win);
        }
        return index;
    }

    void moveStackWindowsLocked(TaskStack stack) {
        AppTokenList tokens;
        int taskNdx;
        DisplayContent displayContent = stack.getDisplayContent();
        ArrayList<Task> tasks = stack.getTasks();
        int numTasks = tasks.size();
        for (taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = numTokens - 1; tokenNdx >= 0; --tokenNdx) {
                this.tmpRemoveAppWindowsLocked((WindowToken)tokens.get(tokenNdx));
            }
        }
        for (taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            int pos = this.findAppWindowInsertionPointLocked((AppWindowToken)tokens.get(0));
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                if (wtoken == null) continue;
                int newPos = this.reAddAppWindowsLocked(displayContent, pos, wtoken);
                if (newPos != pos) {
                    displayContent.layoutNeeded = true;
                }
                pos = newPos;
            }
        }
        if (!this.updateFocusedWindowLocked(3, false)) {
            this.assignLayersLocked(displayContent.getWindowList());
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.performLayoutAndPlaceSurfacesLocked();
        this.mInputMonitor.updateInputWindowsLw(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToTop(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                Task task;
                block9: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block9;
                    return;
                }
                TaskStack stack = task.mStack;
                DisplayContent displayContent = task.getDisplayContent();
                boolean isHomeStackTask = stack.isHomeStack();
                if (isHomeStackTask != displayContent.homeOnTop()) {
                    displayContent.moveHomeStackBox(isHomeStackTask);
                }
                stack.moveTaskToTop(task);
                displayContent.moveStack(stack, true);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToBottom(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                Task task;
                block8: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block8;
                    Slog.e(TAG, "moveTaskToBottom: taskId=" + taskId + " not found in mTaskIdToTask");
                    return;
                }
                TaskStack stack = task.mStack;
                stack.moveTaskToBottom(task);
                this.moveStackWindowsLocked(stack);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStack(int stackId, int relativeStackBoxId, int position, float weight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (position <= 5 && (weight < 0.2f || weight > 0.8f)) {
                throw new IllegalArgumentException("createStack: weight must be between 0.2 and 0.8, weight=" + weight);
            }
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                TaskStack stack = displayContent.createStack(stackId, relativeStackBoxId, position, weight);
                if (stack == null) continue;
                this.mStackIdToStack.put(stackId, stack);
                displayContent.moveStack(stack, true);
                this.performLayoutAndPlaceSurfacesLocked();
                return;
            }
            Slog.e(TAG, "createStack: Unable to find relativeStackBoxId=" + relativeStackBoxId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeStack(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null) {
                this.mStackIdToStack.delete(stackId);
                int nextStackId = stack.remove();
                stack.getDisplayContent().layoutNeeded = true;
                this.requestTraversalLocked();
                return nextStackId;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = task.mStack;
            stack.removeTask(task);
            stack.getDisplayContent().layoutNeeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(int taskId, int stackId, boolean toTop) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            stack.addTask(task, toTop);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeStackBox(int stackBoxId, float weight) {
        if (weight < 0.2f || weight > 0.8f) {
            throw new IllegalArgumentException("resizeStack: weight must be between 0.2 and 0.8, weight=" + weight);
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                if (!this.mDisplayContents.valueAt(displayNdx).resizeStack(stackBoxId, weight)) continue;
                this.performLayoutAndPlaceSurfacesLocked();
                return;
            }
        }
        throw new IllegalArgumentException("resizeStack: stackBoxId " + stackBoxId + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ActivityManager.StackBoxInfo> getStackBoxInfos() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getDefaultDisplayContentLocked().getStackBoxInfos();
        }
    }

    public Rect getStackBounds(int stackId) {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            Rect bounds = this.mDisplayContents.valueAt(displayNdx).getStackBounds(stackId);
            if (bounds == null) continue;
            return bounds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFreezingScreen(int exitAnim, int enterAnim) {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "startFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mClientFreezingScreen) {
                this.mClientFreezingScreen = true;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.startFreezingDisplayLocked(false, exitAnim, enterAnim);
                    this.mH.removeMessages(30);
                    this.mH.sendEmptyMessageDelayed(30, 5000L);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFreezingScreen() {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "stopFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mClientFreezingScreen) {
                this.mClientFreezingScreen = false;
                this.mLastFinishedFreezeSource = "client";
                long origId = Binder.clearCallingIdentity();
                try {
                    this.stopFreezingDisplayLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    @Override
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(1, new Pair<IBinder, String>(token, tag)));
    }

    @Override
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(2, token));
    }

    @Override
    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean inKeyguardRestrictedInputMode() {
        return this.mPolicy.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    @Override
    public boolean isKeyguardSecure() {
        return this.mPolicy.isKeyguardSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.dismissKeyguardLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (!w.mHasSurface) continue;
                    try {
                        w.mClient.closeSystemDialogs(reason);
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    @Override
    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        scale = WindowManagerService.fixScale(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScale = scale;
                break;
            }
            case 1: {
                this.mTransitionAnimationScale = scale;
                break;
            }
            case 2: {
                this.mAnimatorDurationScale = scale;
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    @Override
    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScale = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScale = WindowManagerService.fixScale(scales[1]);
            }
            if (scales.length >= 3) {
                this.setAnimatorDurationScale(WindowManagerService.fixScale(scales[2]));
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    private void setAnimatorDurationScale(float scale) {
        this.mAnimatorDurationScale = scale;
        ValueAnimator.setDurationScale(scale);
    }

    @Override
    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScale;
            }
            case 1: {
                return this.mTransitionAnimationScale;
            }
            case 2: {
                return this.mAnimatorDurationScale;
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScale, this.mTransitionAnimationScale, this.mAnimatorDurationScale};
    }

    @Override
    public void registerPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    @Override
    public void unregisterPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    @Override
    public int getLidState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 0);
        if (sw > 0) {
            return 0;
        }
        if (sw == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public void switchKeyboardLayout(int deviceId, int direction) {
        this.mInputManager.switchKeyboardLayout(deviceId, direction);
    }

    @Override
    public void shutdown(boolean confirm) {
        ShutdownThread.shutdown(this.mContext, confirm);
    }

    @Override
    public void rebootSafeMode(boolean confirm) {
        ShutdownThread.rebootSafeMode(this.mContext, confirm);
    }

    @Override
    public void setInputFilter(IInputFilter filter) {
        if (!this.checkCallingPermission("android.permission.FILTER_EVENTS", "setInputFilter()")) {
            throw new SecurityException("Requires FILTER_EVENTS permission");
        }
        this.mInputManager.setInputFilter(filter);
    }

    @Override
    public void setTouchExplorationEnabled(boolean enabled) {
        this.mPolicy.setTouchExplorationEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newUserId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int oldUserId = this.mCurrentUserId;
            this.mCurrentUserId = newUserId;
            this.mAppTransition.setCurrentUser(newUserId);
            this.mPolicy.setCurrentUserLw(newUserId);
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.switchUserStacks(oldUserId, newUserId);
                this.rebuildAppWindowListLocked(displayContent);
            }
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScreenAfterBoot() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mSystemBooted) {
                return;
            }
            this.mSystemBooted = true;
            this.hideBootMessagesLocked();
            this.mH.sendEmptyMessageDelayed(23, 30000L);
        }
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendEmptyMessage(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootTimeout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled || this.mHeadless) {
                return;
            }
            Slog.w(TAG, "***** BOOT TIMEOUT: forcing display enabled");
            this.mForceDisplayEnabled = true;
        }
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performEnableScreen() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            if (!this.mSystemBooted && !this.mShowingBootMessages) {
                return;
            }
            if (!this.mForceDisplayEnabled) {
                boolean haveBootMsg = false;
                boolean haveApp = false;
                boolean haveWallpaper = false;
                boolean wallpaperEnabled = this.mContext.getResources().getBoolean(0x1110030) && !this.mOnlyCore;
                boolean haveKeyguard = true;
                WindowList windows = this.getDefaultWindowListLocked();
                int N = windows.size();
                for (int i = 0; i < N; ++i) {
                    WindowState w = (WindowState)windows.get(i);
                    if (w.mAttrs.type == 2004) {
                        boolean vis = w.mViewVisibility == 0 && w.mPolicyVisibility;
                        boolean bl = haveKeyguard = !vis;
                    }
                    if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                        return;
                    }
                    if (!w.isDrawnLw()) continue;
                    if (w.mAttrs.type == 2021) {
                        haveBootMsg = true;
                        continue;
                    }
                    if (w.mAttrs.type == 2) {
                        haveApp = true;
                        continue;
                    }
                    if (w.mAttrs.type == 2013) {
                        haveWallpaper = true;
                        continue;
                    }
                    if (w.mAttrs.type != 2004) continue;
                    haveKeyguard = true;
                }
                if (!this.mSystemBooted && !haveBootMsg) {
                    return;
                }
                if (this.mSystemBooted && (!haveApp && !haveKeyguard || wallpaperEnabled && !haveWallpaper)) {
                    return;
                }
            }
            this.mDisplayEnabled = true;
            try {
                IBinder surfaceFlinger = ServiceManager.getService("SurfaceFlinger");
                if (surfaceFlinger != null) {
                    Parcel data = Parcel.obtain();
                    data.writeInterfaceToken("android.ui.ISurfaceComposer");
                    surfaceFlinger.transact(1, data, null, 0);
                    data.recycle();
                }
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Boot completed: SurfaceFlinger is dead!");
            }
            this.mInputMonitor.setEventDispatchingLw(this.mEventDispatchingEnabled);
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        boolean first = false;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAllowBootMessages) {
                return;
            }
            if (!this.mShowingBootMessages) {
                if (!always) {
                    return;
                }
                first = true;
            }
            if (this.mSystemBooted) {
                return;
            }
            this.mShowingBootMessages = true;
            this.mPolicy.showBootMessage(msg, always);
        }
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInTouchMode = mode;
        }
    }

    @Override
    public void showStrictModeViolation(boolean on) {
        if (this.mHeadless) {
            return;
        }
        int pid = Binder.getCallingPid();
        this.mH.sendMessage(this.mH.obtainMessage(25, on ? 1 : 0, pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStrictModeViolation(int arg, int pid) {
        boolean on = arg != 0;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (on) {
                boolean isVisible = false;
                int numDisplays = this.mDisplayContents.size();
                block6: for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (ws.mSession.mPid != pid || !ws.isVisibleLw()) continue;
                        isVisible = true;
                        continue block6;
                    }
                }
                if (!isVisible) {
                    return;
                }
            }
            SurfaceControl.openTransaction();
            try {
                if (this.mStrictModeFlash == null) {
                    this.mStrictModeFlash = new StrictModeFlash(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
                }
                this.mStrictModeFlash.setVisibility(on);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set("persist.sys.strictmode.visual", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap screenshotApplications(IBinder appToken, int displayId, int width, int height, boolean force565) {
        int dh;
        int dw;
        int minLayer;
        boolean screenshotReady;
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotApplications()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        Bitmap rawss = null;
        int maxLayer = 0;
        Rect frame = new Rect();
        float scale = 0.0f;
        int rot = 0;
        if (appToken == null) {
            screenshotReady = true;
            minLayer = 0;
        } else {
            screenshotReady = false;
            minLayer = Integer.MAX_VALUE;
        }
        int retryCount = 0;
        WindowState appWin = null;
        do {
            if (retryCount++ > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            HashMap<IBinder, WindowState> e = this.mWindowMap;
            synchronized (e) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent == null) {
                    return null;
                }
                DisplayInfo displayInfo = displayContent.getDisplayInfo();
                dw = displayInfo.logicalWidth;
                dh = displayInfo.logicalHeight;
                int aboveAppLayer = this.mPolicy.windowTypeToLayerLw(2) * 10000 + 1000;
                aboveAppLayer += 10000;
                boolean isImeTarget = this.mInputMethodTarget != null && this.mInputMethodTarget.mAppToken != null && this.mInputMethodTarget.mAppToken.appToken != null && this.mInputMethodTarget.mAppToken.appToken.asBinder() == appToken;
                boolean including = false;
                appWin = null;
                WindowList windows = displayContent.getWindowList();
                Rect stackBounds = new Rect();
                for (int i = windows.size() - 1; i >= 0; --i) {
                    WindowState ws = (WindowState)windows.get(i);
                    if (!ws.mHasSurface || ws.mLayer >= aboveAppLayer) continue;
                    if (!(including || appToken == null || ws.mIsImWindow && isImeTarget)) {
                        if (ws.mAppToken == null || ws.mAppToken.token != appToken) continue;
                        appWin = ws;
                        stackBounds.set(ws.getStackBounds());
                    }
                    boolean fullscreen = ws.isFullscreen(dw, dh);
                    including = !ws.mIsImWindow && !fullscreen;
                    WindowStateAnimator winAnim = ws.mWinAnimator;
                    if (maxLayer < winAnim.mSurfaceLayer) {
                        maxLayer = winAnim.mSurfaceLayer;
                    }
                    if (minLayer > winAnim.mSurfaceLayer) {
                        minLayer = winAnim.mSurfaceLayer;
                    }
                    if (!ws.mIsWallpaper) {
                        Rect wf = ws.mFrame;
                        Rect cr = ws.mContentInsets;
                        int left = wf.left + cr.left;
                        int top = wf.top + cr.top;
                        int right = wf.right - cr.right;
                        int bottom = wf.bottom - cr.bottom;
                        frame.union(left, top, right, bottom);
                        frame.intersect(stackBounds);
                    }
                    if (ws.mAppToken != null && ws.mAppToken.token == appToken && ws.isDisplayedLw()) {
                        screenshotReady = true;
                    }
                    if (fullscreen) break;
                }
                if (appToken != null && appWin == null) {
                    return null;
                }
                if (!screenshotReady) {
                    continue;
                }
                frame.intersect(0, 0, dw, dh);
                if (frame.isEmpty() || maxLayer == 0) {
                    return null;
                }
                rot = this.getDefaultDisplayContentLocked().getDisplay().getRotation();
                int fw = frame.width();
                int fh = frame.height();
                scale = Math.max((float)width / (float)fw, (float)height / (float)fh);
                dw = (int)((float)dw * scale);
                dh = (int)((float)dh * scale);
                if (rot == 1 || rot == 3) {
                    int tmp = dw;
                    dw = dh;
                    dh = tmp;
                    rot = rot == 1 ? 3 : 1;
                }
                rawss = SurfaceControl.screenshot(dw, dh, minLayer, maxLayer);
            }
        } while (!screenshotReady && retryCount <= 3);
        if (retryCount > 3) {
            Slog.i(TAG, "Screenshot max retries " + retryCount + " of " + appToken + " appWin=" + (appWin == null ? "null" : appWin + " drawState=" + appWin.mWinAnimator.mDrawState));
        }
        if (rawss == null) {
            Slog.w(TAG, "Screenshot failure taking screenshot for (" + dw + "x" + dh + ") to layer " + maxLayer);
            return null;
        }
        Bitmap bm = Bitmap.createBitmap(width, height, force565 ? Bitmap.Config.RGB_565 : rawss.getConfig());
        frame.scale(scale);
        Matrix matrix = new Matrix();
        ScreenRotationAnimation.createRotationMatrix(rot, dw, dh, matrix);
        matrix.postTranslate(-FloatMath.ceil(frame.left), -FloatMath.ceil(frame.top));
        Canvas canvas = new Canvas(bm);
        canvas.drawColor(-16777216);
        canvas.drawBitmap(rawss, matrix, null);
        canvas.setBitmap(null);
        int[] buffer = new int[bm.getWidth() * bm.getHeight()];
        bm.getPixels(buffer, 0, bm.getWidth(), 0, 0, bm.getWidth(), bm.getHeight());
        boolean allBlack = true;
        int firstColor = buffer[0];
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == firstColor) continue;
            allBlack = false;
            break;
        }
        if (allBlack) {
            Slog.i(TAG, "Screenshot " + appWin + " was monochrome(" + Integer.toHexString(firstColor) + ")! mSurfaceLayer=" + (appWin != null ? Integer.valueOf(appWin.mWinAnimator.mSurfaceLayer) : "null") + " minLayer=" + minLayer + " maxLayer=" + maxLayer);
        }
        rawss.recycle();
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(1, rotation == -1 ? this.mRotation : rotation);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(0, 777);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        this.updateRotationUnchecked(alwaysSendConfiguration, forceRelayout);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            boolean changed;
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0 && (changed = this.updateRotationUncheckedLocked(false))) {
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRotationUnchecked(boolean alwaysSendConfiguration, boolean forceRelayout) {
        boolean changed;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            changed = this.updateRotationUncheckedLocked(false);
            if (!changed || forceRelayout) {
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            }
        }
        if (changed || alwaysSendConfiguration) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRotationUncheckedLocked(boolean inTransaction) {
        int i;
        boolean altOrientation;
        if (this.mDeferredRotationPauseCount > 0) {
            return false;
        }
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
            return false;
        }
        if (!this.mDisplayEnabled) {
            return false;
        }
        int rotation = this.mPolicy.rotationForOrientationLw(this.mForcedAppOrientation, this.mRotation);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mForcedAppOrientation, rotation);
        if (this.mRotation == rotation && this.mAltOrientation == altOrientation) {
            return false;
        }
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        this.mPolicy.setRotationLw(this.mRotation);
        this.mWindowsFreezingScreen = true;
        this.mH.removeMessages(11);
        this.mH.sendEmptyMessageDelayed(11, 2000L);
        this.mWaitingForConfig = true;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        displayContent.layoutNeeded = true;
        int[] anim2 = new int[2];
        if (displayContent.isDimming()) {
            anim2[1] = 0;
            anim2[0] = 0;
        } else {
            this.mPolicy.selectRotationAnimationLw(anim2);
        }
        this.startFreezingDisplayLocked(inTransaction, anim2[0], anim2[1]);
        screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        this.computeScreenConfigurationLocked(null);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (!inTransaction) {
            SurfaceControl.openTransaction();
        }
        try {
            if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotationInTransaction(rotation, this.mFxSession, 10000L, this.mTransitionAnimationScale, displayInfo.logicalWidth, displayInfo.logicalHeight)) {
                this.scheduleAnimationLocked();
            }
            this.mDisplayManagerService.performTraversalInTransactionFromWindowManager();
        }
        finally {
            if (!inTransaction) {
                SurfaceControl.closeTransaction();
            }
        }
        WindowList windows = displayContent.getWindowList();
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mHasSurface) {
                w.mOrientationChanging = true;
                this.mInnerFields.mOrientationChangeComplete = false;
            }
            w.mLastFreezeDuration = 0;
        }
        for (i = this.mRotationWatchers.size() - 1; i >= 0; --i) {
            try {
                this.mRotationWatchers.get(i).onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (this.mDisplayMagnifier != null && displayContent.getDisplayId() == 0) {
            this.mDisplayMagnifier.onRotationChangedLocked(this.getDefaultDisplayContentLocked(), rotation);
        }
        return true;
    }

    @Override
    public int getRotation() {
        return this.mRotation;
    }

    @Override
    public boolean isRotationFrozen() {
        return this.mPolicy.getUserRotationMode() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int watchRotation(IRotationWatcher watcher) {
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void binderDied() {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                        if (watcherBinder != WindowManagerService.this.mRotationWatchers.get(i).asBinder()) continue;
                        IRotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                        if (removed != null) {
                            removed.asBinder().unlinkToDeath(this, 0);
                        }
                        --i;
                    }
                }
            }
        };
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            try {
                watcher.asBinder().linkToDeath(dr, 0);
                this.mRotationWatchers.add(watcher);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return this.mRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRotationWatcher(IRotationWatcher watcher) {
        IBinder watcherBinder = watcher.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = 0; i < this.mRotationWatchers.size(); ++i) {
                if (watcherBinder != this.mRotationWatchers.get(i).asBinder()) continue;
                this.mRotationWatchers.remove(i);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredOptionsPanelGravity() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int rotation = this.getRotation();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (displayContent.mInitialDisplayWidth < displayContent.mInitialDisplayHeight) {
                switch (rotation) {
                    default: {
                        return 81;
                    }
                    case 1: {
                        return 85;
                    }
                    case 2: {
                        return 81;
                    }
                    case 3: 
                }
                return 8388691;
            }
            switch (rotation) {
                default: {
                    return 85;
                }
                case 1: {
                    return 81;
                }
                case 2: {
                    return 8388691;
                }
                case 3: 
            }
            return 81;
        }
    }

    @Override
    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w(TAG, "View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w(TAG, "View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get(SYSTEM_SECURE, "1")) && "0".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
    }

    @Override
    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    @Override
    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowList windows = new WindowList();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                windows.addAll(displayContent.getWindowList());
            }
        }
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)windows.get(i);
                out.write(Integer.toHexString(System.identityHashCode(w)));
                out.write(32);
                out.append(w.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket(client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not send command " + command + " with parameters " + parameters, e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWindowsChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].windowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocusChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].focusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState findWindow(int hashCode) {
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (System.identityHashCode(w) != hashCode) continue;
                    return w;
                }
            }
        }
        return null;
    }

    void sendNewConfiguration() {
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration computeNewConfiguration() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Configuration config = this.computeNewConfigurationLocked();
            if (config == null && this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.mLastFinishedFreezeSource = "new-config";
                this.performLayoutAndPlaceSurfacesLocked();
            }
            return config;
        }
    }

    Configuration computeNewConfigurationLocked() {
        Configuration config = new Configuration();
        config.fontScale = 0.0f;
        if (!this.computeScreenConfigurationLocked(config)) {
            return null;
        }
        return config;
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int rotation, int dw, int dh) {
        int height;
        int width = this.mPolicy.getConfigDisplayWidth(dw, dh, rotation);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mPolicy.getConfigDisplayHeight(dw, dh, rotation)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh) {
        int h;
        int shortSize;
        int w = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, boolean rotated, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, 0, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 1, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, 2, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 3, unrotDh, unrotDw);
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, DisplayMetrics dm, int dw, int dh) {
        dm.noncompatWidthPixels = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        dm.noncompatHeightPixels = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int computeCompatSmallestWidth(boolean rotated, DisplayMetrics dm, int dw, int dh) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(dm);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 1, tmpDm, unrotDh, unrotDw);
        sw = this.reduceCompatConfigWidthSize(sw, 2, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 3, tmpDm, unrotDh, unrotDw);
        return sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean computeScreenConfigurationLocked(Configuration config) {
        if (!this.mDisplayReady) {
            return false;
        }
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? displayContent.mBaseDisplayHeight : displayContent.mBaseDisplayWidth;
        int realdh = rotated ? displayContent.mBaseDisplayWidth : displayContent.mBaseDisplayHeight;
        int dw = realdw;
        int dh = realdh;
        if (this.mAltOrientation) {
            if (realdw > realdh) {
                int maxw = (int)((float)realdh / 1.3f);
                if (maxw < realdw) {
                    dw = maxw;
                }
            } else {
                int maxh = (int)((float)realdw / 1.3f);
                if (maxh < realdh) {
                    dh = maxh;
                }
            }
        }
        if (config != null) {
            config.orientation = dw <= dh ? 1 : 2;
        }
        int appWidth = this.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation);
        int appHeight = this.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.rotation = this.mRotation;
            displayInfo.logicalWidth = dw;
            displayInfo.logicalHeight = dh;
            displayInfo.logicalDensityDpi = displayContent.mBaseDisplayDensity;
            displayInfo.appWidth = appWidth;
            displayInfo.appHeight = appHeight;
            displayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
            displayInfo.getAppMetrics(this.mDisplayMetrics);
            this.mDisplayManagerService.setDisplayInfoOverrideFromWindowManager(displayContent.getDisplayId(), displayInfo);
        }
        DisplayMetrics dm = this.mDisplayMetrics;
        this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(dm, this.mCompatDisplayMetrics);
        if (config != null) {
            boolean hardKeyboardAvailable;
            config.screenWidthDp = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, this.mRotation) / dm.density);
            config.screenHeightDp = (int)((float)this.mPolicy.getConfigDisplayHeight(dw, dh, this.mRotation) / dm.density);
            this.computeSizeRangesAndScreenLayout(displayInfo, rotated, dw, dh, dm.density, config);
            config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
            config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
            config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, dm, dw, dh);
            config.densityDpi = displayContent.mBaseDisplayDensity;
            config.touchscreen = 1;
            config.keyboard = 1;
            config.navigation = 1;
            int keyboardPresence = 0;
            int navigationPresence = 0;
            for (InputDevice device : this.mInputManager.getInputDevices()) {
                int presenceFlag;
                if (device.isVirtual()) continue;
                int sources = device.getSources();
                int n = presenceFlag = device.isExternal() ? 2 : 1;
                if (this.mIsTouchDevice) {
                    if ((sources & 0x1002) == 4098) {
                        config.touchscreen = 3;
                    }
                } else {
                    config.touchscreen = 1;
                }
                if ((sources & 0x10004) == 65540) {
                    config.navigation = 3;
                    navigationPresence |= presenceFlag;
                } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                    config.navigation = 2;
                    navigationPresence |= presenceFlag;
                }
                if (device.getKeyboardType() != 2) continue;
                config.keyboard = 2;
                keyboardPresence |= presenceFlag;
            }
            boolean bl = hardKeyboardAvailable = config.keyboard != 1;
            if (hardKeyboardAvailable != this.mHardKeyboardAvailable) {
                this.mHardKeyboardAvailable = hardKeyboardAvailable;
                this.mHardKeyboardEnabled = hardKeyboardAvailable;
                this.mH.removeMessages(22);
                this.mH.sendEmptyMessage(22);
            }
            if (!this.mHardKeyboardEnabled) {
                config.keyboard = 1;
            }
            config.keyboardHidden = 1;
            config.hardKeyboardHidden = 1;
            config.navigationHidden = 1;
            this.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardKeyboardAvailable() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mHardKeyboardAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardKeyboardEnabled() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mHardKeyboardEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardKeyboardEnabled(boolean enabled) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mHardKeyboardEnabled != enabled) {
                this.mHardKeyboardEnabled = enabled;
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnHardKeyboardStatusChangeListener(OnHardKeyboardStatusChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mHardKeyboardStatusChangeListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean enabled;
        boolean available;
        OnHardKeyboardStatusChangeListener listener;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            listener = this.mHardKeyboardStatusChangeListener;
            available = this.mHardKeyboardAvailable;
            enabled = this.mHardKeyboardEnabled;
        }
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder prepareDragSurface(IWindow window, SurfaceSession session, int flags, int width, int height, Surface outSurface) {
        int callerPid = Binder.getCallingPid();
        long origId = Binder.clearCallingIdentity();
        Binder token = null;
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                block10: {
                    try {
                        if (this.mDragState == null) {
                            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                            Display display = displayContent.getDisplay();
                            SurfaceControl surface = new SurfaceControl(session, "drag surface", width, height, -3, 4);
                            surface.setLayerStack(display.getLayerStack());
                            outSurface.copyFrom(surface);
                            IBinder winBinder = window.asBinder();
                            token = new Binder();
                            this.mDragState = new DragState(this, token, surface, 0, winBinder);
                            this.mDragState.mToken = new Binder();
                            token = this.mDragState.mToken;
                            this.mH.removeMessages(20, winBinder);
                            Message msg = this.mH.obtainMessage(20, winBinder);
                            this.mH.sendMessageDelayed(msg, 5000L);
                        } else {
                            Slog.w(TAG, "Drag already in progress");
                        }
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Slog.e(TAG, "Can't allocate drag surface w=" + width + " h=" + height, e);
                        if (this.mDragState == null) break block10;
                        this.mDragState.reset();
                        this.mDragState = null;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "pauseKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.pauseDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "resumeKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.resumeDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setEventDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mEventDispatchingEnabled = enabled;
            if (this.mDisplayEnabled) {
                this.mInputMonitor.setEventDispatchingLw(enabled);
            }
            this.sendScreenStatusToClientsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getFocusedWindowToken() {
        if (!this.checkCallingPermission("android.permission.RETRIEVE_WINDOW_INFO", "getFocusedWindowToken()")) {
            throw new SecurityException("Requires RETRIEVE_WINDOW_INFO permission.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.getFocusedWindowLocked();
            if (windowState != null) {
                return windowState.mClient.asBinder();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState getFocusedWindow() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getFocusedWindowLocked();
        }
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w(TAG, "Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        int menuState = this.mInputManager.getKeyCodeState(-1, -256, 82);
        int sState = this.mInputManager.getKeyCodeState(-1, -256, 47);
        int dpadState = this.mInputManager.getKeyCodeState(-1, 513, 23);
        int trackballState = this.mInputManager.getScanCodeState(-1, 65540, 272);
        int volumeDownState = this.mInputManager.getKeyCodeState(-1, -256, 25);
        this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
        try {
            if (SystemProperties.getInt("persist.sys.safemode", 0) != 0) {
                this.mSafeMode = true;
                SystemProperties.set("persist.sys.safemode", "");
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (this.mSafeMode) {
            Log.i(TAG, "SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")");
        } else {
            Log.i(TAG, "SAFE MODE not enabled");
        }
        this.mPolicy.setSafeMode(this.mSafeMode);
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        this.displayReady(0);
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            this.readForcedDisplaySizeAndDensityLocked(displayContent);
            this.mDisplayReady = true;
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> e = this.mWindowMap;
        synchronized (e) {
            this.mIsTouchDevice = this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
            this.configureDisplayPolicyLocked(this.getDefaultDisplayContentLocked());
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayReady(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.mAnimator.addDisplayLocked(displayId);
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    DisplayInfo displayInfo = displayContent.getDisplayInfo();
                    DisplayInfo newDisplayInfo = this.mDisplayManagerService.getDisplayInfo(displayId);
                    if (newDisplayInfo != null) {
                        displayInfo.copyFrom(newDisplayInfo);
                    }
                    displayContent.mInitialDisplayWidth = displayInfo.logicalWidth;
                    displayContent.mInitialDisplayHeight = displayInfo.logicalHeight;
                    displayContent.mInitialDisplayDensity = displayInfo.logicalDensityDpi;
                    displayContent.mBaseDisplayWidth = displayContent.mInitialDisplayWidth;
                    displayContent.mBaseDisplayHeight = displayContent.mInitialDisplayHeight;
                    displayContent.mBaseDisplayDensity = displayContent.mInitialDisplayDensity;
                    displayContent.mBaseDisplayRect.set(0, 0, displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight);
                }
            }
        }
    }

    public void systemReady() {
        this.mPolicy.systemReady();
    }

    private void sendScreenStatusToClientsLocked() {
        boolean on = this.mPowerManager.isScreenOn();
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
            int numWindows = windows.size();
            for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                try {
                    ((WindowState)windows.get((int)winNdx)).mClient.dispatchScreenState(on);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public IWindowSession openSession(IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState imFocus;
            int idx = this.findDesiredInputMethodWindowIndexLocked(false);
            if (idx > 0 && (imFocus = (WindowState)this.getDefaultWindowListLocked().get(idx - 1)) != null) {
                if (imFocus.mAttrs.type == 3 && imFocus.mAppToken != null) {
                    for (int i = 0; i < imFocus.mAppToken.windows.size(); ++i) {
                        WindowState w = (WindowState)imFocus.mAppToken.windows.get(i);
                        if (w == imFocus) continue;
                        Log.i(TAG, "Switching to real app window: " + w);
                        imFocus = w;
                        break;
                    }
                }
                if (imFocus.mSession.mClient != null && imFocus.mSession.mClient.asBinder() == client.asBinder()) {
                    return true;
                }
            }
            if (this.mCurrentFocus != null && this.mCurrentFocus.mSession.mClient != null && this.mCurrentFocus.mSession.mClient.asBinder() == client.asBinder()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInitialDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    size.x = displayContent.mInitialDisplayWidth;
                    size.y = displayContent.mInitialDisplayHeight;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBaseDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    size.x = displayContent.mBaseDisplayWidth;
                    size.y = displayContent.mBaseDisplayHeight;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplaySize(int displayId, int width, int height) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int MIN_WIDTH = 200;
            int MIN_HEIGHT = 200;
            int MAX_SCALE = 2;
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                width = Math.min(Math.max(width, 200), displayContent.mInitialDisplayWidth * 2);
                height = Math.min(Math.max(height, 200), displayContent.mInitialDisplayHeight * 2);
                this.setForcedDisplaySizeLocked(displayContent, width, height);
                Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", width + "," + height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readForcedDisplaySizeAndDensityLocked(DisplayContent displayContent) {
        String densityStr;
        int pos;
        String sizeStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_size_forced");
        if (sizeStr == null || sizeStr.length() == 0) {
            sizeStr = SystemProperties.get(SIZE_OVERRIDE, null);
        }
        if (sizeStr != null && sizeStr.length() > 0 && (pos = sizeStr.indexOf(44)) > 0 && sizeStr.lastIndexOf(44) == pos) {
            try {
                int width = Integer.parseInt(sizeStr.substring(0, pos));
                int height = Integer.parseInt(sizeStr.substring(pos + 1));
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    if (displayContent.mBaseDisplayWidth != width || displayContent.mBaseDisplayHeight != height) {
                        Slog.i(TAG, "FORCED DISPLAY SIZE: " + width + "x" + height);
                        displayContent.mBaseDisplayWidth = width;
                        displayContent.mBaseDisplayHeight = height;
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((densityStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_density_forced")) == null || densityStr.length() == 0) {
            densityStr = SystemProperties.get(DENSITY_OVERRIDE, null);
        }
        if (densityStr != null && densityStr.length() > 0) {
            try {
                int density = Integer.parseInt(densityStr);
                Object height = displayContent.mDisplaySizeLock;
                synchronized (height) {
                    if (displayContent.mBaseDisplayDensity != density) {
                        Slog.i(TAG, "FORCED DISPLAY DENSITY: " + density);
                        displayContent.mBaseDisplayDensity = density;
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplaySizeLocked(DisplayContent displayContent, int width, int height) {
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayContent.mBaseDisplayWidth = width;
            displayContent.mBaseDisplayHeight = height;
        }
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplaySize(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.setForcedDisplaySizeLocked(displayContent, displayContent.mInitialDisplayWidth, displayContent.mInitialDisplayHeight);
                Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInitialDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    return displayContent.mInitialDisplayDensity;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    return displayContent.mBaseDisplayDensity;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayDensity(int displayId, int density) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.setForcedDisplayDensityLocked(displayContent, density);
                Settings.Global.putString(this.mContext.getContentResolver(), "display_density_forced", Integer.toString(density));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplayDensityLocked(DisplayContent displayContent, int density) {
        Slog.i(TAG, "Using new display density: " + density);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayContent.mBaseDisplayDensity = density;
        }
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplayDensity(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.setForcedDisplayDensityLocked(displayContent, displayContent.mInitialDisplayDensity);
                Settings.Global.putString(this.mContext.getContentResolver(), "display_density_forced", "");
            }
        }
    }

    private void reconfigureDisplayLocked(DisplayContent displayContent) {
        this.configureDisplayPolicyLocked(displayContent);
        displayContent.layoutNeeded = true;
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mTempConfiguration.setToDefaults();
        this.mTempConfiguration.fontScale = this.mCurConfiguration.fontScale;
        if (this.computeScreenConfigurationLocked(this.mTempConfiguration) && this.mCurConfiguration.diff(this.mTempConfiguration) != 0) {
            configChanged = true;
        }
        if (configChanged) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(false, 0, 0);
            this.mH.sendEmptyMessage(18);
        }
        this.performLayoutAndPlaceSurfacesLocked();
    }

    private void configureDisplayPolicyLocked(DisplayContent displayContent) {
        this.mPolicy.setInitialDisplaySize(displayContent.getDisplay(), displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight, displayContent.mBaseDisplayDensity);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        this.mPolicy.setDisplayOverscan(displayContent.getDisplay(), displayInfo.overscanLeft, displayInfo.overscanTop, displayInfo.overscanRight, displayInfo.overscanBottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverscan(int displayId, int left, int top, int right, int bottom) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.setOverscanLocked(displayContent, left, top, right, bottom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOverscanLocked(DisplayContent displayContent, int left, int top, int right, int bottom) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.overscanLeft = left;
            displayInfo.overscanTop = top;
            displayInfo.overscanRight = right;
            displayInfo.overscanBottom = bottom;
        }
        this.mDisplaySettings.setOverscanLocked(displayInfo.name, left, top, right, bottom);
        this.mDisplaySettings.writeSettingsLocked();
        this.reconfigureDisplayLocked(displayContent);
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = this.mWindowMap.get(client);
        if (win == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " does not exist");
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        if (session != null && win.mSession != session) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " is in session " + win.mSession + ", not " + session);
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        return win;
    }

    final void rebuildAppWindowListLocked() {
        this.rebuildAppWindowListLocked(this.getDefaultDisplayContentLocked());
    }

    private void rebuildAppWindowListLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        int NW = windows.size();
        int lastBelow = -1;
        int numRemoved = 0;
        if (this.mRebuildTmp.length < NW) {
            this.mRebuildTmp = new WindowState[NW + 10];
        }
        int i = 0;
        while (i < NW) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mAppToken != null) {
                WindowState win = (WindowState)windows.remove(i);
                win.mRebuilding = true;
                this.mRebuildTmp[numRemoved] = win;
                this.mWindowsChanged = true;
                --NW;
                ++numRemoved;
                continue;
            }
            if (lastBelow == i - 1 && (w.mAttrs.type == 2013 || w.mAttrs.type == 2025)) {
                lastBelow = i;
            }
            ++i;
        }
        i = ++lastBelow;
        AppTokenList exitingAppTokens = displayContent.mExitingAppTokens;
        int NT = exitingAppTokens.size();
        for (int j = 0; j < NT; ++j) {
            i = this.reAddAppWindowsLocked(displayContent, i, (WindowToken)exitingAppTokens.get(j));
        }
        ArrayList<Task> tasks = displayContent.getTasks();
        int numTasks = tasks.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                i = this.reAddAppWindowsLocked(displayContent, i, wtoken);
            }
        }
        if ((i -= lastBelow) != numRemoved) {
            Slog.w(TAG, "Rebuild removed " + numRemoved + " windows but added " + i, new RuntimeException("here").fillInStackTrace());
            for (i = 0; i < numRemoved; ++i) {
                WindowState ws = this.mRebuildTmp[i];
                if (!ws.mRebuilding) continue;
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
                ws.dump(pw, "", true);
                ((PrintWriter)pw).flush();
                Slog.w(TAG, "This window was lost: " + ws);
                Slog.w(TAG, sw.toString());
                ws.mWinAnimator.destroySurfaceLocked();
            }
            Slog.w(TAG, "Current app token list:");
            this.dumpAppTokensLocked();
            Slog.w(TAG, "Final window list:");
            this.dumpWindowsLocked();
        }
    }

    private final void assignLayersLocked(WindowList windows) {
        int N = windows.size();
        int curBaseLayer = 0;
        int curLayer = 0;
        boolean anyLayerChanged = false;
        for (int i = 0; i < N; ++i) {
            WindowState w = (WindowState)windows.get(i);
            WindowStateAnimator winAnimator = w.mWinAnimator;
            boolean layerChanged = false;
            int oldLayer = w.mLayer;
            if (w.mBaseLayer == curBaseLayer || w.mIsImWindow || i > 0 && w.mIsWallpaper) {
                w.mLayer = curLayer += 5;
            } else {
                curBaseLayer = curLayer = w.mBaseLayer;
                w.mLayer = curLayer;
            }
            if (w.mLayer != oldLayer) {
                layerChanged = true;
                anyLayerChanged = true;
            }
            AppWindowToken wtoken = w.mAppToken;
            oldLayer = winAnimator.mAnimLayer;
            winAnimator.mAnimLayer = w.mTargetAppToken != null ? w.mLayer + w.mTargetAppToken.mAppAnimator.animLayerAdjustment : (wtoken != null ? w.mLayer + wtoken.mAppAnimator.animLayerAdjustment : w.mLayer);
            if (w.mIsImWindow) {
                winAnimator.mAnimLayer += this.mInputMethodAnimLayerAdjustment;
            } else if (w.mIsWallpaper) {
                winAnimator.mAnimLayer += this.mWallpaperAnimLayerAdjustment;
            }
            if (winAnimator.mAnimLayer != oldLayer) {
                layerChanged = true;
                anyLayerChanged = true;
            }
            if (!layerChanged || !w.getStack().isDimming(winAnimator)) continue;
            this.scheduleAnimationLocked();
        }
        if (this.mDisplayMagnifier != null && anyLayerChanged && ((WindowState)windows.get(windows.size() - 1)).getDisplayId() == 0) {
            this.mDisplayMagnifier.onWindowLayersChangedLocked();
        }
    }

    private final void performLayoutAndPlaceSurfacesLocked() {
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performLayoutAndPlaceSurfacesLockedLoop();
            this.mH.removeMessages(4);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mInnerFields.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performLayoutAndPlaceSurfacesLockedLoop() {
        boolean recoveringMemory;
        block18: {
            if (this.mInLayout) {
                Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
                return;
            }
            if (this.mWaitingForConfig) {
                return;
            }
            if (!this.mDisplayReady) {
                return;
            }
            Trace.traceBegin(32L, "wmLayout");
            this.mInLayout = true;
            recoveringMemory = false;
            try {
                Object tmp;
                if (this.mForceRemoves == null) break block18;
                recoveringMemory = true;
                for (int i = 0; i < this.mForceRemoves.size(); ++i) {
                    WindowState ws = this.mForceRemoves.get(i);
                    Slog.i(TAG, "Force removing: " + ws);
                    this.removeWindowInnerLocked(ws.mSession, ws);
                }
                this.mForceRemoves = null;
                Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
                Object object = tmp = new Object();
                synchronized (object) {
                    try {
                        tmp.wait(250L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException e) {
                Log.wtf(TAG, "Unhandled exception while force removing for memory", e);
            }
        }
        try {
            this.performLayoutAndPlaceSurfacesLockedInner(recoveringMemory);
            this.mInLayout = false;
            if (this.needsLayout()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversalLocked();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mWindowsChanged && !this.mWindowChangeListeners.isEmpty()) {
                this.mH.removeMessages(19);
                this.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Log.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    private final void performLayoutLockedInner(DisplayContent displayContent, boolean initial, boolean updateInputWindows) {
        int i;
        if (!displayContent.layoutNeeded) {
            return;
        }
        displayContent.layoutNeeded = false;
        WindowList windows = displayContent.getWindowList();
        boolean isDefaultDisplay = displayContent.isDefaultDisplay;
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        int NFW = this.mFakeWindows.size();
        for (int i2 = 0; i2 < NFW; ++i2) {
            this.mFakeWindows.get(i2).layout(dw, dh);
        }
        int N = windows.size();
        WindowStateAnimator universeBackground = null;
        this.mPolicy.beginLayoutLw(isDefaultDisplay, dw, dh, this.mRotation);
        if (isDefaultDisplay) {
            this.mSystemDecorLayer = this.mPolicy.getSystemDecorLayerLw();
            this.mScreenRect.set(0, 0, dw, dh);
        }
        this.mPolicy.getContentRectLw(this.mTmpContentRect);
        displayContent.setStackBoxSize(this.mTmpContentRect);
        int seq = this.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mLayoutSeq = seq;
        boolean behindDream = false;
        int topAttached = -1;
        for (i = N - 1; i >= 0; --i) {
            boolean gone;
            WindowState win = (WindowState)windows.get(i);
            boolean bl = gone = behindDream && this.mPolicy.canBeForceHidden(win, win.mAttrs) || win.isGoneForLayoutLw();
            if (!gone || !win.mHaveFrame || win.mLayoutNeeded || win.mAttrs.type == 2004 && win.isConfigChanged() || win.mAttrs.type == 2025) {
                if (!win.mLayoutAttached) {
                    if (initial) {
                        win.mContentChanged = false;
                    }
                    if (win.mAttrs.type == 2023) {
                        behindDream = true;
                    }
                    win.mLayoutNeeded = false;
                    win.prelayout();
                    this.mPolicy.layoutWindowLw(win, win.mAttrs, null);
                    win.mLayoutSeq = seq;
                } else if (topAttached < 0) {
                    topAttached = i;
                }
            }
            if (win.mViewVisibility != 0 || win.mAttrs.type != 2025 || universeBackground != null) continue;
            universeBackground = win.mWinAnimator;
        }
        if (this.mAnimator.mUniverseBackground != universeBackground) {
            this.mFocusMayChange = true;
            this.mAnimator.mUniverseBackground = universeBackground;
        }
        boolean attachedBehindDream = false;
        for (i = topAttached; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (win.mLayoutAttached) {
                if (attachedBehindDream && this.mPolicy.canBeForceHidden(win, win.mAttrs) || (win.mViewVisibility == 8 || !win.mRelayoutCalled) && win.mHaveFrame && !win.mLayoutNeeded) continue;
                if (initial) {
                    win.mContentChanged = false;
                }
                win.mLayoutNeeded = false;
                win.prelayout();
                this.mPolicy.layoutWindowLw(win, win.mAttrs, win.mAttachedWindow);
                win.mLayoutSeq = seq;
                continue;
            }
            if (win.mAttrs.type != 2023) continue;
            attachedBehindDream = behindDream;
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mPolicy.finishLayoutLw();
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (!this.okToDisplay()) {
            w.mOrientationChanging = true;
            w.mLastFreezeDuration = 0;
            this.mInnerFields.mOrientationChangeComplete = false;
            if (!this.mWindowsFreezingScreen) {
                this.mWindowsFreezingScreen = true;
                this.mH.removeMessages(11);
                this.mH.sendEmptyMessageDelayed(11, 2000L);
            }
        }
    }

    public int handleAppTransitionReadyLocked(WindowList windows) {
        int i;
        int changes = 0;
        int NN = this.mOpeningApps.size();
        boolean goodToGo = true;
        if (!this.mDisplayFrozen && !this.mAppTransition.isTimeout()) {
            for (i = 0; i < NN && goodToGo; ++i) {
                AppWindowToken wtoken = this.mOpeningApps.get(i);
                if (wtoken.allDrawn || wtoken.startingDisplayed || wtoken.startingMoved) continue;
                goodToGo = false;
            }
        }
        if (goodToGo) {
            AppWindowToken wtoken;
            AppWindowToken lowerWallpaperAppToken;
            AppWindowToken upperWallpaperAppToken;
            int transit = this.mAppTransition.getAppTransition();
            if (this.mSkipAppTransitionAnimation) {
                transit = -1;
            }
            this.mAppTransition.goodToGo();
            this.mStartingIconInTransition = false;
            this.mSkipAppTransitionAnimation = false;
            this.mH.removeMessages(13);
            this.rebuildAppWindowListLocked();
            WindowState oldWallpaper = this.mWallpaperTarget != null && this.mWallpaperTarget.mWinAnimator.isAnimating() && !this.mWallpaperTarget.mWinAnimator.isDummyAnimation() ? null : this.mWallpaperTarget;
            this.mInnerFields.mWallpaperMayChange = false;
            WindowManager.LayoutParams animLp = null;
            int bestAnimLayer = -1;
            boolean fullscreenAnim = false;
            boolean openingAppHasWallpaper = false;
            boolean closingAppHasWallpaper = false;
            if (this.mLowerWallpaperTarget == null) {
                upperWallpaperAppToken = null;
                lowerWallpaperAppToken = null;
            } else {
                lowerWallpaperAppToken = this.mLowerWallpaperTarget.mAppToken;
                upperWallpaperAppToken = this.mUpperWallpaperTarget.mAppToken;
            }
            int NC = this.mClosingApps.size();
            NN = NC + this.mOpeningApps.size();
            for (i = 0; i < NN; ++i) {
                WindowState ws;
                AppWindowToken wtoken2;
                if (i < NC) {
                    wtoken2 = this.mClosingApps.get(i);
                    if (wtoken2 == lowerWallpaperAppToken || wtoken2 == upperWallpaperAppToken) {
                        closingAppHasWallpaper = true;
                    }
                } else {
                    wtoken2 = this.mOpeningApps.get(i - NC);
                    if (wtoken2 == lowerWallpaperAppToken || wtoken2 == upperWallpaperAppToken) {
                        openingAppHasWallpaper = true;
                    }
                }
                if (wtoken2.appFullscreen) {
                    ws = wtoken2.findMainWindow();
                    if (ws == null) continue;
                    animLp = ws.mAttrs;
                    bestAnimLayer = ws.mLayer;
                    fullscreenAnim = true;
                    continue;
                }
                if (fullscreenAnim || (ws = wtoken2.findMainWindow()) == null || ws.mLayer <= bestAnimLayer) continue;
                animLp = ws.mAttrs;
                bestAnimLayer = ws.mLayer;
            }
            if (closingAppHasWallpaper && openingAppHasWallpaper) {
                switch (transit) {
                    case 4102: 
                    case 4104: 
                    case 4106: {
                        transit = 4110;
                        break;
                    }
                    case 8199: 
                    case 8201: 
                    case 8203: {
                        transit = 8207;
                    }
                }
            } else if (oldWallpaper != null && !this.mOpeningApps.contains(oldWallpaper.mAppToken)) {
                transit = 8204;
            } else if (this.mWallpaperTarget != null && this.mWallpaperTarget.isVisibleLw()) {
                transit = 4109;
            }
            if (!this.mPolicy.allowAppAnimationsLw()) {
                animLp = null;
            }
            AppWindowToken topOpeningApp = null;
            int topOpeningLayer = 0;
            NN = this.mOpeningApps.size();
            for (i = 0; i < NN; ++i) {
                wtoken = this.mOpeningApps.get(i);
                AppWindowAnimator appAnimator = wtoken.mAppAnimator;
                appAnimator.clearThumbnail();
                wtoken.inPendingTransaction = false;
                appAnimator.animation = null;
                this.setTokenVisibilityLocked(wtoken, animLp, true, transit, false);
                wtoken.updateReportedVisibilityLocked();
                wtoken.waitingToShow = false;
                appAnimator.mAllAppWinAnimators.clear();
                int N = wtoken.allAppWindows.size();
                for (int j = 0; j < N; ++j) {
                    appAnimator.mAllAppWinAnimators.add(((WindowState)wtoken.allAppWindows.get((int)j)).mWinAnimator);
                }
                this.mAnimator.mAnimating |= appAnimator.showAllWindowsLocked();
                if (animLp == null) continue;
                int layer = -1;
                for (int j = 0; j < wtoken.windows.size(); ++j) {
                    WindowState win = (WindowState)wtoken.windows.get(j);
                    if (win.mWinAnimator.mAnimLayer <= layer) continue;
                    layer = win.mWinAnimator.mAnimLayer;
                }
                if (topOpeningApp != null && layer <= topOpeningLayer) continue;
                topOpeningApp = wtoken;
                topOpeningLayer = layer;
            }
            NN = this.mClosingApps.size();
            for (i = 0; i < NN; ++i) {
                wtoken = this.mClosingApps.get(i);
                wtoken.mAppAnimator.clearThumbnail();
                wtoken.inPendingTransaction = false;
                wtoken.mAppAnimator.animation = null;
                this.setTokenVisibilityLocked(wtoken, animLp, false, transit, false);
                wtoken.updateReportedVisibilityLocked();
                wtoken.waitingToHide = false;
                wtoken.allDrawn = true;
                wtoken.deferClearAllDrawn = false;
            }
            AppWindowAnimator appAnimator = topOpeningApp == null ? null : topOpeningApp.mAppAnimator;
            Bitmap nextAppTransitionThumbnail = this.mAppTransition.getNextAppTransitionThumbnail();
            if (nextAppTransitionThumbnail != null && appAnimator != null && appAnimator.animation != null) {
                Rect dirty = new Rect(0, 0, nextAppTransitionThumbnail.getWidth(), nextAppTransitionThumbnail.getHeight());
                try {
                    Animation anim2;
                    DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                    Display display = displayContent.getDisplay();
                    SurfaceControl surfaceControl = new SurfaceControl(this.mFxSession, "thumbnail anim", dirty.width(), dirty.height(), -3, 4);
                    surfaceControl.setLayerStack(display.getLayerStack());
                    appAnimator.thumbnail = surfaceControl;
                    Surface drawSurface = new Surface();
                    drawSurface.copyFrom(surfaceControl);
                    Canvas c = drawSurface.lockCanvas(dirty);
                    c.drawBitmap(nextAppTransitionThumbnail, 0.0f, 0.0f, null);
                    drawSurface.unlockCanvasAndPost(c);
                    drawSurface.release();
                    appAnimator.thumbnailLayer = topOpeningLayer;
                    DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
                    appAnimator.thumbnailAnimation = anim2 = this.mAppTransition.createThumbnailAnimationLocked(transit, true, true, displayInfo.appWidth, displayInfo.appHeight);
                    anim2.restrictDuration(10000L);
                    anim2.scaleCurrentDuration(this.mTransitionAnimationScale);
                    Point p = new Point();
                    this.mAppTransition.getStartingPoint(p);
                    appAnimator.thumbnailX = p.x;
                    appAnimator.thumbnailY = p.y;
                }
                catch (Surface.OutOfResourcesException e) {
                    Slog.e(TAG, "Can't allocate thumbnail/Canvas surface w=" + dirty.width() + " h=" + dirty.height(), e);
                    appAnimator.clearThumbnail();
                }
            }
            this.mAppTransition.postAnimationCallback();
            this.mAppTransition.clear();
            this.mOpeningApps.clear();
            this.mClosingApps.clear();
            changes |= 3;
            this.getDefaultDisplayContentLocked().layoutNeeded = true;
            if (windows == this.getDefaultWindowListLocked() && !this.moveInputMethodWindowsIfNeededLocked(true)) {
                this.assignLayersLocked(windows);
            }
            this.updateFocusedWindowLocked(2, false);
            this.mFocusMayChange = false;
        }
        return changes;
    }

    private int handleAnimatingStoppedAndTransitionLocked() {
        int changes = 0;
        this.mAppTransition.setIdle();
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        ArrayList<Task> tasks = displayContent.getTasks();
        int numTasks = tasks.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                wtoken.sendingToBottom = false;
            }
        }
        this.rebuildAppWindowListLocked();
        this.moveInputMethodWindowsIfNeededLocked(true);
        this.mInnerFields.mWallpaperMayChange = true;
        this.mFocusMayChange = true;
        return changes |= 1;
    }

    private void updateResizingWindows(WindowState w) {
        WindowStateAnimator winAnimator = w.mWinAnimator;
        if (w.mHasSurface && w.mLayoutSeq == this.mLayoutSeq) {
            w.mOverscanInsetsChanged = w.mOverscanInsetsChanged | !w.mLastOverscanInsets.equals(w.mOverscanInsets);
            w.mContentInsetsChanged = w.mContentInsetsChanged | !w.mLastContentInsets.equals(w.mContentInsets);
            w.mVisibleInsetsChanged = w.mVisibleInsetsChanged | !w.mLastVisibleInsets.equals(w.mVisibleInsets);
            boolean configChanged = w.isConfigChanged();
            w.mLastFrame.set(w.mFrame);
            if (w.mContentInsetsChanged || w.mVisibleInsetsChanged || winAnimator.mSurfaceResized || configChanged) {
                w.mLastOverscanInsets.set(w.mOverscanInsets);
                w.mLastContentInsets.set(w.mContentInsets);
                w.mLastVisibleInsets.set(w.mVisibleInsets);
                this.makeWindowFreezingScreenIfNeededLocked(w);
                if (w.mOrientationChanging) {
                    winAnimator.mDrawState = 1;
                    if (w.mAppToken != null) {
                        w.mAppToken.allDrawn = false;
                        w.mAppToken.deferClearAllDrawn = false;
                    }
                }
                if (!this.mResizingWindows.contains(w)) {
                    this.mResizingWindows.add(w);
                }
            } else if (w.mOrientationChanging && w.isDrawnLw()) {
                w.mOrientationChanging = false;
                w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
            }
        }
    }

    private void handleNotObscuredLocked(WindowState w, long currentTime, int innerDw, int innerDh) {
        boolean opaqueDrawn;
        WindowManager.LayoutParams attrs = w.mAttrs;
        int attrFlags = attrs.flags;
        boolean canBeSeen = w.isDisplayedLw();
        if (w.mHasSurface) {
            if ((attrFlags & 0x80) != 0) {
                this.mInnerFields.mHoldScreen = w.mSession;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.screenBrightness >= 0.0f && this.mInnerFields.mScreenBrightness < 0.0f) {
                this.mInnerFields.mScreenBrightness = w.mAttrs.screenBrightness;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.buttonBrightness >= 0.0f && this.mInnerFields.mButtonBrightness < 0.0f) {
                this.mInnerFields.mButtonBrightness = w.mAttrs.buttonBrightness;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.userActivityTimeout >= 0L && this.mInnerFields.mUserActivityTimeout < 0L) {
                this.mInnerFields.mUserActivityTimeout = w.mAttrs.userActivityTimeout;
            }
            int type = attrs.type;
            if (canBeSeen && (type == 2008 || type == 2028 || type == 2004 || type == 2010)) {
                this.mInnerFields.mSyswin = true;
            }
            if (canBeSeen) {
                if (type == 2023 || type == 2004) {
                    this.mInnerFields.mDisplayHasContent = 1;
                } else if (this.mInnerFields.mDisplayHasContent == 0) {
                    this.mInnerFields.mDisplayHasContent = 2;
                }
            }
        }
        boolean bl = opaqueDrawn = canBeSeen && w.isOpaqueDrawn();
        if (opaqueDrawn && w.isFullscreen(innerDw, innerDh)) {
            this.mInnerFields.mObscured = true;
        }
    }

    private void handleFlagDimBehind(WindowState w, int innerDw, int innerDh) {
        WindowManager.LayoutParams attrs = w.mAttrs;
        if ((attrs.flags & 2) != 0 && w.isDisplayedLw() && !w.mExiting) {
            WindowStateAnimator winAnimator = w.mWinAnimator;
            TaskStack stack = w.getStack();
            stack.setDimmingTag();
            if (!stack.isDimming(winAnimator)) {
                stack.startDimmingIfNeeded(winAnimator);
            }
        }
    }

    private void updateAllDrawnLocked(DisplayContent displayContent) {
        ArrayList<Task> tasks = displayContent.getTasks();
        int numTasks = tasks.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            int numTokens = tokens.size();
            for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                int numInteresting;
                AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                if (wtoken.allDrawn || (numInteresting = wtoken.numInterestingWindows) <= 0 || wtoken.numDrawnWindows < numInteresting) continue;
                wtoken.allDrawn = true;
                this.mH.obtainMessage(32, wtoken.token).sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performLayoutAndPlaceSurfacesLockedInner(boolean recoveringMemory) {
        int N;
        int displayNdx;
        int i;
        long currentTime = SystemClock.uptimeMillis();
        if (this.mFocusMayChange) {
            this.mFocusMayChange = false;
            this.updateFocusedWindowLocked(3, false);
        }
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx2 = 0; displayNdx2 < numDisplays; ++displayNdx2) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx2);
            for (i = displayContent.mExitingTokens.size() - 1; i >= 0; --i) {
                displayContent.mExitingTokens.get((int)i).hasVisible = false;
            }
            for (i = displayContent.mExitingAppTokens.size() - 1; i >= 0; --i) {
                ((AppWindowToken)displayContent.mExitingAppTokens.get((int)i)).hasVisible = false;
            }
        }
        this.mInnerFields.mHoldScreen = null;
        this.mInnerFields.mScreenBrightness = -1.0f;
        this.mInnerFields.mButtonBrightness = -1.0f;
        this.mInnerFields.mUserActivityTimeout = -1L;
        this.mInnerFields.mDisplayHasContent = 0;
        ++this.mTransactionSequence;
        DisplayContent defaultDisplay = this.getDefaultDisplayContentLocked();
        DisplayInfo defaultInfo = defaultDisplay.getDisplayInfo();
        int defaultDw = defaultInfo.logicalWidth;
        int defaultDh = defaultInfo.logicalHeight;
        SurfaceControl.openTransaction();
        try {
            if (this.mWatermark != null) {
                this.mWatermark.positionSurface(defaultDw, defaultDh);
            }
            if (this.mStrictModeFlash != null) {
                this.mStrictModeFlash.positionSurface(defaultDw, defaultDh);
            }
            boolean focusDisplayed = false;
            for (int displayNdx3 = 0; displayNdx3 < numDisplays; ++displayNdx3) {
                boolean hasUniqueContent;
                boolean isDefaultDisplay;
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx3);
                boolean updateAllDrawn = false;
                WindowList windows = displayContent.getWindowList();
                DisplayInfo displayInfo = displayContent.getDisplayInfo();
                int displayId = displayContent.getDisplayId();
                int dw = displayInfo.logicalWidth;
                int dh = displayInfo.logicalHeight;
                int innerDw = displayInfo.appWidth;
                int innerDh = displayInfo.appHeight;
                boolean bl = isDefaultDisplay = displayId == 0;
                if (this.mInnerFields.mDisplayHasContent != 1) {
                    this.mInnerFields.mDisplayHasContent = 0;
                }
                int repeats = 0;
                do {
                    if (++repeats > 6) {
                        Slog.w(TAG, "Animation repeat aborted after too many iterations");
                        displayContent.layoutNeeded = false;
                        break;
                    }
                    this.debugLayoutRepeats("On entry to LockedInner", displayContent.pendingLayoutChanges);
                    if ((displayContent.pendingLayoutChanges & 4) != 0 && (this.adjustWallpaperWindowsLocked() & 2) != 0) {
                        this.assignLayersLocked(windows);
                        displayContent.layoutNeeded = true;
                    }
                    if (isDefaultDisplay && (displayContent.pendingLayoutChanges & 2) != 0 && this.updateOrientationFromAppTokensLocked(true)) {
                        displayContent.layoutNeeded = true;
                        this.mH.sendEmptyMessage(18);
                    }
                    if ((displayContent.pendingLayoutChanges & 1) != 0) {
                        displayContent.layoutNeeded = true;
                    }
                    if (repeats < 4) {
                        this.performLayoutLockedInner(displayContent, repeats == 1, false);
                    } else {
                        Slog.w(TAG, "Layout repeat skipped after too many iterations");
                    }
                    displayContent.pendingLayoutChanges = 0;
                    this.debugLayoutRepeats("loop number " + this.mLayoutRepeatCount, displayContent.pendingLayoutChanges);
                    if (!isDefaultDisplay) continue;
                    this.mPolicy.beginPostLayoutPolicyLw(dw, dh);
                    for (i = windows.size() - 1; i >= 0; --i) {
                        WindowState w = (WindowState)windows.get(i);
                        if (!w.mHasSurface) continue;
                        this.mPolicy.applyPostLayoutPolicyLw(w, w.mAttrs);
                    }
                    displayContent.pendingLayoutChanges |= this.mPolicy.finishPostLayoutPolicyLw();
                    this.debugLayoutRepeats("after finishPostLayoutPolicyLw", displayContent.pendingLayoutChanges);
                } while (displayContent.pendingLayoutChanges != 0);
                this.mInnerFields.mObscured = false;
                this.mInnerFields.mSyswin = false;
                displayContent.resetDimming();
                boolean someoneLosingFocus = !this.mLosingFocus.isEmpty();
                int N2 = windows.size();
                for (i = N2 - 1; i >= 0; --i) {
                    WindowState w = (WindowState)windows.get(i);
                    boolean obscuredChanged = w.mObscured != this.mInnerFields.mObscured;
                    w.mObscured = this.mInnerFields.mObscured;
                    if (!this.mInnerFields.mObscured) {
                        this.handleNotObscuredLocked(w, currentTime, innerDw, innerDh);
                    }
                    if (!w.getStack().testDimmingTag()) {
                        this.handleFlagDimBehind(w, innerDw, innerDh);
                    }
                    if (isDefaultDisplay && obscuredChanged && this.mWallpaperTarget == w && w.isVisibleLw()) {
                        this.updateWallpaperVisibilityLocked();
                    }
                    WindowStateAnimator winAnimator = w.mWinAnimator;
                    if (w.mHasSurface && w.shouldAnimateMove()) {
                        Animation a = AnimationUtils.loadAnimation(this.mContext, 17432685);
                        winAnimator.setAnimation(a);
                        winAnimator.mAnimDw = w.mLastFrame.left - w.mFrame.left;
                        winAnimator.mAnimDh = w.mLastFrame.top - w.mFrame.top;
                        try {
                            w.mClient.moved(w.mFrame.left, w.mFrame.top);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    w.mContentChanged = false;
                    if (w.mHasSurface) {
                        boolean committed = winAnimator.commitFinishDrawingLocked(currentTime);
                        if (isDefaultDisplay && committed) {
                            if (w.mAttrs.type == 2023) {
                                displayContent.pendingLayoutChanges |= 1;
                                this.debugLayoutRepeats("dream and commitFinishDrawingLocked true", displayContent.pendingLayoutChanges);
                            }
                            if ((w.mAttrs.flags & 0x100000) != 0) {
                                this.mInnerFields.mWallpaperMayChange = true;
                                displayContent.pendingLayoutChanges |= 4;
                                this.debugLayoutRepeats("wallpaper and commitFinishDrawingLocked true", displayContent.pendingLayoutChanges);
                            }
                        }
                        winAnimator.setSurfaceBoundariesLocked(recoveringMemory);
                        AppWindowToken atoken = w.mAppToken;
                        if (atoken != null && (!atoken.allDrawn || atoken.mAppAnimator.freezingScreen)) {
                            if (atoken.lastTransactionSequence != (long)this.mTransactionSequence) {
                                atoken.lastTransactionSequence = this.mTransactionSequence;
                                atoken.numDrawnWindows = 0;
                                atoken.numInterestingWindows = 0;
                                atoken.startingDisplayed = false;
                            }
                            if (!(!w.isOnScreen() && winAnimator.mAttrType != 1 || w.mExiting || w.mDestroying)) {
                                if (w != atoken.startingWindow) {
                                    if (!atoken.mAppAnimator.freezingScreen || !w.mAppFreezing) {
                                        ++atoken.numInterestingWindows;
                                        if (w.isDrawnLw()) {
                                            ++atoken.numDrawnWindows;
                                            updateAllDrawn = true;
                                        }
                                    }
                                } else if (w.isDrawnLw()) {
                                    atoken.startingDisplayed = true;
                                }
                            }
                        }
                    }
                    if (isDefaultDisplay && someoneLosingFocus && w == this.mCurrentFocus && w.isDisplayedLw()) {
                        focusDisplayed = true;
                    }
                    this.updateResizingWindows(w);
                }
                switch (this.mInnerFields.mDisplayHasContent) {
                    case 1: {
                        hasUniqueContent = isDefaultDisplay;
                        break;
                    }
                    case 2: {
                        hasUniqueContent = true;
                        break;
                    }
                    default: {
                        hasUniqueContent = false;
                    }
                }
                this.mDisplayManagerService.setDisplayHasContent(displayId, hasUniqueContent, true);
                this.getDisplayContentLocked(displayId).stopDimmingIfNeeded();
                if (!updateAllDrawn) continue;
                this.updateAllDrawnLocked(displayContent);
            }
            if (focusDisplayed) {
                this.mH.sendEmptyMessage(3);
            }
            this.mDisplayManagerService.performTraversalInTransactionFromWindowManager();
        }
        catch (RuntimeException e) {
            Log.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        WindowList defaultWindows = defaultDisplay.getWindowList();
        if (this.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= this.handleAppTransitionReadyLocked(defaultWindows);
            this.debugLayoutRepeats("after handleAppTransitionReadyLocked", defaultDisplay.pendingLayoutChanges);
        }
        if (!this.mAnimator.mAnimating && this.mAppTransition.isRunning()) {
            defaultDisplay.pendingLayoutChanges |= this.handleAnimatingStoppedAndTransitionLocked();
            this.debugLayoutRepeats("after handleAnimStopAndXitionLock", defaultDisplay.pendingLayoutChanges);
        }
        if (this.mInnerFields.mWallpaperForceHidingChanged && defaultDisplay.pendingLayoutChanges == 0 && !this.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= 1;
            this.debugLayoutRepeats("after animateAwayWallpaperLocked", defaultDisplay.pendingLayoutChanges);
        }
        this.mInnerFields.mWallpaperForceHidingChanged = false;
        if (this.mInnerFields.mWallpaperMayChange) {
            defaultDisplay.pendingLayoutChanges |= 4;
            this.debugLayoutRepeats("WallpaperMayChange", defaultDisplay.pendingLayoutChanges);
        }
        if (this.mFocusMayChange) {
            this.mFocusMayChange = false;
            if (this.updateFocusedWindowLocked(2, false)) {
                defaultDisplay.pendingLayoutChanges |= 8;
            }
        }
        if (this.needsLayout()) {
            defaultDisplay.pendingLayoutChanges |= 1;
            this.debugLayoutRepeats("mLayoutNeeded", defaultDisplay.pendingLayoutChanges);
        }
        for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mResizingWindows.get(i);
            if (win.mAppFreezing) continue;
            WindowStateAnimator winAnimator = win.mWinAnimator;
            try {
                Configuration newConfig;
                boolean diff = false;
                boolean configChanged = win.isConfigChanged();
                win.setConfiguration(this.mCurConfiguration);
                final IWindow client = win.mClient;
                final Rect frame = win.mFrame;
                final Rect overscanInsets = win.mLastOverscanInsets;
                final Rect contentInsets = win.mLastContentInsets;
                final Rect visibleInsets = win.mLastVisibleInsets;
                final boolean reportDraw = winAnimator.mDrawState == 1;
                Configuration configuration = newConfig = configChanged ? win.mConfiguration : null;
                if (win.mClient instanceof IWindow.Stub) {
                    this.mH.post(new Runnable(){

                        public void run() {
                            try {
                                client.resized(frame, overscanInsets, contentInsets, visibleInsets, reportDraw, newConfig);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    client.resized(frame, overscanInsets, contentInsets, visibleInsets, reportDraw, newConfig);
                }
                win.mOverscanInsetsChanged = false;
                win.mContentInsetsChanged = false;
                win.mVisibleInsetsChanged = false;
                winAnimator.mSurfaceResized = false;
            }
            catch (RemoteException e) {
                win.mOrientationChanging = false;
                win.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
            }
            this.mResizingWindows.remove(i);
        }
        if (this.mInnerFields.mOrientationChangeComplete) {
            if (this.mWindowsFreezingScreen) {
                this.mWindowsFreezingScreen = false;
                this.mLastFinishedFreezeSource = this.mInnerFields.mLastWindowFreezeSource;
                this.mH.removeMessages(11);
            }
            this.stopFreezingDisplayLocked();
        }
        boolean wallpaperDestroyed = false;
        i = this.mDestroySurface.size();
        if (i > 0) {
            do {
                WindowState win = this.mDestroySurface.get(--i);
                win.mDestroying = false;
                if (this.mInputMethodWindow == win) {
                    this.mInputMethodWindow = null;
                }
                if (win == this.mWallpaperTarget) {
                    wallpaperDestroyed = true;
                }
                win.mWinAnimator.destroySurfaceLocked();
            } while (i > 0);
            this.mDestroySurface.clear();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            ArrayList<WindowToken> exitingTokens = displayContent.mExitingTokens;
            for (i = exitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = exitingTokens.get(i);
                if (token.hasVisible) continue;
                exitingTokens.remove(i);
                if (token.windowType != 2013) continue;
                this.mWallpaperTokens.remove(token);
            }
            AppTokenList exitingAppTokens = displayContent.mExitingAppTokens;
            for (i = exitingAppTokens.size() - 1; i >= 0; --i) {
                AppWindowToken token = (AppWindowToken)exitingAppTokens.get(i);
                if (token.hasVisible || this.mClosingApps.contains(token)) continue;
                token.mAppAnimator.clearAnimation();
                token.mAppAnimator.animating = false;
                Task task = this.mTaskIdToTask.get(token.groupId);
                if (task != null && task.removeAppToken(token)) {
                    this.mTaskIdToTask.delete(token.groupId);
                }
                exitingAppTokens.remove(i);
            }
        }
        if (!this.mAnimator.mAnimating && this.mRelayoutWhileAnimating.size() > 0) {
            for (int j = this.mRelayoutWhileAnimating.size() - 1; j >= 0; --j) {
                try {
                    this.mRelayoutWhileAnimating.get((int)j).mClient.doneAnimating();
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mRelayoutWhileAnimating.clear();
        }
        if (wallpaperDestroyed) {
            defaultDisplay.pendingLayoutChanges |= 4;
            defaultDisplay.layoutNeeded = true;
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            if (displayContent.pendingLayoutChanges == 0) continue;
            displayContent.layoutNeeded = true;
        }
        this.mInputMonitor.updateInputWindowsLw(true);
        this.setHoldScreenLocked(this.mInnerFields.mHoldScreen);
        if (!this.mDisplayFrozen) {
            if (this.mInnerFields.mScreenBrightness < 0.0f || this.mInnerFields.mScreenBrightness > 1.0f) {
                this.mPowerManager.setScreenBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mPowerManager.setScreenBrightnessOverrideFromWindowManager(this.toBrightnessOverride(this.mInnerFields.mScreenBrightness));
            }
            if (this.mInnerFields.mButtonBrightness < 0.0f || this.mInnerFields.mButtonBrightness > 1.0f) {
                this.mPowerManager.setButtonBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mPowerManager.setButtonBrightnessOverrideFromWindowManager(this.toBrightnessOverride(this.mInnerFields.mButtonBrightness));
            }
            this.mPowerManager.setUserActivityTimeoutOverrideFromWindowManager(this.mInnerFields.mUserActivityTimeout);
        }
        if (this.mTurnOnScreen) {
            this.mPowerManager.wakeUp(SystemClock.uptimeMillis());
            this.mTurnOnScreen = false;
        }
        if (this.mInnerFields.mUpdateRotation) {
            if (this.updateRotationUncheckedLocked(false)) {
                this.mH.sendEmptyMessage(18);
            } else {
                this.mInnerFields.mUpdateRotation = false;
            }
        }
        if (this.mInnerFields.mOrientationChangeComplete && !defaultDisplay.layoutNeeded && !this.mInnerFields.mUpdateRotation) {
            this.checkDrawnWindowsLocked();
        }
        if ((N = this.mPendingRemove.size()) > 0) {
            if (this.mPendingRemoveTmp.length < N) {
                this.mPendingRemoveTmp = new WindowState[N + 10];
            }
            this.mPendingRemove.toArray(this.mPendingRemoveTmp);
            this.mPendingRemove.clear();
            DisplayContentList displayList = new DisplayContentList();
            for (i = 0; i < N; ++i) {
                WindowState w = this.mPendingRemoveTmp[i];
                this.removeWindowInnerLocked(w.mSession, w);
                if (displayList.contains(w.mDisplayContent)) continue;
                displayList.add(w.mDisplayContent);
            }
            for (DisplayContent displayContent : displayList) {
                this.assignLayersLocked(displayContent.getWindowList());
                displayContent.layoutNeeded = true;
            }
        }
        this.setFocusedStackFrame();
        this.enableScreenIfNeededLocked();
        this.scheduleAnimationLocked();
    }

    private int toBrightnessOverride(float value) {
        return (int)(value * 255.0f);
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.size() > 0) {
            for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
                Pair<WindowState, IRemoteCallback> pair = this.mWaitingForDrawn.get(j);
                WindowState win = (WindowState)pair.first;
                if (win.mRemoved) {
                    Slog.w(TAG, "Aborted waiting for drawn: " + pair.first);
                    try {
                        ((IRemoteCallback)pair.second).sendResult(null);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    this.mWaitingForDrawn.remove(pair);
                    this.mH.removeMessages(24, pair);
                    continue;
                }
                if (!win.mWinAnimator.mSurfaceShown) continue;
                try {
                    ((IRemoteCallback)pair.second).sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.mWaitingForDrawn.remove(pair);
                this.mH.removeMessages(24, pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForWindowDrawn(IBinder token, IRemoteCallback callback) {
        if (token != null && callback != null) {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win = this.windowForClientLocked(null, token, true);
                if (win != null) {
                    Pair<WindowState, IRemoteCallback> pair = new Pair<WindowState, IRemoteCallback>(win, callback);
                    Message m = this.mH.obtainMessage(24, pair);
                    this.mH.sendMessageDelayed(m, 2000L);
                    this.mWaitingForDrawn.add(pair);
                    this.checkDrawnWindowsLocked();
                    return true;
                }
                Slog.i(TAG, "waitForWindowDrawn: win null");
            }
        }
        return false;
    }

    void setHoldScreenLocked(Session newHoldScreen) {
        boolean hold;
        boolean bl = hold = newHoldScreen != null;
        if (hold && this.mHoldingScreenOn != newHoldScreen) {
            this.mHoldingScreenWakeLock.setWorkSource(new WorkSource(newHoldScreen.mUid));
        }
        this.mHoldingScreenOn = newHoldScreen;
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (hold != state) {
            if (hold) {
                this.mHoldingScreenWakeLock.acquire();
                this.mPolicy.keepScreenOnStartedLw();
            } else {
                this.mPolicy.keepScreenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTraversal() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.requestTraversalLocked();
        }
    }

    void requestTraversalLocked() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mH.sendEmptyMessage(4);
        }
    }

    void scheduleAnimationLocked() {
        if (!this.mAnimationScheduled) {
            this.mAnimationScheduled = true;
            this.mChoreographer.postCallback(1, this.mAnimator.mAnimationRunnable, null);
        }
    }

    private boolean needsLayout() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            if (!displayContent.layoutNeeded) continue;
            return true;
        }
        return false;
    }

    boolean copyAnimToLayoutParamsLocked() {
        boolean doRequest = false;
        int bulkUpdateParams = this.mAnimator.mBulkUpdateParams;
        if ((bulkUpdateParams & 1) != 0) {
            this.mInnerFields.mUpdateRotation = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 2) != 0) {
            this.mInnerFields.mWallpaperMayChange = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 4) != 0) {
            this.mInnerFields.mWallpaperForceHidingChanged = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 8) == 0) {
            this.mInnerFields.mOrientationChangeComplete = false;
        } else {
            this.mInnerFields.mOrientationChangeComplete = true;
            this.mInnerFields.mLastWindowFreezeSource = this.mAnimator.mLastWindowFreezeSource;
            if (this.mWindowsFreezingScreen) {
                doRequest = true;
            }
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            this.mTurnOnScreen = true;
        }
        if ((bulkUpdateParams & 0x20) != 0) {
            this.mInnerFields.mWallpaperActionPending = true;
        }
        return doRequest;
    }

    int adjustAnimationBackground(WindowStateAnimator winAnimator) {
        WindowList windows = winAnimator.mWin.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState testWin = (WindowState)windows.get(i);
            if (!testWin.mIsWallpaper || !testWin.isVisibleNow()) continue;
            return testWin.mWinAnimator.mAnimLayer;
        }
        return winAnimator.mAnimLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemoryLocked(WindowStateAnimator winAnimator, String operation, boolean secure) {
        SurfaceControl surface = winAnimator.mSurfaceControl;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent(31000, winAnimator.mWin.toString(), winAnimator.mSession.mPid, operation);
        if (this.mForceRemoves == null) {
            this.mForceRemoves = new ArrayList();
        }
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            Slog.i(TAG, "Out of memory for surface!  Looking for leaks...");
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState ws = (WindowState)windows.get(winNdx);
                    WindowStateAnimator wsa = ws.mWinAnimator;
                    if (wsa.mSurfaceControl == null) continue;
                    if (!this.mSessions.contains(wsa.mSession)) {
                        Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + ws + " surface=" + wsa.mSurfaceControl + " token=" + ws.mToken + " pid=" + ws.mSession.mPid + " uid=" + ws.mSession.mUid);
                        wsa.mSurfaceControl.destroy();
                        wsa.mSurfaceShown = false;
                        wsa.mSurfaceControl = null;
                        ws.mHasSurface = false;
                        this.mForceRemoves.add(ws);
                        leakedSurface = true;
                        continue;
                    }
                    if (ws.mAppToken == null || !ws.mAppToken.clientHidden) continue;
                    Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + ws + " surface=" + wsa.mSurfaceControl + " token=" + ws.mAppToken);
                    wsa.mSurfaceControl.destroy();
                    wsa.mSurfaceShown = false;
                    wsa.mSurfaceControl = null;
                    ws.mHasSurface = false;
                    leakedSurface = true;
                }
            }
            if (!leakedSurface) {
                Slog.w(TAG, "No leaked surfaces; killing applicatons!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (this.mForceRemoves.contains(ws)) continue;
                        WindowStateAnimator wsa = ws.mWinAnimator;
                        if (wsa.mSurfaceControl == null) continue;
                        pidCandidates.append(wsa.mSession.mPid, wsa.mSession.mPid);
                    }
                    if (pidCandidates.size() <= 0) continue;
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (!this.mActivityManager.killPids(pids, "Free memory", secure)) continue;
                        killedApps = true;
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w(TAG, "Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surface != null) {
                    surface.destroy();
                    winAnimator.mSurfaceShown = false;
                    winAnimator.mSurfaceControl = null;
                    winAnimator.mWin.mHasSurface = false;
                    this.scheduleRemoveStartingWindow(winAnimator.mWin.mAppToken);
                }
                try {
                    winAnimator.mWin.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    private boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.computeFocusedWindowLocked();
        if (this.mCurrentFocus != newFocus) {
            Trace.traceBegin(32L, "wmUpdateFocus");
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            boolean imWindowChanged = this.moveInputMethodWindowsIfNeededLocked(mode != 1 && mode != 3);
            if (imWindowChanged) {
                displayContent.layoutNeeded = true;
                newFocus = this.computeFocusedWindowLocked();
            }
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            int focusChanged = this.mPolicy.focusChangedLw(oldFocus, newFocus);
            if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
                if (mode == 2) {
                    this.performLayoutLockedInner(displayContent, true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    this.assignLayersLocked(displayContent.getWindowList());
                }
            }
            if ((focusChanged & 1) != 0) {
                displayContent.layoutNeeded = true;
                if (mode == 2) {
                    this.performLayoutLockedInner(displayContent, true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.finishUpdateFocusedWindowAfterAssignLayersLocked(updateInputWindows);
            }
            Trace.traceEnd(32L);
            return true;
        }
        return false;
    }

    private void finishUpdateFocusedWindowAfterAssignLayersLocked(boolean updateInputWindows) {
        this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
    }

    private WindowState computeFocusedWindowLocked() {
        if (this.mAnimator.mUniverseBackground != null && this.mAnimator.mUniverseBackground.mWin.canReceiveKeys()) {
            return this.mAnimator.mUniverseBackground.mWin;
        }
        int displayCount = this.mDisplayContents.size();
        for (int i = 0; i < displayCount; ++i) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(i);
            WindowState win = this.findFocusedWindowLocked(displayContent);
            if (win == null) continue;
            return win;
        }
        return null;
    }

    private WindowState findFocusedWindowLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            AppWindowToken wtoken = win.mAppToken;
            if (wtoken != null && (wtoken.removed || wtoken.sendingToBottom) || !win.canReceiveKeys()) continue;
            if (wtoken != null && win.mAttrs.type != 3 && this.mFocusedApp != null) {
                ArrayList<Task> tasks = displayContent.getTasks();
                for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                    AppWindowToken token;
                    int tokenNdx;
                    AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                    for (tokenNdx = tokens.size() - 1; tokenNdx >= 0 && wtoken != (token = (AppWindowToken)tokens.get(tokenNdx)); --tokenNdx) {
                        if (this.mFocusedApp != token) continue;
                        return null;
                    }
                    if (tokenNdx >= 0) break;
                }
            }
            return win;
        }
        return null;
    }

    private void startFreezingDisplayLocked(boolean inTransaction, int exitAnim, int enterAnim) {
        if (this.mDisplayFrozen) {
            return;
        }
        if (!this.mDisplayReady || !this.mPolicy.isScreenOnFully()) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mDisplayFreezeTime = SystemClock.elapsedRealtime();
        this.mLastFinishedFreezeSource = null;
        this.mInputMonitor.freezeInputDispatchingLw();
        this.mPolicy.setLastInputMethodWindowLw(null, null);
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.freeze();
        }
        this.mExitAnimId = exitAnim;
        this.mEnterAnimId = enterAnim;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.kill();
        }
        screenRotationAnimation = new ScreenRotationAnimation(this.mContext, displayContent, this.mFxSession, inTransaction, this.mPolicy.isDefaultOrientationForced());
        this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
    }

    private void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen || this.mClientFreezingScreen) {
            return;
        }
        this.mDisplayFrozen = false;
        this.mLastDisplayFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Screen frozen for ");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, sb);
        if (this.mLastFinishedFreezeSource != null) {
            sb.append(" due to ");
            sb.append(this.mLastFinishedFreezeSource);
        }
        Slog.i(TAG, sb.toString());
        this.mH.removeMessages(17);
        this.mH.removeMessages(30);
        boolean updateRotation = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            boolean isDimming = displayContent.isDimming();
            if (!this.mPolicy.validateRotationAnimationLw(this.mExitAnimId, this.mEnterAnimId, isDimming)) {
                this.mEnterAnimId = 0;
                this.mExitAnimId = 0;
            }
            if (screenRotationAnimation.dismiss(this.mFxSession, 10000L, this.mTransitionAnimationScale, displayInfo.logicalWidth, displayInfo.logicalHeight, this.mExitAnimId, this.mEnterAnimId)) {
                this.scheduleAnimationLocked();
            } else {
                screenRotationAnimation.kill();
                screenRotationAnimation = null;
                this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
                updateRotation = true;
            }
        } else {
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
                screenRotationAnimation = null;
                this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
            }
            updateRotation = true;
        }
        this.mInputMonitor.thawInputDispatchingLw();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mH.removeMessages(15);
        this.mH.sendEmptyMessageDelayed(15, 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= this.updateRotationUncheckedLocked(false);
        }
        if (configChanged) {
            this.mH.sendEmptyMessage(18);
        }
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension(defUnits, defDps, dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermarkInTransaction() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        FilterInputStream ind = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            ind = new DataInputStream(in);
            String line = ((DataInputStream)ind).readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                this.mWatermark = new Watermark(this.getDefaultDisplayContentLocked().getDisplay(), this.mRealDisplayMetrics, this.mFxSession, toks);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (ind != null) {
                try {
                    ind.close();
                }
                catch (IOException e) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mLastStatusBarVisibility = visibility;
            visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
            this.updateStatusBarVisibilityLocked(visibility);
        }
    }

    void updateStatusBarVisibilityLocked(int visibility) {
        this.mInputManager.setSystemUiVisibility(visibility);
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = (WindowState)windows.get(i);
            try {
                int curValue = ws.mSystemUiVisibility;
                int diff = curValue ^ visibility;
                diff &= 7;
                int newValue = curValue & ~(diff &= ~visibility) | visibility & diff;
                if (newValue != curValue) {
                    ++ws.mSeq;
                    ws.mSystemUiVisibility = newValue;
                }
                if (newValue == curValue && !ws.mAttrs.hasSystemUiListeners) continue;
                ws.mClient.dispatchSystemUiVisibilityChanged(ws.mSeq, visibility, newValue, diff);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reevaluateStatusBarVisibility() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
            this.updateStatusBarVisibilityLocked(visibility);
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowManagerPolicy.FakeWindow addFakeWindow(Looper looper, InputEventReceiver.Factory inputEventReceiverFactory, String name, int windowType, int layoutParamsFlags, int layoutParamsPrivateFlags, boolean canReceiveKeys, boolean hasFocus, boolean touchFullscreen) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            FakeWindowImpl fw = new FakeWindowImpl(this, looper, inputEventReceiverFactory, name, windowType, layoutParamsFlags, layoutParamsPrivateFlags, canReceiveKeys, hasFocus, touchFullscreen);
            int i = 0;
            while (i < this.mFakeWindows.size() && this.mFakeWindows.get((int)i).mWindowLayer > fw.mWindowLayer) {
            }
            this.mFakeWindows.add(i, fw);
            this.mInputMonitor.updateInputWindowsLw(true);
            return fw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFakeWindowLocked(WindowManagerPolicy.FakeWindow window) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mFakeWindows.remove(window)) {
                this.mInputMonitor.updateInputWindowsLw(true);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLastInputMethodWindowForTransition() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (this.mInputMethodWindow != null) {
                this.mPolicy.setLastInputMethodWindowLw(this.mInputMethodWindow, this.mInputMethodTarget);
            }
        }
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    @Override
    public void lockNow(Bundle options) {
        this.mPolicy.lockNow(options);
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.mSafeMode;
    }

    void dumpPolicyLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", pw, args);
    }

    void dumpAnimatorLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER ANIMATOR STATE (dumpsys window animator)");
        this.mAnimator.dumpLocked(pw, "    ", dumpAll);
    }

    void dumpTokensLocked(PrintWriter pw, boolean dumpAll) {
        WindowToken token2;
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        if (this.mTokenMap.size() > 0) {
            pw.println("  All tokens:");
            for (WindowToken token2 : this.mTokenMap.values()) {
                pw.print("  ");
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWallpaperTokens.size() > 0) {
            pw.println();
            pw.println("  Wallpaper tokens:");
            for (int i = this.mWallpaperTokens.size() - 1; i >= 0; --i) {
                token2 = this.mWallpaperTokens.get(i);
                pw.print("  Wallpaper #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mFinishedStarting.size() > 0) {
            pw.println();
            pw.println("  Finishing start of application tokens:");
            for (int i = this.mFinishedStarting.size() - 1; i >= 0; --i) {
                token2 = this.mFinishedStarting.get(i);
                pw.print("  Finished Starting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.mOpeningApps.size() > 0 || this.mClosingApps.size() > 0) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
        }
    }

    void dumpSessionsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        if (this.mSessions.size() > 0) {
            for (Session s : this.mSessions) {
                pw.print("  Session ");
                pw.print(s);
                pw.println(':');
                s.dump(pw, "    ");
            }
        }
    }

    void dumpDisplayContentsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER DISPLAY CONTENTS (dumpsys window displays)");
        if (this.mDisplayReady) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.dump("  ", pw);
            }
        } else {
            pw.println("  NO DISPLAY");
        }
    }

    void dumpWindowsLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        this.dumpWindowsNoHeaderLocked(pw, dumpAll, windows);
    }

    void dumpWindowsNoHeaderLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        int displayNdx;
        int numDisplays = this.mDisplayContents.size();
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
            for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                WindowState w2 = (WindowState)windowList.get(winNdx);
                if (windows != null && !windows.contains(w2)) continue;
                pw.print("  Window #");
                pw.print(winNdx);
                pw.print(' ');
                pw.print(w2);
                pw.println(":");
                w2.dump(pw, "    ", dumpAll || windows != null);
            }
        }
        if (this.mInputMethodDialogs.size() > 0) {
            pw.println();
            pw.println("  Input method dialogs:");
            for (i = this.mInputMethodDialogs.size() - 1; i >= 0; --i) {
                w = this.mInputMethodDialogs.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  IM Dialog #");
                pw.print(i);
                pw.print(": ");
                pw.println(w);
            }
        }
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                Pair<WindowState, IRemoteCallback> pair = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(pair.first);
                pw.print(": ");
                pw.println(pair.second);
            }
        }
        pw.println();
        pw.print("  mCurConfiguration=");
        pw.println(this.mCurConfiguration);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.print(this.mInTouchMode);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.print("  mLastDisplayFreezeDuration=");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, pw);
        if (this.mLastFinishedFreezeSource != null) {
            pw.print(" due to ");
            pw.print(this.mLastFinishedFreezeSource);
        }
        pw.println();
        if (dumpAll) {
            pw.print("  mSystemDecorLayer=");
            pw.print(this.mSystemDecorLayer);
            pw.print(" mScreenRect=");
            pw.println(this.mScreenRect.toShortString());
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            pw.print("  mWallpaperTarget=");
            pw.println(this.mWallpaperTarget);
            if (this.mLowerWallpaperTarget != null || this.mUpperWallpaperTarget != null) {
                pw.print("  mLowerWallpaperTarget=");
                pw.println(this.mLowerWallpaperTarget);
                pw.print("  mUpperWallpaperTarget=");
                pw.println(this.mUpperWallpaperTarget);
            }
            pw.print("  mLastWallpaperX=");
            pw.print(this.mLastWallpaperX);
            pw.print(" mLastWallpaperY=");
            pw.println(this.mLastWallpaperY);
            if (this.mInputMethodAnimLayerAdjustment != 0 || this.mWallpaperAnimLayerAdjustment != 0) {
                pw.print("  mInputMethodAnimLayerAdjustment=");
                pw.print(this.mInputMethodAnimLayerAdjustment);
                pw.print("  mWallpaperAnimLayerAdjustment=");
                pw.println(this.mWallpaperAnimLayerAdjustment);
            }
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            if (this.needsLayout()) {
                pw.print("  layoutNeeded on displays=");
                for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                    if (!displayContent.layoutNeeded) continue;
                    pw.print(displayContent.getDisplayId());
                }
                pw.println();
            }
            pw.print("  mTransactionSequence=");
            pw.println(this.mTransactionSequence);
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" windows=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" client=");
            pw.print(this.mClientFreezingScreen);
            pw.print(" apps=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" waitingForConfig=");
            pw.println(this.mWaitingForConfig);
            pw.print("  mRotation=");
            pw.print(this.mRotation);
            pw.print(" mAltOrientation=");
            pw.println(this.mAltOrientation);
            pw.print("  mLastWindowForcedOrientation=");
            pw.print(this.mLastWindowForcedOrientation);
            pw.print(" mForcedAppOrientation=");
            pw.println(this.mForcedAppOrientation);
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  mWindowAnimationScale=");
            pw.print(this.mWindowAnimationScale);
            pw.print(" mTransitionWindowAnimationScale=");
            pw.print(this.mTransitionAnimationScale);
            pw.print(" mAnimatorDurationScale=");
            pw.println(this.mAnimatorDurationScale);
            pw.print("  mTraversalScheduled=");
            pw.println(this.mTraversalScheduled);
            pw.print("  mStartingIconInTransition=");
            pw.print(this.mStartingIconInTransition);
            pw.print(" mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
            pw.println("  mLayoutToAnim:");
            this.mAppTransition.dump(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpWindows(PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        HashMap<IBinder, WindowState> hashMap;
        WindowList windows = new WindowList();
        if ("visible".equals(name)) {
            hashMap = this.mWindowMap;
            synchronized (hashMap) {
                int numDisplays = this.mDisplayContents.size();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                        WindowState w = (WindowState)windowList.get(winNdx);
                        if (!w.mWinAnimator.mSurfaceShown) continue;
                        windows.add(w);
                    }
                }
            }
        }
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState w = (WindowState)windowList.get(winNdx);
                    if (name != null) {
                        if (!((Object)w.mAttrs.getTitle()).toString().contains(name)) continue;
                        windows.add(w);
                        continue;
                    }
                    if (System.identityHashCode(w) != objectId) continue;
                    windows.add(w);
                }
            }
        }
        if (windows.size() <= 0) {
            return false;
        }
        hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.dumpWindowsLocked(pw, dumpAll, windows);
        }
        return true;
    }

    void dumpLastANRLocked(PrintWriter pw) {
        pw.println("WINDOW MANAGER LAST ANR (dumpsys window lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    public void saveANRStateLocked(AppWindowToken appWindowToken, WindowState windowState, String reason) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        pw.println("  ANR time: " + DateFormat.getInstance().format(new Date()));
        if (appWindowToken != null) {
            pw.println("  Application at fault: " + appWindowToken.stringName);
        }
        if (windowState != null) {
            pw.println("  Window at fault: " + windowState.mAttrs.getTitle());
        }
        if (reason != null) {
            pw.println("  Reason: " + reason);
        }
        ((PrintWriter)pw).println();
        this.dumpWindowsNoHeaderLocked(pw, true, null);
        ((PrintWriter)pw).close();
        this.mLastANRState = sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WindowManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        boolean dumpAll = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Window manager dump options:");
                pw.println("  [-a] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    l[astanr]: last ANR information");
                pw.println("    p[policy]: policy state");
                pw.println("    a[animator]: animator state");
                pw.println("    s[essions]: active sessions");
                pw.println("    d[isplays]: active display contents");
                pw.println("    t[okens]: token list");
                pw.println("    w[indows]: window list");
                pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                pw.println("    be a partial substring in a window name, a");
                pw.println("    Window hex object identifier, or");
                pw.println("    \"all\" for all windows, or");
                pw.println("    \"visible\" for the visible windows.");
                pw.println("  -a: include all available server state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("lastanr".equals(cmd) || "l".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpLastANRLocked(pw);
                }
                return;
            }
            if ("policy".equals(cmd) || "p".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpPolicyLocked(pw, args, true);
                }
                return;
            }
            if ("animator".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpAnimatorLocked(pw, args, true);
                }
                return;
            }
            if ("sessions".equals(cmd) || "s".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpSessionsLocked(pw, true);
                }
                return;
            }
            if ("displays".equals(cmd) || "d".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpDisplayContentsLocked(pw, true);
                }
                return;
            }
            if ("tokens".equals(cmd) || "t".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpTokensLocked(pw, true);
                }
                return;
            }
            if ("windows".equals(cmd) || "w".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if ("all".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if (!this.dumpWindows(pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPolicyLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpAnimatorLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpSessionsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpDisplayContentsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpTokensLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpWindowsLocked(pw, dumpAll, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
        }
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayContent newDisplayContentLocked(Display display) {
        DisplayContent displayContent = new DisplayContent(display, this);
        int displayId = display.getDisplayId();
        this.mDisplayContents.put(displayId, displayContent);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Rect rect = new Rect();
        this.mDisplaySettings.getOverscanLocked(displayInfo.name, rect);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.overscanLeft = rect.left;
            displayInfo.overscanTop = rect.top;
            displayInfo.overscanRight = rect.right;
            displayInfo.overscanBottom = rect.bottom;
            this.mDisplayManagerService.setDisplayInfoOverrideFromWindowManager(displayId, displayInfo);
        }
        this.configureDisplayPolicyLocked(displayContent);
        if (displayId == 0) {
            displayContent.mTapDetector = new StackTapPointerEventListener(this, displayContent);
            this.registerPointerEventListener(displayContent.mTapDetector);
        }
        return displayContent;
    }

    public void createDisplayContentLocked(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("getDisplayContent: display must not be null");
        }
        this.getDisplayContentLocked(display.getDisplayId());
    }

    public DisplayContent getDisplayContentLocked(int displayId) {
        Display display;
        DisplayContent displayContent = this.mDisplayContents.get(displayId);
        if (displayContent == null && (display = this.mDisplayManager.getDisplay(displayId)) != null) {
            displayContent = this.newDisplayContentLocked(display);
        }
        return displayContent;
    }

    public DisplayContent getDefaultDisplayContentLocked() {
        return this.getDisplayContentLocked(0);
    }

    public WindowList getDefaultWindowListLocked() {
        return this.getDefaultDisplayContentLocked().getWindowList();
    }

    public DisplayInfo getDefaultDisplayInfoLocked() {
        return this.getDefaultDisplayContentLocked().getDisplayInfo();
    }

    public WindowList getWindowListLocked(Display display) {
        return this.getWindowListLocked(display.getDisplayId());
    }

    public WindowList getWindowListLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        return displayContent != null ? displayContent.getWindowList() : null;
    }

    @Override
    public void onDisplayAdded(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(27, displayId, 0));
    }

    private void handleDisplayAddedLocked(int displayId) {
        Display display = this.mDisplayManager.getDisplay(displayId);
        if (display != null) {
            this.createDisplayContentLocked(display);
            this.displayReady(displayId);
        }
    }

    @Override
    public void onDisplayRemoved(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(28, displayId, 0));
    }

    private void handleDisplayRemovedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            this.mDisplayContents.delete(displayId);
            displayContent.close();
            if (displayId == 0) {
                this.unregisterPointerEventListener(displayContent.mTapDetector);
            }
            WindowList windows = displayContent.getWindowList();
            while (!windows.isEmpty()) {
                WindowState win = (WindowState)windows.get(windows.size() - 1);
                this.removeWindowLocked(win.mSession, win);
            }
        }
        this.mAnimator.removeDisplayLocked(displayId);
    }

    @Override
    public void onDisplayChanged(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(29, displayId, 0));
    }

    private void handleDisplayChangedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            displayContent.updateDisplayInfo();
        }
    }

    @Override
    public Object getWindowManagerLock() {
        return this.mWindowMap;
    }

    public static interface OnHardKeyboardStatusChangeListener {
        public void onHardKeyboardStatusChange(boolean var1, boolean var2);
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int DO_TRAVERSAL = 4;
        public static final int ADD_STARTING = 5;
        public static final int REMOVE_STARTING = 6;
        public static final int FINISHED_STARTING = 7;
        public static final int REPORT_APPLICATION_TOKEN_WINDOWS = 8;
        public static final int REPORT_APPLICATION_TOKEN_DRAWN = 9;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int DRAG_START_TIMEOUT = 20;
        public static final int DRAG_END_TIMEOUT = 21;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        public static final int SHOW_STRICT_MODE_VIOLATION = 25;
        public static final int DO_ANIMATION_CALLBACK = 26;
        public static final int DO_DISPLAY_ADDED = 27;
        public static final int DO_DISPLAY_REMOVED = 28;
        public static final int DO_DISPLAY_CHANGED = 29;
        public static final int CLIENT_FREEZE_TIMEOUT = 30;
        public static final int TAP_OUTSIDE_STACK = 31;
        public static final int NOTIFY_ACTIVITY_DRAWN = 32;
        public static final int REMOVE_STARTING_TIMEOUT = 33;

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            block48 : switch (msg.what) {
                case 2: {
                    WindowState newFocus;
                    WindowState lastFocus;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        lastFocus = WindowManagerService.this.mLastFocus;
                        newFocus = WindowManagerService.this.mCurrentFocus;
                        if (lastFocus == newFocus) {
                            return;
                        }
                        WindowManagerService.this.mLastFocus = newFocus;
                        if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                            WindowManagerService.this.mLosingFocus.add(lastFocus);
                            lastFocus = null;
                        }
                    }
                    if (newFocus != null) {
                        newFocus.reportFocusChangedSerialized(true, WindowManagerService.this.mInTouchMode);
                        WindowManagerService.this.notifyFocusChanged();
                    }
                    if (lastFocus == null) break;
                    lastFocus.reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    break;
                }
                case 3: {
                    ArrayList<WindowState> losers;
                    HashMap<IBinder, WindowState> newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        losers = WindowManagerService.this.mLosingFocus;
                        WindowManagerService.this.mLosingFocus = new ArrayList();
                    }
                    int N = losers.size();
                    for (int i = 0; i < N; ++i) {
                        losers.get(i).reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    }
                    break;
                }
                case 4: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.mTraversalScheduled = false;
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 5: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    StartingData sd = wtoken.startingData;
                    if (sd == null) {
                        return;
                    }
                    View view = null;
                    try {
                        view = WindowManagerService.this.mPolicy.addStartingWindow(wtoken.token, sd.pkg, sd.theme, sd.compatInfo, sd.nonLocalizedLabel, sd.labelRes, sd.icon, sd.logo, sd.windowFlags);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when adding starting window", e);
                    }
                    if (view == null) break;
                    boolean abort = false;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (wtoken.removed || wtoken.startingData == null) {
                            if (wtoken.startingWindow != null) {
                                WindowManagerService.this.removeStartingWindowTimeout(wtoken);
                                wtoken.startingWindow = null;
                                wtoken.startingData = null;
                                abort = true;
                            }
                        } else {
                            wtoken.startingView = view;
                        }
                    }
                    if (!abort) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(wtoken.token, view);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 33: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    Slog.e(WindowManagerService.TAG, "Starting window " + wtoken + " timed out");
                }
                case 6: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    IBinder token = null;
                    View view2 = null;
                    HashMap<IBinder, WindowState> abort = WindowManagerService.this.mWindowMap;
                    synchronized (abort) {
                        if (wtoken.startingWindow != null) {
                            view2 = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                    }
                    if (view2 == null) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(token, view2);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 7: {
                    IBinder token = null;
                    View view = null;
                    while (true) {
                        HashMap<IBinder, WindowState> view2 = WindowManagerService.this.mWindowMap;
                        synchronized (view2) {
                            int N = WindowManagerService.this.mFinishedStarting.size();
                            if (N <= 0) {
                                break block48;
                            }
                            AppWindowToken wtoken = WindowManagerService.this.mFinishedStarting.remove(N - 1);
                            if (wtoken.startingWindow == null) {
                                continue;
                            }
                            view = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                        try {
                            WindowManagerService.this.mPolicy.removeStartingWindow(token, view);
                        }
                        catch (Exception e) {
                            Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                        }
                    }
                }
                case 9: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    try {
                        wtoken.appToken.windowsDrawn();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 8: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    boolean nowVisible = msg.arg1 != 0;
                    boolean nowGone = msg.arg2 != 0;
                    try {
                        if (nowVisible) {
                            wtoken.appToken.windowsVisible();
                            break;
                        }
                        wtoken.appToken.windowsGone();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 11: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w(WindowManagerService.TAG, "Window freeze timeout expired.");
                        WindowList windows = WindowManagerService.this.getDefaultWindowListLocked();
                        int i = windows.size();
                        while (i > 0) {
                            WindowState w = (WindowState)windows.get(--i);
                            if (!w.mOrientationChanging) continue;
                            w.mOrientationChanging = false;
                            w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - WindowManagerService.this.mDisplayFreezeTime);
                            Slog.w(WindowManagerService.TAG, "Force clearing orientation change: " + w);
                        }
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 13: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mAppTransition.isTransitionSet()) {
                            WindowManagerService.this.mAppTransition.setTimeout();
                            WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        }
                        break;
                    }
                }
                case 14: {
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScale);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScale);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScale);
                    break;
                }
                case 15: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mAnimator.mAnimating || WindowManagerService.this.mAnimationScheduled) {
                            this.sendEmptyMessageDelayed(15, 2000L);
                            return;
                        }
                        if (WindowManagerService.this.mDisplayFrozen) {
                            return;
                        }
                    }
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 17: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w(WindowManagerService.TAG, "App freeze timeout expired.");
                        DisplayContent displayContent = WindowManagerService.this.getDefaultDisplayContentLocked();
                        ArrayList<Task> tasks = displayContent.getTasks();
                        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                            for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                                AppWindowToken tok = (AppWindowToken)tokens.get(tokenNdx);
                                if (!tok.mAppAnimator.freezingScreen) continue;
                                Slog.w(WindowManagerService.TAG, "Force clearing freeze: " + tok);
                                WindowManagerService.this.unsetAppFreezingScreenLocked(tok, true, true);
                            }
                        }
                        break;
                    }
                }
                case 30: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mClientFreezingScreen) {
                            WindowManagerService.this.mClientFreezingScreen = false;
                            WindowManagerService.this.mLastFinishedFreezeSource = "client-timeout";
                            WindowManagerService.this.stopFreezingDisplayLocked();
                        }
                        break;
                    }
                }
                case 18: {
                    this.removeMessages(18);
                    WindowManagerService.this.sendNewConfiguration();
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        WindowManagerService.this.mWindowsChanged = false;
                    }
                    WindowManagerService.this.notifyWindowsChanged();
                    break;
                }
                case 20: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> displayContent = WindowManagerService.this.mWindowMap;
                    synchronized (displayContent) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.unregister();
                            WindowManagerService.this.mInputMonitor.updateInputWindowsLw(true);
                            WindowManagerService.this.mDragState.reset();
                            WindowManagerService.this.mDragState = null;
                        }
                        break;
                    }
                }
                case 21: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> displayContent = WindowManagerService.this.mWindowMap;
                    synchronized (displayContent) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.mDragResult = false;
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        break;
                    }
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    Pair pair;
                    HashMap<IBinder, WindowState> displayContent = WindowManagerService.this.mWindowMap;
                    synchronized (displayContent) {
                        pair = (Pair)msg.obj;
                        Slog.w(WindowManagerService.TAG, "Timeout waiting for drawn: " + pair.first);
                        if (!WindowManagerService.this.mWaitingForDrawn.remove(pair)) {
                            return;
                        }
                    }
                    try {
                        ((IRemoteCallback)pair.second).sendResult(null);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 25: {
                    WindowManagerService.this.showStrictModeViolation(msg.arg1, msg.arg2);
                    break;
                }
                case 26: {
                    try {
                        ((IRemoteCallback)msg.obj).sendResult(null);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        WindowManagerService.this.handleDisplayAddedLocked(msg.arg1);
                        break;
                    }
                }
                case 28: {
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        WindowManagerService.this.handleDisplayRemovedLocked(msg.arg1);
                        break;
                    }
                }
                case 29: {
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        WindowManagerService.this.handleDisplayChangedLocked(msg.arg1);
                        break;
                    }
                }
                case 31: {
                    int stackId;
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        stackId = ((DisplayContent)msg.obj).stackIdFromPoint(msg.arg1, msg.arg2);
                    }
                    if (stackId < 0) break;
                    try {
                        WindowManagerService.this.mActivityManager.setFocusedStack(stackId);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 32: {
                    try {
                        WindowManagerService.this.mActivityManager.notifyActivityDrawn((IBinder)msg.obj);
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }

    final class DragInputEventReceiver
    extends InputEventReceiver {
        public DragInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInputEvent(InputEvent event) {
            block21: {
                boolean handled = false;
                try {
                    HashMap<IBinder, WindowState> hashMap;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || WindowManagerService.this.mDragState == null) break block21;
                    MotionEvent motionEvent = (MotionEvent)event;
                    boolean endDrag = false;
                    float newX = motionEvent.getRawX();
                    float newY = motionEvent.getRawY();
                    switch (motionEvent.getAction()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                WindowManagerService.this.mDragState.notifyMoveLw(newX, newY);
                                break;
                            }
                        }
                        case 1: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                break;
                            }
                        }
                        case 3: {
                            endDrag = true;
                        }
                    }
                    if (endDrag) {
                        hashMap = WindowManagerService.this.mWindowMap;
                        synchronized (hashMap) {
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                    }
                    handled = true;
                }
                catch (Exception e) {
                    Slog.e(WindowManagerService.TAG, "Exception caught by drag handleMotion", e);
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    class LayoutFields {
        static final int SET_UPDATE_ROTATION = 1;
        static final int SET_WALLPAPER_MAY_CHANGE = 2;
        static final int SET_FORCE_HIDING_CHANGED = 4;
        static final int SET_ORIENTATION_CHANGE_COMPLETE = 8;
        static final int SET_TURN_ON_SCREEN = 16;
        static final int SET_WALLPAPER_ACTION_PENDING = 32;
        boolean mWallpaperForceHidingChanged = false;
        boolean mWallpaperMayChange = false;
        boolean mOrientationChangeComplete = true;
        Object mLastWindowFreezeSource = null;
        private Session mHoldScreen = null;
        private boolean mObscured = false;
        private boolean mSyswin = false;
        private float mScreenBrightness = -1.0f;
        private float mButtonBrightness = -1.0f;
        private long mUserActivityTimeout = -1L;
        private boolean mUpdateRotation = false;
        boolean mWallpaperActionPending = false;
        private static final int DISPLAY_CONTENT_UNKNOWN = 0;
        private static final int DISPLAY_CONTENT_MIRROR = 1;
        private static final int DISPLAY_CONTENT_UNIQUE = 2;
        private int mDisplayHasContent = 0;

        LayoutFields() {
        }
    }
}

