/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.search;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.ISearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.search.Searchables;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchManagerService
extends ISearchManager.Stub {
    private static final String TAG = "SearchManagerService";
    private final Context mContext;
    private final SparseArray<Searchables> mSearchables = new SparseArray();

    public SearchManagerService(Context context) {
        this.mContext = context;
        this.mContext.registerReceiver(new BootCompletedReceiver(), new IntentFilter("android.intent.action.BOOT_COMPLETED"));
        this.mContext.registerReceiver(new UserReceiver(), new IntentFilter("android.intent.action.USER_REMOVED"));
        new MyPackageMonitor().register(context, null, UserHandle.ALL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Searchables getSearchables(int userId) {
        long origId;
        block7: {
            Searchables searchables;
            origId = Binder.clearCallingIdentity();
            try {
                boolean userExists;
                boolean bl = userExists = ((UserManager)this.mContext.getSystemService("user")).getUserInfo(userId) != null;
                if (userExists) break block7;
                searchables = null;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return searchables;
        }
        Object var7_8 = null;
        Binder.restoreCallingIdentity(origId);
        SparseArray<Searchables> sparseArray = this.mSearchables;
        synchronized (sparseArray) {
            Searchables searchables = this.mSearchables.get(userId);
            if (searchables == null) {
                searchables = new Searchables(this.mContext, userId);
                searchables.buildSearchableList();
                this.mSearchables.append(userId, searchables);
            }
            return searchables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        if (userId != 0) {
            SparseArray<Searchables> sparseArray = this.mSearchables;
            synchronized (sparseArray) {
                this.mSearchables.remove(userId);
            }
        }
    }

    @Override
    public SearchableInfo getSearchableInfo(ComponentName launchActivity) {
        if (launchActivity == null) {
            Log.e(TAG, "getSearchableInfo(), activity == null");
            return null;
        }
        return this.getSearchables(UserHandle.getCallingUserId()).getSearchableInfo(launchActivity);
    }

    @Override
    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        return this.getSearchables(UserHandle.getCallingUserId()).getSearchablesInGlobalSearchList();
    }

    @Override
    public List<ResolveInfo> getGlobalSearchActivities() {
        return this.getSearchables(UserHandle.getCallingUserId()).getGlobalSearchActivities();
    }

    @Override
    public ComponentName getGlobalSearchActivity() {
        return this.getSearchables(UserHandle.getCallingUserId()).getGlobalSearchActivity();
    }

    @Override
    public ComponentName getWebSearchActivity() {
        return this.getSearchables(UserHandle.getCallingUserId()).getWebSearchActivity();
    }

    @Override
    public ComponentName getAssistIntent(int userHandle) {
        try {
            userHandle = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userHandle, true, false, "getAssistIntent", null);
            IPackageManager pm = AppGlobals.getPackageManager();
            Intent assistIntent = new Intent("android.intent.action.ASSIST");
            ResolveInfo info = pm.resolveIntent(assistIntent, assistIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536, userHandle);
            if (info != null) {
                return new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
            }
        }
        catch (RemoteException re) {
            Log.e(TAG, "RemoteException in getAssistIntent: " + re);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception in getAssistIntent: " + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        SparseArray<Searchables> sparseArray = this.mSearchables;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSearchables.size(); ++i) {
                ipw.print("\nUser: ");
                ipw.println(this.mSearchables.keyAt(i));
                ipw.increaseIndent();
                this.mSearchables.valueAt(i).dump(fd, ipw, args);
                ipw.decreaseIndent();
            }
        }
    }

    class GlobalSearchProviderObserver
    extends ContentObserver {
        private final ContentResolver mResolver;

        public GlobalSearchProviderObserver(ContentResolver resolver) {
            super(null);
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Secure.getUriFor("search_global_search_activity"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            SparseArray sparseArray = SearchManagerService.this.mSearchables;
            synchronized (sparseArray) {
                for (int i = 0; i < SearchManagerService.this.mSearchables.size(); ++i) {
                    SearchManagerService.this.getSearchables(SearchManagerService.this.mSearchables.keyAt(i)).buildSearchableList();
                }
            }
            Intent intent = new Intent("android.search.action.GLOBAL_SEARCH_ACTIVITY_CHANGED");
            intent.addFlags(0x20000000);
            SearchManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        public void onSomePackagesChanged() {
            this.updateSearchables();
        }

        public void onPackageModified(String pkg) {
            this.updateSearchables();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSearchables() {
            int changingUserId = this.getChangingUserId();
            SparseArray sparseArray = SearchManagerService.this.mSearchables;
            synchronized (sparseArray) {
                for (int i = 0; i < SearchManagerService.this.mSearchables.size(); ++i) {
                    if (changingUserId != SearchManagerService.this.mSearchables.keyAt(i)) continue;
                    SearchManagerService.this.getSearchables(SearchManagerService.this.mSearchables.keyAt(i)).buildSearchableList();
                    break;
                }
            }
            Intent intent = new Intent("android.search.action.SEARCHABLES_CHANGED");
            intent.addFlags(0x24000000);
            SearchManagerService.this.mContext.sendBroadcastAsUser(intent, new UserHandle(changingUserId));
        }
    }

    private final class UserReceiver
    extends BroadcastReceiver {
        private UserReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            SearchManagerService.this.onUserRemoved(intent.getIntExtra("android.intent.extra.user_handle", 0));
        }
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            new Thread(){

                public void run() {
                    Process.setThreadPriority(10);
                    SearchManagerService.this.mContext.unregisterReceiver(BootCompletedReceiver.this);
                    SearchManagerService.this.getSearchables(0);
                }
            }.start();
        }
    }
}

