/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrintAttributes;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.server.print.UserState;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintManagerService
extends IPrintManager.Stub {
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final String EXTRA_PRINT_SERVICE_COMPONENT_NAME = "EXTRA_PRINT_SERVICE_COMPONENT_NAME";
    private final Object mLock = new Object();
    private final Context mContext;
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private int mCurrentUserId = 0;

    public PrintManagerService(Context context) {
        this.mContext = context;
        this.registerContentObservers();
        this.registerBoradcastReceivers();
    }

    public void systemRuning() {
        BackgroundThread.getHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UserState userState;
                Object object = PrintManagerService.this.mLock;
                synchronized (object) {
                    userState = PrintManagerService.this.getCurrentUserStateLocked();
                    userState.updateIfNeededLocked();
                }
                userState.removeObsoletePrintJobs();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle print(String printJobName, IPrintDocumentAdapter adapter, PrintAttributes attributes, String packageName, int appId, int userId) {
        Bundle bundle;
        UserState userState;
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        String resolvedPackageName = this.resolveCallingPackageNameEnforcingSecurity(packageName);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            bundle = userState.print(printJobName, adapter, attributes, resolvedPackageName, resolvedAppId);
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PrintJobInfo> getPrintJobInfos(int appId, int userId) {
        List<PrintJobInfo> list;
        UserState userState;
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            list = userState.getPrintJobInfos(resolvedAppId);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId, int userId) {
        PrintJobInfo printJobInfo;
        UserState userState;
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            printJobInfo = userState.getPrintJobInfo(printJobId, resolvedAppId);
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
        return printJobInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelPrintJob(PrintJobId printJobId, int appId, int userId) {
        UserState userState;
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.cancelPrintJob(printJobId, resolvedAppId);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartPrintJob(PrintJobId printJobId, int appId, int userId) {
        UserState userState;
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.restartPrintJob(printJobId, resolvedAppId);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PrintServiceInfo> getEnabledPrintServices(int userId) {
        List<PrintServiceInfo> list;
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            list = userState.getEnabledPrintServices();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PrintServiceInfo> getInstalledPrintServices(int userId) {
        List<PrintServiceInfo> list;
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            list = userState.getInstalledPrintServices();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.createPrinterDiscoverySession(observer);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.destroyPrinterDiscoverySession(observer);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.startPrinterDiscovery(observer, priorityList);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.stopPrinterDiscovery(observer);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validatePrinters(List<PrinterId> printerIds, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.validatePrinters(printerIds);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPrinterStateTracking(PrinterId printerId, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.startPrinterStateTracking(printerId);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPrinterStateTracking(PrinterId printerId, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.stopPrinterStateTracking(printerId);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId, int userId) throws RemoteException {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        int resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.addPrintJobStateChangeListener(listener, resolvedAppId);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener, int userId) {
        UserState userState;
        int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
        Object object = this.mLock;
        synchronized (object) {
            userState = this.getOrCreateUserStateLocked(resolvedUserId);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.removePrintJobStateChangeListener(listener);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump PrintManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("PRINT MANAGER STATE (dumpsys print)");
            int userStateCount = this.mUserStates.size();
            for (int i = 0; i < userStateCount; ++i) {
                UserState userState = this.mUserStates.get(i);
                userState.dump(fd, pw, "");
                pw.println();
            }
        }
    }

    private void registerContentObservers() {
        final Uri enabledPrintServicesUri = Settings.Secure.getUriFor("enabled_print_services");
        ContentObserver observer = new ContentObserver(BackgroundThread.getHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(boolean selfChange, Uri uri) {
                if (enabledPrintServicesUri.equals(uri)) {
                    Object object = PrintManagerService.this.mLock;
                    synchronized (object) {
                        UserState userState = PrintManagerService.this.getCurrentUserStateLocked();
                        userState.updateIfNeededLocked();
                    }
                }
            }
        };
        this.mContext.getContentResolver().registerContentObserver(enabledPrintServicesUri, false, observer, -1);
    }

    private void registerBoradcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onPackageChanged(String packageName, int uid, String[] components) {
                Object object = PrintManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = PrintManagerService.this.getOrCreateUserStateLocked(this.getChangingUserId());
                    for (ComponentName componentName : userState.getEnabledServices()) {
                        if (!packageName.equals(componentName.getPackageName())) continue;
                        userState.updateIfNeededLocked();
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = PrintManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = PrintManagerService.this.getOrCreateUserStateLocked(this.getChangingUserId());
                    Iterator<ComponentName> iterator = userState.getEnabledServices().iterator();
                    while (iterator.hasNext()) {
                        ComponentName componentName = iterator.next();
                        if (!packageName.equals(componentName.getPackageName())) continue;
                        iterator.remove();
                        this.persistComponentNamesToSettingLocked("enabled_print_services", userState.getEnabledServices(), this.getChangingUserId());
                        userState.updateIfNeededLocked();
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] stoppedPackages, int uid, boolean doit) {
                Object object = PrintManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = PrintManagerService.this.getOrCreateUserStateLocked(this.getChangingUserId());
                    boolean stoppedSomePackages = false;
                    block3: for (ComponentName componentName : userState.getEnabledServices()) {
                        String componentPackage = componentName.getPackageName();
                        for (String stoppedPackage : stoppedPackages) {
                            if (!componentPackage.equals(stoppedPackage)) continue;
                            if (!doit) {
                                return true;
                            }
                            stoppedSomePackages = true;
                            continue block3;
                        }
                    }
                    if (stoppedSomePackages) {
                        userState.updateIfNeededLocked();
                    }
                    return false;
                }
            }

            @Override
            public void onPackageAdded(String packageName, int uid) {
                Intent intent = new Intent("android.printservice.PrintService");
                intent.setPackage(packageName);
                List<ResolveInfo> installedServices = PrintManagerService.this.mContext.getPackageManager().queryIntentServicesAsUser(intent, 4, this.getChangingUserId());
                if (installedServices == null) {
                    return;
                }
                int installedServiceCount = installedServices.size();
                for (int i = 0; i < installedServiceCount; ++i) {
                    ServiceInfo serviceInfo = installedServices.get((int)i).serviceInfo;
                    ComponentName component = new ComponentName(serviceInfo.packageName, serviceInfo.name);
                    String label = ((Object)serviceInfo.loadLabel(PrintManagerService.this.mContext.getPackageManager())).toString();
                    PrintManagerService.this.showEnableInstalledPrintServiceNotification(component, label, this.getChangingUserId());
                }
            }

            private void persistComponentNamesToSettingLocked(String settingName, Set<ComponentName> componentNames, int userId) {
                StringBuilder builder = new StringBuilder();
                for (ComponentName componentName : componentNames) {
                    if (builder.length() > 0) {
                        builder.append(':');
                    }
                    builder.append(componentName.flattenToShortString());
                }
                Settings.Secure.putStringForUser(PrintManagerService.this.mContext.getContentResolver(), settingName, builder.toString(), userId);
            }
        };
        monitor.register(this.mContext, BackgroundThread.getHandler().getLooper(), UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    PrintManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    PrintManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                }
            }
        }, UserHandle.ALL, intentFilter, null, BackgroundThread.getHandler());
    }

    private UserState getCurrentUserStateLocked() {
        return this.getOrCreateUserStateLocked(this.mCurrentUserId);
    }

    private UserState getOrCreateUserStateLocked(int userId) {
        UserState userState = this.mUserStates.get(userId);
        if (userState == null) {
            userState = new UserState(this.mContext, userId, this.mLock);
            this.mUserStates.put(userId, userState);
        }
        return userState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int newUserId) {
        UserState userState;
        Object object = this.mLock;
        synchronized (object) {
            if (newUserId == this.mCurrentUserId) {
                return;
            }
            this.mCurrentUserId = newUserId;
            userState = this.mUserStates.get(this.mCurrentUserId);
            if (userState == null) {
                userState = this.getCurrentUserStateLocked();
                userState.updateIfNeededLocked();
            } else {
                userState.updateIfNeededLocked();
            }
        }
        userState.removeObsoletePrintJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int removedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.mUserStates.get(removedUserId);
            if (userState != null) {
                userState.destroyLocked();
                this.mUserStates.remove(removedUserId);
            }
        }
    }

    private int resolveCallingAppEnforcingPermissions(int appId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
            return appId;
        }
        int callingAppId = UserHandle.getAppId(callingUid);
        if (appId == callingAppId) {
            return appId;
        }
        if (this.mContext.checkCallingPermission("com.android.printspooler.permission.ACCESS_ALL_PRINT_JOBS") != 0) {
            throw new SecurityException("Call from app " + callingAppId + " as app " + appId + " without com.android.printspooler.permission" + ".ACCESS_ALL_PRINT_JOBS");
        }
        return appId;
    }

    private int resolveCallingUserEnforcingPermissions(int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
            return userId;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId == userId) {
            return userId;
        }
        if (this.mContext.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0 || this.mContext.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            if (userId == -3) {
                return callingUserId;
            }
            throw new SecurityException("Call from user " + callingUserId + " as user " + userId + " without permission INTERACT_ACROSS_USERS or " + "INTERACT_ACROSS_USERS_FULL not allowed.");
        }
        if (userId == -2 || userId == -3) {
            return this.mCurrentUserId;
        }
        throw new IllegalArgumentException("Calling user can be changed to only UserHandle.USER_CURRENT or UserHandle.USER_CURRENT_OR_SELF.");
    }

    private String resolveCallingPackageNameEnforcingSecurity(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(Binder.getCallingUid());
        int packageCount = packages.length;
        for (int i = 0; i < packageCount; ++i) {
            if (!packageName.equals(packages[i])) continue;
            return packageName;
        }
        return null;
    }

    private void showEnableInstalledPrintServiceNotification(ComponentName component, String label, int userId) {
        UserHandle userHandle = new UserHandle(userId);
        Intent intent = new Intent("android.settings.ACTION_PRINT_SETTINGS");
        intent.putExtra(EXTRA_PRINT_SERVICE_COMPONENT_NAME, component.flattenToString());
        PendingIntent pendingIntent = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x50000000, null, userHandle);
        Notification.Builder builder = new Notification.Builder(this.mContext).setSmallIcon(17302414).setContentTitle(this.mContext.getString(17040853, label)).setContentText(this.mContext.getString(17040854)).setContentIntent(pendingIntent).setWhen(System.currentTimeMillis()).setAutoCancel(true).setShowWhen(true);
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        String notificationTag = this.getClass().getName() + ":" + component.flattenToString();
        notificationManager.notifyAsUser(notificationTag, 0, builder.build(), userHandle);
    }
}

