/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.IStopUserCallback;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.pm.PackageManagerService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerService
extends IUserManager.Stub {
    private static final String LOG_TAG = "UserManagerService";
    private static final boolean DBG = false;
    private static final String TAG_NAME = "name";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_PATH = "icon";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATION_TIME = "created";
    private static final String ATTR_LAST_LOGGED_IN_TIME = "lastLoggedIn";
    private static final String ATTR_SALT = "salt";
    private static final String ATTR_PIN_HASH = "pinHash";
    private static final String ATTR_FAILED_ATTEMPTS = "failedAttempts";
    private static final String ATTR_LAST_RETRY_MS = "lastAttemptMs";
    private static final String ATTR_SERIAL_NO = "serialNumber";
    private static final String ATTR_NEXT_SERIAL_NO = "nextSerialNumber";
    private static final String ATTR_PARTIAL = "partial";
    private static final String ATTR_USER_VERSION = "version";
    private static final String TAG_USERS = "users";
    private static final String TAG_USER = "user";
    private static final String TAG_RESTRICTIONS = "restrictions";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_VALUE = "value";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE_TYPE = "type";
    private static final String ATTR_MULTIPLE = "m";
    private static final String ATTR_TYPE_STRING_ARRAY = "sa";
    private static final String ATTR_TYPE_STRING = "s";
    private static final String ATTR_TYPE_BOOLEAN = "b";
    private static final String USER_INFO_DIR = "system" + File.separator + "users";
    private static final String USER_LIST_FILENAME = "userlist.xml";
    private static final String USER_PHOTO_FILENAME = "photo.png";
    private static final String RESTRICTIONS_FILE_PREFIX = "res_";
    private static final String XML_SUFFIX = ".xml";
    private static final int MIN_USER_ID = 10;
    private static final int USER_VERSION = 4;
    private static final long EPOCH_PLUS_30_YEARS = 946080000000L;
    private static final int BACKOFF_INC_INTERVAL = 5;
    private static final int[] BACKOFF_TIMES = new int[]{0, 30000, 60000, 300000, 1800000};
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Object mInstallLock;
    private final Object mPackagesLock;
    private final Handler mHandler;
    private final File mUsersDir;
    private final File mUserListFile;
    private final File mBaseUserPath;
    private final SparseArray<UserInfo> mUsers = new SparseArray();
    private final SparseArray<Bundle> mUserRestrictions = new SparseArray();
    private final SparseArray<RestrictionsPinState> mRestrictionsPinStates = new SparseArray();
    private final SparseBooleanArray mRemovingUserIds = new SparseBooleanArray();
    private int[] mUserIds;
    private boolean mGuestEnabled;
    private int mNextSerialNumber;
    private int mUserVersion = 0;
    private static UserManagerService sInstance;
    private PackageMonitor mUserPackageMonitor = new PackageMonitor(){

        public void onPackageRemoved(String pkg, int uid) {
            boolean uninstalled;
            int userId = this.getChangingUserId();
            boolean bl = uninstalled = this.isPackageDisappearing(pkg) == 3;
            if (uninstalled && userId >= 0 && !UserManagerService.this.isPackageInstalled(pkg, userId)) {
                UserManagerService.this.cleanAppRestrictionsForPackage(pkg, userId);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserManagerService getInstance() {
        Class<UserManagerService> clazz = UserManagerService.class;
        synchronized (UserManagerService.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    UserManagerService(File dataDir, File baseUserPath) {
        this(null, null, new Object(), new Object(), dataDir, baseUserPath);
    }

    UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock) {
        this(context, pm, installLock, packagesLock, Environment.getDataDirectory(), new File(Environment.getDataDirectory(), TAG_USER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock, File dataDir, File baseUserPath) {
        this.mContext = context;
        this.mPm = pm;
        this.mInstallLock = installLock;
        this.mPackagesLock = packagesLock;
        this.mHandler = new Handler();
        Object object = this.mInstallLock;
        synchronized (object) {
            Object object2 = this.mPackagesLock;
            synchronized (object2) {
                UserInfo ui;
                int i;
                this.mUsersDir = new File(dataDir, USER_INFO_DIR);
                this.mUsersDir.mkdirs();
                File userZeroDir = new File(this.mUsersDir, "0");
                userZeroDir.mkdirs();
                this.mBaseUserPath = baseUserPath;
                FileUtils.setPermissions(this.mUsersDir.toString(), 509, -1, -1);
                this.mUserListFile = new File(this.mUsersDir, USER_LIST_FILENAME);
                this.readUserListLocked();
                ArrayList<UserInfo> partials = new ArrayList<UserInfo>();
                for (i = 0; i < this.mUsers.size(); ++i) {
                    ui = this.mUsers.valueAt(i);
                    if (!ui.partial || i == 0) continue;
                    partials.add(ui);
                }
                for (i = 0; i < partials.size(); ++i) {
                    ui = (UserInfo)partials.get(i);
                    Slog.w(LOG_TAG, "Removing partially created user #" + i + " (name=" + ui.name + ")");
                    this.removeUserStateLocked(ui.id);
                }
                sInstance = this;
            }
        }
    }

    void systemReady() {
        ContextImpl context = ActivityThread.systemMain().getSystemContext();
        this.mUserPackageMonitor.register(context, null, UserHandle.ALL, false);
        this.userForeground(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getUsers(boolean excludeDying) {
        UserManagerService.checkManageUsersPermission("query users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo ui = this.mUsers.valueAt(i);
                if (ui.partial || excludeDying && this.mRemovingUserIds.get(ui.id)) continue;
                users.add(ui);
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(int userId) {
        UserManagerService.checkManageUsersPermission("query user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRestricted() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(UserHandle.getCallingUserId()).isRestricted();
        }
    }

    private UserInfo getUserInfoLocked(int userId) {
        UserInfo ui = this.mUsers.get(userId);
        if (ui != null && ui.partial && !this.mRemovingUserIds.get(userId)) {
            Slog.w(LOG_TAG, "getUserInfo: unknown user #" + userId);
            return null;
        }
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mUserIds, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserName(int userId, String name) {
        UserManagerService.checkManageUsersPermission("rename users");
        boolean changed = false;
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "setUserName: unknown user #" + userId);
                return;
            }
            if (name != null && !name.equals(info.name)) {
                info.name = name;
                this.writeUserLocked(info);
                changed = true;
            }
        }
        if (changed) {
            this.sendUserInfoChangedBroadcast(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(int userId, Bitmap bitmap) {
        UserManagerService.checkManageUsersPermission("update users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "setUserIcon: unknown user #" + userId);
                return;
            }
            this.writeBitmapLocked(info, bitmap);
            this.writeUserLocked(info);
        }
        this.sendUserInfoChangedBroadcast(userId);
    }

    private void sendUserInfoChangedBroadcast(int userId) {
        Intent changedIntent = new Intent("android.intent.action.USER_INFO_CHANGED");
        changedIntent.putExtra("android.intent.extra.user_handle", userId);
        changedIntent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(changedIntent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getUserIcon(int userId) {
        UserManagerService.checkManageUsersPermission("read users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "getUserIcon: unknown user #" + userId);
                return null;
            }
            if (info.iconPath == null) {
                return null;
            }
            return BitmapFactory.decodeFile(info.iconPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGuestEnabled(boolean enable) {
        UserManagerService.checkManageUsersPermission("enable guest users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (this.mGuestEnabled != enable) {
                this.mGuestEnabled = enable;
                for (int i = 0; i < this.mUsers.size(); ++i) {
                    UserInfo user = this.mUsers.valueAt(i);
                    if (user.partial || !user.isGuest()) continue;
                    if (!enable) {
                        this.removeUser(user.id);
                    }
                    return;
                }
                if (enable) {
                    this.createUser("Guest", 4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGuestEnabled() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.mGuestEnabled;
        }
    }

    @Override
    public void wipeUser(int userHandle) {
        UserManagerService.checkManageUsersPermission("wipe user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeInitialized(int userId) {
        UserManagerService.checkManageUsersPermission("makeInitialized");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "makeInitialized: unknown user #" + userId);
            }
            if ((info.flags & 0x10) == 0) {
                info.flags |= 0x10;
                this.writeUserLocked(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getUserRestrictions(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.mUserRestrictions.get(userId);
            return restrictions != null ? restrictions : Bundle.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestrictions(Bundle restrictions, int userId) {
        UserManagerService.checkManageUsersPermission("setUserRestrictions");
        if (restrictions == null) {
            return;
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.mUserRestrictions.get(userId).clear();
            this.mUserRestrictions.get(userId).putAll(restrictions);
            this.writeUserLocked(this.mUsers.get(userId));
        }
    }

    private boolean isUserLimitReachedLocked() {
        int nUsers = this.mUsers.size();
        return nUsers >= UserManager.getMaxSupportedUsers();
    }

    private static final void checkManageUsersPermission(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0 && ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", uid, -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS permission to: " + message);
        }
    }

    private void writeBitmapLocked(UserInfo info, Bitmap bitmap) {
        try {
            FileOutputStream os;
            File dir = new File(this.mUsersDir, Integer.toString(info.id));
            File file = new File(dir, USER_PHOTO_FILENAME);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, os = new FileOutputStream(file))) {
                info.iconPath = file.getAbsolutePath();
            }
            try {
                os.close();
            }
            catch (IOException ioe) {}
        }
        catch (FileNotFoundException e) {
            Slog.w(LOG_TAG, "Error setting photo for user ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUserIds() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.mUserIds;
        }
    }

    int[] getUserIdsLPr() {
        return this.mUserIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserListLocked() {
        this.mGuestEnabled = false;
        if (!this.mUserListFile.exists()) {
            this.fallbackToSingleUserLocked();
            return;
        }
        FileInputStream fis = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            int type;
            fis = userListFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user list");
                this.fallbackToSingleUserLocked();
                return;
            }
            this.mNextSerialNumber = -1;
            if (parser.getName().equals(TAG_USERS)) {
                String versionNumber;
                String lastSerialNumber = parser.getAttributeValue(null, ATTR_NEXT_SERIAL_NO);
                if (lastSerialNumber != null) {
                    this.mNextSerialNumber = Integer.parseInt(lastSerialNumber);
                }
                if ((versionNumber = parser.getAttributeValue(null, ATTR_USER_VERSION)) != null) {
                    this.mUserVersion = Integer.parseInt(versionNumber);
                }
            }
            while ((type = parser.next()) != 1) {
                String id2;
                UserInfo user;
                if (type != 2 || !parser.getName().equals(TAG_USER) || (user = this.readUserLocked(Integer.parseInt(id2 = parser.getAttributeValue(null, ATTR_ID)))) == null) continue;
                this.mUsers.put(user.id, user);
                if (user.isGuest()) {
                    this.mGuestEnabled = true;
                }
                if (this.mNextSerialNumber >= 0 && this.mNextSerialNumber > user.id) continue;
                this.mNextSerialNumber = user.id + 1;
            }
            this.updateUserIdsLocked();
            this.upgradeIfNecessaryLocked();
        }
        catch (IOException ioe) {
            this.fallbackToSingleUserLocked();
        }
        catch (XmlPullParserException pe) {
            this.fallbackToSingleUserLocked();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void upgradeIfNecessaryLocked() {
        UserInfo user;
        int userVersion = this.mUserVersion;
        if (userVersion < 1) {
            user = this.mUsers.get(0);
            if ("Primary".equals(user.name)) {
                user.name = this.mContext.getResources().getString(17040761);
                this.writeUserLocked(user);
            }
            userVersion = 1;
        }
        if (userVersion < 2) {
            user = this.mUsers.get(0);
            if ((user.flags & 0x10) == 0) {
                user.flags |= 0x10;
                this.writeUserLocked(user);
            }
            userVersion = 2;
        }
        if (userVersion < 4) {
            userVersion = 4;
        }
        if (userVersion < 4) {
            Slog.w(LOG_TAG, "User version " + this.mUserVersion + " didn't upgrade as expected to " + 4);
        } else {
            this.mUserVersion = userVersion;
            this.writeUserListLocked();
        }
    }

    private void fallbackToSingleUserLocked() {
        UserInfo primary = new UserInfo(0, this.mContext.getResources().getString(17040761), null, 19);
        this.mUsers.put(0, primary);
        this.mNextSerialNumber = 10;
        this.mUserVersion = 4;
        Bundle restrictions = new Bundle();
        this.mUserRestrictions.append(0, restrictions);
        this.updateUserIdsLocked();
        this.writeUserListLocked();
        this.writeUserLocked(primary);
    }

    private void writeUserLocked(UserInfo userInfo) {
        FileOutputStream fos = null;
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userInfo.id + XML_SUFFIX));
        try {
            fos = userFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USER);
            serializer.attribute(null, ATTR_ID, Integer.toString(userInfo.id));
            serializer.attribute(null, ATTR_SERIAL_NO, Integer.toString(userInfo.serialNumber));
            serializer.attribute(null, ATTR_FLAGS, Integer.toString(userInfo.flags));
            serializer.attribute(null, ATTR_CREATION_TIME, Long.toString(userInfo.creationTime));
            serializer.attribute(null, ATTR_LAST_LOGGED_IN_TIME, Long.toString(userInfo.lastLoggedInTime));
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userInfo.id);
            if (pinState != null) {
                if (pinState.salt != 0L) {
                    serializer.attribute(null, ATTR_SALT, Long.toString(pinState.salt));
                }
                if (pinState.pinHash != null) {
                    serializer.attribute(null, ATTR_PIN_HASH, pinState.pinHash);
                }
                if (pinState.failedAttempts != 0) {
                    serializer.attribute(null, ATTR_FAILED_ATTEMPTS, Integer.toString(pinState.failedAttempts));
                    serializer.attribute(null, ATTR_LAST_RETRY_MS, Long.toString(pinState.lastAttemptTime));
                }
            }
            if (userInfo.iconPath != null) {
                serializer.attribute(null, ATTR_ICON_PATH, userInfo.iconPath);
            }
            if (userInfo.partial) {
                serializer.attribute(null, ATTR_PARTIAL, "true");
            }
            serializer.startTag(null, TAG_NAME);
            serializer.text(userInfo.name);
            serializer.endTag(null, TAG_NAME);
            Bundle restrictions = this.mUserRestrictions.get(userInfo.id);
            if (restrictions != null) {
                serializer.startTag(null, TAG_RESTRICTIONS);
                this.writeBoolean(serializer, restrictions, "no_config_wifi");
                this.writeBoolean(serializer, restrictions, "no_modify_accounts");
                this.writeBoolean(serializer, restrictions, "no_install_apps");
                this.writeBoolean(serializer, restrictions, "no_uninstall_apps");
                this.writeBoolean(serializer, restrictions, "no_share_location");
                this.writeBoolean(serializer, restrictions, "no_install_unknown_sources");
                this.writeBoolean(serializer, restrictions, "no_config_bluetooth");
                this.writeBoolean(serializer, restrictions, "no_usb_file_transfer");
                this.writeBoolean(serializer, restrictions, "no_config_credentials");
                this.writeBoolean(serializer, restrictions, "no_remove_user");
                serializer.endTag(null, TAG_RESTRICTIONS);
            }
            serializer.endTag(null, TAG_USER);
            serializer.endDocument();
            userFile.finishWrite(fos);
        }
        catch (Exception ioe) {
            Slog.e(LOG_TAG, "Error writing user info " + userInfo.id + "\n" + ioe);
            userFile.failWrite(fos);
        }
    }

    private void writeUserListLocked() {
        FileOutputStream fos = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            fos = userListFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USERS);
            serializer.attribute(null, ATTR_NEXT_SERIAL_NO, Integer.toString(this.mNextSerialNumber));
            serializer.attribute(null, ATTR_USER_VERSION, Integer.toString(this.mUserVersion));
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                serializer.startTag(null, TAG_USER);
                serializer.attribute(null, ATTR_ID, Integer.toString(user.id));
                serializer.endTag(null, TAG_USER);
            }
            serializer.endTag(null, TAG_USERS);
            serializer.endDocument();
            userListFile.finishWrite(fos);
        }
        catch (Exception e) {
            userListFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing user list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserInfo readUserLocked(int id2) {
        int flags = 0;
        int serialNumber = id2;
        String name = null;
        String iconPath = null;
        long creationTime = 0L;
        long lastLoggedInTime = 0L;
        long salt = 0L;
        String pinHash = null;
        int failedAttempts = 0;
        long lastAttemptTime = 0L;
        boolean partial = false;
        Bundle restrictions = new Bundle();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, Integer.toString(id2) + XML_SUFFIX));
            fis = userFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user " + id2);
                UserInfo userInfo = null;
                return userInfo;
            }
            if (type == 2 && parser.getName().equals(TAG_USER)) {
                int storedId = this.readIntAttribute(parser, ATTR_ID, -1);
                if (storedId != id2) {
                    Slog.e(LOG_TAG, "User id does not match the file name");
                    UserInfo e = null;
                    return e;
                }
                serialNumber = this.readIntAttribute(parser, ATTR_SERIAL_NO, id2);
                flags = this.readIntAttribute(parser, ATTR_FLAGS, 0);
                iconPath = parser.getAttributeValue(null, ATTR_ICON_PATH);
                creationTime = this.readLongAttribute(parser, ATTR_CREATION_TIME, 0L);
                lastLoggedInTime = this.readLongAttribute(parser, ATTR_LAST_LOGGED_IN_TIME, 0L);
                salt = this.readLongAttribute(parser, ATTR_SALT, 0L);
                pinHash = parser.getAttributeValue(null, ATTR_PIN_HASH);
                failedAttempts = this.readIntAttribute(parser, ATTR_FAILED_ATTEMPTS, 0);
                lastAttemptTime = this.readLongAttribute(parser, ATTR_LAST_RETRY_MS, 0L);
                String valueString = parser.getAttributeValue(null, ATTR_PARTIAL);
                if ("true".equals(valueString)) {
                    partial = true;
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tag = parser.getName();
                    if (TAG_NAME.equals(tag)) {
                        type = parser.next();
                        if (type != 4) continue;
                        name = parser.getText();
                        continue;
                    }
                    if (!TAG_RESTRICTIONS.equals(tag)) continue;
                    this.readBoolean(parser, restrictions, "no_config_wifi");
                    this.readBoolean(parser, restrictions, "no_modify_accounts");
                    this.readBoolean(parser, restrictions, "no_install_apps");
                    this.readBoolean(parser, restrictions, "no_uninstall_apps");
                    this.readBoolean(parser, restrictions, "no_share_location");
                    this.readBoolean(parser, restrictions, "no_install_unknown_sources");
                    this.readBoolean(parser, restrictions, "no_config_bluetooth");
                    this.readBoolean(parser, restrictions, "no_usb_file_transfer");
                    this.readBoolean(parser, restrictions, "no_config_credentials");
                    this.readBoolean(parser, restrictions, "no_remove_user");
                }
            }
            UserInfo userInfo = new UserInfo(id2, name, iconPath, flags);
            userInfo.serialNumber = serialNumber;
            userInfo.creationTime = creationTime;
            userInfo.lastLoggedInTime = lastLoggedInTime;
            userInfo.partial = partial;
            this.mUserRestrictions.append(id2, restrictions);
            if (salt != 0L) {
                RestrictionsPinState pinState = this.mRestrictionsPinStates.get(id2);
                if (pinState == null) {
                    pinState = new RestrictionsPinState();
                    this.mRestrictionsPinStates.put(id2, pinState);
                }
                pinState.salt = salt;
                pinState.pinHash = pinHash;
                pinState.failedAttempts = failedAttempts;
                pinState.lastAttemptTime = lastAttemptTime;
            }
            UserInfo userInfo2 = userInfo;
            return userInfo2;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (XmlPullParserException pe) {
            return null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void readBoolean(XmlPullParser parser, Bundle restrictions, String restrictionKey) {
        String value = parser.getAttributeValue(null, restrictionKey);
        if (value != null) {
            restrictions.putBoolean(restrictionKey, Boolean.parseBoolean(value));
        }
    }

    private void writeBoolean(XmlSerializer xml2, Bundle restrictions, String restrictionKey) throws IOException {
        if (restrictions.containsKey(restrictionKey)) {
            xml2.attribute(null, restrictionKey, Boolean.toString(restrictions.getBoolean(restrictionKey)));
        }
    }

    private int readIntAttribute(XmlPullParser parser, String attr2, int defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private long readLongAttribute(XmlPullParser parser, String attr2, long defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private boolean isPackageInstalled(String pkg, int userId) {
        ApplicationInfo info = this.mPm.getApplicationInfo(pkg, 8192, userId);
        return info != null && (info.flags & 0x800000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictions(int userId, boolean all) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            String[] files = dir.list();
            if (files == null) {
                return;
            }
            for (String fileName : files) {
                File resFile;
                if (!fileName.startsWith(RESTRICTIONS_FILE_PREFIX) || !(resFile = new File(dir, fileName)).exists()) continue;
                if (all) {
                    resFile.delete();
                    continue;
                }
                String pkg = this.restrictionsFileNameToPackage(fileName);
                if (this.isPackageInstalled(pkg, userId)) continue;
                resFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictionsForPackage(String pkg, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            File resFile = new File(dir, this.packageToRestrictionsFileName(pkg));
            if (resFile.exists()) {
                resFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserInfo createUser(String name, int flags) {
        UserManagerService.checkManageUsersPermission("Only the system can create users");
        long ident = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo;
            Object object = this.mInstallLock;
            synchronized (object) {
                Object object2 = this.mPackagesLock;
                synchronized (object2) {
                    if (this.isUserLimitReachedLocked()) {
                        UserInfo userInfo2 = null;
                        return userInfo2;
                    }
                    int userId = this.getNextAvailableIdLocked();
                    userInfo = new UserInfo(userId, name, null, flags);
                    File userPath = new File(this.mBaseUserPath, Integer.toString(userId));
                    userInfo.serialNumber = this.mNextSerialNumber++;
                    long now = System.currentTimeMillis();
                    userInfo.creationTime = now > 946080000000L ? now : 0L;
                    userInfo.partial = true;
                    Environment.getUserSystemDirectory(userInfo.id).mkdirs();
                    this.mUsers.put(userId, userInfo);
                    this.writeUserListLocked();
                    this.writeUserLocked(userInfo);
                    this.mPm.createNewUserLILPw(userId, userPath);
                    userInfo.partial = false;
                    this.writeUserLocked(userInfo);
                    this.updateUserIdsLocked();
                    Bundle restrictions = new Bundle();
                    this.mUserRestrictions.append(userId, restrictions);
                }
            }
            if (userInfo == null) return userInfo;
            Intent addedIntent = new Intent("android.intent.action.USER_ADDED");
            addedIntent.putExtra("android.intent.extra.user_handle", userInfo.id);
            this.mContext.sendBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS");
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(int userHandle) {
        int res;
        UserManagerService.checkManageUsersPermission("Only the system can remove users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo user = this.mUsers.get(userHandle);
            if (userHandle == 0 || user == null) {
                return false;
            }
            this.mRemovingUserIds.put(userHandle, true);
            user.partial = true;
            this.writeUserLocked(user);
        }
        try {
            res = ActivityManagerNative.getDefault().stopUser(userHandle, new IStopUserCallback.Stub(){

                public void userStopped(int userId) {
                    UserManagerService.this.finishRemoveUser(userId);
                }

                public void userStopAborted(int userId) {
                }
            });
        }
        catch (RemoteException e) {
            return false;
        }
        return res == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRemoveUser(final int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent addedIntent = new Intent("android.intent.action.USER_REMOVED");
            addedIntent.putExtra("android.intent.extra.user_handle", userHandle);
            this.mContext.sendOrderedBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS", new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = UserManagerService.this.mInstallLock;
                            synchronized (object) {
                                Object object2 = UserManagerService.this.mPackagesLock;
                                synchronized (object2) {
                                    UserManagerService.this.removeUserStateLocked(userHandle);
                                }
                            }
                        }
                    }.start();
                }
            }, null, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void removeUserStateLocked(final int userHandle) {
        this.mPm.cleanUpUserLILPw(userHandle);
        this.mUsers.remove(userHandle);
        this.mHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = UserManagerService.this.mPackagesLock;
                synchronized (object) {
                    UserManagerService.this.mRemovingUserIds.delete(userHandle);
                }
            }
        }, 60000L);
        this.mRestrictionsPinStates.remove(userHandle);
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userHandle + XML_SUFFIX));
        userFile.delete();
        this.writeUserListLocked();
        this.updateUserIdsLocked();
        this.removeDirectoryRecursive(Environment.getUserSystemDirectory(userHandle));
    }

    private void removeDirectoryRecursive(File parent) {
        if (parent.isDirectory()) {
            String[] files;
            for (String filename : files = parent.list()) {
                File child = new File(parent, filename);
                this.removeDirectoryRecursive(child);
            }
        }
        parent.delete();
    }

    @Override
    public Bundle getApplicationRestrictions(String packageName) {
        return this.getApplicationRestrictionsForUser(packageName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictionsForUser(String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can get restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.readApplicationRestrictionsLocked(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(String packageName, Bundle restrictions, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can set restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.writeApplicationRestrictionsLocked(packageName, restrictions, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRestrictionsChallenge(String newPin) {
        UserManagerService.checkManageUsersPermission("Only system can modify the restrictions pin");
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
            if (pinState == null) {
                pinState = new RestrictionsPinState();
            }
            if (newPin == null) {
                pinState.salt = 0L;
                pinState.pinHash = null;
            } else {
                try {
                    pinState.salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                }
                catch (NoSuchAlgorithmException e) {
                    pinState.salt = (long)(Math.random() * 9.223372036854776E18);
                }
                pinState.pinHash = this.passwordToHash(newPin, pinState.salt);
                pinState.failedAttempts = 0;
            }
            this.mRestrictionsPinStates.put(userId, pinState);
            this.writeUserLocked(this.mUsers.get(userId));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkRestrictionsChallenge(String pin) {
        UserManagerService.checkManageUsersPermission("Only system can verify the restrictions pin");
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
            if (pinState == null || pinState.salt == 0L || pinState.pinHash == null) {
                return -2;
            }
            if (pin == null) {
                int waitTime = this.getRemainingTimeForPinAttempt(pinState);
                Slog.d(LOG_TAG, "Remaining waittime peek=" + waitTime);
                return waitTime;
            }
            int waitTime = this.getRemainingTimeForPinAttempt(pinState);
            Slog.d(LOG_TAG, "Remaining waittime=" + waitTime);
            if (waitTime > 0) {
                return waitTime;
            }
            if (this.passwordToHash(pin, pinState.salt).equals(pinState.pinHash)) {
                pinState.failedAttempts = 0;
                this.writeUserLocked(this.mUsers.get(userId));
                return -1;
            }
            ++pinState.failedAttempts;
            pinState.lastAttemptTime = System.currentTimeMillis();
            this.writeUserLocked(this.mUsers.get(userId));
            return waitTime;
        }
    }

    private int getRemainingTimeForPinAttempt(RestrictionsPinState pinState) {
        int backoffIndex = Math.min(pinState.failedAttempts / 5, BACKOFF_TIMES.length - 1);
        int backoffTime = pinState.failedAttempts % 5 == 0 ? BACKOFF_TIMES[backoffIndex] : 0;
        return (int)Math.max((long)backoffTime + pinState.lastAttemptTime - System.currentTimeMillis(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRestrictionsChallenge() {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.hasRestrictionsPinLocked(userId);
        }
    }

    private boolean hasRestrictionsPinLocked(int userId) {
        RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
        return pinState != null && pinState.salt != 0L && pinState.pinHash != null;
    }

    @Override
    public void removeRestrictions() {
        UserManagerService.checkManageUsersPermission("Only system can remove restrictions");
        int userHandle = UserHandle.getCallingUserId();
        this.removeRestrictionsForUser(userHandle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRestrictionsForUser(int userHandle, boolean unblockApps) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.setUserRestrictions(new Bundle(), userHandle);
            this.setRestrictionsChallenge(null);
            this.cleanAppRestrictions(userHandle, true);
        }
        if (unblockApps) {
            this.unblockAllAppsForUser(userHandle);
        }
    }

    private void unblockAllAppsForUser(final int userHandle) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List<ApplicationInfo> apps = UserManagerService.this.mPm.getInstalledApplications(8192, userHandle).getList();
                long ident = Binder.clearCallingIdentity();
                try {
                    for (ApplicationInfo appInfo : apps) {
                        if ((appInfo.flags & 0x800000) == 0 || (appInfo.flags & 0x8000000) == 0) continue;
                        UserManagerService.this.mPm.setApplicationBlockedSettingAsUser(appInfo.packageName, false, userHandle);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        });
    }

    private String passwordToHash(String password, long salt) {
        if (password == null) {
            return null;
        }
        String algo = null;
        String hashed = salt + password;
        try {
            byte[] saltedPassword = (password + salt).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = UserManagerService.toHex(sha1) + UserManagerService.toHex(md5);
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(LOG_TAG, "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    private static String toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForPackage(String packageName) {
        long ident = Binder.clearCallingIdentity();
        try {
            int n = this.mContext.getPackageManager().getApplicationInfo((String)packageName, (int)8192).uid;
            return n;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle readApplicationRestrictionsLocked(String packageName, int userId) {
        Bundle restrictions = new Bundle();
        ArrayList<String> values = new ArrayList<String>();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
            fis = restrictionsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read restrictions file " + restrictionsFile.getBaseFile());
                Bundle bundle = restrictions;
                return bundle;
            }
            while ((type = parser.next()) != 1) {
                if (type != 2 || !parser.getName().equals(TAG_ENTRY)) continue;
                String key = parser.getAttributeValue(null, ATTR_KEY);
                String valType = parser.getAttributeValue(null, ATTR_VALUE_TYPE);
                String multiple = parser.getAttributeValue(null, ATTR_MULTIPLE);
                if (multiple != null) {
                    int count = Integer.parseInt(multiple);
                    while (count > 0 && (type = parser.next()) != 1) {
                        if (type != 2 || !parser.getName().equals(TAG_VALUE)) continue;
                        values.add(parser.nextText().trim());
                        --count;
                    }
                    String[] valueStrings = new String[values.size()];
                    values.toArray(valueStrings);
                    restrictions.putStringArray(key, valueStrings);
                    continue;
                }
                if (ATTR_TYPE_BOOLEAN.equals(valType)) {
                    restrictions.putBoolean(key, Boolean.parseBoolean(parser.nextText().trim()));
                    continue;
                }
                String value = parser.nextText().trim();
                restrictions.putString(key, value);
            }
        }
        catch (IOException ioe) {
        }
        catch (XmlPullParserException pe) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return restrictions;
    }

    private void writeApplicationRestrictionsLocked(String packageName, Bundle restrictions, int userId) {
        FileOutputStream fos = null;
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        try {
            fos = restrictionsFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_RESTRICTIONS);
            for (String key : restrictions.keySet()) {
                Object value = restrictions.get(key);
                serializer.startTag(null, TAG_ENTRY);
                serializer.attribute(null, ATTR_KEY, key);
                if (value instanceof Boolean) {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BOOLEAN);
                    serializer.text(value.toString());
                } else if (value == null || value instanceof String) {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING);
                    serializer.text(value != null ? (String)value : "");
                } else {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING_ARRAY);
                    String[] values = (String[])value;
                    serializer.attribute(null, ATTR_MULTIPLE, Integer.toString(values.length));
                    for (String choice : values) {
                        serializer.startTag(null, TAG_VALUE);
                        serializer.text(choice != null ? choice : "");
                        serializer.endTag(null, TAG_VALUE);
                    }
                }
                serializer.endTag(null, TAG_ENTRY);
            }
            serializer.endTag(null, TAG_RESTRICTIONS);
            serializer.endDocument();
            restrictionsFile.finishWrite(fos);
        }
        catch (Exception e) {
            restrictionsFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing application restrictions list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserSerialNumber(int userHandle) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (!this.exists(userHandle)) {
                return -1;
            }
            return this.getUserInfoLocked((int)userHandle).serialNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserHandle(int userSerialNumber) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            for (int userId : this.mUserIds) {
                if (this.getUserInfoLocked((int)userId).serialNumber != userSerialNumber) continue;
                return userId;
            }
            return -1;
        }
    }

    private void updateUserIdsLocked() {
        int num = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            ++num;
        }
        int[] newUsers = new int[num];
        int n = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            newUsers[n++] = this.mUsers.keyAt(i);
        }
        this.mUserIds = newUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userForeground(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            RestrictionsPinState pinState;
            UserInfo user = this.mUsers.get(userId);
            long now = System.currentTimeMillis();
            if (user == null || user.partial) {
                Slog.w(LOG_TAG, "userForeground: unknown user #" + userId);
                return;
            }
            if (now > 946080000000L) {
                user.lastLoggedInTime = now;
                this.writeUserLocked(user);
            }
            long salt = (pinState = this.mRestrictionsPinStates.get(userId)) == null ? 0L : pinState.salt;
            this.cleanAppRestrictions(userId, !user.isRestricted() && salt == 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextAvailableIdLocked() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            int i;
            for (i = 10; i < Integer.MAX_VALUE && (this.mUsers.indexOfKey(i) >= 0 || this.mRemovingUserIds.get(i)); ++i) {
            }
            return i;
        }
    }

    private String packageToRestrictionsFileName(String packageName) {
        return RESTRICTIONS_FILE_PREFIX + packageName + XML_SUFFIX;
    }

    private String restrictionsFileNameToPackage(String fileName) {
        return fileName.substring(RESTRICTIONS_FILE_PREFIX.length(), fileName.length() - XML_SUFFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UserManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Object object = this.mPackagesLock;
        synchronized (object) {
            pw.println("Users:");
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                if (user == null) continue;
                pw.print("  ");
                pw.print(user);
                pw.print(" serialNo=");
                pw.print(user.serialNumber);
                if (this.mRemovingUserIds.get(this.mUsers.keyAt(i))) {
                    pw.print(" <removing> ");
                }
                if (user.partial) {
                    pw.print(" <partial>");
                }
                pw.println();
                pw.print("    Created: ");
                if (user.creationTime == 0L) {
                    pw.println("<unknown>");
                } else {
                    sb.setLength(0);
                    TimeUtils.formatDuration(now - user.creationTime, sb);
                    sb.append(" ago");
                    pw.println(sb);
                }
                pw.print("    Last logged in: ");
                if (user.lastLoggedInTime == 0L) {
                    pw.println("<unknown>");
                    continue;
                }
                sb.setLength(0);
                TimeUtils.formatDuration(now - user.lastLoggedInTime, sb);
                sb.append(" ago");
                pw.println(sb);
            }
        }
    }

    class RestrictionsPinState {
        long salt;
        String pinHash;
        int failedAttempts;
        long lastAttemptTime;

        RestrictionsPinState() {
        }
    }
}

