/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.ServiceManager;
import android.util.Log;
import com.android.server.pm.PackageManagerService;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDexOptService
extends JobService {
    static final String TAG = "BackgroundDexOptService";
    static final int BACKGROUND_DEXOPT_JOB = 800;
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptService.class.getName());
    final AtomicBoolean mIdleTime = new AtomicBoolean(false);

    public static void schedule(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        JobInfo job = new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).build();
        js.schedule(job);
    }

    public boolean onStartJob(JobParameters params) {
        Log.i(TAG, "onIdleStart");
        final PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            return false;
        }
        final HashSet pkgs = pm.getPackagesThatNeedDexOpt();
        if (pkgs == null) {
            return false;
        }
        final JobParameters jobParams = params;
        this.mIdleTime.set(true);
        new Thread("BackgroundDexOptService_DexOpter"){

            @Override
            public void run() {
                for (String pkg : pkgs) {
                    if (!BackgroundDexOptService.this.mIdleTime.get()) {
                        BackgroundDexOptService.schedule((Context)((Object)BackgroundDexOptService.this));
                        return;
                    }
                    pm.performDexOpt(pkg, null, true);
                }
                BackgroundDexOptService.this.jobFinished(jobParams, false);
            }
        }.start();
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Log.i(TAG, "onIdleStop");
        this.mIdleTime.set(false);
        return false;
    }
}

