/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.IRemoteDisplayCallback;
import android.media.IRemoteDisplayProvider;
import android.media.RemoteDisplayState;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Objects;

final class RemoteDisplayProviderProxy
implements ServiceConnection {
    private static final String TAG = "RemoteDisplayProvider";
    private static final boolean DEBUG = Log.isLoggable("RemoteDisplayProvider", 3);
    private final Context mContext;
    private final ComponentName mComponentName;
    private final int mUserId;
    private final Handler mHandler;
    private Callback mDisplayStateCallback;
    private boolean mRunning;
    private boolean mBound;
    private Connection mActiveConnection;
    private boolean mConnectionReady;
    private int mDiscoveryMode;
    private String mSelectedDisplayId;
    private RemoteDisplayState mDisplayState;
    private boolean mScheduledDisplayStateChangedCallback;
    private final Runnable mDisplayStateChanged = new Runnable(){

        @Override
        public void run() {
            RemoteDisplayProviderProxy.this.mScheduledDisplayStateChangedCallback = false;
            if (RemoteDisplayProviderProxy.this.mDisplayStateCallback != null) {
                RemoteDisplayProviderProxy.this.mDisplayStateCallback.onDisplayStateChanged(RemoteDisplayProviderProxy.this, RemoteDisplayProviderProxy.this.mDisplayState);
            }
        }
    };

    public RemoteDisplayProviderProxy(Context context, ComponentName componentName, int userId) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mUserId = userId;
        this.mHandler = new Handler();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "Proxy");
        pw.println(prefix + "  mUserId=" + this.mUserId);
        pw.println(prefix + "  mRunning=" + this.mRunning);
        pw.println(prefix + "  mBound=" + this.mBound);
        pw.println(prefix + "  mActiveConnection=" + this.mActiveConnection);
        pw.println(prefix + "  mConnectionReady=" + this.mConnectionReady);
        pw.println(prefix + "  mDiscoveryMode=" + this.mDiscoveryMode);
        pw.println(prefix + "  mSelectedDisplayId=" + this.mSelectedDisplayId);
        pw.println(prefix + "  mDisplayState=" + this.mDisplayState);
    }

    public void setCallback(Callback callback) {
        this.mDisplayStateCallback = callback;
    }

    public RemoteDisplayState getDisplayState() {
        return this.mDisplayState;
    }

    public void setDiscoveryMode(int mode) {
        if (this.mDiscoveryMode != mode) {
            this.mDiscoveryMode = mode;
            if (this.mConnectionReady) {
                this.mActiveConnection.setDiscoveryMode(mode);
            }
            this.updateBinding();
        }
    }

    public void setSelectedDisplay(String id2) {
        if (!Objects.equals(this.mSelectedDisplayId, id2)) {
            if (this.mConnectionReady && this.mSelectedDisplayId != null) {
                this.mActiveConnection.disconnect(this.mSelectedDisplayId);
            }
            this.mSelectedDisplayId = id2;
            if (this.mConnectionReady && id2 != null) {
                this.mActiveConnection.connect(id2);
            }
            this.updateBinding();
        }
    }

    public void setDisplayVolume(int volume) {
        if (this.mConnectionReady && this.mSelectedDisplayId != null) {
            this.mActiveConnection.setVolume(this.mSelectedDisplayId, volume);
        }
    }

    public void adjustDisplayVolume(int delta) {
        if (this.mConnectionReady && this.mSelectedDisplayId != null) {
            this.mActiveConnection.adjustVolume(this.mSelectedDisplayId, delta);
        }
    }

    public boolean hasComponentName(String packageName, String className) {
        return this.mComponentName.getPackageName().equals(packageName) && this.mComponentName.getClassName().equals(className);
    }

    public String getFlattenedComponentName() {
        return this.mComponentName.flattenToShortString();
    }

    public void start() {
        if (!this.mRunning) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Starting");
            }
            this.mRunning = true;
            this.updateBinding();
        }
    }

    public void stop() {
        if (this.mRunning) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Stopping");
            }
            this.mRunning = false;
            this.updateBinding();
        }
    }

    public void rebindIfDisconnected() {
        if (this.mActiveConnection == null && this.shouldBind()) {
            this.unbind();
            this.bind();
        }
    }

    private void updateBinding() {
        if (this.shouldBind()) {
            this.bind();
        } else {
            this.unbind();
        }
    }

    private boolean shouldBind() {
        return this.mRunning && (this.mDiscoveryMode != 0 || this.mSelectedDisplayId != null);
    }

    private void bind() {
        block5: {
            if (!this.mBound) {
                if (DEBUG) {
                    Slog.d(TAG, this + ": Binding");
                }
                Intent service = new Intent("com.android.media.remotedisplay.RemoteDisplayProvider");
                service.setComponent(this.mComponentName);
                try {
                    this.mBound = this.mContext.bindServiceAsUser(service, this, 1, new UserHandle(this.mUserId));
                    if (!this.mBound && DEBUG) {
                        Slog.d(TAG, this + ": Bind failed");
                    }
                }
                catch (SecurityException ex) {
                    if (!DEBUG) break block5;
                    Slog.d(TAG, this + ": Bind failed", ex);
                }
            }
        }
    }

    private void unbind() {
        if (this.mBound) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Unbinding");
            }
            this.mBound = false;
            this.disconnect();
            this.mContext.unbindService(this);
        }
    }

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        if (DEBUG) {
            Slog.d(TAG, this + ": Connected");
        }
        if (this.mBound) {
            this.disconnect();
            IRemoteDisplayProvider provider = IRemoteDisplayProvider.Stub.asInterface((IBinder)service);
            if (provider != null) {
                Connection connection = new Connection(provider);
                if (connection.register()) {
                    this.mActiveConnection = connection;
                } else if (DEBUG) {
                    Slog.d(TAG, this + ": Registration failed");
                }
            } else {
                Slog.e(TAG, this + ": Service returned invalid remote display provider binder");
            }
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        if (DEBUG) {
            Slog.d(TAG, this + ": Service disconnected");
        }
        this.disconnect();
    }

    private void onConnectionReady(Connection connection) {
        if (this.mActiveConnection == connection) {
            this.mConnectionReady = true;
            if (this.mDiscoveryMode != 0) {
                this.mActiveConnection.setDiscoveryMode(this.mDiscoveryMode);
            }
            if (this.mSelectedDisplayId != null) {
                this.mActiveConnection.connect(this.mSelectedDisplayId);
            }
        }
    }

    private void onConnectionDied(Connection connection) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Service connection died");
            }
            this.disconnect();
        }
    }

    private void onDisplayStateChanged(Connection connection, RemoteDisplayState state) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Slog.d(TAG, this + ": State changed, state=" + state);
            }
            this.setDisplayState(state);
        }
    }

    private void disconnect() {
        if (this.mActiveConnection != null) {
            if (this.mSelectedDisplayId != null) {
                this.mActiveConnection.disconnect(this.mSelectedDisplayId);
            }
            this.mConnectionReady = false;
            this.mActiveConnection.dispose();
            this.mActiveConnection = null;
            this.setDisplayState(null);
        }
    }

    private void setDisplayState(RemoteDisplayState state) {
        if (!Objects.equals(this.mDisplayState, state)) {
            this.mDisplayState = state;
            if (!this.mScheduledDisplayStateChangedCallback) {
                this.mScheduledDisplayStateChangedCallback = true;
                this.mHandler.post(this.mDisplayStateChanged);
            }
        }
    }

    public String toString() {
        return "Service connection " + this.mComponentName.flattenToShortString();
    }

    private static final class ProviderCallback
    extends IRemoteDisplayCallback.Stub {
        private final WeakReference<Connection> mConnectionRef;

        public ProviderCallback(Connection connection) {
            this.mConnectionRef = new WeakReference<Connection>(connection);
        }

        public void dispose() {
            this.mConnectionRef.clear();
        }

        public void onStateChanged(RemoteDisplayState state) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.postStateChanged(state);
            }
        }
    }

    private final class Connection
    implements IBinder.DeathRecipient {
        private final IRemoteDisplayProvider mProvider;
        private final ProviderCallback mCallback;

        public Connection(IRemoteDisplayProvider provider) {
            this.mProvider = provider;
            this.mCallback = new ProviderCallback(this);
        }

        public boolean register() {
            try {
                this.mProvider.asBinder().linkToDeath(this, 0);
                this.mProvider.setCallback((IRemoteDisplayCallback)this.mCallback);
                RemoteDisplayProviderProxy.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        RemoteDisplayProviderProxy.this.onConnectionReady(Connection.this);
                    }
                });
                return true;
            }
            catch (RemoteException ex) {
                this.binderDied();
                return false;
            }
        }

        public void dispose() {
            this.mProvider.asBinder().unlinkToDeath(this, 0);
            this.mCallback.dispose();
        }

        public void setDiscoveryMode(int mode) {
            try {
                this.mProvider.setDiscoveryMode(mode);
            }
            catch (RemoteException ex) {
                Slog.e(RemoteDisplayProviderProxy.TAG, "Failed to deliver request to set discovery mode.", ex);
            }
        }

        public void connect(String id2) {
            try {
                this.mProvider.connect(id2);
            }
            catch (RemoteException ex) {
                Slog.e(RemoteDisplayProviderProxy.TAG, "Failed to deliver request to connect to display.", ex);
            }
        }

        public void disconnect(String id2) {
            try {
                this.mProvider.disconnect(id2);
            }
            catch (RemoteException ex) {
                Slog.e(RemoteDisplayProviderProxy.TAG, "Failed to deliver request to disconnect from display.", ex);
            }
        }

        public void setVolume(String id2, int volume) {
            try {
                this.mProvider.setVolume(id2, volume);
            }
            catch (RemoteException ex) {
                Slog.e(RemoteDisplayProviderProxy.TAG, "Failed to deliver request to set display volume.", ex);
            }
        }

        public void adjustVolume(String id2, int volume) {
            try {
                this.mProvider.adjustVolume(id2, volume);
            }
            catch (RemoteException ex) {
                Slog.e(RemoteDisplayProviderProxy.TAG, "Failed to deliver request to adjust display volume.", ex);
            }
        }

        @Override
        public void binderDied() {
            RemoteDisplayProviderProxy.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RemoteDisplayProviderProxy.this.onConnectionDied(Connection.this);
                }
            });
        }

        void postStateChanged(final RemoteDisplayState state) {
            RemoteDisplayProviderProxy.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RemoteDisplayProviderProxy.this.onDisplayStateChanged(Connection.this, state);
                }
            });
        }
    }

    public static interface Callback {
        public void onDisplayStateChanged(RemoteDisplayProviderProxy var1, RemoteDisplayState var2);
    }
}

