/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.RoutingControlAction;

final class ActiveSourceHandler {
    private static final String TAG = "ActiveSourceHandler";
    private final HdmiCecLocalDeviceTv mSource;
    private final HdmiControlService mService;
    private final IHdmiControlCallback mCallback;

    static ActiveSourceHandler create(HdmiCecLocalDeviceTv source, IHdmiControlCallback callback) {
        if (source == null) {
            Slog.e(TAG, "Wrong arguments");
            return null;
        }
        return new ActiveSourceHandler(source, callback);
    }

    private ActiveSourceHandler(HdmiCecLocalDeviceTv source, IHdmiControlCallback callback) {
        this.mSource = source;
        this.mService = this.mSource.getService();
        this.mCallback = callback;
    }

    void process(HdmiCecLocalDevice.ActiveSource newActive) {
        HdmiCecLocalDeviceTv tv = this.mSource;
        HdmiCecLocalDevice.ActiveSource activeSource = tv.getActiveSource();
        if (activeSource.equals(newActive)) {
            this.invokeCallback(0);
            return;
        }
        HdmiDeviceInfo device = this.mService.getDeviceInfo(newActive.logicalAddress);
        if (device == null) {
            tv.startNewDeviceAction(newActive);
        }
        if (!tv.isProhibitMode()) {
            tv.updateActiveSource(newActive);
            boolean notifyInputChange = this.mCallback == null;
            tv.updateActiveInput(newActive.physicalAddress, notifyInputChange);
            this.invokeCallback(0);
        } else {
            HdmiCecLocalDevice.ActiveSource current = tv.getActiveSource();
            if (current.logicalAddress == this.getSourceAddress()) {
                HdmiCecMessage activeSourceCommand = HdmiCecMessageBuilder.buildActiveSource(current.logicalAddress, current.physicalAddress);
                this.mService.sendCecCommand(activeSourceCommand);
                tv.updateActiveSource(current);
                this.invokeCallback(0);
            } else {
                HdmiCecMessage routingChange = HdmiCecMessageBuilder.buildRoutingChange(this.getSourceAddress(), newActive.physicalAddress, current.physicalAddress);
                this.mService.sendCecCommand(routingChange);
                tv.addAndStartAction(new RoutingControlAction(tv, current.physicalAddress, true, this.mCallback));
            }
        }
    }

    private final int getSourceAddress() {
        return this.mSource.getDeviceInfo().getLogicalAddress();
    }

    private void invokeCallback(int result) {
        if (this.mCallback == null) {
            return;
        }
        try {
            this.mCallback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Callback failed:" + e);
        }
    }
}

