/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.WifiDisplayStatus;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayInfo;
import android.view.Surface;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.UiThread;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayTransactionListener;
import com.android.server.display.DisplayViewport;
import com.android.server.display.HeadlessDisplayAdapter;
import com.android.server.display.LocalDisplayAdapter;
import com.android.server.display.LogicalDisplay;
import com.android.server.display.OverlayDisplayAdapter;
import com.android.server.display.PersistentDataStore;
import com.android.server.display.VirtualDisplayAdapter;
import com.android.server.display.WifiDisplayAdapter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DisplayManagerService
extends IDisplayManager.Stub {
    private static final String TAG = "DisplayManagerService";
    private static final boolean DEBUG = false;
    private static final String FORCE_WIFI_DISPLAY_ENABLE = "persist.debug.wfd.enable";
    private static final String SYSTEM_HEADLESS = "ro.config.headless";
    private static final long WAIT_FOR_DEFAULT_DISPLAY_TIMEOUT = 10000L;
    private static final int MSG_REGISTER_DEFAULT_DISPLAY_ADAPTER = 1;
    private static final int MSG_REGISTER_ADDITIONAL_DISPLAY_ADAPTERS = 2;
    private static final int MSG_DELIVER_DISPLAY_EVENT = 3;
    private static final int MSG_REQUEST_TRAVERSAL = 4;
    private static final int MSG_UPDATE_VIEWPORT = 5;
    private static final int DISPLAY_BLANK_STATE_UNKNOWN = 0;
    private static final int DISPLAY_BLANK_STATE_BLANKED = 1;
    private static final int DISPLAY_BLANK_STATE_UNBLANKED = 2;
    private final Context mContext;
    private final boolean mHeadless;
    private final DisplayManagerHandler mHandler;
    private final Handler mUiHandler;
    private final DisplayAdapterListener mDisplayAdapterListener;
    private WindowManagerFuncs mWindowManagerFuncs;
    private InputManagerFuncs mInputManagerFuncs;
    private final SyncRoot mSyncRoot = new SyncRoot();
    public boolean mSafeMode;
    public boolean mOnlyCore;
    private final boolean mSingleDisplayDemoMode;
    public final SparseArray<CallbackRecord> mCallbacks = new SparseArray();
    private final ArrayList<DisplayAdapter> mDisplayAdapters = new ArrayList();
    private final ArrayList<DisplayDevice> mDisplayDevices = new ArrayList();
    private final SparseArray<LogicalDisplay> mLogicalDisplays = new SparseArray();
    private int mNextNonDefaultDisplayId = 1;
    private final CopyOnWriteArrayList<DisplayTransactionListener> mDisplayTransactionListeners = new CopyOnWriteArrayList();
    private int mAllDisplayBlankStateFromPowerManager = 0;
    private boolean mPendingTraversal;
    private WifiDisplayAdapter mWifiDisplayAdapter;
    private VirtualDisplayAdapter mVirtualDisplayAdapter;
    private final DisplayViewport mDefaultViewport = new DisplayViewport();
    private final DisplayViewport mExternalTouchViewport = new DisplayViewport();
    private final PersistentDataStore mPersistentDataStore = new PersistentDataStore();
    private final ArrayList<CallbackRecord> mTempCallbacks = new ArrayList();
    private final DisplayInfo mTempDisplayInfo = new DisplayInfo();
    private final DisplayViewport mTempDefaultViewport = new DisplayViewport();
    private final DisplayViewport mTempExternalTouchViewport = new DisplayViewport();

    public DisplayManagerService(Context context, Handler mainHandler) {
        this.mContext = context;
        this.mHeadless = SystemProperties.get(SYSTEM_HEADLESS).equals("1");
        this.mHandler = new DisplayManagerHandler(mainHandler.getLooper());
        this.mUiHandler = UiThread.getHandler();
        this.mDisplayAdapterListener = new DisplayAdapterListener();
        this.mSingleDisplayDemoMode = SystemProperties.getBoolean("persist.demo.singledisplay", false);
        this.mHandler.sendEmptyMessage(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDefaultDisplay() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            long timeout = SystemClock.uptimeMillis() + 10000L;
            while (this.mLogicalDisplays.get(0) == null) {
                long delay = timeout - SystemClock.uptimeMillis();
                if (delay <= 0L) {
                    return false;
                }
                try {
                    this.mSyncRoot.wait(delay);
                }
                catch (InterruptedException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowManager(WindowManagerFuncs windowManagerFuncs) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mWindowManagerFuncs = windowManagerFuncs;
            this.scheduleTraversalLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputManager(InputManagerFuncs inputManagerFuncs) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mInputManagerFuncs = inputManagerFuncs;
            this.scheduleTraversalLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(boolean safeMode, boolean onlyCore) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mSafeMode = safeMode;
            this.mOnlyCore = onlyCore;
        }
        this.mHandler.sendEmptyMessage(2);
    }

    public boolean isHeadless() {
        return this.mHeadless;
    }

    public void registerDisplayTransactionListener(DisplayTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mDisplayTransactionListeners.add(listener);
    }

    public void unregisterDisplayTransactionListener(DisplayTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mDisplayTransactionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayInfoOverrideFromWindowManager(int displayId, DisplayInfo info) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && display.setDisplayInfoOverrideFromWindowManagerLocked(info)) {
                this.sendDisplayEventLocked(displayId, 2);
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTraversalInTransactionFromWindowManager() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (!this.mPendingTraversal) {
                return;
            }
            this.mPendingTraversal = false;
            this.performTraversalInTransactionLocked();
        }
        for (DisplayTransactionListener listener : this.mDisplayTransactionListeners) {
            listener.onDisplayTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blankAllDisplaysFromPowerManager() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mAllDisplayBlankStateFromPowerManager != 1) {
                this.mAllDisplayBlankStateFromPowerManager = 1;
                this.updateAllDisplayBlankingLocked();
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblankAllDisplaysFromPowerManager() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mAllDisplayBlankStateFromPowerManager != 2) {
                this.mAllDisplayBlankStateFromPowerManager = 2;
                this.updateAllDisplayBlankingLocked();
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DisplayInfo getDisplayInfo(int displayId) {
        long token;
        block6: {
            DisplayInfo displayInfo;
            int callingUid = Binder.getCallingUid();
            token = Binder.clearCallingIdentity();
            try {
                DisplayInfo info;
                SyncRoot syncRoot = this.mSyncRoot;
                // MONITORENTER : syncRoot
                LogicalDisplay display = this.mLogicalDisplays.get(displayId);
                if (display == null || !(info = display.getDisplayInfoLocked()).hasAccess(callingUid)) break block6;
                displayInfo = info;
                // MONITOREXIT : syncRoot
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            return displayInfo;
        }
        DisplayInfo displayInfo = null;
        // MONITOREXIT : syncRoot
        Binder.restoreCallingIdentity(token);
        return displayInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDisplayIds() {
        int callingUid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                int count = this.mLogicalDisplays.size();
                int[] displayIds = new int[count];
                int n = 0;
                for (int i = 0; i < count; ++i) {
                    LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
                    DisplayInfo info = display.getDisplayInfoLocked();
                    if (!info.hasAccess(callingUid)) continue;
                    displayIds[n++] = this.mLogicalDisplays.keyAt(i);
                }
                if (n != count) {
                    displayIds = Arrays.copyOfRange(displayIds, 0, n);
                }
                int[] nArray = displayIds;
                return nArray;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(IDisplayManagerCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            int callingPid = Binder.getCallingPid();
            if (this.mCallbacks.get(callingPid) != null) {
                throw new SecurityException("The calling process has already registered an IDisplayManagerCallback.");
            }
            CallbackRecord record = new CallbackRecord(callingPid, callback);
            try {
                IBinder binder = callback.asBinder();
                binder.linkToDeath(record, 0);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
            this.mCallbacks.put(callingPid, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallbackDied(int pid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mCallbacks.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanWifiDisplays() {
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestScanLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWifiDisplay(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        boolean trusted = this.canCallerConfigureWifiDisplay();
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestConnectLocked(address, trusted);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWifiDisplay() {
        if (this.mContext.checkCallingPermission("android.permission.CONFIGURE_WIFI_DISPLAY") != 0) {
            throw new SecurityException("Requires CONFIGURE_WIFI_DISPLAYpermission to pause a wifi display session.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestPauseLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWifiDisplay() {
        if (this.mContext.checkCallingPermission("android.permission.CONFIGURE_WIFI_DISPLAY") != 0) {
            throw new SecurityException("Requires CONFIGURE_WIFI_DISPLAYpermission to resume a wifi display session.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestResumeLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectWifiDisplay() {
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestDisconnectLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameWifiDisplay(String address, String alias) {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        if (!this.canCallerConfigureWifiDisplay()) {
            throw new SecurityException("Requires CONFIGURE_WIFI_DISPLAY permission to rename a wifi display.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestRenameLocked(address, alias);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetWifiDisplay(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        if (!this.canCallerConfigureWifiDisplay()) {
            throw new SecurityException("Requires CONFIGURE_WIFI_DISPLAY permission to forget a wifi display.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestForgetLocked(address);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WifiDisplayStatus getWifiDisplayStatus() {
        long token;
        block6: {
            WifiDisplayStatus wifiDisplayStatus;
            token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = this.mSyncRoot;
                // MONITORENTER : syncRoot
                if (this.mWifiDisplayAdapter == null) break block6;
                wifiDisplayStatus = this.mWifiDisplayAdapter.getWifiDisplayStatusLocked();
                // MONITOREXIT : syncRoot
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            return wifiDisplayStatus;
        }
        WifiDisplayStatus wifiDisplayStatus = new WifiDisplayStatus();
        // MONITOREXIT : syncRoot
        Binder.restoreCallingIdentity(token);
        return wifiDisplayStatus;
    }

    private boolean canCallerConfigureWifiDisplay() {
        return this.mContext.checkCallingPermission("android.permission.CONFIGURE_WIFI_DISPLAY") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int createVirtualDisplay(IBinder appToken, String packageName, String name, int width, int height, int densityDpi, Surface surface, int flags) {
        long token;
        int callingUid;
        block18: {
            callingUid = Binder.getCallingUid();
            if (!this.validatePackageName(callingUid, packageName)) {
                throw new SecurityException("packageName must match the calling uid");
            }
            if (appToken == null) {
                throw new IllegalArgumentException("appToken must not be null");
            }
            if (TextUtils.isEmpty(name)) {
                throw new IllegalArgumentException("name must be non-null and non-empty");
            }
            if (width <= 0) throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            if (height <= 0) throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            if (densityDpi <= 0) {
                throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            }
            if (surface == null) {
                throw new IllegalArgumentException("surface must not be null");
            }
            if ((flags & 1) != 0 && this.mContext.checkCallingPermission("android.permission.CAPTURE_VIDEO_OUTPUT") != 0 && this.mContext.checkCallingPermission("android.permission.CAPTURE_SECURE_VIDEO_OUTPUT") != 0) {
                throw new SecurityException("Requires CAPTURE_VIDEO_OUTPUT or CAPTURE_SECURE_VIDEO_OUTPUT permission to create a public virtual display.");
            }
            if ((flags & 4) != 0 && this.mContext.checkCallingPermission("android.permission.CAPTURE_SECURE_VIDEO_OUTPUT") != 0) {
                throw new SecurityException("Requires CAPTURE_SECURE_VIDEO_OUTPUT to create a secure virtual display.");
            }
            token = Binder.clearCallingIdentity();
            SyncRoot syncRoot = this.mSyncRoot;
            // MONITORENTER : syncRoot
            if (this.mVirtualDisplayAdapter != null) break block18;
            Slog.w(TAG, "Rejecting request to create private virtual display because the virtual display adapter is not available.");
            int n = -1;
            // MONITOREXIT : syncRoot
            Binder.restoreCallingIdentity(token);
            return n;
        }
        DisplayDevice device = this.mVirtualDisplayAdapter.createVirtualDisplayLocked(appToken, callingUid, packageName, name, width, height, densityDpi, surface, flags);
        if (device == null) {
            int n = -1;
            // MONITOREXIT : syncRoot
            Binder.restoreCallingIdentity(token);
            return n;
        }
        this.handleDisplayDeviceAddedLocked(device);
        LogicalDisplay display = this.findLogicalDisplayForDeviceLocked(device);
        if (display != null) {
            int n = display.getDisplayIdLocked();
            // MONITOREXIT : syncRoot
            Binder.restoreCallingIdentity(token);
            return n;
        }
        try {
            Slog.w(TAG, "Rejecting request to create virtual display because the logical display was not created.");
            this.mVirtualDisplayAdapter.releaseVirtualDisplayLocked(appToken);
            this.handleDisplayDeviceRemovedLocked(device);
            // MONITOREXIT : syncRoot
            return -1;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseVirtualDisplay(IBinder appToken) {
        long token = Binder.clearCallingIdentity();
        try {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                block9: {
                    if (this.mVirtualDisplayAdapter != null) break block9;
                    return;
                }
                DisplayDevice device = this.mVirtualDisplayAdapter.releaseVirtualDisplayLocked(appToken);
                if (device != null) {
                    this.handleDisplayDeviceRemovedLocked(device);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean validatePackageName(int uid, String packageName) {
        String[] packageNames;
        if (packageName != null && (packageNames = this.mContext.getPackageManager().getPackagesForUid(uid)) != null) {
            for (String n : packageNames) {
                if (!n.equals(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDefaultDisplayAdapter() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mHeadless) {
                this.registerDisplayAdapterLocked(new HeadlessDisplayAdapter(this.mSyncRoot, this.mContext, this.mHandler, this.mDisplayAdapterListener));
            } else {
                this.registerDisplayAdapterLocked(new LocalDisplayAdapter(this.mSyncRoot, this.mContext, this.mHandler, this.mDisplayAdapterListener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdditionalDisplayAdapters() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.shouldRegisterNonEssentialDisplayAdaptersLocked()) {
                this.registerOverlayDisplayAdapterLocked();
                this.registerWifiDisplayAdapterLocked();
                this.registerVirtualDisplayAdapterLocked();
            }
        }
    }

    private void registerOverlayDisplayAdapterLocked() {
        this.registerDisplayAdapterLocked(new OverlayDisplayAdapter(this.mSyncRoot, this.mContext, (Handler)this.mHandler, (DisplayAdapter.Listener)this.mDisplayAdapterListener, this.mUiHandler));
    }

    private void registerWifiDisplayAdapterLocked() {
        if (this.mContext.getResources().getBoolean(17891407) || SystemProperties.getInt(FORCE_WIFI_DISPLAY_ENABLE, -1) == 1) {
            this.mWifiDisplayAdapter = new WifiDisplayAdapter(this.mSyncRoot, this.mContext, (Handler)this.mHandler, (DisplayAdapter.Listener)this.mDisplayAdapterListener, this.mPersistentDataStore);
            this.registerDisplayAdapterLocked(this.mWifiDisplayAdapter);
        }
    }

    private void registerVirtualDisplayAdapterLocked() {
        this.mVirtualDisplayAdapter = new VirtualDisplayAdapter(this.mSyncRoot, this.mContext, this.mHandler, this.mDisplayAdapterListener);
        this.registerDisplayAdapterLocked(this.mVirtualDisplayAdapter);
    }

    private boolean shouldRegisterNonEssentialDisplayAdaptersLocked() {
        return !this.mSafeMode && !this.mOnlyCore;
    }

    private void registerDisplayAdapterLocked(DisplayAdapter adapter) {
        this.mDisplayAdapters.add(adapter);
        adapter.registerLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceAdded(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.handleDisplayDeviceAddedLocked(device);
        }
    }

    private void handleDisplayDeviceAddedLocked(DisplayDevice device) {
        if (this.mDisplayDevices.contains(device)) {
            Slog.w(TAG, "Attempted to add already added display device: " + device.getDisplayDeviceInfoLocked());
            return;
        }
        Slog.i(TAG, "Display device added: " + device.getDisplayDeviceInfoLocked());
        this.mDisplayDevices.add(device);
        this.addLogicalDisplayLocked(device);
        this.updateDisplayBlankingLocked(device);
        this.scheduleTraversalLocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceChanged(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (!this.mDisplayDevices.contains(device)) {
                Slog.w(TAG, "Attempted to change non-existent display device: " + device.getDisplayDeviceInfoLocked());
                return;
            }
            Slog.i(TAG, "Display device changed: " + device.getDisplayDeviceInfoLocked());
            device.applyPendingDisplayDeviceInfoChangesLocked();
            if (this.updateLogicalDisplaysLocked()) {
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceRemoved(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.handleDisplayDeviceRemovedLocked(device);
        }
    }

    private void handleDisplayDeviceRemovedLocked(DisplayDevice device) {
        if (!this.mDisplayDevices.remove(device)) {
            Slog.w(TAG, "Attempted to remove non-existent display device: " + device.getDisplayDeviceInfoLocked());
            return;
        }
        Slog.i(TAG, "Display device removed: " + device.getDisplayDeviceInfoLocked());
        this.updateLogicalDisplaysLocked();
        this.scheduleTraversalLocked(false);
    }

    private void updateAllDisplayBlankingLocked() {
        int count = this.mDisplayDevices.size();
        for (int i = 0; i < count; ++i) {
            DisplayDevice device = this.mDisplayDevices.get(i);
            this.updateDisplayBlankingLocked(device);
        }
    }

    private void updateDisplayBlankingLocked(DisplayDevice device) {
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        if ((info.flags & 0x20) == 0) {
            switch (this.mAllDisplayBlankStateFromPowerManager) {
                case 1: {
                    device.blankLocked();
                    break;
                }
                case 2: {
                    device.unblankLocked();
                }
            }
        }
    }

    private void addLogicalDisplayLocked(DisplayDevice device) {
        boolean isDefault;
        DisplayDeviceInfo deviceInfo = device.getDisplayDeviceInfoLocked();
        boolean bl = isDefault = (deviceInfo.flags & 1) != 0;
        if (isDefault && this.mLogicalDisplays.get(0) != null) {
            Slog.w(TAG, "Ignoring attempt to add a second default display: " + deviceInfo);
            isDefault = false;
        }
        if (!isDefault && this.mSingleDisplayDemoMode) {
            Slog.i(TAG, "Not creating a logical display for a secondary display  because single display demo mode is enabled: " + deviceInfo);
            return;
        }
        int displayId = this.assignDisplayIdLocked(isDefault);
        int layerStack = this.assignLayerStackLocked(displayId);
        LogicalDisplay display = new LogicalDisplay(displayId, layerStack, device);
        display.updateLocked(this.mDisplayDevices);
        if (!display.isValidLocked()) {
            Slog.w(TAG, "Ignoring display device because the logical display created from it was not considered valid: " + deviceInfo);
            return;
        }
        this.mLogicalDisplays.put(displayId, display);
        if (isDefault) {
            this.mSyncRoot.notifyAll();
        }
        this.sendDisplayEventLocked(displayId, 1);
    }

    private int assignDisplayIdLocked(boolean isDefault) {
        int n;
        if (isDefault) {
            n = 0;
        } else {
            int n2 = this.mNextNonDefaultDisplayId;
            n = n2;
            this.mNextNonDefaultDisplayId = n2 + 1;
        }
        return n;
    }

    private int assignLayerStackLocked(int displayId) {
        return displayId;
    }

    private boolean updateLogicalDisplaysLocked() {
        boolean changed = false;
        int i = this.mLogicalDisplays.size();
        while (i-- > 0) {
            int displayId = this.mLogicalDisplays.keyAt(i);
            LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
            this.mTempDisplayInfo.copyFrom(display.getDisplayInfoLocked());
            display.updateLocked(this.mDisplayDevices);
            if (!display.isValidLocked()) {
                this.mLogicalDisplays.removeAt(i);
                this.sendDisplayEventLocked(displayId, 3);
                changed = true;
                continue;
            }
            if (this.mTempDisplayInfo.equals(display.getDisplayInfoLocked())) continue;
            this.sendDisplayEventLocked(displayId, 2);
            changed = true;
        }
        return changed;
    }

    private void performTraversalInTransactionLocked() {
        this.clearViewportsLocked();
        int count = this.mDisplayDevices.size();
        for (int i = 0; i < count; ++i) {
            DisplayDevice device = this.mDisplayDevices.get(i);
            this.configureDisplayInTransactionLocked(device);
            device.performTraversalInTransactionLocked();
        }
        if (this.mInputManagerFuncs != null) {
            this.mHandler.sendEmptyMessage(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayHasContent(int displayId, boolean hasContent, boolean inTraversal) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && display.hasContentLocked() != hasContent) {
                display.setHasContentLocked(hasContent);
                this.scheduleTraversalLocked(inTraversal);
            }
        }
    }

    private void clearViewportsLocked() {
        this.mDefaultViewport.valid = false;
        this.mExternalTouchViewport.valid = false;
    }

    private void configureDisplayInTransactionLocked(DisplayDevice device) {
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        boolean isPrivate = (info.flags & 0x10) != 0;
        LogicalDisplay display = this.findLogicalDisplayForDeviceLocked(device);
        if (!isPrivate) {
            if (display != null && !display.hasContentLocked()) {
                display = null;
            }
            if (display == null) {
                display = this.mLogicalDisplays.get(0);
            }
        }
        if (display == null) {
            Slog.w(TAG, "Missing logical display to use for physical display device: " + device.getDisplayDeviceInfoLocked());
            return;
        }
        boolean isBlanked = this.mAllDisplayBlankStateFromPowerManager == 1 && (info.flags & 0x20) == 0;
        display.configureDisplayInTransactionLocked(device, isBlanked);
        if (!this.mDefaultViewport.valid && (info.flags & 1) != 0) {
            DisplayManagerService.setViewportLocked(this.mDefaultViewport, display, device);
        }
        if (!this.mExternalTouchViewport.valid && info.touch == 2) {
            DisplayManagerService.setViewportLocked(this.mExternalTouchViewport, display, device);
        }
    }

    private static void setViewportLocked(DisplayViewport viewport, LogicalDisplay display, DisplayDevice device) {
        viewport.valid = true;
        viewport.displayId = display.getDisplayIdLocked();
        device.populateViewportLocked(viewport);
    }

    private LogicalDisplay findLogicalDisplayForDeviceLocked(DisplayDevice device) {
        int count = this.mLogicalDisplays.size();
        for (int i = 0; i < count; ++i) {
            LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
            if (display.getPrimaryDisplayDeviceLocked() != device) continue;
            return display;
        }
        return null;
    }

    private void sendDisplayEventLocked(int displayId, int event) {
        Message msg = this.mHandler.obtainMessage(3, displayId, event);
        this.mHandler.sendMessage(msg);
    }

    private void scheduleTraversalLocked(boolean inTraversal) {
        if (!this.mPendingTraversal && this.mWindowManagerFuncs != null) {
            this.mPendingTraversal = true;
            if (!inTraversal) {
                this.mHandler.sendEmptyMessage(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverDisplayEvent(int displayId, int event) {
        int count;
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            count = this.mCallbacks.size();
            this.mTempCallbacks.clear();
            for (int i = 0; i < count; ++i) {
                this.mTempCallbacks.add(this.mCallbacks.valueAt(i));
            }
        }
        for (int i = 0; i < count; ++i) {
            this.mTempCallbacks.get(i).notifyDisplayEventAsync(displayId, event);
        }
        this.mTempCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext == null || this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DisplayManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("DISPLAY MANAGER (dumpsys display)");
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            pw.println("  mHeadless=" + this.mHeadless);
            pw.println("  mOnlyCode=" + this.mOnlyCore);
            pw.println("  mSafeMode=" + this.mSafeMode);
            pw.println("  mPendingTraversal=" + this.mPendingTraversal);
            pw.println("  mAllDisplayBlankStateFromPowerManager=" + this.mAllDisplayBlankStateFromPowerManager);
            pw.println("  mNextNonDefaultDisplayId=" + this.mNextNonDefaultDisplayId);
            pw.println("  mDefaultViewport=" + this.mDefaultViewport);
            pw.println("  mExternalTouchViewport=" + this.mExternalTouchViewport);
            pw.println("  mSingleDisplayDemoMode=" + this.mSingleDisplayDemoMode);
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "    ");
            ipw.increaseIndent();
            pw.println();
            pw.println("Display Adapters: size=" + this.mDisplayAdapters.size());
            for (DisplayAdapter adapter : this.mDisplayAdapters) {
                pw.println("  " + adapter.getName());
                adapter.dumpLocked(ipw);
            }
            pw.println();
            pw.println("Display Devices: size=" + this.mDisplayDevices.size());
            for (DisplayDevice device : this.mDisplayDevices) {
                pw.println("  " + device.getDisplayDeviceInfoLocked());
                device.dumpLocked(ipw);
            }
            int logicalDisplayCount = this.mLogicalDisplays.size();
            pw.println();
            pw.println("Logical Displays: size=" + logicalDisplayCount);
            for (int i = 0; i < logicalDisplayCount; ++i) {
                int displayId = this.mLogicalDisplays.keyAt(i);
                LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
                pw.println("  Display " + displayId + ":");
                display.dumpLocked(ipw);
            }
        }
    }

    private final class CallbackRecord
    implements IBinder.DeathRecipient {
        private final int mPid;
        private final IDisplayManagerCallback mCallback;

        public CallbackRecord(int pid, IDisplayManagerCallback callback) {
            this.mPid = pid;
            this.mCallback = callback;
        }

        public void binderDied() {
            DisplayManagerService.this.onCallbackDied(this.mPid);
        }

        public void notifyDisplayEventAsync(int displayId, int event) {
            try {
                this.mCallback.onDisplayEvent(displayId, event);
            }
            catch (RemoteException ex) {
                Slog.w(DisplayManagerService.TAG, "Failed to notify process " + this.mPid + " that displays changed, assuming it died.", ex);
                this.binderDied();
            }
        }
    }

    private final class DisplayAdapterListener
    implements DisplayAdapter.Listener {
        private DisplayAdapterListener() {
        }

        public void onDisplayDeviceEvent(DisplayDevice device, int event) {
            switch (event) {
                case 1: {
                    DisplayManagerService.this.handleDisplayDeviceAdded(device);
                    break;
                }
                case 2: {
                    DisplayManagerService.this.handleDisplayDeviceChanged(device);
                    break;
                }
                case 3: {
                    DisplayManagerService.this.handleDisplayDeviceRemoved(device);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTraversalRequested() {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                DisplayManagerService.this.scheduleTraversalLocked(false);
            }
        }
    }

    private final class DisplayManagerHandler
    extends Handler {
        public DisplayManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayManagerService.this.registerDefaultDisplayAdapter();
                    break;
                }
                case 2: {
                    DisplayManagerService.this.registerAdditionalDisplayAdapters();
                    break;
                }
                case 3: {
                    DisplayManagerService.this.deliverDisplayEvent(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    DisplayManagerService.this.mWindowManagerFuncs.requestTraversal();
                    break;
                }
                case 5: {
                    SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                    synchronized (syncRoot) {
                        DisplayManagerService.this.mTempDefaultViewport.copyFrom(DisplayManagerService.this.mDefaultViewport);
                        DisplayManagerService.this.mTempExternalTouchViewport.copyFrom(DisplayManagerService.this.mExternalTouchViewport);
                    }
                    DisplayManagerService.this.mInputManagerFuncs.setDisplayViewports(DisplayManagerService.this.mTempDefaultViewport, DisplayManagerService.this.mTempExternalTouchViewport);
                }
            }
        }
    }

    public static interface InputManagerFuncs {
        public void setDisplayViewports(DisplayViewport var1, DisplayViewport var2);
    }

    public static interface WindowManagerFuncs {
        public void requestTraversal();
    }

    public static final class SyncRoot {
    }
}

