/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accounts.AccountManager;
import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.admin.IDevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.hardware.usb.UsbManager;
import android.media.AudioManager;
import android.media.IAudioService;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.PowerManager;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.Credentials;
import android.security.IKeyChainService;
import android.security.KeyChain;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.os.storage.ExternalStorageFormatter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.devicepolicy.DeviceOwner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DevicePolicyManagerService
extends IDevicePolicyManager.Stub {
    private static final String LOG_TAG = "DevicePolicyManagerService";
    private static final String DEVICE_POLICIES_XML = "device_policies.xml";
    private static final String LOCK_TASK_COMPONENTS_XML = "lock-task-component";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long MS_PER_DAY = 86400000L;
    private static final long EXPIRATION_GRACE_PERIOD_MS = 432000000L;
    protected static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final int MONITORING_CERT_NOTIFICATION_ID = 17039584;
    private static final boolean DBG = false;
    private static final String ATTR_PERMISSION_PROVIDER = "permission-provider";
    private static final String ATTR_SETUP_COMPLETE = "setup-complete";
    private static final Set<String> DEVICE_OWNER_USER_RESTRICTIONS = new HashSet<String>();
    private static final Set<String> SECURE_SETTINGS_WHITELIST;
    private static final Set<String> SECURE_SETTINGS_DEVICEOWNER_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_WHITELIST;
    final Context mContext;
    final UserManager mUserManager;
    final PowerManager.WakeLock mWakeLock;
    final LocalService mLocalService;
    IPowerManager mIPowerManager;
    IWindowManager mIWindowManager;
    NotificationManager mNotificationManager;
    private DeviceOwner mDeviceOwner;
    private boolean mHasFeature;
    final SparseArray<DevicePolicyData> mUserData = new SparseArray();
    Handler mHandler = new Handler();
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            final int userHandle = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification(userHandle);
                    }
                });
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || "android.security.STORAGE_CHANGED".equals(action)) {
                new MonitoringCertNotificationTask().execute(intent);
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                DevicePolicyManagerService.this.removeUserData(userHandle);
            } else if ("android.intent.action.USER_STARTED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                if ("android.intent.action.USER_STARTED".equals(action)) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        DevicePolicyManagerService.this.mUserData.remove(userHandle);
                    }
                }
                DevicePolicyManagerService.this.handlePackagesChanged(userHandle);
            }
        }
    };
    public static final String SYSTEM_PROP_DISABLE_CAMERA = "sys.secpolicy.camera.disabled";

    private void handlePackagesChanged(int userHandle) {
        boolean removed = false;
        DevicePolicyData policy = this.getUserData(userHandle);
        IPackageManager pm = AppGlobals.getPackageManager();
        for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
            ActiveAdmin aa = policy.mAdminList.get(i);
            try {
                if (pm.getPackageInfo(aa.info.getPackageName(), 0, userHandle) != null && pm.getReceiverInfo(aa.info.getComponent(), 0, userHandle) != null) continue;
                removed = true;
                policy.mAdminList.remove(i);
                policy.mAdminMap.remove(aa.info.getComponent());
                continue;
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        if (removed) {
            this.validatePasswordOwnerLocked(policy);
            this.syncDeviceCapabilitiesLocked(policy);
            this.saveSettingsLocked(policy.mUserHandle);
        }
    }

    public DevicePolicyManagerService(Context context) {
        this.mContext = context;
        this.mUserManager = UserManager.get(this.mContext);
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.device_admin");
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "DPM");
        this.mLocalService = new LocalService();
        if (!this.mHasFeature) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.security.STORAGE_CHANGED");
        filter.setPriority(1000);
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addDataScheme("package");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        LocalServices.addService(DevicePolicyManagerInternal.class, this.mLocalService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy == null) {
                policy = new DevicePolicyData(userHandle);
                this.mUserData.append(userHandle, policy);
                this.loadSettingsLocked(policy, userHandle);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy;
            if (userHandle == 0) {
                Slog.w(LOG_TAG, "Tried to remove device policy file for user 0! Ignoring.");
                return;
            }
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.removeProfileOwner(userHandle);
                this.mDeviceOwner.writeOwnerFile();
            }
            if ((policy = this.mUserData.get(userHandle)) != null) {
                this.mUserData.remove(userHandle);
            }
            File policyFile = new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML);
            policyFile.delete();
            Slog.i(LOG_TAG, "Removed device policy file " + policyFile.getAbsolutePath());
        }
        this.updateScreenCaptureDisabledInWindowManager(userHandle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDeviceOwner() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.mDeviceOwner = DeviceOwner.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpirationAlarmCheckLocked(Context context, DevicePolicyData policy) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null, policy.mUserHandle);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + 86400000L;
        } else {
            long alarmInterval = timeToExpire % 86400000L;
            if (alarmInterval == 0L) {
                alarmInterval = 86400000L;
            }
            alarmTime = now + alarmInterval;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            PendingIntent pi = PendingIntent.getBroadcastAsUser(context, 5571, new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), 0x48000000, new UserHandle(policy.mUserHandle));
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private IPowerManager getIPowerManager() {
        if (this.mIPowerManager == null) {
            IBinder b = ServiceManager.getService("power");
            this.mIPowerManager = IPowerManager.Stub.asInterface(b);
        }
        return this.mIPowerManager;
    }

    private IWindowManager getWindowManager() {
        if (this.mIWindowManager == null) {
            IBinder b = ServiceManager.getService("window");
            this.mIWindowManager = IWindowManager.Stub.asInterface(b);
        }
        return this.mIWindowManager;
    }

    private NotificationManager getNotificationManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle) {
        ActiveAdmin admin = this.getUserData((int)userHandle).mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        int callingUid = Binder.getCallingUid();
        int userHandle = UserHandle.getUserId(callingUid);
        DevicePolicyData policy = this.getUserData(userHandle);
        ArrayList<ActiveAdmin> candidates = new ArrayList<ActiveAdmin>();
        if (who != null) {
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != callingUid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + Binder.getCallingUid());
            }
            candidates.add(admin);
        } else {
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.getUid() != callingUid) continue;
                candidates.add(admin);
            }
        }
        for (ActiveAdmin admin : candidates) {
            boolean ownsProfile;
            boolean ownsDevice = this.isDeviceOwner(admin.info.getPackageName());
            boolean bl = ownsProfile = this.getProfileOwner(userHandle) != null && this.getProfileOwner(userHandle).getPackageName().equals(admin.info.getPackageName());
            if (!(reqPolicy == -2 ? ownsDevice : (reqPolicy == -1 ? ownsDevice || ownsProfile : admin.info.usesPolicy(reqPolicy)))) continue;
            return admin;
        }
        if (who != null) {
            if (reqPolicy == -2) {
                throw new SecurityException("Admin " + ((ActiveAdmin)candidates.get((int)0)).info.getComponent() + " does not own the device");
            }
            if (reqPolicy == -1) {
                throw new SecurityException("Admin " + ((ActiveAdmin)candidates.get((int)0)).info.getComponent() + " does not own the profile");
            }
            throw new SecurityException("Admin " + ((ActiveAdmin)candidates.get((int)0)).info.getComponent() + " did not specify uses-policy for: " + ((ActiveAdmin)candidates.get((int)0)).info.getTagForPolicy(reqPolicy));
        }
        throw new SecurityException("No active admin owned by uid " + Binder.getCallingUid() + " for policy #" + reqPolicy);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        this.sendAdminCommandLocked(admin, action, null, result);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, Bundle adminExtras, BroadcastReceiver result) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (adminExtras != null) {
            intent.putExtras(adminExtras);
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcastAsUser(intent, admin.getUserHandle(), null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcastAsUser(intent, admin.getUserHandle());
        }
    }

    void sendAdminCommandLocked(String action, int reqPolicy, int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int count = policy.mAdminList.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(reqPolicy)) continue;
                this.sendAdminCommandLocked(admin, action);
            }
        }
    }

    private void sendAdminCommandToSelfAndProfilesLocked(String action, int reqPolicy, int userHandle) {
        List profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo ui : profiles) {
            int id2 = ui.getUserHandle().getIdentifier();
            this.sendAdminCommandLocked(action, reqPolicy, id2);
        }
    }

    void removeActiveAdminLocked(final ComponentName adminReceiver, int userHandle) {
        final ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
        if (admin != null) {
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onReceive(Context context, Intent intent) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        int userHandle = admin.getUserHandle().getIdentifier();
                        DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(userHandle);
                        boolean doProxyCleanup = admin.info.usesPolicy(5);
                        policy.mAdminList.remove(admin);
                        policy.mAdminMap.remove(adminReceiver);
                        DevicePolicyManagerService.this.validatePasswordOwnerLocked(policy);
                        DevicePolicyManagerService.this.syncDeviceCapabilitiesLocked(policy);
                        if (doProxyCleanup) {
                            DevicePolicyManagerService.this.resetGlobalProxyLocked(DevicePolicyManagerService.this.getUserData(userHandle));
                        }
                        DevicePolicyManagerService.this.saveSettingsLocked(userHandle);
                        DevicePolicyManagerService.this.updateMaximumTimeToLockLocked(policy);
                    }
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        Intent resolveIntent = new Intent();
        resolveIntent.setComponent(adminName);
        List<ResolveInfo> infos = this.mContext.getPackageManager().queryBroadcastReceivers(resolveIntent, 32896, userHandle);
        if (infos == null || infos.size() <= 0) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        try {
            return new DeviceAdminInfo(this.mContext, infos.get(0));
        }
        catch (XmlPullParserException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
    }

    private static JournaledFile makeJournaledFile(int userHandle) {
        String base = userHandle == 0 ? "/data/system/device_policies.xml" : new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileOutputStream stream = null;
        try {
            int i;
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, "utf-8");
            out.startDocument(null, true);
            out.startTag(null, "policies");
            if (policy.mRestrictionsProvider != null) {
                out.attribute(null, ATTR_PERMISSION_PROVIDER, policy.mRestrictionsProvider.flattenToString());
            }
            if (policy.mUserSetupComplete) {
                out.attribute(null, ATTR_SETUP_COMPLETE, Boolean.toString(true));
            }
            int N = policy.mAdminList.size();
            for (i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, "name", ap.info.getComponent().flattenToString());
                ap.writeToXml(out);
                out.endTag(null, "admin");
            }
            if (policy.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, "value", Integer.toString(policy.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (policy.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, "value", Integer.toString(policy.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (policy.mActivePasswordQuality != 0 || policy.mActivePasswordLength != 0 || policy.mActivePasswordUpperCase != 0 || policy.mActivePasswordLowerCase != 0 || policy.mActivePasswordLetters != 0 || policy.mActivePasswordNumeric != 0 || policy.mActivePasswordSymbols != 0 || policy.mActivePasswordNonLetter != 0) {
                out.startTag(null, "active-password");
                out.attribute(null, "quality", Integer.toString(policy.mActivePasswordQuality));
                out.attribute(null, "length", Integer.toString(policy.mActivePasswordLength));
                out.attribute(null, "uppercase", Integer.toString(policy.mActivePasswordUpperCase));
                out.attribute(null, "lowercase", Integer.toString(policy.mActivePasswordLowerCase));
                out.attribute(null, "letters", Integer.toString(policy.mActivePasswordLetters));
                out.attribute(null, "numeric", Integer.toString(policy.mActivePasswordNumeric));
                out.attribute(null, "symbols", Integer.toString(policy.mActivePasswordSymbols));
                out.attribute(null, "nonletter", Integer.toString(policy.mActivePasswordNonLetter));
                out.endTag(null, "active-password");
            }
            for (i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String component = policy.mLockTaskPackages.get(i);
                out.startTag(null, LOCK_TASK_COMPONENTS_XML);
                out.attribute(null, "name", component);
                out.endTag(null, LOCK_TASK_COMPONENTS_XML);
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.close();
            journal.commit();
            this.sendChangedNotification(userHandle);
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedNotification(int userHandle) {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userHandle));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void loadSettingsLocked(DevicePolicyData policy, int userHandle) {
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        try {
            String userSetupComplete;
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, null);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            String permissionProvider = parser.getAttributeValue(null, ATTR_PERMISSION_PROVIDER);
            if (permissionProvider != null) {
                policy.mRestrictionsProvider = ComponentName.unflattenFromString(permissionProvider);
            }
            if ((userSetupComplete = parser.getAttributeValue(null, ATTR_SETUP_COMPLETE)) != null && Boolean.toString(true).equals(userSetupComplete)) {
                policy.mUserSetupComplete = true;
            }
            type = parser.next();
            int outerDepth = parser.getDepth();
            policy.mLockTaskPackages.clear();
            policy.mAdminList.clear();
            policy.mAdminMap.clear();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, "name");
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString(name), userHandle);
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai);
                        ap.readFromXml(parser);
                        policy.mAdminMap.put(ap.info.getComponent(), ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w(LOG_TAG, "Failed loading admin " + name, e);
                    }
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    policy.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    policy.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("active-password".equals(tag)) {
                    policy.mActivePasswordQuality = Integer.parseInt(parser.getAttributeValue(null, "quality"));
                    policy.mActivePasswordLength = Integer.parseInt(parser.getAttributeValue(null, "length"));
                    policy.mActivePasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "uppercase"));
                    policy.mActivePasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "lowercase"));
                    policy.mActivePasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "letters"));
                    policy.mActivePasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "numeric"));
                    policy.mActivePasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "symbols"));
                    policy.mActivePasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "nonletter"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if (LOCK_TASK_COMPONENTS_XML.equals(tag)) {
                    policy.mLockTaskPackages.add(parser.getAttributeValue(null, "name"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                Slog.w(LOG_TAG, "Unknown tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (NullPointerException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        policy.mAdminList.addAll(policy.mAdminMap.values());
        LockPatternUtils utils = new LockPatternUtils(this.mContext);
        if (utils.getActivePasswordQuality() < policy.mActivePasswordQuality) {
            Slog.w(LOG_TAG, "Active password quality 0x" + Integer.toHexString(policy.mActivePasswordQuality) + " does not match actual quality 0x" + Integer.toHexString(utils.getActivePasswordQuality()));
            policy.mActivePasswordQuality = 0;
            policy.mActivePasswordLength = 0;
            policy.mActivePasswordUpperCase = 0;
            policy.mActivePasswordLowerCase = 0;
            policy.mActivePasswordLetters = 0;
            policy.mActivePasswordNumeric = 0;
            policy.mActivePasswordSymbols = 0;
            policy.mActivePasswordNonLetter = 0;
        }
        this.validatePasswordOwnerLocked(policy);
        this.syncDeviceCapabilitiesLocked(policy);
        this.updateMaximumTimeToLockLocked(policy);
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 196608: 
            case 262144: 
            case 327680: 
            case 393216: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked(DevicePolicyData policy) {
        if (policy.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                if (policy.mAdminList.get(i).getUid() != policy.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w(LOG_TAG, "Previous password owner " + policy.mPasswordOwner + " no longer active; disabling");
                policy.mPasswordOwner = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncDeviceCapabilitiesLocked(DevicePolicyData policy) {
        boolean systemState = SystemProperties.getBoolean(SYSTEM_PROP_DISABLE_CAMERA, false);
        boolean cameraDisabled = this.getCameraDisabled(null, policy.mUserHandle);
        if (cameraDisabled != systemState) {
            long token = Binder.clearCallingIdentity();
            try {
                String value = cameraDisabled ? "1" : "0";
                SystemProperties.set(SYSTEM_PROP_DISABLE_CAMERA, value);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public void systemReady() {
        if (!this.mHasFeature) {
            return;
        }
        this.getUserData(0);
        this.loadDeviceOwner();
        this.cleanUpOldUsers();
        new SetupContentObserver(this.mHandler).register(this.mContext.getContentResolver());
        this.updateUserSetupComplete();
        List<UserInfo> users = this.mUserManager.getUsers(true);
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            int userHandle = users.get((int)i).id;
            this.updateScreenCaptureDisabledInWindowManager(userHandle, this.getScreenCaptureDisabled(null, userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOldUsers() {
        HashSet<Integer> usersWithData;
        Set<Object> usersWithProfileOwners;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            usersWithProfileOwners = this.mDeviceOwner != null ? this.mDeviceOwner.getProfileOwnerKeys() : new HashSet();
            usersWithData = new HashSet<Integer>();
            for (int i = 0; i < this.mUserData.size(); ++i) {
                usersWithData.add(this.mUserData.keyAt(i));
            }
        }
        List<UserInfo> allUsers = this.mUserManager.getUsers();
        HashSet deletedUsers = new HashSet();
        deletedUsers.addAll(usersWithProfileOwners);
        deletedUsers.addAll(usersWithData);
        for (UserInfo userInfo : allUsers) {
            deletedUsers.remove(userInfo.id);
        }
        for (Integer userId : deletedUsers) {
            this.removeUserData(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long now = System.currentTimeMillis();
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo ui : profiles) {
                int profileUserHandle = ui.getUserHandle().getIdentifier();
                DevicePolicyData policy = this.getUserData(profileUserHandle);
                int count = policy.mAdminList.size();
                if (count <= 0) continue;
                for (int i = 0; i < count; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || now < admin.passwordExpirationDate - 432000000L || admin.passwordExpirationDate <= 0L) continue;
                    this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING");
                }
            }
            this.setExpirationAlarmCheckLocked(this.mContext, this.getUserData(userHandle));
        }
    }

    @Override
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.setActiveAdmin(adminReceiver, refreshing, userHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle, Bundle onEnableData) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        DeviceAdminInfo info = this.findAdmin(adminReceiver, userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (!refreshing && this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info);
                policy.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin oldAdmin = policy.mAdminList.get(i);
                    if (!oldAdmin.info.getComponent().equals(adminReceiver)) continue;
                    replaceIndex = i;
                    break;
                }
                if (replaceIndex == -1) {
                    policy.mAdminList.add(newAdmin);
                    this.enableIfNecessary(info.getPackageName(), userHandle);
                } else {
                    policy.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked(userHandle);
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED", onEnableData, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminActive(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentName> getActiveAdmins(int userHandle) {
        if (!this.mHasFeature) {
            return Collections.EMPTY_LIST;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(policy.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean packageHasActiveAdmins(String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            if (admin.getUid() != Binder.getCallingUid()) {
                if (this.isDeviceOwner(adminReceiver.getPackageName())) {
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver, userHandle);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordQuality(ComponentName who, int quality, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService.validateQualityConstant(quality);
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordQuality != quality) {
                ap.passwordQuality = quality;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int mode = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordQuality : mode;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (mode >= admin.passwordQuality) continue;
                    mode = admin.passwordQuality;
                }
            }
            return mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLength(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLength != length) {
                ap.minimumPasswordLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLength : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordLength) continue;
                    length = admin.minimumPasswordLength;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordHistoryLength(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordHistoryLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordHistoryLength : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.passwordHistoryLength) continue;
                    length = admin.passwordHistoryLength;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordExpirationTimeout(ComponentName who, long timeout, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long expiration;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be >= 0 ms");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w(LOG_TAG, "setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration)));
            }
            this.saveSettingsLocked(userHandle);
            this.setExpirationAlarmCheckLocked(this.mContext, this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpirationTimeout(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long timeout = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.passwordExpirationTimeout : timeout;
                return l;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                    timeout = admin.passwordExpirationTimeout;
                }
            }
            return timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            List<String> providers;
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                activeAdmin.crossProfileWidgetProviders = new ArrayList<String>();
            }
            if (!(providers = activeAdmin.crossProfileWidgetProviders).contains(packageName)) {
                providers.add(packageName);
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                return false;
            }
            List<String> providers = activeAdmin.crossProfileWidgetProviders;
            if (providers.remove(packageName)) {
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCrossProfileWidgetProviders(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null || activeAdmin.crossProfileWidgetProviders.isEmpty()) {
                return null;
            }
            if (Binder.getCallingUid() == Process.myUid()) {
                return new ArrayList<String>(activeAdmin.crossProfileWidgetProviders);
            }
            return activeAdmin.crossProfileWidgetProviders;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who, int userHandle) {
        long timeout = 0L;
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            return admin != null ? admin.passwordExpirationDate : timeout;
        }
        List profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo userInfo : profiles) {
            DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
                timeout = admin.passwordExpirationDate;
            }
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpiration(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getPasswordExpirationLocked(who, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumUpperCase(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordUpperCase != length) {
                ap.minimumPasswordUpperCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumUpperCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordUpperCase : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordUpperCase) continue;
                    length = admin.minimumPasswordUpperCase;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLowerCase(ComponentName who, int length, int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLowerCase != length) {
                ap.minimumPasswordLowerCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLowerCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLowerCase : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordLowerCase) continue;
                    length = admin.minimumPasswordLowerCase;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLetters(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLetters != length) {
                ap.minimumPasswordLetters = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLetters(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLetters : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordLetters) continue;
                    length = admin.minimumPasswordLetters;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNumeric(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNumeric != length) {
                ap.minimumPasswordNumeric = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNumeric(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNumeric : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordNumeric) continue;
                    length = admin.minimumPasswordNumeric;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumSymbols(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordSymbols != length) {
                ap.minimumPasswordSymbols = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumSymbols(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordSymbols : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordSymbols) continue;
                    length = admin.minimumPasswordSymbols;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNonLetter(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNonLetter != length) {
                ap.minimumPasswordNonLetter = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNonLetter(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNonLetter : length;
                return n;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordNonLetter) continue;
                    length = admin.minimumPasswordNonLetter;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivePasswordSufficient(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            UserInfo parent = this.getProfileParent(userHandle);
            int id2 = parent == null ? userHandle : parent.id;
            DevicePolicyData policy = this.getUserData(id2);
            this.getActiveAdminForCallerLocked(null, 0);
            if (policy.mActivePasswordQuality < this.getPasswordQuality(null, userHandle) || policy.mActivePasswordLength < this.getPasswordMinimumLength(null, userHandle)) {
                return false;
            }
            if (policy.mActivePasswordQuality != 393216) {
                return true;
            }
            return policy.mActivePasswordUpperCase >= this.getPasswordMinimumUpperCase(null, userHandle) && policy.mActivePasswordLowerCase >= this.getPasswordMinimumLowerCase(null, userHandle) && policy.mActivePasswordLetters >= this.getPasswordMinimumLetters(null, userHandle) && policy.mActivePasswordNumeric >= this.getPasswordMinimumNumeric(null, userHandle) && policy.mActivePasswordSymbols >= this.getPasswordMinimumSymbols(null, userHandle) && policy.mActivePasswordNonLetter >= this.getPasswordMinimumNonLetter(null, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFailedPasswordAttempts(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 1);
            DevicePolicyData policy = this.getUserData(this.getProfileParent((int)userHandle).id);
            return policy.mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, 4);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumFailedPasswordsForWipe(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = who != null ? this.getActiveAdminUncheckedLocked(who, userHandle) : this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle);
            return admin != null ? admin.maximumFailedPasswordsForWipe : 0;
        }
    }

    private ActiveAdmin getAdminWithMinimumFailedPasswordsForWipeLocked(int userHandle) {
        int count = 0;
        ActiveAdmin strictestAdmin = null;
        for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
            DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.maximumFailedPasswordsForWipe == 0 || count != 0 && count <= admin.maximumFailedPasswordsForWipe && (!userInfo.isPrimary() || count < admin.maximumFailedPasswordsForWipe)) continue;
                count = admin.maximumFailedPasswordsForWipe;
                strictestAdmin = admin;
            }
        }
        return strictestAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPassword(String password, int flags, int userHandle) {
        int quality;
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "reset the password");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 2);
            quality = this.getPasswordQuality(null, userHandle);
            if (quality != 0) {
                int realQuality = LockPatternUtils.computePasswordQuality(password);
                if (realQuality < quality && quality != 393216) {
                    Slog.w(LOG_TAG, "resetPassword: password quality 0x" + Integer.toHexString(realQuality) + " does not meet required quality 0x" + Integer.toHexString(quality));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null, userHandle);
            if (password.length() < length) {
                Slog.w(LOG_TAG, "resetPassword: password length " + password.length() + " does not meet required length " + length);
                return false;
            }
            if (quality == 393216) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                int neededLetters = this.getPasswordMinimumLetters(null, userHandle);
                if (letters < neededLetters) {
                    Slog.w(LOG_TAG, "resetPassword: number of letters " + letters + " does not meet required number of letters " + neededLetters);
                    return false;
                }
                int neededNumbers = this.getPasswordMinimumNumeric(null, userHandle);
                if (numbers < neededNumbers) {
                    Slog.w(LOG_TAG, "resetPassword: number of numerical digits " + numbers + " does not meet required number of numerical digits " + neededNumbers);
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null, userHandle);
                if (lowercase < neededLowerCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of lowercase letters " + lowercase + " does not meet required number of lowercase letters " + neededLowerCase);
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null, userHandle);
                if (uppercase < neededUpperCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of uppercase letters " + uppercase + " does not meet required number of uppercase letters " + neededUpperCase);
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null, userHandle);
                if (symbols < neededSymbols) {
                    Slog.w(LOG_TAG, "resetPassword: number of special symbols " + symbols + " does not meet required number of special symbols " + neededSymbols);
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null, userHandle);
                if (nonletter < neededNonLetter) {
                    Slog.w(LOG_TAG, "resetPassword: number of non-letter characters " + nonletter + " does not meet required number of non-letter characters " + neededNonLetter);
                    return false;
                }
            }
        }
        int callingUid = Binder.getCallingUid();
        DevicePolicyData policy = this.getUserData(userHandle);
        if (policy.mPasswordOwner >= 0 && policy.mPasswordOwner != callingUid) {
            Slog.w(LOG_TAG, "resetPassword: already set by another uid and not entered by user");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            boolean requireEntry;
            LockPatternUtils utils = new LockPatternUtils(this.mContext);
            utils.saveLockPassword(password, quality, false, userHandle);
            boolean bl = requireEntry = (flags & 1) != 0;
            if (requireEntry) {
                utils.requireCredentialEntry(-1);
            }
            DevicePolicyManagerService devicePolicyManagerService2 = this;
            synchronized (devicePolicyManagerService2) {
                int newOwner;
                int n = newOwner = requireEntry ? callingUid : -1;
                if (policy.mPasswordOwner != newOwner) {
                    policy.mPasswordOwner = newOwner;
                    this.saveSettingsLocked(userHandle);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeToLock(ComponentName who, long timeMs, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                this.saveSettingsLocked(userHandle);
                this.updateMaximumTimeToLockLocked(this.getUserData(userHandle));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMaximumTimeToLockLocked(DevicePolicyData policy) {
        long timeMs = this.getMaximumTimeToLock(null, policy.mUserHandle);
        if (policy.mLastMaximumTimeToLock == timeMs) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (timeMs <= 0L) {
                timeMs = Integer.MAX_VALUE;
            } else {
                Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", 0);
            }
            policy.mLastMaximumTimeToLock = timeMs;
            try {
                this.getIPowerManager().setMaximumScreenOffTimeoutFromDeviceAdmin((int)timeMs);
            }
            catch (RemoteException e) {
                Slog.w(LOG_TAG, "Failure talking with power manager", e);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLock(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long time = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.maximumTimeToUnlock : time;
                return l;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (time == 0L) {
                        time = admin.maximumTimeToUnlock;
                        continue;
                    }
                    if (admin.maximumTimeToUnlock == 0L || time <= admin.maximumTimeToUnlock) continue;
                    time = admin.maximumTimeToUnlock;
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockNow() {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 3);
            this.lockNowUnchecked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockNowUnchecked() {
        long ident = Binder.clearCallingIdentity();
        try {
            this.getIPowerManager().goToSleep(SystemClock.uptimeMillis(), 1, 0);
            new LockPatternUtils(this.mContext).requireCredentialEntry(-1);
            this.getWindowManager().lockNow(null);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean isExtStorageEncrypted() {
        String state = SystemProperties.get("vold.decrypt");
        return !"".equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceCanManageCaCerts(ComponentName who) {
        if (who == null) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
        } else {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installCaCert(ComponentName admin, byte[] certBuffer) throws RemoteException {
        byte[] pemCert;
        this.enforceCanManageCaCerts(admin);
        try {
            X509Certificate cert = DevicePolicyManagerService.parseCert(certBuffer);
            pemCert = Credentials.convertToPem(cert);
        }
        catch (CertificateException ce) {
            Log.e(LOG_TAG, "Problem converting cert", ce);
            return false;
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Problem reading cert", ioe);
            return false;
        }
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser((Context)this.mContext, (UserHandle)userHandle);
            try {
                keyChainConnection.getService().installCaCertificate(pemCert);
                boolean bl = true;
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "installCaCertsToKeyChain(): ", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e1) {
                    Log.w(LOG_TAG, "installCaCertsToKeyChain(): ", e1);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    private static X509Certificate parseCert(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallCaCert(ComponentName admin, String alias) {
        this.enforceCanManageCaCerts(admin);
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try (KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser((Context)this.mContext, (UserHandle)userHandle);){
            keyChainConnection.getService().deleteCaCertificate(alias);
        }
        catch (InterruptedException ie) {
            Log.w(LOG_TAG, "CaCertUninstaller: ", ie);
            Thread.currentThread().interrupt();
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installKeyPair(ComponentName who, byte[] privKey, byte[] cert, String alias) {
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
        }
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser((Context)this.mContext, (UserHandle)userHandle);
            try {
                IKeyChainService keyChain = keyChainConnection.getService();
                boolean bl = keyChain.installKeyPair(privKey, cert, alias);
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Installing certificate", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while installing certificate", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    void wipeDataLocked(int flags, String reason) {
        boolean wipeExtRequested;
        boolean forceExtWipe = !Environment.isExternalStorageRemovable() && this.isExtStorageEncrypted();
        boolean bl = wipeExtRequested = (flags & 1) != 0;
        if ((forceExtWipe || wipeExtRequested) && !Environment.isExternalStorageEmulated()) {
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET");
            intent.putExtra("always_reset", true);
            intent.putExtra("android.intent.extra.REASON", reason);
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            this.mWakeLock.acquire(10000L);
            this.mContext.startService(intent);
        } else {
            try {
                RecoverySystem.rebootWipeUserData((Context)this.mContext, (String)reason);
            }
            catch (IOException e) {
                Slog.w(LOG_TAG, "Failed requesting data wipe", e);
            }
            catch (SecurityException e) {
                Slog.w(LOG_TAG, "Failed requesting data wipe", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData(int flags, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ComponentName cname;
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(null, 4);
            String source = admin != null && admin.info != null ? ((cname = admin.info.getComponent()) != null ? cname.flattenToShortString() : admin.info.getPackageName()) : "?";
            long ident = Binder.clearCallingIdentity();
            try {
                this.wipeDeviceOrUserLocked(flags, userHandle, "DevicePolicyManager.wipeData() from " + source);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private void wipeDeviceOrUserLocked(int flags, final int userHandle, String reason) {
        if (userHandle == 0) {
            this.wipeDataLocked(flags, reason);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActivityManagerNative.getDefault().switchUser(0);
                        if (!DevicePolicyManagerService.this.mUserManager.removeUser(userHandle)) {
                            Slog.w(DevicePolicyManagerService.LOG_TAG, "Couldn't remove user " + userHandle);
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp, userHandle);
            if (admin == null) {
                try {
                    result.sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setFlags(0x10000000);
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcastAsUser(intent, new UserHandle(userHandle), null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        result.sendResult(this.getResultExtras(false));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "set the active password");
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyData p = this.getUserData(userHandle);
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (p.mActivePasswordQuality != quality || p.mActivePasswordLength != length || p.mFailedPasswordAttempts != 0 || p.mActivePasswordLetters != letters || p.mActivePasswordUpperCase != uppercase || p.mActivePasswordLowerCase != lowercase || p.mActivePasswordNumeric != numbers || p.mActivePasswordSymbols != symbols || p.mActivePasswordNonLetter != nonletter) {
                long ident = Binder.clearCallingIdentity();
                try {
                    p.mActivePasswordQuality = quality;
                    p.mActivePasswordLength = length;
                    p.mActivePasswordLetters = letters;
                    p.mActivePasswordLowerCase = lowercase;
                    p.mActivePasswordUpperCase = uppercase;
                    p.mActivePasswordNumeric = numbers;
                    p.mActivePasswordSymbols = symbols;
                    p.mActivePasswordNonLetter = nonletter;
                    p.mFailedPasswordAttempts = 0;
                    this.saveSettingsLocked(userHandle);
                    this.updatePasswordExpirationsLocked(userHandle);
                    this.setExpirationAlarmCheckLocked(this.mContext, p);
                    this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0, userHandle);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    private void updatePasswordExpirationsLocked(int userHandle) {
        List profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo userInfo : profiles) {
            int profileId = userInfo.getUserHandle().getIdentifier();
            DevicePolicyData policy = this.getUserData(profileId);
            int N = policy.mAdminList.size();
            if (N > 0) {
                for (int i = 0; i < N; ++i) {
                    long expiration;
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!admin.info.usesPolicy(6)) continue;
                    long timeout = admin.passwordExpirationTimeout;
                    admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
                }
            }
            this.saveSettingsLocked(profileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "report failed password attempt");
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        long ident = Binder.clearCallingIdentity();
        try {
            boolean wipeData = false;
            int identifier = 0;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                DevicePolicyData policy = this.getUserData(userHandle);
                ++policy.mFailedPasswordAttempts;
                this.saveSettingsLocked(userHandle);
                if (this.mHasFeature) {
                    int max;
                    ActiveAdmin strictestAdmin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle);
                    int n = max = strictestAdmin != null ? strictestAdmin.maximumFailedPasswordsForWipe : 0;
                    if (max > 0 && policy.mFailedPasswordAttempts >= max) {
                        wipeData = true;
                        identifier = strictestAdmin.getUserHandle().getIdentifier();
                    }
                    this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_FAILED", 1, userHandle);
                }
            }
            if (wipeData) {
                this.wipeDeviceOrUserLocked(0, identifier, "reportFailedPasswordAttempt()");
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mFailedPasswordAttempts != 0 || policy.mPasswordOwner >= 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    policy.mFailedPasswordAttempts = 0;
                    policy.mPasswordOwner = -1;
                    this.saveSettingsLocked(userHandle);
                    if (this.mHasFeature) {
                        this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1, userHandle);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            DevicePolicyData policy = this.getUserData(0);
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = policy.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = policy.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals(who)) continue;
                return component;
            }
            if (UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only the owner is allowed to set the global proxy. User " + userHandle + " is not permitted.");
                return null;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                this.resetGlobalProxyLocked(policy);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getGlobalProxyAdmin(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(0);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecommendedGlobalProxy(ComponentName who, ProxyInfo proxyInfo) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long token = Binder.clearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            connectivityManager.setGlobalProxy(proxyInfo);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void resetGlobalProxyLocked(DevicePolicyData policy) {
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = policy.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxyLocked(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxyLocked(null, null);
    }

    private void saveGlobalProxyLocked(String proxySpec, String exclusionList) {
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        exclusionList = exclusionList.trim();
        ContentResolver res = this.mContext.getContentResolver();
        ProxyInfo proxyProperties = new ProxyInfo(data[0], proxyPort, exclusionList);
        if (!proxyProperties.isValid()) {
            Slog.e(LOG_TAG, "Invalid proxy properties, ignoring: " + proxyProperties.toString());
            return;
        }
        Settings.Global.putString(res, "global_http_proxy_host", data[0]);
        Settings.Global.putInt(res, "global_http_proxy_port", proxyPort);
        Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStorageEncryption(ComponentName who, boolean encrypt, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            if (userHandle != 0 || UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only owner is allowed to set storage encryption. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return 0;
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked(userHandle);
            }
            DevicePolicyData policy = this.getUserData(0);
            boolean newRequested = false;
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= policy.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStorageEncryption(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getStorageEncryptionStatus(int userHandle) {
        if (!this.mHasFeature) {
            // empty if block
        }
        this.enforceCrossUserPermission(userHandle);
        return this.getEncryptionStatus();
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEncryptionStatus() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        if ("encrypted".equalsIgnoreCase(status)) {
            long token = Binder.clearCallingIdentity();
            try {
                int n = LockPatternUtils.isDeviceEncrypted() ? 3 : 1;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        if ("unencrypted".equalsIgnoreCase(status)) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenCaptureDisabled(ComponentName who, int userHandle, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (ap.disableScreenCapture != disabled) {
                ap.disableScreenCapture = disabled;
                this.saveSettingsLocked(userHandle);
                this.updateScreenCaptureDisabledInWindowManager(userHandle, disabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getScreenCaptureDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableScreenCapture : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableScreenCapture) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreenCaptureDisabledInWindowManager(int userHandle, boolean disabled) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.getWindowManager().setScreenCaptureDisabled(userHandle, disabled);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to notify WindowManager.", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoTimeRequired(ComponentName who, int userHandle, boolean required) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -2);
            if (admin.requireAutoTime != required) {
                admin.requireAutoTime = required;
                this.saveSettingsLocked(userHandle);
            }
        }
        if (required) {
            long ident = Binder.clearCallingIdentity();
            try {
                Settings.Global.putInt(this.mContext.getContentResolver(), "auto_time", 1);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoTimeRequired() {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdmin();
            return deviceOwner != null ? deviceOwner.requireAutoTime : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraDisabled(ComponentName who, boolean disabled, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCameraDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyguardDisabledFeatures(ComponentName who, int which, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "disable keyguard features");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 9);
            if (ap.disabledKeyguardFeatures != which) {
                ap.disabledKeyguardFeatures = which;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getKeyguardDisabledFeatures(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.disabledKeyguardFeatures : 0;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            int which = 0;
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                which |= admin.disabledKeyguardFeatures;
            }
            return which;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeviceOwner(String packageName, String ownerName) {
        if (!this.mHasFeature) {
            return false;
        }
        if (packageName == null || !DeviceOwner.isInstalled(packageName, this.mContext.getPackageManager())) {
            throw new IllegalArgumentException("Invalid package name " + packageName + " for device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.allowedToSetDeviceOwnerOnDevice()) {
                throw new IllegalStateException("Trying to set device owner but device is already provisioned.");
            }
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner()) {
                throw new IllegalStateException("Trying to set device owner but device owner is already set.");
            }
            if (this.mDeviceOwner == null) {
                this.mDeviceOwner = DeviceOwner.createWithDeviceOwner(packageName, ownerName);
                this.mDeviceOwner.writeOwnerFile();
                return true;
            }
            this.mDeviceOwner.setDeviceOwner(packageName, ownerName);
            this.mDeviceOwner.writeOwnerFile();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceOwner(String packageName) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner() && this.mDeviceOwner.getDeviceOwnerPackageName().equals(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwner() {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner()) {
                return this.mDeviceOwner.getDeviceOwnerPackageName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwnerName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getDeviceOwnerName();
            }
        }
        return null;
    }

    private ActiveAdmin getDeviceOwnerAdmin() {
        String deviceOwnerPackageName = this.getDeviceOwner();
        if (deviceOwnerPackageName == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(0);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!deviceOwnerPackageName.equals(admin.info.getPackageName())) continue;
            return admin;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeviceOwner(String packageName) {
        if (packageName == null) {
            throw new NullPointerException("packageName is null");
        }
        try {
            int uid = this.mContext.getPackageManager().getPackageUid(packageName, 0);
            if (uid != Binder.getCallingUid()) {
                throw new SecurityException("Invalid packageName");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException(e);
        }
        if (!this.isDeviceOwner(packageName)) {
            throw new SecurityException("clearDeviceOwner can only be called by the device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.clearUserRestrictions(new UserHandle(0));
                if (this.mDeviceOwner != null) {
                    this.mDeviceOwner.clearDeviceOwner();
                    this.mDeviceOwner.writeOwnerFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProfileOwner(ComponentName who, String ownerName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        UserInfo info = this.mUserManager.getUserInfo(userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Attempted to set profile owner for invalid userId: " + userHandle);
        }
        if (info.isGuest()) {
            throw new IllegalStateException("Cannot set a profile owner on a guest");
        }
        if (who == null || !DeviceOwner.isInstalledForUser(who.getPackageName(), userHandle)) {
            throw new IllegalArgumentException("Component " + who + " not installed for userId:" + userHandle);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (UserHandle.getAppId(Binder.getCallingUid()) != 1000 && this.hasUserSetupCompleted(userHandle)) {
                throw new IllegalStateException("Trying to set profile owner but user is already set-up.");
            }
            if (this.mDeviceOwner == null) {
                this.mDeviceOwner = DeviceOwner.createWithProfileOwner(who, ownerName, userHandle);
                this.mDeviceOwner.writeOwnerFile();
                return true;
            }
            this.mDeviceOwner.setProfileOwner(who, ownerName, userHandle);
            this.mDeviceOwner.writeOwnerFile();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProfileOwner(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        UserHandle callingUser = Binder.getCallingUserHandle();
        this.getActiveAdminForCallerLocked(who, -1);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.clearUserRestrictions(callingUser);
                if (this.mDeviceOwner != null) {
                    this.mDeviceOwner.removeProfileOwner(callingUser.getIdentifier());
                    this.mDeviceOwner.writeOwnerFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private void clearUserRestrictions(UserHandle userHandle) {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        Bundle userRestrictions = this.mUserManager.getUserRestrictions();
        this.mUserManager.setUserRestrictions(new Bundle(), userHandle);
        if (userRestrictions.getBoolean("no_adjust_volume")) {
            audioManager.setMasterMute(false);
        }
        if (userRestrictions.getBoolean("no_unmute_microphone")) {
            audioManager.setMicrophoneMute(false);
        }
    }

    public boolean hasUserSetupCompleted() {
        return this.hasUserSetupCompleted(UserHandle.getCallingUserId());
    }

    private boolean hasUserSetupCompleted(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        return policy == null || policy.mUserSetupComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileEnabled(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                this.mUserManager.setUserEnabled(userId);
                Intent intent = new Intent("android.intent.action.MANAGED_PROFILE_ADDED");
                intent.putExtra("android.intent.extra.USER", new UserHandle(userHandle));
                intent.addFlags(0x50000000);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileName(ComponentName who, String profileName) {
        int userId = UserHandle.getCallingUserId();
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        this.getActiveAdminForCallerLocked(who, -1);
        long id2 = Binder.clearCallingIdentity();
        try {
            this.mUserManager.setUserName(userId, profileName);
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getProfileOwner(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getProfileOwnerComponent(userHandle);
            }
        }
        return null;
    }

    private ActiveAdmin getProfileOwnerAdmin(int userHandle) {
        ComponentName profileOwner;
        ComponentName componentName = profileOwner = this.mDeviceOwner != null ? this.mDeviceOwner.getProfileOwnerComponent(userHandle) : null;
        if (profileOwner == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!profileOwner.equals(admin.info)) continue;
            return admin;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfileOwnerName(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getProfileOwnerName(userHandle);
            }
        }
        return null;
    }

    private boolean allowedToSetDeviceOwnerOnDevice() {
        int callingId = Binder.getCallingUid();
        if (callingId == 2000 || callingId == 0) {
            return AccountManager.get(this.mContext).getAccounts().length == 0;
        }
        return !this.hasUserSetupCompleted(0);
    }

    private void enforceCrossUserPermission(int userHandle) {
        if (userHandle < 0) {
            throw new IllegalArgumentException("Invalid userId " + userHandle);
        }
        int callingUid = Binder.getCallingUid();
        if (userHandle == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Must be system or have INTERACT_ACROSS_USERS_FULL permission");
        }
    }

    private void enforceSystemProcess(String message) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException(message);
        }
    }

    private void enforceNotManagedProfile(int userHandle, String message) {
        if (this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " for a managed profile. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getProfileParent(int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = this.mUserManager.getProfileParent(userHandle);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isManagedProfile(int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mUserManager.getUserInfo(userHandle).isManagedProfile();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void enableIfNecessary(String packageName, int userId) {
        try {
            IPackageManager ipm = AppGlobals.getPackageManager();
            ApplicationInfo ai = ipm.getApplicationInfo(packageName, 32768, userId);
            if (ai.enabledSetting == 4) {
                ipm.setApplicationEnabledSetting(packageName, 0, 1, userId, "DevicePolicyManager");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DevicePolicyManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            p.println("Current Device Policy Manager state:");
            int userCount = this.mUserData.size();
            for (int u = 0; u < userCount; ++u) {
                DevicePolicyData policy = this.getUserData(this.mUserData.keyAt(u));
                p.println("  Enabled Device Admins (User " + policy.mUserHandle + "):");
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if (ap == null) continue;
                    pw.print("  ");
                    pw.print(ap.info.getComponent().flattenToShortString());
                    pw.println(":");
                    ap.dump("    ", pw);
                }
                pw.println(" ");
                pw.print("  mPasswordOwner=");
                pw.println(policy.mPasswordOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentPreferredActivity(ComponentName who, IntentFilter filter, ComponentName activity) {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.addPersistentPreferredActivity(filter, activity, userHandle);
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPackagePersistentPreferredActivities(ComponentName who, String packageName) {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.clearPackagePersistentPreferredActivities(packageName, userHandle);
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationRestrictions(ComponentName who, String packageName, Bundle settings) {
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                this.mUserManager.setApplicationRestrictions(packageName, settings, userHandle);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrustAgentFeaturesEnabled(ComponentName admin, ComponentName agent, List<String> features, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "manage trust agent features");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (admin == null) {
                throw new NullPointerException("admin is null");
            }
            if (agent == null) {
                throw new NullPointerException("agent is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(admin, 9);
            ap.trustAgentFeatures.put(agent.flattenToString(), features);
            this.saveSettingsLocked(userHandle);
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrustAgentFeaturesEnabled(ComponentName admin, ComponentName agent, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (agent == null) {
                throw new NullPointerException("agent is null");
            }
            String componentName = agent.flattenToString();
            if (admin != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(admin, userHandle);
                List<String> list = ap != null ? ap.trustAgentFeatures.get(componentName) : null;
                return list;
            }
            List profiles = this.mUserManager.getProfiles(userHandle);
            ArrayList<String> result = null;
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserData(userInfo.getUserHandle().getIdentifier());
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if ((ap.disabledKeyguardFeatures & 0x10) == 0) continue;
                    List<String> features = ap.trustAgentFeatures.get(componentName);
                    if (result == null) {
                        if (features == null || features.size() == 0) {
                            result = new ArrayList<String>();
                            Slog.w(LOG_TAG, "admin " + ap.info.getPackageName() + " has null trust agent feature set; all will be disabled");
                            continue;
                        }
                        result = new ArrayList(features.size());
                        result.addAll(features);
                        continue;
                    }
                    result.retainAll(features);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictionsProvider(ComponentName who, ComponentName permissionProvider) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            int userHandle = UserHandle.getCallingUserId();
            DevicePolicyData userData = this.getUserData(userHandle);
            userData.mRestrictionsProvider = permissionProvider;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getRestrictionsProvider(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can query the permission provider");
            }
            DevicePolicyData userData = this.getUserData(userHandle);
            ComponentName componentName = userData != null ? userData.mRestrictionsProvider : null;
            return componentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCrossProfileIntentFilter(ComponentName who, IntentFilter filter, int flags) {
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                if ((flags & 1) != 0) {
                    pm.addCrossProfileIntentFilter(filter, who.getPackageName(), this.mContext.getUserId(), callingUserId, 0, 0);
                }
                if ((flags & 2) != 0) {
                    pm.addCrossProfileIntentFilter(filter, who.getPackageName(), this.mContext.getUserId(), 0, callingUserId, 0);
                }
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCrossProfileIntentFilters(ComponentName who) {
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.clearCrossProfileIntentFilters(callingUserId, who.getPackageName(), callingUserId);
                pm.clearCrossProfileIntentFilters(0, who.getPackageName(), callingUserId);
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPackagesInPermittedListOrSystem(List<String> enabledPackages, List<String> permittedList) {
        int userIdToCheck = UserHandle.getCallingUserId();
        long id2 = Binder.clearCallingIdentity();
        try {
            UserInfo user = this.mUserManager.getUserInfo(userIdToCheck);
            if (user.isManagedProfile()) {
                userIdToCheck = user.profileGroupId;
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String enabledPackage : enabledPackages) {
                boolean systemService = false;
                try {
                    ApplicationInfo applicationInfo = pm.getApplicationInfo(enabledPackage, 8192, userIdToCheck);
                    systemService = (applicationInfo.flags & 1) != 0;
                }
                catch (RemoteException e) {
                    Log.i(LOG_TAG, "Can't talk to package managed", e);
                }
                if (systemService || permittedList.contains(enabledPackage)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
        return true;
    }

    private AccessibilityManager getAccessibilityManagerForUser(int userId) {
        IBinder iBinder = ServiceManager.getService("accessibility");
        IAccessibilityManager service = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
        return new AccessibilityManager(this.mContext, service, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermittedAccessibilityServices(ComponentName who, List packageList) {
        if (!this.mHasFeature) {
            return false;
        }
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        if (packageList != null) {
            int userId = UserHandle.getCallingUserId();
            List<AccessibilityServiceInfo> enabledServices = null;
            long id2 = Binder.clearCallingIdentity();
            try {
                UserInfo user = this.mUserManager.getUserInfo(userId);
                if (user.isManagedProfile()) {
                    userId = user.profileGroupId;
                }
                AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                enabledServices = accessibilityManager.getEnabledAccessibilityServiceList(-1);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            if (enabledServices != null) {
                ArrayList<String> enabledPackages = new ArrayList<String>();
                for (AccessibilityServiceInfo service : enabledServices) {
                    enabledPackages.add(service.getResolveInfo().serviceInfo.packageName);
                }
                if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList)) {
                    Slog.e(LOG_TAG, "Cannot set permitted accessibility services, because it contains already enabled accesibility services.");
                    return false;
                }
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedAccessiblityServices = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPermittedAccessibilityServices(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedAccessiblityServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPermittedAccessibilityServicesForUser(int userId) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ArrayList<String> result = null;
            List profiles = this.mUserManager.getProfiles(userId);
            int PROFILES_SIZE = profiles.size();
            for (int i = 0; i < PROFILES_SIZE; ++i) {
                DevicePolicyData policy = this.getUserData(((UserInfo)profiles.get((int)i)).id);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedAccessiblityServices;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                long id2 = Binder.clearCallingIdentity();
                try {
                    UserInfo user = this.mUserManager.getUserInfo(userId);
                    if (user.isManagedProfile()) {
                        userId = user.profileGroupId;
                    }
                    AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                    List<AccessibilityServiceInfo> installedServices = accessibilityManager.getInstalledAccessibilityServiceList();
                    IPackageManager pm = AppGlobals.getPackageManager();
                    if (installedServices != null) {
                        for (AccessibilityServiceInfo service : installedServices) {
                            String packageName = service.getResolveInfo().serviceInfo.packageName;
                            try {
                                ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 8192, userId);
                                if ((applicationInfo.flags & 1) == 0) continue;
                                result.add(packageName);
                            }
                            catch (RemoteException e) {
                                Log.i(LOG_TAG, "Accessibility service in missing package", e);
                            }
                        }
                    }
                }
                finally {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCallerIsCurrentUserOrProfile() {
        int callingUserId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            UserInfo currentUser;
            UserInfo callingUser = this.mUserManager.getUserInfo(callingUserId);
            try {
                currentUser = ActivityManagerNative.getDefault().getCurrentUser();
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to talk to activity managed.", e);
                boolean bl = false;
                Binder.restoreCallingIdentity(token);
                return bl;
            }
            if (callingUser.isManagedProfile() && callingUser.profileGroupId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods for managed profile of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
            if (!callingUser.isManagedProfile() && callingUserId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermittedInputMethods(ComponentName who, List packageList) {
        InputMethodManager inputMethodManager;
        List<InputMethodInfo> enabledImes;
        if (!this.mHasFeature) {
            return false;
        }
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        if (!this.checkCallerIsCurrentUserOrProfile()) {
            return false;
        }
        if (packageList != null && (enabledImes = (inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method")).getEnabledInputMethodList()) != null) {
            ArrayList<String> enabledPackages = new ArrayList<String>();
            for (InputMethodInfo ime : enabledImes) {
                enabledPackages.add(ime.getPackageName());
            }
            if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList)) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods, because it contains already enabled input method.");
                return false;
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedInputMethods = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPermittedInputMethods(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        if (who == null) {
            throw new NullPointerException("ComponentName is null");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedInputMethods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPermittedInputMethodsForCurrentUser() {
        UserInfo currentUser;
        try {
            currentUser = ActivityManagerNative.getDefault().getCurrentUser();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to make remote calls to get current user", e);
            return null;
        }
        int userId = currentUser.id;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ArrayList<String> result = null;
            List profiles = this.mUserManager.getProfiles(userId);
            int PROFILES_SIZE = profiles.size();
            for (int i = 0; i < PROFILES_SIZE; ++i) {
                DevicePolicyData policy = this.getUserData(((UserInfo)profiles.get((int)i)).id);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedInputMethods;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
                List<InputMethodInfo> imes = inputMethodManager.getInputMethodList();
                long id2 = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    if (imes != null) {
                        for (InputMethodInfo ime : imes) {
                            String packageName = ime.getPackageName();
                            try {
                                ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 8192, userId);
                                if ((applicationInfo.flags & 1) == 0) continue;
                                result.add(packageName);
                            }
                            catch (RemoteException e) {
                                Log.i(LOG_TAG, "Input method for missing package", e);
                            }
                        }
                    }
                }
                finally {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserHandle createUser(ComponentName who, String name) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                UserInfo userInfo = this.mUserManager.createUser(name, 0);
                if (userInfo != null) {
                    UserHandle userHandle = userInfo.getUserHandle();
                    return userHandle;
                }
                UserHandle userHandle = null;
                return userHandle;
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserHandle createAndInitializeUser(ComponentName who, String name, String ownerName, ComponentName profileOwnerComponent, Bundle adminExtras) {
        UserHandle user = this.createUser(who, name);
        long id2 = Binder.clearCallingIdentity();
        try {
            String profileOwnerPkg = profileOwnerComponent.getPackageName();
            IPackageManager ipm = AppGlobals.getPackageManager();
            IActivityManager activityManager = ActivityManagerNative.getDefault();
            try {
                if (!ipm.isPackageAvailable(profileOwnerPkg, user.getIdentifier())) {
                    ipm.installExistingPackageAsUser(profileOwnerPkg, user.getIdentifier());
                }
                activityManager.startUserInBackground(user.getIdentifier());
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to make remote calls for configureUser", e);
            }
            this.setActiveAdmin(profileOwnerComponent, true, user.getIdentifier(), adminExtras);
            this.setProfileOwner(profileOwnerComponent, ownerName, user.getIdentifier());
            UserHandle userHandle = user;
            return userHandle;
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(ComponentName who, UserHandle userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                bl = this.mUserManager.removeUser(userHandle.getIdentifier());
            }
            catch (Throwable throwable) {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                throw throwable;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchUser(ComponentName who, UserHandle userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                int userId = 0;
                if (userHandle != null) {
                    userId = userHandle.getIdentifier();
                }
                bl = ActivityManagerNative.getDefault().switchUser(userId);
            }
            catch (RemoteException e) {
                boolean bl2;
                try {
                    Log.e(LOG_TAG, "Couldn't switch user", e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                    throw throwable;
                }
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                return bl2;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getApplicationRestrictions(ComponentName who, String packageName) {
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Bundle bundle;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                bundle = this.mUserManager.getApplicationRestrictions(packageName, userHandle);
            }
            catch (Throwable throwable) {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                throw throwable;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserRestriction(ComponentName who, String key, boolean enabled) {
        UserHandle user = new UserHandle(UserHandle.getCallingUserId());
        int userHandle = user.getIdentifier();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            boolean isDeviceOwner = this.isDeviceOwner(activeAdmin.info.getPackageName());
            if (!isDeviceOwner && userHandle != 0 && DEVICE_OWNER_USER_RESTRICTIONS.contains(key)) {
                throw new SecurityException("Profile owners cannot set user restriction " + key);
            }
            boolean alreadyRestricted = this.mUserManager.hasUserRestriction(key, user);
            IAudioService iAudioService = null;
            if ("no_unmute_microphone".equals(key) || "no_adjust_volume".equals(key)) {
                iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
            }
            if (enabled && !alreadyRestricted) {
                try {
                    if ("no_unmute_microphone".equals(key)) {
                        iAudioService.setMicrophoneMute(true, who.getPackageName());
                    } else if ("no_adjust_volume".equals(key)) {
                        iAudioService.setMasterMute(true, 0, who.getPackageName(), null);
                    }
                }
                catch (RemoteException re) {
                    Slog.e(LOG_TAG, "Failed to talk to AudioService.", re);
                }
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                if (enabled && !alreadyRestricted) {
                    if ("no_config_wifi".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 0, userHandle);
                    } else if ("no_usb_file_transfer".equals(key)) {
                        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
                        manager.setCurrentFunction("none", false);
                    } else if ("no_share_location".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "location_mode", 0, userHandle);
                        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "location_providers_allowed", "", userHandle);
                    } else if ("no_debugging_features".equals(key)) {
                        if (userHandle == 0) {
                            Settings.Global.putStringForUser(this.mContext.getContentResolver(), "adb_enabled", "0", userHandle);
                        }
                    } else if ("ensure_verify_apps".equals(key)) {
                        Settings.Global.putStringForUser(this.mContext.getContentResolver(), "package_verifier_enable", "1", userHandle);
                        Settings.Global.putStringForUser(this.mContext.getContentResolver(), "verifier_verify_adb_installs", "1", userHandle);
                    } else if ("no_install_unknown_sources".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "install_non_market_apps", 0, userHandle);
                    }
                }
                this.mUserManager.setUserRestriction(key, enabled, user);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            if (!enabled && alreadyRestricted) {
                try {
                    if ("no_unmute_microphone".equals(key)) {
                        iAudioService.setMicrophoneMute(false, who.getPackageName());
                    } else if ("no_adjust_volume".equals(key)) {
                        iAudioService.setMasterMute(false, 0, who.getPackageName(), null);
                    }
                }
                catch (RemoteException re) {
                    Slog.e(LOG_TAG, "Failed to talk to AudioService.", re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setApplicationHidden(ComponentName who, String packageName, boolean hidden) {
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.setApplicationHiddenSettingAsUser(packageName, hidden, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setApplicationHiddenSetting", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isApplicationHidden(ComponentName who, String packageName) {
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.getApplicationHiddenSettingAsUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getApplicationHiddenSettingAsUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSystemApp(ComponentName who, String packageName) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm;
                UserManager um = UserManager.get(this.mContext);
                UserInfo primaryUser = um.getProfileParent(userId);
                if (primaryUser == null) {
                    primaryUser = um.getUserInfo(userId);
                }
                if (!this.isSystemApp(pm = AppGlobals.getPackageManager(), packageName, primaryUser.id)) {
                    throw new IllegalArgumentException("Only system apps can be enabled this way.");
                }
                pm.installExistingPackageAsUser(packageName, userId);
            }
            catch (RemoteException re) {
                Slog.wtf(LOG_TAG, "Failed to install " + packageName, re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableSystemAppWithIntent(ComponentName who, Intent intent) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int n;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                UserManager um = UserManager.get(this.mContext);
                UserInfo primaryUser = um.getProfileParent(userId);
                if (primaryUser == null) {
                    primaryUser = um.getUserInfo(userId);
                }
                IPackageManager pm = AppGlobals.getPackageManager();
                List<ResolveInfo> activitiesToEnable = pm.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 0, primaryUser.id);
                int numberOfAppsInstalled = 0;
                if (activitiesToEnable != null) {
                    for (ResolveInfo info : activitiesToEnable) {
                        if (info.activityInfo == null) continue;
                        if (!this.isSystemApp(pm, info.activityInfo.packageName, primaryUser.id)) {
                            throw new IllegalArgumentException("Only system apps can be enabled this way.");
                        }
                        ++numberOfAppsInstalled;
                        pm.installExistingPackageAsUser(info.activityInfo.packageName, userId);
                    }
                }
                n = numberOfAppsInstalled;
            }
            catch (RemoteException e) {
                int n2;
                try {
                    Slog.wtf(LOG_TAG, "Failed to resolve intent for: " + intent);
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                    throw throwable;
                }
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                return n2;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return n;
        }
    }

    private boolean isSystemApp(IPackageManager pm, String packageName, int userId) throws RemoteException {
        ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 8192, userId);
        return (appInfo.flags & 1) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountManagementDisabled(ComponentName who, String accountType, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (disabled) {
                ap.accountTypesWithManagementDisabled.add(accountType);
            } else {
                ap.accountTypesWithManagementDisabled.remove(accountType);
            }
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
    }

    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAccountTypesWithManagementDisabledAsUser(int userId) {
        this.enforceCrossUserPermission(userId);
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userId);
            int N = policy.mAdminList.size();
            HashSet<String> resultSet = new HashSet<String>();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                resultSet.addAll(admin.accountTypesWithManagementDisabled);
            }
            return resultSet.toArray(new String[resultSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUninstallBlocked(ComponentName who, String packageName, boolean uninstallBlocked) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                pm.setBlockUninstallForUser(packageName, uninstallBlocked, userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setBlockUninstallForUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUninstallBlocked(ComponentName who, String packageName) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.getBlockUninstallForUser(packageName, userId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getBlockUninstallForUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrossProfileCallerIdDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableCallerId != disabled) {
                admin.disableCallerId = disabled;
                this.saveSettingsLocked(UserHandle.getCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCrossProfileCallerIdDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableCallerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCrossProfileCallerIdDisabledForUser(int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdmin(userId);
            return admin != null ? admin.disableCallerId : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockTaskPackages(ComponentName who, String[] packages) throws SecurityException {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            int userHandle = Binder.getCallingUserHandle().getIdentifier();
            DevicePolicyData policy = this.getUserData(userHandle);
            policy.mLockTaskPackages.clear();
            if (packages != null) {
                for (int j = 0; j < packages.length; ++j) {
                    String pkg = packages[j];
                    policy.mLockTaskPackages.add(pkg);
                }
            }
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockTaskPackages(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            int userHandle = Binder.getCallingUserHandle().getIdentifier();
            DevicePolicyData policy = this.getUserData(userHandle);
            return policy.mLockTaskPackages.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockTaskPermitted(String pkg) {
        int uid = Binder.getCallingUid();
        int userHandle = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            for (int i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String lockTaskPackage = policy.mLockTaskPackages.get(i);
                if (!lockTaskPackage.equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLockTaskModeChanged(boolean isEnabled, String pkg, int userHandle) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("notifyLockTaskModeChanged can only be called by system");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            Bundle adminExtras = new Bundle();
            adminExtras.putString("android.app.extra.LOCK_TASK_PACKAGE", pkg);
            for (ActiveAdmin admin : policy.mAdminList) {
                boolean ownsProfile;
                boolean ownsDevice = this.isDeviceOwner(admin.info.getPackageName());
                boolean bl = ownsProfile = this.getProfileOwner(userHandle) != null && this.getProfileOwner(userHandle).equals(admin.info.getPackageName());
                if (!ownsDevice && !ownsProfile) continue;
                if (isEnabled) {
                    this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_ENTERING", adminExtras, null);
                    continue;
                }
                this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_EXITING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalSetting(ComponentName who, String setting, String value) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -2);
            if (!GLOBAL_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: device owners cannot update %1$s", setting));
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(contentResolver, setting, value);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecureSetting(ComponentName who, String setting, String value) {
        int callingUserId = UserHandle.getCallingUserId();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            if (this.isDeviceOwner(activeAdmin.info.getPackageName())) {
                if (!SECURE_SETTINGS_DEVICEOWNER_WHITELIST.contains(setting)) {
                    throw new SecurityException(String.format("Permission denial: Device owners cannot update %1$s", setting));
                }
            } else if (!SECURE_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: Profile owners cannot update %1$s", setting));
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putStringForUser(contentResolver, setting, value, callingUserId);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterVolumeMuted(ComponentName who, boolean on) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
            try {
                iAudioService.setMasterMute(on, 0, who.getPackageName(), null);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setMasterMute", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMasterVolumeMuted(ComponentName who) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            this.getActiveAdminForCallerLocked(who, -1);
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            return audioManager.isMasterMute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUserSetupComplete() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        ContentResolver resolver = this.mContext.getContentResolver();
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            int userHandle = users.get((int)i).id;
            if (Settings.Secure.getIntForUser(resolver, "user_setup_complete", 0, userHandle) == 0) continue;
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mUserSetupComplete) continue;
            policy.mUserSetupComplete = true;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.saveSettingsLocked(userHandle);
                continue;
            }
        }
    }

    static {
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_usb_file_transfer");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_tethering");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_factory_reset");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_add_user");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_cell_broadcasts");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_mobile_networks");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_physical_media");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_unmute_microphone");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_adjust_volume");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_sms");
        SECURE_SETTINGS_WHITELIST = new HashSet<String>();
        SECURE_SETTINGS_WHITELIST.add("default_input_method");
        SECURE_SETTINGS_WHITELIST.add("skip_first_use_hints");
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST = new HashSet<String>();
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.addAll(SECURE_SETTINGS_WHITELIST);
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.add("location_mode");
        GLOBAL_SETTINGS_WHITELIST = new HashSet<String>();
        GLOBAL_SETTINGS_WHITELIST.add("adb_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time_zone");
        GLOBAL_SETTINGS_WHITELIST.add("bluetooth_on");
        GLOBAL_SETTINGS_WHITELIST.add("data_roaming");
        GLOBAL_SETTINGS_WHITELIST.add("development_settings_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("mode_ringer");
        GLOBAL_SETTINGS_WHITELIST.add("network_preference");
        GLOBAL_SETTINGS_WHITELIST.add("usb_mass_storage_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_on");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_sleep_policy");
    }

    private final class LocalService
    extends DevicePolicyManagerInternal {
        private List<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> mWidgetProviderListeners;

        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getCrossProfileWidgetProviders(int profileId) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (DevicePolicyManagerService.this.mDeviceOwner == null) {
                    return Collections.emptyList();
                }
                ComponentName ownerComponent = DevicePolicyManagerService.this.mDeviceOwner.getProfileOwnerComponent(profileId);
                if (ownerComponent == null) {
                    return Collections.emptyList();
                }
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(profileId);
                ActiveAdmin admin = policy.mAdminMap.get(ownerComponent);
                if (admin == null || admin.crossProfileWidgetProviders == null || admin.crossProfileWidgetProviders.isEmpty()) {
                    return Collections.emptyList();
                }
                return admin.crossProfileWidgetProviders;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnCrossProfileWidgetProvidersChangeListener(DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (this.mWidgetProviderListeners == null) {
                    this.mWidgetProviderListeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>();
                }
                if (!this.mWidgetProviderListeners.contains(listener)) {
                    this.mWidgetProviderListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCrossProfileProvidersChanged(int userId, List<String> packages) {
            ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> listeners;
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                listeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>(this.mWidgetProviderListeners);
            }
            int listenerCount = listeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener = (DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener)listeners.get(i);
                listener.onCrossProfileWidgetProvidersChanged(userId, packages);
            }
        }
    }

    private class SetupContentObserver
    extends ContentObserver {
        private final Uri mUserSetupComplete;

        public SetupContentObserver(Handler handler) {
            super(handler);
            this.mUserSetupComplete = Settings.Secure.getUriFor("user_setup_complete");
        }

        void register(ContentResolver resolver) {
            resolver.registerContentObserver(this.mUserSetupComplete, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mUserSetupComplete.equals(uri)) {
                DevicePolicyManagerService.this.updateUserSetupComplete();
            }
        }
    }

    private class MonitoringCertNotificationTask
    extends AsyncTask<Intent, Void, Void> {
        private MonitoringCertNotificationTask() {
        }

        protected Void doInBackground(Intent ... params) {
            int userHandle = params[0].getIntExtra("android.intent.extra.user_handle", -1);
            if (userHandle == -1) {
                for (UserInfo userInfo : DevicePolicyManagerService.this.mUserManager.getUsers()) {
                    this.manageNotification(userInfo.getUserHandle());
                }
            } else {
                this.manageNotification(new UserHandle(userHandle));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageNotification(UserHandle userHandle) {
            Context userContext;
            int smallIconId;
            String contentText;
            if (!DevicePolicyManagerService.this.mUserManager.isUserRunning(userHandle)) {
                return;
            }
            boolean hasCert = false;
            long id2 = Binder.clearCallingIdentity();
            try (KeyChain.KeyChainConnection kcs = KeyChain.bindAsUser((Context)DevicePolicyManagerService.this.mContext, (UserHandle)userHandle);){
                if (!kcs.getService().getUserCaAliases().getList().isEmpty()) {
                    hasCert = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Could not connect to KeyChain service", e);
            }
            finally {
                Binder.restoreCallingIdentity(id2);
            }
            if (!hasCert) {
                DevicePolicyManagerService.this.getNotificationManager().cancelAsUser(null, 17039584, userHandle);
                return;
            }
            String ownerName = DevicePolicyManagerService.this.getDeviceOwnerName();
            if (ownerName != null) {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039586, ownerName);
                smallIconId = 17303157;
            } else {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039585);
                smallIconId = 17301642;
            }
            Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
            dialogIntent.setFlags(0x10008000);
            dialogIntent.setPackage("com.android.settings");
            PendingIntent notifyIntent = PendingIntent.getActivityAsUser(DevicePolicyManagerService.this.mContext, 0, dialogIntent, 0x8000000, null, userHandle);
            try {
                userContext = DevicePolicyManagerService.this.mContext.createPackageContextAsUser("android", 0, userHandle);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Create context as " + userHandle + " failed", e);
                return;
            }
            Notification noti = new Notification.Builder(userContext).setSmallIcon(smallIconId).setContentTitle(DevicePolicyManagerService.this.mContext.getString(17039584)).setContentText(contentText).setContentIntent(notifyIntent).setPriority(1).setShowWhen(false).setColor(DevicePolicyManagerService.this.mContext.getResources().getColor(17170520)).build();
            DevicePolicyManagerService.this.getNotificationManager().notifyAsUser(null, 17039584, noti, userHandle);
        }
    }

    static class ActiveAdmin {
        private static final String TAG_DISABLE_KEYGUARD_FEATURES = "disable-keyguard-features";
        private static final String TAG_DISABLE_CAMERA = "disable-camera";
        private static final String TAG_DISABLE_CALLER_ID = "disable-caller-id";
        private static final String TAG_DISABLE_SCREEN_CAPTURE = "disable-screen-capture";
        private static final String TAG_DISABLE_ACCOUNT_MANAGEMENT = "disable-account-management";
        private static final String TAG_REQUIRE_AUTO_TIME = "require_auto_time";
        private static final String TAG_ACCOUNT_TYPE = "account-type";
        private static final String TAG_PERMITTED_ACCESSIBILITY_SERVICES = "permitted-accessiblity-services";
        private static final String TAG_ENCRYPTION_REQUESTED = "encryption-requested";
        private static final String TAG_MANAGE_TRUST_AGENT_FEATURES = "manage-trust-agent-features";
        private static final String TAG_TRUST_AGENT_FEATURE = "feature";
        private static final String TAG_TRUST_AGENT_COMPONENT = "component";
        private static final String TAG_PASSWORD_EXPIRATION_DATE = "password-expiration-date";
        private static final String TAG_PASSWORD_EXPIRATION_TIMEOUT = "password-expiration-timeout";
        private static final String TAG_GLOBAL_PROXY_EXCLUSION_LIST = "global-proxy-exclusion-list";
        private static final String TAG_GLOBAL_PROXY_SPEC = "global-proxy-spec";
        private static final String TAG_SPECIFIES_GLOBAL_PROXY = "specifies-global-proxy";
        private static final String TAG_PERMITTED_IMES = "permitted-imes";
        private static final String TAG_MAX_FAILED_PASSWORD_WIPE = "max-failed-password-wipe";
        private static final String TAG_MAX_TIME_TO_UNLOCK = "max-time-to-unlock";
        private static final String TAG_MIN_PASSWORD_NONLETTER = "min-password-nonletter";
        private static final String TAG_MIN_PASSWORD_SYMBOLS = "min-password-symbols";
        private static final String TAG_MIN_PASSWORD_NUMERIC = "min-password-numeric";
        private static final String TAG_MIN_PASSWORD_LETTERS = "min-password-letters";
        private static final String TAG_MIN_PASSWORD_LOWERCASE = "min-password-lowercase";
        private static final String TAG_MIN_PASSWORD_UPPERCASE = "min-password-uppercase";
        private static final String TAG_PASSWORD_HISTORY_LENGTH = "password-history-length";
        private static final String TAG_MIN_PASSWORD_LENGTH = "min-password-length";
        private static final String ATTR_VALUE = "value";
        private static final String TAG_PASSWORD_QUALITY = "password-quality";
        private static final String TAG_POLICIES = "policies";
        private static final String TAG_CROSS_PROFILE_WIDGET_PROVIDERS = "cross-profile-widget-providers";
        private static final String TAG_PROVIDER = "provider";
        private static final String TAG_PACKAGE_LIST_ITEM = "item";
        final DeviceAdminInfo info;
        int passwordQuality = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        int minimumPasswordLength = 0;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        int minimumPasswordUpperCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        int minimumPasswordLowerCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        int minimumPasswordLetters = 1;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        int minimumPasswordNumeric = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        int minimumPasswordSymbols = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        int minimumPasswordNonLetter = 0;
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        static final int DEF_KEYGUARD_FEATURES_DISABLED = 0;
        int disabledKeyguardFeatures = 0;
        boolean encryptionRequested = false;
        boolean disableCamera = false;
        boolean disableCallerId = false;
        boolean disableScreenCapture = false;
        boolean requireAutoTime = false;
        Set<String> accountTypesWithManagementDisabled = new HashSet<String>();
        List<String> permittedAccessiblityServices;
        List<String> permittedInputMethods;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;
        HashMap<String, List<String>> trustAgentFeatures = new HashMap();
        List<String> crossProfileWidgetProviders;

        ActiveAdmin(DeviceAdminInfo _info) {
            this.info = _info;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        public UserHandle getUserHandle() {
            return new UserHandle(UserHandle.getUserId(this.info.getActivityInfo().applicationInfo.uid));
        }

        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, TAG_POLICIES);
            this.info.writePoliciesToXml(out);
            out.endTag(null, TAG_POLICIES);
            if (this.passwordQuality != 0) {
                out.startTag(null, TAG_PASSWORD_QUALITY);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.passwordQuality));
                out.endTag(null, TAG_PASSWORD_QUALITY);
                if (this.minimumPasswordLength != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LENGTH);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLength));
                    out.endTag(null, TAG_MIN_PASSWORD_LENGTH);
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                }
                if (this.minimumPasswordUpperCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordUpperCase));
                    out.endTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                }
                if (this.minimumPasswordLowerCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLowerCase));
                    out.endTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                }
                if (this.minimumPasswordLetters != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_LETTERS);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLetters));
                    out.endTag(null, TAG_MIN_PASSWORD_LETTERS);
                }
                if (this.minimumPasswordNumeric != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_NUMERIC);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordNumeric));
                    out.endTag(null, TAG_MIN_PASSWORD_NUMERIC);
                }
                if (this.minimumPasswordSymbols != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordSymbols));
                    out.endTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                }
                if (this.minimumPasswordNonLetter > 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_NONLETTER);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordNonLetter));
                    out.endTag(null, TAG_MIN_PASSWORD_NONLETTER);
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, TAG_MAX_TIME_TO_UNLOCK);
                out.attribute(null, ATTR_VALUE, Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, TAG_MAX_TIME_TO_UNLOCK);
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                if (this.globalProxySpec != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_SPEC);
                    out.attribute(null, ATTR_VALUE, this.globalProxySpec);
                    out.endTag(null, TAG_GLOBAL_PROXY_SPEC);
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                    out.attribute(null, ATTR_VALUE, this.globalProxyExclusionList);
                    out.endTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
                out.attribute(null, ATTR_VALUE, Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_DATE);
                out.attribute(null, ATTR_VALUE, Long.toString(this.passwordExpirationDate));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_DATE);
            }
            if (this.encryptionRequested) {
                out.startTag(null, TAG_ENCRYPTION_REQUESTED);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.encryptionRequested));
                out.endTag(null, TAG_ENCRYPTION_REQUESTED);
            }
            if (this.disableCamera) {
                out.startTag(null, TAG_DISABLE_CAMERA);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableCamera));
                out.endTag(null, TAG_DISABLE_CAMERA);
            }
            if (this.disableCallerId) {
                out.startTag(null, TAG_DISABLE_CALLER_ID);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableCallerId));
                out.endTag(null, TAG_DISABLE_CALLER_ID);
            }
            if (this.disableScreenCapture) {
                out.startTag(null, TAG_DISABLE_SCREEN_CAPTURE);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableScreenCapture));
                out.endTag(null, TAG_DISABLE_SCREEN_CAPTURE);
            }
            if (this.requireAutoTime) {
                out.startTag(null, TAG_REQUIRE_AUTO_TIME);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.requireAutoTime));
                out.endTag(null, TAG_REQUIRE_AUTO_TIME);
            }
            if (this.disabledKeyguardFeatures != 0) {
                out.startTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.disabledKeyguardFeatures));
                out.endTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
            }
            if (!this.accountTypesWithManagementDisabled.isEmpty()) {
                out.startTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
                for (String ac : this.accountTypesWithManagementDisabled) {
                    out.startTag(null, TAG_ACCOUNT_TYPE);
                    out.attribute(null, ATTR_VALUE, ac);
                    out.endTag(null, TAG_ACCOUNT_TYPE);
                }
                out.endTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
            }
            if (!this.trustAgentFeatures.isEmpty()) {
                Set<Map.Entry<String, List<String>>> set = this.trustAgentFeatures.entrySet();
                out.startTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
                for (Map.Entry<String, List<String>> component : set) {
                    out.startTag(null, TAG_TRUST_AGENT_COMPONENT);
                    out.attribute(null, ATTR_VALUE, component.getKey());
                    for (String feature : component.getValue()) {
                        out.startTag(null, TAG_TRUST_AGENT_FEATURE);
                        out.attribute(null, ATTR_VALUE, feature);
                        out.endTag(null, TAG_TRUST_AGENT_FEATURE);
                    }
                    out.endTag(null, TAG_TRUST_AGENT_COMPONENT);
                }
                out.endTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
            }
            if (this.crossProfileWidgetProviders != null && !this.crossProfileWidgetProviders.isEmpty()) {
                out.startTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
                int providerCount = this.crossProfileWidgetProviders.size();
                for (int i = 0; i < providerCount; ++i) {
                    String provider = this.crossProfileWidgetProviders.get(i);
                    out.startTag(null, TAG_PROVIDER);
                    out.attribute(null, ATTR_VALUE, provider);
                    out.endTag(null, TAG_PROVIDER);
                }
                out.endTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
            }
            this.writePackageListToXml(out, TAG_PERMITTED_ACCESSIBILITY_SERVICES, this.permittedAccessiblityServices);
            this.writePackageListToXml(out, TAG_PERMITTED_IMES, this.permittedInputMethods);
        }

        void writePackageListToXml(XmlSerializer out, String outerTag, List<String> packageList) throws IllegalArgumentException, IllegalStateException, IOException {
            if (packageList == null) {
                return;
            }
            out.startTag(null, outerTag);
            for (String packageName : packageList) {
                out.startTag(null, TAG_PACKAGE_LIST_ITEM);
                out.attribute(null, ATTR_VALUE, packageName);
                out.endTag(null, TAG_PACKAGE_LIST_ITEM);
            }
            out.endTag(null, outerTag);
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if (TAG_POLICIES.equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                } else if (TAG_PASSWORD_QUALITY.equals(tag)) {
                    this.passwordQuality = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_LENGTH.equals(tag)) {
                    this.minimumPasswordLength = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_PASSWORD_HISTORY_LENGTH.equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_UPPERCASE.equals(tag)) {
                    this.minimumPasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_LOWERCASE.equals(tag)) {
                    this.minimumPasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_LETTERS.equals(tag)) {
                    this.minimumPasswordLetters = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_NUMERIC.equals(tag)) {
                    this.minimumPasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_SYMBOLS.equals(tag)) {
                    this.minimumPasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MIN_PASSWORD_NONLETTER.equals(tag)) {
                    this.minimumPasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MAX_TIME_TO_UNLOCK.equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_MAX_FAILED_PASSWORD_WIPE.equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_SPECIFIES_GLOBAL_PROXY.equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_GLOBAL_PROXY_SPEC.equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, ATTR_VALUE);
                } else if (TAG_GLOBAL_PROXY_EXCLUSION_LIST.equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, ATTR_VALUE);
                } else if (TAG_PASSWORD_EXPIRATION_TIMEOUT.equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_PASSWORD_EXPIRATION_DATE.equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_ENCRYPTION_REQUESTED.equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_DISABLE_CAMERA.equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_DISABLE_CALLER_ID.equals(tag)) {
                    this.disableCallerId = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_DISABLE_SCREEN_CAPTURE.equals(tag)) {
                    this.disableScreenCapture = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_REQUIRE_AUTO_TIME.equals(tag)) {
                    this.requireAutoTime = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_DISABLE_KEYGUARD_FEATURES.equals(tag)) {
                    this.disabledKeyguardFeatures = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                } else if (TAG_DISABLE_ACCOUNT_MANAGEMENT.equals(tag)) {
                    this.accountTypesWithManagementDisabled = this.readDisableAccountInfo(parser, tag);
                } else if (TAG_MANAGE_TRUST_AGENT_FEATURES.equals(tag)) {
                    this.trustAgentFeatures = this.getAllTrustAgentFeatures(parser, tag);
                } else if (TAG_CROSS_PROFILE_WIDGET_PROVIDERS.equals(tag)) {
                    this.crossProfileWidgetProviders = this.getCrossProfileWidgetProviders(parser, tag);
                } else if (TAG_PERMITTED_ACCESSIBILITY_SERVICES.equals(tag)) {
                    this.permittedAccessiblityServices = this.readPackageList(parser, tag);
                } else if (TAG_PERMITTED_IMES.equals(tag)) {
                    this.permittedInputMethods = this.readPackageList(parser, tag);
                } else {
                    Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown admin tag: " + tag);
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }

        private List<String> readPackageList(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int outerType;
            ArrayList<String> result = new ArrayList<String>();
            int outerDepth = parser.getDepth();
            while ((outerType = parser.next()) != 1 && (outerType != 3 || parser.getDepth() > outerDepth)) {
                if (outerType == 3 || outerType == 4) continue;
                String outerTag = parser.getName();
                if (TAG_PACKAGE_LIST_ITEM.equals(outerTag)) {
                    String packageName = parser.getAttributeValue(null, ATTR_VALUE);
                    if (packageName != null) {
                        result.add(packageName);
                        continue;
                    }
                    Slog.w(DevicePolicyManagerService.LOG_TAG, "Package name missing under " + outerTag);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + outerTag);
            }
            return result;
        }

        private Set<String> readDisableAccountInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            HashSet<String> result = new HashSet<String>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_ACCOUNT_TYPE.equals(tagDAM)) {
                    result.add(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private HashMap<String, List<String>> getAllTrustAgentFeatures(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT.equals(tagDAM)) {
                    String component = parser.getAttributeValue(null, ATTR_VALUE);
                    result.put(component, this.getTrustAgentFeatures(parser, tag));
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private List<String> getTrustAgentFeatures(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayList<String> result = new ArrayList<String>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_FEATURE.equals(tagDAM)) {
                    String feature = parser.getAttributeValue(null, ATTR_VALUE);
                    result.add(feature);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private List<String> getCrossProfileWidgetProviders(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayList<String> result = null;
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_PROVIDER.equals(tagDAM)) {
                    String provider = parser.getAttributeValue(null, ATTR_VALUE);
                    if (result == null) {
                        result = new ArrayList<String>();
                    }
                    result.add(provider);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.println("policies:");
            ArrayList<DeviceAdminInfo.PolicyInfo> pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(pols.get((int)i).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.passwordQuality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordLength);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordUpperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordLowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordLetters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordNumeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordSymbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordNonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
            pw.print(prefix);
            pw.print("disableCallerId=");
            pw.println(this.disableCallerId);
            pw.print(prefix);
            pw.print("disableScreenCapture=");
            pw.println(this.disableScreenCapture);
            pw.print(prefix);
            pw.print("requireAutoTime=");
            pw.println(this.requireAutoTime);
            pw.print(prefix);
            pw.print("disabledKeyguardFeatures=");
            pw.println(this.disabledKeyguardFeatures);
            pw.print(prefix);
            pw.print("crossProfileWidgetProviders=");
            pw.println(this.crossProfileWidgetProviders);
            if (this.permittedAccessiblityServices != null) {
                pw.print(prefix);
                pw.print("permittedAccessibilityServices=");
                pw.println(this.permittedAccessiblityServices.toString());
            }
            if (this.permittedInputMethods != null) {
                pw.print(prefix);
                pw.print("permittedInputMethods=");
                pw.println(this.permittedInputMethods.toString());
            }
        }
    }

    public static class DevicePolicyData {
        int mActivePasswordQuality = 0;
        int mActivePasswordLength = 0;
        int mActivePasswordUpperCase = 0;
        int mActivePasswordLowerCase = 0;
        int mActivePasswordLetters = 0;
        int mActivePasswordNumeric = 0;
        int mActivePasswordSymbols = 0;
        int mActivePasswordNonLetter = 0;
        int mFailedPasswordAttempts = 0;
        int mUserHandle;
        int mPasswordOwner = -1;
        long mLastMaximumTimeToLock = -1L;
        boolean mUserSetupComplete = false;
        final HashMap<ComponentName, ActiveAdmin> mAdminMap = new HashMap();
        final ArrayList<ActiveAdmin> mAdminList = new ArrayList();
        final List<String> mLockTaskPackages = new ArrayList<String>();
        ComponentName mRestrictionsProvider;

        public DevicePolicyData(int userHandle) {
            this.mUserHandle = userHandle;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private DevicePolicyManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new DevicePolicyManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("device_policy", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 480) {
                this.mService.systemReady();
            }
        }
    }
}

