/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.os.Binder;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.app.IUsageStats;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.PkgUsageStats;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UsageStatsService
extends IUsageStats.Stub {
    public static final String SERVICE_NAME = "usagestats";
    private static final boolean localLOGV = false;
    private static final boolean REPORT_UNEXPECTED = false;
    private static final String TAG = "UsageStats";
    private static final int VERSION = 1008;
    private static final int CHECKIN_VERSION = 4;
    private static final String FILE_PREFIX = "usage-";
    private static final String FILE_HISTORY = "usage-history.xml";
    private static final int FILE_WRITE_INTERVAL = 1800000;
    private static final int MAX_NUM_FILES = 5;
    private static final int NUM_LAUNCH_TIME_BINS = 10;
    private static final int[] LAUNCH_TIME_BINS = new int[]{250, 500, 750, 1000, 1500, 2000, 3000, 4000, 5000};
    static IUsageStats sService;
    private Context mContext;
    private final ArrayMap<String, PkgUsageStatsExtended> mStats;
    private final ArrayMap<String, ArrayMap<String, Long>> mLastResumeTimes;
    private PackageMonitor mPackageMonitor;
    final Object mStatsLock;
    final Object mFileLock;
    private String mLastResumedPkg;
    private String mLastResumedComp;
    private boolean mIsResumed;
    private File mFile;
    private AtomicFile mHistoryFile;
    private String mFileLeaf;
    private File mDir;
    private Calendar mCal;
    private final AtomicInteger mLastWriteDay = new AtomicInteger(-1);
    private final AtomicLong mLastWriteElapsedTime = new AtomicLong(0L);
    private final AtomicBoolean mUnforcedDiskWriteRunning = new AtomicBoolean(false);

    UsageStatsService(String dir) {
        this.mStats = new ArrayMap();
        this.mLastResumeTimes = new ArrayMap();
        this.mStatsLock = new Object();
        this.mFileLock = new Object();
        this.mDir = new File(dir);
        this.mCal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        this.mDir.mkdir();
        File parentDir = this.mDir.getParentFile();
        String[] fList = parentDir.list();
        if (fList != null) {
            String prefix = this.mDir.getName() + ".";
            int i = fList.length;
            while (i > 0) {
                if (!fList[--i].startsWith(prefix)) continue;
                Slog.i(TAG, "Deleting old usage file: " + fList[i]);
                new File(parentDir, fList[i]).delete();
            }
        }
        this.mFileLeaf = this.getCurrentDateStr(FILE_PREFIX);
        this.mFile = new File(this.mDir, this.mFileLeaf);
        this.mHistoryFile = new AtomicFile(new File(this.mDir, FILE_HISTORY));
        this.readStatsFromFile();
        this.readHistoryStatsFromFile();
        this.mLastWriteElapsedTime.set(SystemClock.elapsedRealtime());
        this.mLastWriteDay.set(this.mCal.get(6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentDateStr(String prefix) {
        StringBuilder sb = new StringBuilder();
        Calendar calendar = this.mCal;
        synchronized (calendar) {
            this.mCal.setTimeInMillis(System.currentTimeMillis());
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(this.mCal.get(1));
            int mm = this.mCal.get(2) - 0 + 1;
            if (mm < 10) {
                sb.append("0");
            }
            sb.append(mm);
            int dd = this.mCal.get(5);
            if (dd < 10) {
                sb.append("0");
            }
            sb.append(dd);
        }
        return sb.toString();
    }

    private Parcel getParcelForFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        byte[] raw2 = UsageStatsService.readFully(stream);
        Parcel in = Parcel.obtain();
        in.unmarshall(raw2, 0, raw2.length);
        in.setDataPosition(0);
        stream.close();
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStatsFromFile() {
        File newFile = this.mFile;
        Object object = this.mFileLock;
        synchronized (object) {
            try {
                if (newFile.exists()) {
                    this.readStatsFLOCK(newFile);
                } else {
                    this.checkFileLimitFLOCK();
                    newFile.createNewFile();
                }
            }
            catch (IOException e) {
                Slog.w(TAG, "Error : " + e + " reading data from file:" + newFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStatsFLOCK(File file) throws IOException {
        Parcel in = this.getParcelForFile(file);
        int vers = in.readInt();
        if (vers != 1008) {
            Slog.w(TAG, "Usage stats version changed; dropping");
            return;
        }
        for (int N = in.readInt(); N > 0; --N) {
            String pkgName = in.readString();
            if (pkgName == null) break;
            PkgUsageStatsExtended pus = new PkgUsageStatsExtended(in);
            Object object = this.mStatsLock;
            synchronized (object) {
                this.mStats.put(pkgName, pus);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoryStatsFromFile() {
        Object object = this.mFileLock;
        synchronized (object) {
            if (this.mHistoryFile.getBaseFile().exists()) {
                this.readHistoryStatsFLOCK(this.mHistoryFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoryStatsFLOCK(AtomicFile file) {
        block26: {
            FileInputStream fis = null;
            try {
                fis = this.mHistoryFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"usage-history".equals(tagName)) break block26;
                String pkg = null;
                do {
                    if ((eventType = parser.next()) == 2) {
                        tagName = parser.getName();
                        int depth = parser.getDepth();
                        if ("pkg".equals(tagName) && depth == 2) {
                            pkg = parser.getAttributeValue(null, "name");
                            continue;
                        }
                        if (!"comp".equals(tagName) || depth != 3 || pkg == null) continue;
                        String comp = parser.getAttributeValue(null, "name");
                        String lastResumeTimeStr = parser.getAttributeValue(null, "lrt");
                        if (comp == null || lastResumeTimeStr == null) continue;
                        try {
                            long lastResumeTime = Long.parseLong(lastResumeTimeStr);
                            Object object = this.mStatsLock;
                            synchronized (object) {
                                ArrayMap<String, Long> lrt = this.mLastResumeTimes.get(pkg);
                                if (lrt == null) {
                                    lrt = new ArrayMap();
                                    this.mLastResumeTimes.put(pkg, lrt);
                                }
                                lrt.put(comp, lastResumeTime);
                            }
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (eventType != 3 || !"pkg".equals(parser.getName())) continue;
                    pkg = null;
                } while (eventType != 1);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Error reading history stats: " + e);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error reading history stats: " + e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private ArrayList<String> getUsageStatsFileListFLOCK() {
        String[] fList = this.mDir.list();
        if (fList == null) {
            return null;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        for (String file : fList) {
            if (!file.startsWith(FILE_PREFIX)) continue;
            if (file.endsWith(".bak")) {
                new File(this.mDir, file).delete();
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    private void checkFileLimitFLOCK() {
        ArrayList<String> fileList = this.getUsageStatsFileListFLOCK();
        if (fileList == null) {
            return;
        }
        int count = fileList.size();
        if (count <= 5) {
            return;
        }
        Collections.sort(fileList);
        count -= 5;
        for (int i = 0; i < count; ++i) {
            String fileName = fileList.get(i);
            File file = new File(this.mDir, fileName);
            Slog.i(TAG, "Deleting usage file : " + fileName);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsToFile(boolean force, boolean forceWriteHistoryStats) {
        int curDay;
        Calendar calendar = this.mCal;
        synchronized (calendar) {
            this.mCal.setTimeInMillis(System.currentTimeMillis());
            curDay = this.mCal.get(6);
        }
        boolean dayChanged = curDay != this.mLastWriteDay.get();
        long currElapsedTime = SystemClock.elapsedRealtime();
        if (!force) {
            if (!dayChanged && currElapsedTime - this.mLastWriteElapsedTime.get() < 1800000L) {
                return;
            }
            if (this.mUnforcedDiskWriteRunning.compareAndSet(false, true)) {
                new Thread("UsageStatsService_DiskWriter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            UsageStatsService.this.writeStatsToFile(true, false);
                        }
                        finally {
                            UsageStatsService.this.mUnforcedDiskWriteRunning.set(false);
                        }
                    }
                }.start();
            }
            return;
        }
        Object object = this.mFileLock;
        synchronized (object) {
            block21: {
                this.mFileLeaf = this.getCurrentDateStr(FILE_PREFIX);
                File backupFile = null;
                if (this.mFile != null && this.mFile.exists()) {
                    backupFile = new File(this.mFile.getPath() + ".bak");
                    if (!backupFile.exists()) {
                        if (!this.mFile.renameTo(backupFile)) {
                            Slog.w(TAG, "Failed to persist new stats");
                            return;
                        }
                    } else {
                        this.mFile.delete();
                    }
                }
                try {
                    this.writeStatsFLOCK(this.mFile);
                    this.mLastWriteElapsedTime.set(currElapsedTime);
                    if (dayChanged) {
                        this.mLastWriteDay.set(curDay);
                        ArrayMap<String, PkgUsageStatsExtended> arrayMap = this.mStats;
                        synchronized (arrayMap) {
                            this.mStats.clear();
                        }
                        this.mFile = new File(this.mDir, this.mFileLeaf);
                        this.checkFileLimitFLOCK();
                    }
                    if (dayChanged || forceWriteHistoryStats) {
                        this.writeHistoryStatsFLOCK(this.mHistoryFile);
                    }
                    if (backupFile != null) {
                        backupFile.delete();
                    }
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed writing stats to file:" + this.mFile);
                    if (backupFile == null) break block21;
                    this.mFile.delete();
                    backupFile.renameTo(this.mFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsFLOCK(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Parcel out = Parcel.obtain();
            this.writeStatsToParcelFLOCK(out);
            stream.write(out.marshall());
            out.recycle();
            stream.flush();
        }
        finally {
            FileUtils.sync(stream);
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatsToParcelFLOCK(Parcel out) {
        Object object = this.mStatsLock;
        synchronized (object) {
            out.writeInt(1008);
            Set<String> keys = this.mStats.keySet();
            out.writeInt(keys.size());
            for (String key : keys) {
                PkgUsageStatsExtended pus = this.mStats.get(key);
                out.writeString(key);
                pus.writeToParcel(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterHistoryStats() {
        Object object = this.mStatsLock;
        synchronized (object) {
            IPackageManager pm = AppGlobals.getPackageManager();
            for (int i = 0; i < this.mLastResumeTimes.size(); ++i) {
                String pkg = this.mLastResumeTimes.keyAt(i);
                try {
                    if (pm.getPackageUid(pkg, 0) >= 0) continue;
                    this.mLastResumeTimes.removeAt(i);
                    --i;
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistoryStatsFLOCK(AtomicFile historyFile) {
        block7: {
            FileOutputStream fos = null;
            try {
                fos = historyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "usage-history");
                Object object = this.mStatsLock;
                synchronized (object) {
                    for (int i = 0; i < this.mLastResumeTimes.size(); ++i) {
                        out.startTag(null, "pkg");
                        out.attribute(null, "name", this.mLastResumeTimes.keyAt(i));
                        ArrayMap<String, Long> comp = this.mLastResumeTimes.valueAt(i);
                        for (int j = 0; j < comp.size(); ++j) {
                            out.startTag(null, "comp");
                            out.attribute(null, "name", comp.keyAt(j));
                            out.attribute(null, "lrt", comp.valueAt(j).toString());
                            out.endTag(null, "comp");
                        }
                        out.endTag(null, "pkg");
                    }
                }
                out.endTag(null, "usage-history");
                out.endDocument();
                historyFile.finishWrite(fos);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error writing history stats" + e);
                if (fos == null) break block7;
                historyFile.failWrite(fos);
            }
        }
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService(SERVICE_NAME, this.asBinder());
    }

    public void monitorPackages() {
        this.mPackageMonitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPackageRemovedAllUsers(String packageName, int uid) {
                Object object = UsageStatsService.this.mStatsLock;
                synchronized (object) {
                    UsageStatsService.this.mLastResumeTimes.remove(packageName);
                }
            }
        };
        this.mPackageMonitor.register(this.mContext, null, true);
        this.filterHistoryStats();
    }

    public void shutdown() {
        if (this.mPackageMonitor != null) {
            this.mPackageMonitor.unregister();
        }
        Slog.i(TAG, "Writing usage stats before shutdown...");
        this.writeStatsToFile(true, true);
    }

    public static IUsageStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService(SERVICE_NAME);
        sService = UsageStatsService.asInterface(b);
        return sService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResumeComponent(ComponentName componentName) {
        this.enforceCallingPermission();
        Object object = this.mStatsLock;
        synchronized (object) {
            ArrayMap<String, Long> componentResumeTimes;
            PkgUsageStatsExtended pus;
            String pkgName;
            if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
                return;
            }
            boolean samePackage = pkgName.equals(this.mLastResumedPkg);
            if (this.mIsResumed && this.mLastResumedPkg != null && (pus = this.mStats.get(this.mLastResumedPkg)) != null) {
                pus.updatePause();
            }
            boolean sameComp = samePackage && componentName.getClassName().equals(this.mLastResumedComp);
            this.mIsResumed = true;
            this.mLastResumedPkg = pkgName;
            this.mLastResumedComp = componentName.getClassName();
            PkgUsageStatsExtended pus2 = this.mStats.get(pkgName);
            if (pus2 == null) {
                pus2 = new PkgUsageStatsExtended();
                this.mStats.put(pkgName, pus2);
            }
            pus2.updateResume(this.mLastResumedComp, !samePackage);
            if (!sameComp) {
                pus2.addLaunchCount(this.mLastResumedComp);
            }
            if ((componentResumeTimes = this.mLastResumeTimes.get(pkgName)) == null) {
                componentResumeTimes = new ArrayMap();
                this.mLastResumeTimes.put(pkgName, componentResumeTimes);
            }
            componentResumeTimes.put(this.mLastResumedComp, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePauseComponent(ComponentName componentName) {
        this.enforceCallingPermission();
        Object object = this.mStatsLock;
        synchronized (object) {
            String pkgName;
            if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
                return;
            }
            if (!this.mIsResumed) {
                return;
            }
            this.mIsResumed = false;
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            if (pus == null) {
                Slog.i(TAG, "No package stats for pkg:" + pkgName);
                return;
            }
            pus.updatePause();
        }
        this.writeStatsToFile(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteLaunchTime(ComponentName componentName, int millis) {
        String pkgName;
        this.enforceCallingPermission();
        if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
            return;
        }
        this.writeStatsToFile(false, false);
        Object object = this.mStatsLock;
        synchronized (object) {
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            if (pus != null) {
                pus.addLaunchTime(componentName.getClassName(), millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFullyDrawnTime(ComponentName componentName, int millis) {
        String pkgName;
        this.enforceCallingPermission();
        if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
            return;
        }
        this.writeStatsToFile(false, false);
        Object object = this.mStatsLock;
        synchronized (object) {
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            if (pus != null) {
                pus.addFullyDrawnTime(componentName.getClassName(), millis);
            }
        }
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PkgUsageStats getPkgUsageStats(ComponentName componentName) {
        String pkgName;
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        if (componentName == null || (pkgName = componentName.getPackageName()) == null) {
            return null;
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            PkgUsageStatsExtended pus = this.mStats.get(pkgName);
            Map lastResumeTimes = this.mLastResumeTimes.get(pkgName);
            if (pus == null && lastResumeTimes == null) {
                return null;
            }
            int launchCount = pus != null ? pus.mLaunchCount : 0;
            long usageTime = pus != null ? pus.mUsageTime : 0L;
            return new PkgUsageStats(pkgName, launchCount, usageTime, lastResumeTimes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PkgUsageStats[] getAllPkgUsageStats() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        Object object = this.mStatsLock;
        synchronized (object) {
            int size = this.mLastResumeTimes.size();
            if (size <= 0) {
                return null;
            }
            PkgUsageStats[] retArr = new PkgUsageStats[size];
            for (int i = 0; i < size; ++i) {
                String pkg = this.mLastResumeTimes.keyAt(i);
                long usageTime = 0L;
                int launchCount = 0;
                PkgUsageStatsExtended pus = this.mStats.get(pkg);
                if (pus != null) {
                    usageTime = pus.mUsageTime;
                    launchCount = pus.mLaunchCount;
                }
                retArr[i] = new PkgUsageStats(pkg, launchCount, usageTime, (Map<String, Long>)this.mLastResumeTimes.valueAt(i));
            }
            return retArr;
        }
    }

    static byte[] readFully(FileInputStream stream) throws IOException {
        int pos = 0;
        int avail = stream.available();
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy(data, 0, newData, 0, pos);
            data = newData;
        }
        return data;
    }

    private void collectDumpInfoFLOCK(PrintWriter pw, boolean isCompactOutput, boolean deleteAfterPrint, HashSet<String> packages) {
        ArrayList<String> fileList = this.getUsageStatsFileListFLOCK();
        if (fileList == null) {
            return;
        }
        Collections.sort(fileList);
        for (String file : fileList) {
            if (deleteAfterPrint && file.equalsIgnoreCase(this.mFileLeaf)) continue;
            File dFile = new File(this.mDir, file);
            String dateStr = file.substring(FILE_PREFIX.length());
            if (dateStr.length() > 0 && (dateStr.charAt(0) <= '0' || dateStr.charAt(0) >= '9')) continue;
            try {
                Parcel in = this.getParcelForFile(dFile);
                this.collectDumpInfoFromParcelFLOCK(in, pw, dateStr, isCompactOutput, packages);
                if (!deleteAfterPrint) continue;
                dFile.delete();
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Failed with " + e + " when collecting dump info from file : " + file);
                return;
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed with " + e + " when collecting dump info from file : " + file);
            }
        }
    }

    private void collectDumpInfoFromParcelFLOCK(Parcel in, PrintWriter pw, String date, boolean isCompactOutput, HashSet<String> packages) {
        StringBuilder sb = new StringBuilder(512);
        if (isCompactOutput) {
            sb.append("D:");
            sb.append(4);
            sb.append(',');
        } else {
            sb.append("Date: ");
        }
        sb.append(date);
        int vers = in.readInt();
        if (vers != 1008) {
            sb.append(" (old data version)");
            pw.println(sb.toString());
            return;
        }
        pw.println(sb.toString());
        int N = in.readInt();
        while (N > 0) {
            --N;
            String pkgName = in.readString();
            if (pkgName == null) break;
            sb.setLength(0);
            PkgUsageStatsExtended pus = new PkgUsageStatsExtended(in);
            if (packages == null || packages.contains(pkgName)) {
                int i;
                int NFDT;
                int i2;
                int NLT;
                if (isCompactOutput) {
                    sb.append("P:");
                    sb.append(pkgName);
                    sb.append(',');
                    sb.append(pus.mLaunchCount);
                    sb.append(',');
                    sb.append(pus.mUsageTime);
                    sb.append('\n');
                    NLT = pus.mLaunchTimes.size();
                    for (i2 = 0; i2 < NLT; ++i2) {
                        sb.append("A:");
                        String activity = pus.mLaunchTimes.keyAt(i2);
                        sb.append(activity);
                        TimeStats times = pus.mLaunchTimes.valueAt(i2);
                        sb.append(',');
                        sb.append(times.count);
                        for (int j = 0; j < 10; ++j) {
                            sb.append(",");
                            sb.append(times.times[j]);
                        }
                        sb.append('\n');
                    }
                    NFDT = pus.mFullyDrawnTimes.size();
                    for (i = 0; i < NFDT; ++i) {
                        sb.append("A:");
                        String activity = pus.mFullyDrawnTimes.keyAt(i);
                        sb.append(activity);
                        TimeStats times = pus.mFullyDrawnTimes.valueAt(i);
                        for (int j = 0; j < 10; ++j) {
                            sb.append(",");
                            sb.append(times.times[j]);
                        }
                        sb.append('\n');
                    }
                } else {
                    sb.append("  ");
                    sb.append(pkgName);
                    sb.append(": ");
                    sb.append(pus.mLaunchCount);
                    sb.append(" times, ");
                    sb.append(pus.mUsageTime);
                    sb.append(" ms");
                    sb.append('\n');
                    NLT = pus.mLaunchTimes.size();
                    for (i2 = 0; i2 < NLT; ++i2) {
                        sb.append("    ");
                        sb.append(pus.mLaunchTimes.keyAt(i2));
                        TimeStats times = pus.mLaunchTimes.valueAt(i2);
                        sb.append(": ");
                        sb.append(times.count);
                        sb.append(" starts");
                        int lastBin = 0;
                        for (int j = 0; j < 9; ++j) {
                            if (times.times[j] != 0) {
                                sb.append(", ");
                                sb.append(lastBin);
                                sb.append('-');
                                sb.append(LAUNCH_TIME_BINS[j]);
                                sb.append("ms=");
                                sb.append(times.times[j]);
                            }
                            lastBin = LAUNCH_TIME_BINS[j];
                        }
                        if (times.times[9] != 0) {
                            sb.append(", ");
                            sb.append(">=");
                            sb.append(lastBin);
                            sb.append("ms=");
                            sb.append(times.times[9]);
                        }
                        sb.append('\n');
                    }
                    NFDT = pus.mFullyDrawnTimes.size();
                    for (i = 0; i < NFDT; ++i) {
                        sb.append("    ");
                        sb.append(pus.mFullyDrawnTimes.keyAt(i));
                        TimeStats times = pus.mFullyDrawnTimes.valueAt(i);
                        sb.append(": fully drawn ");
                        boolean needComma = false;
                        int lastBin = 0;
                        for (int j = 0; j < 9; ++j) {
                            if (times.times[j] != 0) {
                                if (needComma) {
                                    sb.append(", ");
                                } else {
                                    needComma = true;
                                }
                                sb.append(lastBin);
                                sb.append('-');
                                sb.append(LAUNCH_TIME_BINS[j]);
                                sb.append("ms=");
                                sb.append(times.times[j]);
                            }
                            lastBin = LAUNCH_TIME_BINS[j];
                        }
                        if (times.times[9] != 0) {
                            if (needComma) {
                                sb.append(", ");
                            }
                            sb.append(">=");
                            sb.append(lastBin);
                            sb.append("ms=");
                            sb.append(times.times[9]);
                        }
                        sb.append('\n');
                    }
                }
            }
            pw.write(sb.toString());
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    private static String scanArgsData(String[] args, String value) {
        if (args != null) {
            int N = args.length;
            for (int i = 0; i < N; ++i) {
                if (!value.equals(args[i])) continue;
                return ++i < N ? args[i] : null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UsageStats from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean isCheckinRequest = UsageStatsService.scanArgs(args, "--checkin");
        boolean isCompactOutput = isCheckinRequest || UsageStatsService.scanArgs(args, "-c");
        boolean deleteAfterPrint = isCheckinRequest || UsageStatsService.scanArgs(args, "-d");
        String rawPackages = UsageStatsService.scanArgsData(args, "--packages");
        if (!deleteAfterPrint) {
            this.writeStatsToFile(true, false);
        }
        HashSet<String> packages = null;
        if (rawPackages != null) {
            if (!"*".equals(rawPackages)) {
                String[] names;
                for (String n : names = rawPackages.split(",")) {
                    if (packages == null) {
                        packages = new HashSet<String>();
                    }
                    packages.add(n);
                }
            }
        } else if (isCheckinRequest) {
            Slog.w(TAG, "Checkin without packages");
            return;
        }
        Object object = this.mFileLock;
        synchronized (object) {
            this.collectDumpInfoFLOCK(pw, isCompactOutput, deleteAfterPrint, packages);
        }
    }

    private class PkgUsageStatsExtended {
        final ArrayMap<String, TimeStats> mLaunchTimes = new ArrayMap();
        final ArrayMap<String, TimeStats> mFullyDrawnTimes = new ArrayMap();
        int mLaunchCount;
        long mUsageTime;
        long mPausedTime;
        long mResumedTime;

        PkgUsageStatsExtended() {
            this.mLaunchCount = 0;
            this.mUsageTime = 0L;
        }

        PkgUsageStatsExtended(Parcel in) {
            this.mLaunchCount = in.readInt();
            this.mUsageTime = in.readLong();
            int numLaunchTimeStats = in.readInt();
            this.mLaunchTimes.ensureCapacity(numLaunchTimeStats);
            for (int i = 0; i < numLaunchTimeStats; ++i) {
                String comp = in.readString();
                TimeStats times = new TimeStats(in);
                this.mLaunchTimes.put(comp, times);
            }
            int numFullyDrawnTimeStats = in.readInt();
            this.mFullyDrawnTimes.ensureCapacity(numFullyDrawnTimeStats);
            for (int i = 0; i < numFullyDrawnTimeStats; ++i) {
                String comp = in.readString();
                TimeStats times = new TimeStats(in);
                this.mFullyDrawnTimes.put(comp, times);
            }
        }

        void updateResume(String comp, boolean launched) {
            if (launched) {
                ++this.mLaunchCount;
            }
            this.mResumedTime = SystemClock.elapsedRealtime();
        }

        void updatePause() {
            this.mPausedTime = SystemClock.elapsedRealtime();
            this.mUsageTime += this.mPausedTime - this.mResumedTime;
        }

        void addLaunchCount(String comp) {
            TimeStats times = this.mLaunchTimes.get(comp);
            if (times == null) {
                times = new TimeStats();
                this.mLaunchTimes.put(comp, times);
            }
            times.incCount();
        }

        void addLaunchTime(String comp, int millis) {
            TimeStats times = this.mLaunchTimes.get(comp);
            if (times == null) {
                times = new TimeStats();
                this.mLaunchTimes.put(comp, times);
            }
            times.add(millis);
        }

        void addFullyDrawnTime(String comp, int millis) {
            TimeStats times = this.mFullyDrawnTimes.get(comp);
            if (times == null) {
                times = new TimeStats();
                this.mFullyDrawnTimes.put(comp, times);
            }
            times.add(millis);
        }

        void writeToParcel(Parcel out) {
            out.writeInt(this.mLaunchCount);
            out.writeLong(this.mUsageTime);
            int numLaunchTimeStats = this.mLaunchTimes.size();
            out.writeInt(numLaunchTimeStats);
            for (int i = 0; i < numLaunchTimeStats; ++i) {
                out.writeString(this.mLaunchTimes.keyAt(i));
                this.mLaunchTimes.valueAt(i).writeToParcel(out);
            }
            int numFullyDrawnTimeStats = this.mFullyDrawnTimes.size();
            out.writeInt(numFullyDrawnTimeStats);
            for (int i = 0; i < numFullyDrawnTimeStats; ++i) {
                out.writeString(this.mFullyDrawnTimes.keyAt(i));
                this.mFullyDrawnTimes.valueAt(i).writeToParcel(out);
            }
        }

        void clear() {
            this.mLaunchTimes.clear();
            this.mFullyDrawnTimes.clear();
            this.mLaunchCount = 0;
            this.mUsageTime = 0L;
        }
    }

    static class TimeStats {
        int count;
        int[] times = new int[10];

        TimeStats() {
        }

        void incCount() {
            ++this.count;
        }

        void add(int val) {
            int[] bins = LAUNCH_TIME_BINS;
            for (int i = 0; i < 9; ++i) {
                if (val >= bins[i]) continue;
                int n = i;
                this.times[n] = this.times[n] + 1;
                return;
            }
            this.times[9] = this.times[9] + 1;
        }

        TimeStats(Parcel in) {
            this.count = in.readInt();
            int[] localTimes = this.times;
            for (int i = 0; i < 10; ++i) {
                localTimes[i] = in.readInt();
            }
        }

        void writeToParcel(Parcel out) {
            out.writeInt(this.count);
            int[] localTimes = this.times;
            for (int i = 0; i < 10; ++i) {
                out.writeInt(localTimes[i]);
            }
        }
    }
}

