/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.IActivityController;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.server.AlarmManagerService;
import com.android.server.BatteryService;
import com.android.server.FgThread;
import com.android.server.IoThread;
import com.android.server.UiThread;
import com.android.server.am.ActivityManagerService;
import com.android.server.power.PowerManagerService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Watchdog
extends Thread {
    static final String TAG = "Watchdog";
    static final boolean localLOGV = false;
    static final boolean DB = false;
    static final boolean RECORD_KERNEL_THREADS = true;
    static final int TIME_TO_WAIT = 30000;
    static final String[] NATIVE_STACKS_OF_INTEREST = new String[]{"/system/bin/mediaserver", "/system/bin/sdcard", "/system/bin/surfaceflinger"};
    static Watchdog sWatchdog;
    final ArrayList<HandlerChecker> mHandlerCheckers = new ArrayList();
    final HandlerChecker mMonitorChecker = new HandlerChecker(FgThread.getHandler(), "foreground thread");
    ContentResolver mResolver;
    BatteryService mBattery;
    PowerManagerService mPower;
    AlarmManagerService mAlarm;
    ActivityManagerService mActivity;
    int mPhonePid;
    IActivityController mController;
    boolean mAllowRestart = true;

    public static Watchdog getInstance() {
        if (sWatchdog == null) {
            sWatchdog = new Watchdog();
        }
        return sWatchdog;
    }

    private Watchdog() {
        super("watchdog");
        this.mHandlerCheckers.add(this.mMonitorChecker);
        this.mHandlerCheckers.add(new HandlerChecker(new Handler(Looper.getMainLooper()), "main thread"));
        this.mHandlerCheckers.add(new HandlerChecker(UiThread.getHandler(), "ui thread"));
        this.mHandlerCheckers.add(new HandlerChecker(IoThread.getHandler(), "i/o thread"));
    }

    public void init(Context context, BatteryService battery, PowerManagerService power, AlarmManagerService alarm, ActivityManagerService activity) {
        this.mResolver = context.getContentResolver();
        this.mBattery = battery;
        this.mPower = power;
        this.mAlarm = alarm;
        this.mActivity = activity;
        context.registerReceiver(new RebootRequestReceiver(), new IntentFilter("android.intent.action.REBOOT"), "android.permission.REBOOT", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(String name, int pid) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if ("com.android.phone".equals(name)) {
                this.mPhonePid = pid;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivityController(IActivityController controller) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            this.mController = controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowRestart(boolean allowRestart) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            this.mAllowRestart = allowRestart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this.isAlive()) {
                throw new RuntimeException("Monitors can't be added once the Watchdog is running");
            }
            this.mMonitorChecker.addMonitor(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(Handler thread, String name) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this.isAlive()) {
                throw new RuntimeException("Threads can't be added once the Watchdog is running");
            }
            this.mHandlerCheckers.add(new HandlerChecker(thread, name));
        }
    }

    void rebootSystem(String reason) {
        Slog.i(TAG, "Rebooting system because: " + reason);
        PowerManagerService pms = (PowerManagerService)ServiceManager.getService("power");
        pms.reboot(false, reason, false);
    }

    private boolean haveAllCheckersCompletedLocked() {
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            if (hc.isCompletedLocked()) continue;
            return false;
        }
        return true;
    }

    private ArrayList<HandlerChecker> getBlockedCheckersLocked() {
        ArrayList<HandlerChecker> checkers = new ArrayList<HandlerChecker>();
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            if (hc.isCompletedLocked()) continue;
            checkers.add(hc);
        }
        return checkers;
    }

    private String describeCheckersLocked(ArrayList<HandlerChecker> checkers) {
        StringBuilder builder = new StringBuilder(128);
        for (int i = 0; i < checkers.size(); ++i) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(checkers.get(i).describeBlockedStateLocked());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitedHalf = false;
        while (true) {
            IActivityController controller;
            boolean allowRestart;
            String subject;
            ArrayList<HandlerChecker> blockedCheckers;
            Runnable hc;
            Watchdog watchdog = this;
            synchronized (watchdog) {
                long timeout = 30000L;
                if (!waitedHalf) {
                    for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
                        hc = this.mHandlerCheckers.get(i);
                        hc.scheduleCheckLocked();
                    }
                }
                long start = SystemClock.uptimeMillis();
                while (timeout > 0L) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Log.wtf(TAG, e);
                    }
                    timeout = 30000L - (SystemClock.uptimeMillis() - start);
                }
                if (this.haveAllCheckersCompletedLocked()) {
                    waitedHalf = false;
                    continue;
                }
                if (!waitedHalf) {
                    ArrayList<Integer> pids = new ArrayList<Integer>();
                    pids.add(Process.myPid());
                    ActivityManagerService.dumpStackTraces(true, pids, null, null, NATIVE_STACKS_OF_INTEREST);
                    waitedHalf = true;
                    continue;
                }
                blockedCheckers = this.getBlockedCheckersLocked();
                subject = this.describeCheckersLocked(blockedCheckers);
                allowRestart = this.mAllowRestart;
            }
            EventLog.writeEvent(2802, subject);
            ArrayList<Integer> pids = new ArrayList<Integer>();
            pids.add(Process.myPid());
            if (this.mPhonePid > 0) {
                pids.add(this.mPhonePid);
            }
            final File stack = ActivityManagerService.dumpStackTraces(!waitedHalf, pids, null, null, NATIVE_STACKS_OF_INTEREST);
            SystemClock.sleep(2000L);
            this.dumpKernelStackTraces();
            try {
                FileWriter sysrq_trigger = new FileWriter("/proc/sysrq-trigger");
                sysrq_trigger.write("w");
                sysrq_trigger.close();
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to write to /proc/sysrq-trigger");
                Slog.e(TAG, e.getMessage());
            }
            Thread dropboxThread = new Thread("watchdogWriteToDropbox"){

                public void run() {
                    Watchdog.this.mActivity.addErrorToDropBox("watchdog", null, "system_server", null, null, subject, null, stack, null);
                }
            };
            dropboxThread.start();
            try {
                dropboxThread.join(2000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            hc = this;
            synchronized (hc) {
                controller = this.mController;
            }
            if (controller != null) {
                Slog.i(TAG, "Reporting stuck state to activity controller");
                try {
                    Binder.setDumpDisabled("Service dumps disabled due to hung system process.");
                    int res = controller.systemNotResponding(subject);
                    if (res >= 0) {
                        Slog.i(TAG, "Activity controller requested to coninue to wait");
                        waitedHalf = false;
                        continue;
                    }
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (Debug.isDebuggerConnected()) {
                Slog.w(TAG, "Debugger connected: Watchdog is *not* killing the system process");
            } else if (!allowRestart) {
                Slog.w(TAG, "Restart not allowed: Watchdog is *not* killing the system process");
            } else {
                Slog.w(TAG, "*** WATCHDOG KILLING SYSTEM PROCESS: " + subject);
                for (int i = 0; i < blockedCheckers.size(); ++i) {
                    StackTraceElement[] stackTrace;
                    Slog.w(TAG, blockedCheckers.get(i).getName() + " stack trace:");
                    for (StackTraceElement element : stackTrace = blockedCheckers.get(i).getThread().getStackTrace()) {
                        Slog.w(TAG, "    at " + element);
                    }
                }
                Slog.w(TAG, "*** GOODBYE!");
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
            waitedHalf = false;
        }
    }

    private File dumpKernelStackTraces() {
        String tracesPath = SystemProperties.get("dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        this.native_dumpKernelStacks(tracesPath);
        return new File(tracesPath);
    }

    private native void native_dumpKernelStacks(String var1);

    public static interface Monitor {
        public void monitor();
    }

    final class RebootRequestReceiver
    extends BroadcastReceiver {
        RebootRequestReceiver() {
        }

        public void onReceive(Context c, Intent intent) {
            if (intent.getIntExtra("nowait", 0) != 0) {
                Watchdog.this.rebootSystem("Received ACTION_REBOOT broadcast");
                return;
            }
            Slog.w(Watchdog.TAG, "Unsupported ACTION_REBOOT broadcast: " + intent);
        }
    }

    public final class HandlerChecker
    implements Runnable {
        private final Handler mHandler;
        private final String mName;
        private final ArrayList<Monitor> mMonitors = new ArrayList();
        private boolean mCompleted;
        private Monitor mCurrentMonitor;

        HandlerChecker(Handler handler, String name) {
            this.mHandler = handler;
            this.mName = name;
        }

        public void addMonitor(Monitor monitor) {
            this.mMonitors.add(monitor);
        }

        public void scheduleCheckLocked() {
            if (this.mMonitors.size() == 0 && this.mHandler.getLooper().isIdling()) {
                this.mCompleted = true;
                return;
            }
            this.mCompleted = false;
            this.mCurrentMonitor = null;
            this.mHandler.postAtFrontOfQueue(this);
        }

        public boolean isCompletedLocked() {
            return this.mCompleted;
        }

        public Thread getThread() {
            return this.mHandler.getLooper().getThread();
        }

        public String getName() {
            return this.mName;
        }

        public String describeBlockedStateLocked() {
            if (this.mCurrentMonitor == null) {
                return "Blocked in handler on " + this.mName + " (" + this.getThread().getName() + ")";
            }
            return "Blocked in monitor " + this.mCurrentMonitor.getClass().getName() + " on " + this.mName + " (" + this.getThread().getName() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int size = this.mMonitors.size();
            for (int i = 0; i < size; ++i) {
                Watchdog watchdog = Watchdog.this;
                synchronized (watchdog) {
                    this.mCurrentMonitor = this.mMonitors.get(i);
                }
                this.mCurrentMonitor.monitor();
            }
            Watchdog watchdog = Watchdog.this;
            synchronized (watchdog) {
                this.mCompleted = true;
                this.mCurrentMonitor = null;
            }
        }
    }
}

