/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IUserSwitchObserver;
import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.PendingIntent;
import android.app.WallpaperInfo;
import android.app.backup.BackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.Display;
import android.view.IWindowManager;
import android.view.WindowManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class WallpaperManagerService
extends IWallpaperManager.Stub {
    static final String TAG = "WallpaperService";
    static final boolean DEBUG = false;
    final Object mLock = new Object[0];
    static final long MIN_WALLPAPER_CRASH_TIME = 10000L;
    static final String WALLPAPER = "wallpaper";
    static final String WALLPAPER_INFO = "wallpaper_info.xml";
    static final ComponentName IMAGE_WALLPAPER = new ComponentName("com.android.systemui", "com.android.systemui.ImageWallpaper");
    final Context mContext;
    final IWindowManager mIWindowManager;
    final IPackageManager mIPackageManager;
    final MyPackageMonitor mMonitor;
    WallpaperData mLastWallpaper;
    SparseArray<WallpaperData> mWallpaperMap = new SparseArray();
    int mCurrentUserId;

    public WallpaperManagerService(Context context) {
        this.mContext = context;
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, null, UserHandle.ALL, true);
        WallpaperManagerService.getWallpaperDir(0).mkdirs();
        this.loadSettingsLocked(0);
    }

    private static File getWallpaperDir(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.mWallpaperMap.size(); ++i) {
            WallpaperData wallpaper = this.mWallpaperMap.valueAt(i);
            wallpaper.wallpaperObserver.stopWatching();
        }
    }

    public void systemRunning() {
        WallpaperData wallpaper = this.mWallpaperMap.get(0);
        this.switchWallpaper(wallpaper, null);
        wallpaper.wallpaperObserver = new WallpaperObserver(wallpaper);
        wallpaper.wallpaperObserver.startWatching();
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        userFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    WallpaperManagerService.this.onRemoveUser(intent.getIntExtra("android.intent.extra.user_handle", -10000));
                }
            }
        }, userFilter);
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    WallpaperManagerService.this.switchUser(newUserId, reply);
                }

                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }
            });
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWallpaperMap.get((int)0).name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStoppingUser(int userId) {
        if (userId < 1) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper != null) {
                if (wallpaper.wallpaperObserver != null) {
                    wallpaper.wallpaperObserver.stopWatching();
                    wallpaper.wallpaperObserver = null;
                }
                this.mWallpaperMap.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRemoveUser(int userId) {
        if (userId < 1) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.onStoppingUser(userId);
            File wallpaperFile = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER);
            wallpaperFile.delete();
            File wallpaperInfoFile = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER_INFO);
            wallpaperInfoFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchUser(int userId, IRemoteCallback reply) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = userId;
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                wallpaper = new WallpaperData(userId);
                this.mWallpaperMap.put(userId, wallpaper);
                this.loadSettingsLocked(userId);
            }
            if (wallpaper.wallpaperObserver == null) {
                wallpaper.wallpaperObserver = new WallpaperObserver(wallpaper);
                wallpaper.wallpaperObserver.startWatching();
            }
            this.switchWallpaper(wallpaper, reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchWallpaper(WallpaperData wallpaper, IRemoteCallback reply) {
        Object object = this.mLock;
        synchronized (object) {
            RuntimeException e = null;
            try {
                ComponentName cname;
                ComponentName componentName = cname = wallpaper.wallpaperComponent != null ? wallpaper.wallpaperComponent : wallpaper.nextWallpaperComponent;
                if (this.bindWallpaperComponentLocked(cname, true, false, wallpaper, reply)) {
                    return;
                }
            }
            catch (RuntimeException e1) {
                e = e1;
            }
            Slog.w(TAG, "Failure starting previous wallpaper", e);
            this.clearWallpaperLocked(false, wallpaper.userId, reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWallpaper() {
        Object object = this.mLock;
        synchronized (object) {
            this.clearWallpaperLocked(false, UserHandle.getCallingUserId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clearWallpaperLocked(boolean defaultFailed, int userId, IRemoteCallback reply) {
        IllegalArgumentException e;
        WallpaperData wallpaper;
        block11: {
            long ident;
            block9: {
                block10: {
                    block8: {
                        wallpaper = this.mWallpaperMap.get(userId);
                        File f = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER);
                        if (f.exists()) {
                            f.delete();
                        }
                        ident = Binder.clearCallingIdentity();
                        e = null;
                        try {
                            try {
                                wallpaper.imageWallpaperPending = false;
                                if (userId != this.mCurrentUserId) {
                                    Object var11_8 = null;
                                    break block8;
                                }
                                if (!this.bindWallpaperComponentLocked(defaultFailed ? IMAGE_WALLPAPER : null, true, false, wallpaper, reply)) break block9;
                                break block10;
                            }
                            catch (IllegalArgumentException e1) {
                                e = e1;
                                Object var11_11 = null;
                                Binder.restoreCallingIdentity(ident);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_12 = null;
                            Binder.restoreCallingIdentity(ident);
                            throw throwable;
                        }
                    }
                    Binder.restoreCallingIdentity(ident);
                    return;
                }
                Object var11_9 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            Object var11_10 = null;
            Binder.restoreCallingIdentity(ident);
        }
        Slog.e(TAG, "Default wallpaper component not found!", e);
        this.clearWallpaperComponentLocked(wallpaper);
        if (reply == null) return;
        try {
            reply.sendResult(null);
            return;
        }
        catch (RemoteException e1) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNamedWallpaper(String name) {
        Object object = this.mLock;
        synchronized (object) {
            List<UserInfo> users;
            long ident = Binder.clearCallingIdentity();
            try {
                users = ((UserManager)this.mContext.getSystemService("user")).getUsers();
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            for (UserInfo user : users) {
                WallpaperData wd = this.mWallpaperMap.get(user.id);
                if (wd == null) {
                    this.loadSettingsLocked(user.id);
                    wd = this.mWallpaperMap.get(user.id);
                }
                if (wd == null || !name.equals(wd.name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensionHints(int width, int height) throws RemoteException {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be > 0");
            }
            if (width != wallpaper.width || height != wallpaper.height) {
                wallpaper.width = width;
                wallpaper.height = height;
                this.saveSettingsLocked(wallpaper);
                if (this.mCurrentUserId != userId) {
                    return;
                }
                if (wallpaper.connection != null) {
                    if (wallpaper.connection.mEngine != null) {
                        try {
                            wallpaper.connection.mEngine.setDesiredSize(width, height);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        this.notifyCallbacksLocked(wallpaper);
                    } else if (wallpaper.connection.mService != null) {
                        wallpaper.connection.mDimensionsChanged = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidthHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            return wallpaper.width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeightHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            return wallpaper.height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor getWallpaper(IWallpaperManagerCallback cb, Bundle outParams) {
        Object object = this.mLock;
        synchronized (object) {
            int callingUid = Binder.getCallingUid();
            int wallpaperUserId = 0;
            wallpaperUserId = callingUid == 1000 ? this.mCurrentUserId : UserHandle.getUserId(callingUid);
            WallpaperData wallpaper = this.mWallpaperMap.get(wallpaperUserId);
            try {
                if (outParams != null) {
                    outParams.putInt("width", wallpaper.width);
                    outParams.putInt("height", wallpaper.height);
                }
                wallpaper.callbacks.register(cb);
                File f = new File(WallpaperManagerService.getWallpaperDir(wallpaperUserId), WALLPAPER);
                if (!f.exists()) {
                    return null;
                }
                return ParcelFileDescriptor.open(f, 0x10000000);
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Error getting wallpaper", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallpaperInfo getWallpaperInfo() {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper.connection != null) {
                return wallpaper.connection.mInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelFileDescriptor setWallpaper(String name) {
        this.checkPermission("android.permission.SET_WALLPAPER");
        Object object = this.mLock;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor;
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                ParcelFileDescriptor pfd = this.updateWallpaperBitmapLocked(name, wallpaper);
                if (pfd != null) {
                    wallpaper.imageWallpaperPending = true;
                }
                parcelFileDescriptor = pfd;
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return parcelFileDescriptor;
        }
    }

    ParcelFileDescriptor updateWallpaperBitmapLocked(String name, WallpaperData wallpaper) {
        if (name == null) {
            name = "";
        }
        try {
            File dir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            File file = new File(dir, WALLPAPER);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(file, 0x38000000);
            if (!SELinux.restorecon(file)) {
                return null;
            }
            wallpaper.name = name;
            return fd;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Error setting wallpaper", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWallpaperComponent(ComponentName name) {
        this.checkPermission("android.permission.SET_WALLPAPER_COMPONENT");
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                wallpaper.imageWallpaperPending = false;
                this.bindWallpaperComponentLocked(name, false, true, wallpaper, null);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    boolean bindWallpaperComponentLocked(ComponentName componentName, boolean force, boolean fromUser, WallpaperData wallpaper, IRemoteCallback reply) {
        if (!force && wallpaper.connection != null && (wallpaper.wallpaperComponent == null ? componentName == null : wallpaper.wallpaperComponent.equals(componentName))) {
            return true;
        }
        try {
            int serviceUserId;
            ServiceInfo si;
            if (componentName == null) {
                String defaultComponent = this.mContext.getString(17039389);
                if (defaultComponent != null) {
                    componentName = ComponentName.unflattenFromString(defaultComponent);
                }
                if (componentName == null) {
                    componentName = IMAGE_WALLPAPER;
                }
            }
            if ((si = this.mIPackageManager.getServiceInfo(componentName, 4224, serviceUserId = wallpaper.userId)) == null) {
                Slog.w(TAG, "Attempted wallpaper " + componentName + " is unavailable");
                return false;
            }
            if (!"android.permission.BIND_WALLPAPER".equals(si.permission)) {
                String msg = "Selected service does not require android.permission.BIND_WALLPAPER: " + componentName;
                if (fromUser) {
                    throw new SecurityException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            WallpaperInfo wi = null;
            Intent intent = new Intent("android.service.wallpaper.WallpaperService");
            if (componentName != null && !componentName.equals(IMAGE_WALLPAPER)) {
                List<ResolveInfo> ris = this.mIPackageManager.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, serviceUserId);
                for (int i = 0; i < ris.size(); ++i) {
                    ServiceInfo rsi = ris.get((int)i).serviceInfo;
                    if (!rsi.name.equals(si.name) || !rsi.packageName.equals(si.packageName)) continue;
                    try {
                        wi = new WallpaperInfo(this.mContext, ris.get(i));
                        break;
                    }
                    catch (XmlPullParserException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                    catch (IOException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                }
                if (wi == null) {
                    String msg = "Selected service is not a wallpaper: " + componentName;
                    if (fromUser) {
                        throw new SecurityException(msg);
                    }
                    Slog.w(TAG, msg);
                    return false;
                }
            }
            WallpaperConnection newConn = new WallpaperConnection(wi, wallpaper);
            intent.setComponent(componentName);
            intent.putExtra("android.intent.extra.client_label", 17040558);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivityAsUser(this.mContext, 0, Intent.createChooser(new Intent("android.intent.action.SET_WALLPAPER"), this.mContext.getText(17040559)), 0, null, new UserHandle(serviceUserId)));
            if (!this.mContext.bindServiceAsUser(intent, newConn, 0x20000001, new UserHandle(serviceUserId))) {
                String msg = "Unable to bind service: " + componentName;
                if (fromUser) {
                    throw new IllegalArgumentException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            if (wallpaper.userId == this.mCurrentUserId && this.mLastWallpaper != null) {
                this.detachWallpaperLocked(this.mLastWallpaper);
            }
            wallpaper.wallpaperComponent = componentName;
            wallpaper.connection = newConn;
            wallpaper.lastDiedTime = SystemClock.uptimeMillis();
            newConn.mReply = reply;
            try {
                if (wallpaper.userId == this.mCurrentUserId) {
                    this.mIWindowManager.addWindowToken(newConn.mToken, 2013);
                    this.mLastWallpaper = wallpaper;
                }
            }
            catch (RemoteException e) {}
        }
        catch (RemoteException e) {
            String msg = "Remote exception for " + componentName + "\n" + e;
            if (fromUser) {
                throw new IllegalArgumentException(msg);
            }
            Slog.w(TAG, msg);
            return false;
        }
        return true;
    }

    void detachWallpaperLocked(WallpaperData wallpaper) {
        if (wallpaper.connection != null) {
            if (wallpaper.connection.mReply != null) {
                try {
                    wallpaper.connection.mReply.sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                wallpaper.connection.mReply = null;
            }
            if (wallpaper.connection.mEngine != null) {
                try {
                    wallpaper.connection.mEngine.destroy();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mContext.unbindService(wallpaper.connection);
            try {
                this.mIWindowManager.removeWindowToken(wallpaper.connection.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            wallpaper.connection.mService = null;
            wallpaper.connection.mEngine = null;
            wallpaper.connection = null;
        }
    }

    void clearWallpaperComponentLocked(WallpaperData wallpaper) {
        wallpaper.wallpaperComponent = null;
        this.detachWallpaperLocked(wallpaper);
    }

    void attachServiceLocked(WallpaperConnection conn, WallpaperData wallpaper) {
        block2: {
            try {
                conn.mService.attach(conn, conn.mToken, 2013, false, wallpaper.width, wallpaper.height);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed attaching wallpaper; clearing", e);
                if (wallpaper.wallpaperUpdating) break block2;
                this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
            }
        }
    }

    private void notifyCallbacksLocked(WallpaperData wallpaper) {
        int n = wallpaper.callbacks.beginBroadcast();
        for (int i = 0; i < n; ++i) {
            try {
                ((IWallpaperManagerCallback)wallpaper.callbacks.getBroadcastItem(i)).onWallpaperChanged();
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        wallpaper.callbacks.finishBroadcast();
        Intent intent = new Intent("android.intent.action.WALLPAPER_CHANGED");
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mCurrentUserId));
    }

    private void checkPermission(String permission2) {
        if (0 != this.mContext.checkCallingOrSelfPermission(permission2)) {
            throw new SecurityException("Access denied to process: " + Binder.getCallingPid() + ", must have permission " + permission2);
        }
    }

    private static JournaledFile makeJournaledFile(int userId) {
        String base = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER_INFO).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(WallpaperData wallpaper) {
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(wallpaper.userId);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, "utf-8");
            out.startDocument(null, true);
            out.startTag(null, "wp");
            out.attribute(null, "width", Integer.toString(wallpaper.width));
            out.attribute(null, "height", Integer.toString(wallpaper.height));
            out.attribute(null, "name", wallpaper.name);
            if (wallpaper.wallpaperComponent != null && !wallpaper.wallpaperComponent.equals(IMAGE_WALLPAPER)) {
                out.attribute(null, "component", wallpaper.wallpaperComponent.flattenToShortString());
            }
            out.endTag(null, "wp");
            out.endDocument();
            stream.close();
            journal.commit();
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    private void migrateFromOld() {
        File oldWallpaper = new File("/data/data/com.android.settings/files/wallpaper");
        File oldInfo = new File("/data/system/wallpaper_info.xml");
        if (oldWallpaper.exists()) {
            File newWallpaper = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER);
            oldWallpaper.renameTo(newWallpaper);
        }
        if (oldInfo.exists()) {
            File newInfo = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER_INFO);
            oldInfo.renameTo(newInfo);
        }
    }

    private void loadSettingsLocked(int userId) {
        WindowManager wm;
        Display d;
        int baseSize;
        WallpaperData wallpaper;
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(userId);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        if (!file.exists()) {
            this.migrateFromOld();
        }
        if ((wallpaper = this.mWallpaperMap.get(userId)) == null) {
            wallpaper = new WallpaperData(userId);
            this.mWallpaperMap.put(userId, wallpaper);
        }
        boolean success = false;
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, null);
            do {
                String tag;
                if ((type = parser.next()) != 2 || !"wp".equals(tag = parser.getName())) continue;
                wallpaper.width = Integer.parseInt(parser.getAttributeValue(null, "width"));
                wallpaper.height = Integer.parseInt(parser.getAttributeValue(null, "height"));
                wallpaper.name = parser.getAttributeValue(null, "name");
                String comp = parser.getAttributeValue(null, "component");
                ComponentName componentName = wallpaper.nextWallpaperComponent = comp != null ? ComponentName.unflattenFromString(comp) : null;
                if (wallpaper.nextWallpaperComponent != null && !"android".equals(wallpaper.nextWallpaperComponent.getPackageName())) continue;
                wallpaper.nextWallpaperComponent = IMAGE_WALLPAPER;
            } while (type != 1);
            success = true;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "no current wallpaper -- first boot?");
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!success) {
            wallpaper.width = -1;
            wallpaper.height = -1;
            wallpaper.name = "";
        }
        if (wallpaper.width < (baseSize = (d = (wm = (WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()).getMaximumSizeDimension())) {
            wallpaper.width = baseSize;
        }
        if (wallpaper.height < baseSize) {
            wallpaper.height = baseSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void settingsRestored() {
        WallpaperData wallpaper = null;
        boolean success = false;
        Object object = this.mLock;
        synchronized (object) {
            this.loadSettingsLocked(0);
            wallpaper = this.mWallpaperMap.get(0);
            if (wallpaper.nextWallpaperComponent != null && !wallpaper.nextWallpaperComponent.equals(IMAGE_WALLPAPER)) {
                if (!this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, false, false, wallpaper, null)) {
                    this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
                }
                success = true;
            } else {
                success = "".equals(wallpaper.name) ? true : this.restoreNamedResourceLocked(wallpaper);
                if (success) {
                    this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, false, false, wallpaper, null);
                }
            }
        }
        if (!success) {
            Slog.e(TAG, "Failed to restore wallpaper: '" + wallpaper.name + "'");
            wallpaper.name = "";
            WallpaperManagerService.getWallpaperDir(0).delete();
        }
        object = this.mLock;
        synchronized (object) {
            this.saveSettingsLocked(wallpaper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean restoreNamedResourceLocked(WallpaperData wallpaper) {
        block39: {
            block34: {
                block32: {
                    block33: {
                        if (wallpaper.name.length() <= 4) return false;
                        if ("res:".equals(wallpaper.name.substring(0, 4)) == false) return false;
                        resName = wallpaper.name.substring(4);
                        pkg = null;
                        colon = resName.indexOf(58);
                        if (colon > 0) {
                            pkg = resName.substring(0, colon);
                        }
                        ident = null;
                        slash = resName.lastIndexOf(47);
                        if (slash > 0) {
                            ident = resName.substring(slash + 1);
                        }
                        type = null;
                        if (colon > 0 && slash > 0 && slash - colon > 1) {
                            type = resName.substring(colon + 1, slash);
                        }
                        if (pkg == null) return false;
                        if (ident == null) return false;
                        if (type == null) return false;
                        resId = -1;
                        res = null;
                        fos = null;
                        try {
                            try {
                                c = this.mContext.createPackageContext(pkg, 4);
                                r = c.getResources();
                                resId = r.getIdentifier(resName, null, null);
                                if (resId == 0) {
                                    Slog.e("WallpaperService", "couldn't resolve identifier pkg=" + pkg + " type=" + type + " ident=" + ident);
                                    var13_16 = false;
                                    var17_18 = null;
                                    if (res == null) break block32;
                                    break block33;
                                }
                                res = r.openRawResource(resId);
                                if (wallpaper.wallpaperFile.exists()) {
                                    wallpaper.wallpaperFile.delete();
                                }
                                fos = new FileOutputStream(wallpaper.wallpaperFile);
                                buffer = new byte[32768];
                                while ((amt = res.read(buffer)) > 0) {
                                    fos.write(buffer, 0, amt);
                                }
                                Slog.v("WallpaperService", "Restored wallpaper: " + resName);
                                var15_31 = true;
                                break block34;
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                Slog.e("WallpaperService", "Package name " + pkg + " not found");
                                var17_20 = null;
                                if (res != null) {
                                    try {
                                        res.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync(fos);
                                try {
                                    fos.close();
                                    return false;
                                }
                                catch (IOException ex) {
                                    return false;
                                }
                            }
                            catch (Resources.NotFoundException e) {
                                block36: {
                                    Slog.e("WallpaperService", "Resource not found: " + resId);
                                    var17_21 = null;
                                    if (res != null) {
                                        ** try [egrp 2[TRYBLOCK] [12 : 451->459)] { 
lbl75:
                                        // 1 sources

                                        res.close();
                                        break block36;
lbl77:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync(fos);
                                try {}
                                catch (IOException ex) {
                                    return false;
                                }
                                fos.close();
                                return false;
                            }
                            catch (IOException e) {
                                block37: {
                                    Slog.e("WallpaperService", "IOException while restoring wallpaper ", e);
                                    var17_22 = null;
                                    if (res != null) {
                                        ** try [egrp 2[TRYBLOCK] [12 : 451->459)] { 
lbl95:
                                        // 1 sources

                                        res.close();
                                        break block37;
lbl97:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync(fos);
                                try {}
                                catch (IOException ex) {
                                    return false;
                                }
                                fos.close();
                                return false;
                            }
                        }
                        catch (Throwable var16_32) {
                            block38: {
                                var17_23 = null;
                                if (res != null) {
                                    ** try [egrp 2[TRYBLOCK] [12 : 451->459)] { 
lbl113:
                                    // 1 sources

                                    res.close();
                                    break block38;
lbl115:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (fos == null) throw var16_32;
                            FileUtils.sync(fos);
                            ** try [egrp 3[TRYBLOCK] [13 : 472->480)] { 
lbl122:
                            // 1 sources

                            fos.close();
                            throw var16_32;
lbl124:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw var16_32;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [12 : 451->459)] { 
lbl129:
                    // 1 sources

                    res.close();
                    break block32;
lbl131:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (fos == null) return var13_16;
                FileUtils.sync(fos);
                ** try [egrp 3[TRYBLOCK] [13 : 472->480)] { 
lbl138:
                // 1 sources

                fos.close();
                return var13_16;
lbl140:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
                return var13_16;
            }
            var17_19 = null;
            if (res != null) {
                ** try [egrp 2[TRYBLOCK] [12 : 451->459)] { 
lbl147:
                // 1 sources

                res.close();
                break block39;
lbl149:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (fos == null) return var15_31;
        FileUtils.sync(fos);
        try {}
        catch (IOException ex) {
            // empty catch block
            return var15_31;
        }
        fos.close();
        return var15_31;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump wallpaper service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Wallpaper Service state:");
            for (int i = 0; i < this.mWallpaperMap.size(); ++i) {
                WallpaperData wallpaper = this.mWallpaperMap.valueAt(i);
                pw.println(" User " + wallpaper.userId + ":");
                pw.print("  mWidth=");
                pw.print(wallpaper.width);
                pw.print(" mHeight=");
                pw.println(wallpaper.height);
                pw.print("  mName=");
                pw.println(wallpaper.name);
                pw.print("  mWallpaperComponent=");
                pw.println(wallpaper.wallpaperComponent);
                if (wallpaper.connection == null) continue;
                WallpaperConnection conn = wallpaper.connection;
                pw.print("  Wallpaper connection ");
                pw.print(conn);
                pw.println(":");
                if (conn.mInfo != null) {
                    pw.print("    mInfo.component=");
                    pw.println(conn.mInfo.getComponent());
                }
                pw.print("    mToken=");
                pw.println(conn.mToken);
                pw.print("    mService=");
                pw.println(conn.mService);
                pw.print("    mEngine=");
                pw.println(conn.mEngine);
                pw.print("    mLastDiedTime=");
                pw.println(wallpaper.lastDiedTime - SystemClock.uptimeMillis());
            }
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageUpdateFinished(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && wallpaper.wallpaperComponent != null && wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                    wallpaper.wallpaperUpdating = false;
                    ComponentName comp = wallpaper.wallpaperComponent;
                    WallpaperManagerService.this.clearWallpaperComponentLocked(wallpaper);
                    if (!WallpaperManagerService.this.bindWallpaperComponentLocked(comp, false, false, wallpaper, null)) {
                        Slog.w(WallpaperManagerService.TAG, "Wallpaper no longer available; reverting to default");
                        WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageModified(String packageName) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    if (wallpaper.wallpaperComponent == null || !wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                        return;
                    }
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageUpdateStarted(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && wallpaper.wallpaperComponent != null && wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                    wallpaper.wallpaperUpdating = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                boolean changed = false;
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return false;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    boolean res = this.doPackagesChangedLocked(doit, wallpaper);
                    changed |= res;
                }
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSomePackagesChanged() {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        boolean doPackagesChangedLocked(boolean doit, WallpaperData wallpaper) {
            int change;
            boolean changed = false;
            if (wallpaper.wallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.wallpaperComponent.getPackageName())) == 3 || change == 2)) {
                changed = true;
                if (doit) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper uninstalled, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.nextWallpaperComponent.getPackageName())) == 3 || change == 2)) {
                wallpaper.nextWallpaperComponent = null;
            }
            if (wallpaper.wallpaperComponent != null && this.isPackageModified(wallpaper.wallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.wallpaperComponent, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper component gone, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && this.isPackageModified(wallpaper.nextWallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.nextWallpaperComponent, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    wallpaper.nextWallpaperComponent = null;
                }
            }
            return changed;
        }
    }

    class WallpaperConnection
    extends IWallpaperConnection.Stub
    implements ServiceConnection {
        final WallpaperInfo mInfo;
        final Binder mToken = new Binder();
        IWallpaperService mService;
        IWallpaperEngine mEngine;
        WallpaperData mWallpaper;
        IRemoteCallback mReply;
        boolean mDimensionsChanged = false;

        public WallpaperConnection(WallpaperInfo info, WallpaperData wallpaper) {
            this.mInfo = info;
            this.mWallpaper = wallpaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    this.mWallpaper.lastDiedTime = SystemClock.uptimeMillis();
                    this.mService = IWallpaperService.Stub.asInterface(service);
                    WallpaperManagerService.this.attachServiceLocked(this, this.mWallpaper);
                    WallpaperManagerService.this.saveSettingsLocked(this.mWallpaper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mService = null;
                this.mEngine = null;
                if (this.mWallpaper.connection == this) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper service gone: " + this.mWallpaper.wallpaperComponent);
                    if (!this.mWallpaper.wallpaperUpdating && this.mWallpaper.lastDiedTime + 10000L > SystemClock.uptimeMillis() && this.mWallpaper.userId == WallpaperManagerService.this.mCurrentUserId) {
                        Slog.w(WallpaperManagerService.TAG, "Reverting to built-in wallpaper!");
                        WallpaperManagerService.this.clearWallpaperLocked(true, this.mWallpaper.userId, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachEngine(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mEngine = engine;
                if (this.mDimensionsChanged) {
                    try {
                        this.mEngine.setDesiredSize(this.mWallpaper.width, this.mWallpaper.height);
                    }
                    catch (RemoteException e) {
                        Slog.w(WallpaperManagerService.TAG, "Failed to set wallpaper dimensions", e);
                    }
                    this.mDimensionsChanged = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineShown(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mReply != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mReply.sendResult(null);
                    }
                    catch (RemoteException e) {
                        Binder.restoreCallingIdentity(ident);
                    }
                    this.mReply = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParcelFileDescriptor setWallpaper(String name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    return WallpaperManagerService.this.updateWallpaperBitmapLocked(name, this.mWallpaper);
                }
                return null;
            }
        }
    }

    static class WallpaperData {
        int userId;
        File wallpaperFile;
        boolean imageWallpaperPending;
        String name = "";
        ComponentName wallpaperComponent;
        ComponentName nextWallpaperComponent;
        WallpaperConnection connection;
        long lastDiedTime;
        boolean wallpaperUpdating;
        WallpaperObserver wallpaperObserver;
        private RemoteCallbackList<IWallpaperManagerCallback> callbacks = new RemoteCallbackList();
        int width = -1;
        int height = -1;

        WallpaperData(int userId) {
            this.userId = userId;
            this.wallpaperFile = new File(WallpaperManagerService.getWallpaperDir(userId), WallpaperManagerService.WALLPAPER);
        }
    }

    private class WallpaperObserver
    extends FileObserver {
        final WallpaperData mWallpaper;
        final File mWallpaperDir;
        final File mWallpaperFile;

        public WallpaperObserver(WallpaperData wallpaper) {
            super(WallpaperManagerService.getWallpaperDir(wallpaper.userId).getAbsolutePath(), 1544);
            this.mWallpaperDir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            this.mWallpaper = wallpaper;
            this.mWallpaperFile = new File(this.mWallpaperDir, WallpaperManagerService.WALLPAPER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(int event, String path) {
            if (path == null) {
                return;
            }
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                long origId = Binder.clearCallingIdentity();
                BackupManager bm = new BackupManager(WallpaperManagerService.this.mContext);
                bm.dataChanged();
                Binder.restoreCallingIdentity(origId);
                File changedFile = new File(this.mWallpaperDir, path);
                if (this.mWallpaperFile.equals(changedFile)) {
                    WallpaperManagerService.this.notifyCallbacksLocked(this.mWallpaper);
                    if (this.mWallpaper.wallpaperComponent == null || event != 8 || this.mWallpaper.imageWallpaperPending) {
                        if (event == 8) {
                            this.mWallpaper.imageWallpaperPending = false;
                        }
                        WallpaperManagerService.this.bindWallpaperComponentLocked(IMAGE_WALLPAPER, true, false, this.mWallpaper, null);
                        WallpaperManagerService.this.saveSettingsLocked(this.mWallpaper);
                    }
                }
            }
        }
    }
}

