/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.FloatMath;

public class TwilightCalculator {
    public static final int DAY = 0;
    public static final int NIGHT = 1;
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    private static final float J0 = 9.0E-4f;
    private static final float ALTIDUTE_CORRECTION_CIVIL_TWILIGHT = -0.10471976f;
    private static final float C1 = 0.0334196f;
    private static final float C2 = 3.49066E-4f;
    private static final float C3 = 5.236E-6f;
    private static final float OBLIQUITY = 0.4092797f;
    private static final long UTC_2000 = 946728000000L;
    public long mSunset;
    public long mSunrise;
    public int mState;

    public void calculateTwilight(long time, double latiude, double longitude) {
        float daysSince2000 = (float)(time - 946728000000L) / 8.64E7f;
        float meanAnomaly = 6.24006f + daysSince2000 * 0.01720197f;
        float trueAnomaly = meanAnomaly + 0.0334196f * FloatMath.sin(meanAnomaly) + 3.49066E-4f * FloatMath.sin(2.0f * meanAnomaly) + 5.236E-6f * FloatMath.sin(3.0f * meanAnomaly);
        float solarLng = trueAnomaly + 1.7965931f + (float)Math.PI;
        double arcLongitude = -longitude / 360.0;
        float n = Math.round((double)(daysSince2000 - 9.0E-4f) - arcLongitude);
        double solarTransitJ2000 = (double)(n + 9.0E-4f) + arcLongitude + (double)(0.0053f * FloatMath.sin(meanAnomaly)) + (double)(-0.0069f * FloatMath.sin(2.0f * solarLng));
        double solarDec = Math.asin(FloatMath.sin(solarLng) * FloatMath.sin(0.4092797f));
        double latRad = latiude * 0.01745329238474369;
        double cosHourAngle = ((double)FloatMath.sin(-0.10471976f) - Math.sin(latRad) * Math.sin(solarDec)) / (Math.cos(latRad) * Math.cos(solarDec));
        if (cosHourAngle >= 1.0) {
            this.mState = 1;
            this.mSunset = -1L;
            this.mSunrise = -1L;
            return;
        }
        if (cosHourAngle <= -1.0) {
            this.mState = 0;
            this.mSunset = -1L;
            this.mSunrise = -1L;
            return;
        }
        float hourAngle = (float)(Math.acos(cosHourAngle) / (Math.PI * 2));
        this.mSunset = Math.round((solarTransitJ2000 + (double)hourAngle) * 8.64E7) + 946728000000L;
        this.mSunrise = Math.round((solarTransitJ2000 - (double)hourAngle) * 8.64E7) + 946728000000L;
        this.mState = this.mSunrise < time && this.mSunset > time ? 0 : 1;
    }
}

