/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.IAudioService;
import android.media.IRingtonePlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.notification.INotificationListener;
import android.service.notification.StatusBarNotification;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.notification.NotificationScorer;
import com.android.server.LightsService;
import com.android.server.StatusBarManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NotificationManagerService
extends INotificationManager.Stub {
    private static final String TAG = "NotificationService";
    private static final boolean DBG = false;
    private static final int MAX_PACKAGE_NOTIFICATIONS = 50;
    private static final int MESSAGE_TIMEOUT = 2;
    private static final int LONG_DELAY = 3500;
    private static final int SHORT_DELAY = 2000;
    private static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{0L, 250L, 250L, 250L};
    private static final int VIBRATE_PATTERN_MAXLEN = 17;
    private static final int DEFAULT_STREAM_TYPE = 5;
    private static final boolean SCORE_ONGOING_HIGHER = false;
    private static final int JUNK_SCORE = -1000;
    private static final int NOTIFICATION_PRIORITY_MULTIPLIER = 10;
    private static final int SCORE_DISPLAY_THRESHOLD = -20;
    private static final int SCORE_INTERRUPTION_THRESHOLD = -10;
    private static final boolean ENABLE_BLOCKED_NOTIFICATIONS = true;
    private static final boolean ENABLE_BLOCKED_TOASTS = true;
    private static final String ENABLED_NOTIFICATION_LISTENERS_SEPARATOR = ":";
    final Context mContext;
    final IActivityManager mAm;
    final UserManager mUserManager;
    final IBinder mForegroundToken = new Binder();
    private WorkerHandler mHandler;
    private StatusBarManagerService mStatusBar;
    private LightsService.Light mNotificationLight;
    private LightsService.Light mAttentionLight;
    private int mDefaultNotificationColor;
    private int mDefaultNotificationLedOn;
    private int mDefaultNotificationLedOff;
    private long[] mDefaultVibrationPattern;
    private long[] mFallbackVibrationPattern;
    private boolean mSystemReady;
    private int mDisabledNotifications;
    private NotificationRecord mSoundNotification;
    private NotificationRecord mVibrateNotification;
    private IAudioService mAudioService;
    private Vibrator mVibrator;
    private boolean mScreenOn = true;
    private boolean mInCall = false;
    private boolean mNotificationPulseEnabled;
    private final ArrayList<NotificationRecord> mNotificationList = new ArrayList();
    private ArrayList<ToastRecord> mToastQueue;
    private ArrayList<NotificationRecord> mLights = new ArrayList();
    private NotificationRecord mLedNotification;
    private final AppOpsManager mAppOps;
    private ArrayList<NotificationListenerInfo> mListeners = new ArrayList();
    private ArrayList<String> mServicesBinding = new ArrayList();
    private HashSet<ComponentName> mEnabledListenersForCurrentUser = new HashSet();
    private HashSet<String> mEnabledListenerPackageNames = new HashSet();
    private AtomicFile mPolicyFile;
    private HashSet<String> mBlockedPackages = new HashSet();
    private static final int DB_VERSION = 1;
    private static final String TAG_BODY = "notification-policy";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_BLOCKED_PKGS = "blocked-packages";
    private static final String TAG_PACKAGE = "package";
    private static final String ATTR_NAME = "name";
    private final ArrayList<NotificationScorer> mScorers = new ArrayList();
    Archive mArchive = new Archive();
    private StatusBarManagerService.NotificationCallbacks mNotificationCallbacks = new StatusBarManagerService.NotificationCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onSetDisabled(int status) {
            ArrayList arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                long identity;
                block9: {
                    NotificationManagerService.this.mDisabledNotifications = status;
                    if ((NotificationManagerService.this.mDisabledNotifications & 0x40000) == 0) return;
                    identity = Binder.clearCallingIdentity();
                    try {
                        block8: {
                            try {
                                IRingtonePlayer player = NotificationManagerService.this.mAudioService.getRingtonePlayer();
                                if (player == null) break block8;
                                player.stopAsync();
                            }
                            catch (RemoteException e) {
                                Object var7_7 = null;
                                Binder.restoreCallingIdentity(identity);
                                break block9;
                            }
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        Binder.restoreCallingIdentity(identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(identity);
                }
                identity = Binder.clearCallingIdentity();
                try {
                    NotificationManagerService.this.mVibrator.cancel();
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                return;
            }
        }

        public void onClearAll() {
            NotificationManagerService.this.cancelAll(ActivityManager.getCurrentUser());
        }

        public void onNotificationClick(String pkg, String tag, int id2) {
            NotificationManagerService.this.cancelNotification(pkg, tag, id2, 16, 64, false, ActivityManager.getCurrentUser());
        }

        public void onNotificationClear(String pkg, String tag, int id2) {
            NotificationManagerService.this.cancelNotification(pkg, tag, id2, 0, 66, true, ActivityManager.getCurrentUser());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPanelRevealed() {
            ArrayList arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                long identity;
                block9: {
                    NotificationManagerService.this.mSoundNotification = null;
                    identity = Binder.clearCallingIdentity();
                    try {
                        block8: {
                            try {
                                IRingtonePlayer player = NotificationManagerService.this.mAudioService.getRingtonePlayer();
                                if (player == null) break block8;
                                player.stopAsync();
                            }
                            catch (RemoteException e) {
                                Object var6_6 = null;
                                Binder.restoreCallingIdentity(identity);
                                break block9;
                            }
                        }
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        Binder.restoreCallingIdentity(identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(identity);
                }
                NotificationManagerService.this.mVibrateNotification = null;
                identity = Binder.clearCallingIdentity();
                try {
                    NotificationManagerService.this.mVibrator.cancel();
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                NotificationManagerService.this.mLights.clear();
                NotificationManagerService.this.mLedNotification = null;
                NotificationManagerService.this.updateLightsLocked();
                return;
            }
        }

        public void onNotificationError(String pkg, String tag, int id2, int uid, int initialPid, String message) {
            Slog.d(NotificationManagerService.TAG, "onNotification error pkg=" + pkg + " tag=" + tag + " id=" + id2 + "; will crashApplication(uid=" + uid + ", pid=" + initialPid + ")");
            NotificationManagerService.this.cancelNotification(pkg, tag, id2, 0, 0, false, UserHandle.getUserId(uid));
            long ident = Binder.clearCallingIdentity();
            try {
                ActivityManagerNative.getDefault().crashApplication(uid, initialPid, pkg, "Bad notification posted from package " + pkg + ": " + message);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            Binder.restoreCallingIdentity(ident);
        }
    };
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            boolean queryRestart = false;
            boolean queryRemove = false;
            boolean packageChanged = false;
            boolean cancelNotifications = true;
            if (action.equals("android.intent.action.PACKAGE_ADDED") || (queryRemove = action.equals("android.intent.action.PACKAGE_REMOVED")) || action.equals("android.intent.action.PACKAGE_RESTARTED") || (packageChanged = action.equals("android.intent.action.PACKAGE_CHANGED")) || (queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART")) || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                boolean queryReplace;
                String[] pkgList = null;
                boolean bl = queryReplace = queryRemove && intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if (queryRestart) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                } else {
                    Uri uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    if (packageChanged) {
                        try {
                            int enabled = NotificationManagerService.this.mContext.getPackageManager().getApplicationEnabledSetting(pkgName);
                            if (enabled == 1 || enabled == 0) {
                                cancelNotifications = false;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                    pkgList = new String[]{pkgName};
                }
                boolean anyListenersInvolved = false;
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkgName : pkgList) {
                        if (cancelNotifications) {
                            NotificationManagerService.this.cancelAllNotificationsInt(pkgName, 0, 0, !queryRestart, -1);
                        }
                        if (!NotificationManagerService.this.mEnabledListenerPackageNames.contains(pkgName)) continue;
                        anyListenersInvolved = true;
                    }
                }
                if (anyListenersInvolved) {
                    if (!queryReplace) {
                        NotificationManagerService.this.disableNonexistentListeners();
                    }
                    NotificationManagerService.this.rebindListenerServices();
                }
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                NotificationManagerService.this.mScreenOn = true;
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                NotificationManagerService.this.mScreenOn = false;
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                NotificationManagerService.this.mInCall = intent.getStringExtra("state").equals(TelephonyManager.EXTRA_STATE_OFFHOOK);
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.USER_STOPPED")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(null, 0, 0, true, userHandle);
                }
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                NotificationManagerService.this.mNotificationLight.turnOff();
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                NotificationManagerService.this.mSettingsObserver.update(null);
            }
        }
    };
    private SettingsObserver mSettingsObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadBlockDb() {
        HashSet<String> hashSet = this.mBlockedPackages;
        synchronized (hashSet) {
            block14: {
                if (this.mPolicyFile != null) return;
                File dir = new File("/data/system");
                this.mPolicyFile = new AtomicFile(new File(dir, "notification_policy.xml"));
                this.mBlockedPackages.clear();
                FileInputStream infile = null;
                try {
                    try {
                        int type;
                        infile = this.mPolicyFile.openRead();
                        XmlPullParser parser = Xml.newPullParser();
                        parser.setInput(infile, null);
                        int version = 1;
                        block9: while ((type = parser.next()) != 1) {
                            String tag = parser.getName();
                            if (type != 2) continue;
                            if (TAG_BODY.equals(tag)) {
                                version = Integer.parseInt(parser.getAttributeValue(null, ATTR_VERSION));
                                continue;
                            }
                            if (!TAG_BLOCKED_PKGS.equals(tag)) continue;
                            while ((type = parser.next()) != 1) {
                                tag = parser.getName();
                                if (TAG_PACKAGE.equals(tag)) {
                                    this.mBlockedPackages.add(parser.getAttributeValue(null, ATTR_NAME));
                                    continue;
                                }
                                if (!TAG_BLOCKED_PKGS.equals(tag) || type != 3) continue;
                                continue block9;
                            }
                        }
                        Object var9_12 = null;
                    }
                    catch (FileNotFoundException e) {
                        Object var9_13 = null;
                        IoUtils.closeQuietly(infile);
                        break block14;
                    }
                    catch (IOException e) {
                        Log.wtf(TAG, "Unable to read blocked notifications database", e);
                        Object var9_14 = null;
                        IoUtils.closeQuietly(infile);
                        break block14;
                    }
                    catch (NumberFormatException e) {
                        Log.wtf(TAG, "Unable to parse blocked notifications database", e);
                        Object var9_15 = null;
                        IoUtils.closeQuietly(infile);
                        break block14;
                    }
                    catch (XmlPullParserException e) {
                        Log.wtf(TAG, "Unable to parse blocked notifications database", e);
                        Object var9_16 = null;
                        IoUtils.closeQuietly(infile);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    IoUtils.closeQuietly(infile);
                    throw throwable;
                }
                IoUtils.closeQuietly(infile);
            }
            return;
        }
    }

    public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
        this.checkCallerIsSystem();
        return this.mAppOps.checkOpNoThrow(11, uid, pkg) == 0;
    }

    private boolean noteNotificationOp(String pkg, int uid) {
        if (this.mAppOps.noteOpNoThrow(11, uid, pkg) != 0) {
            Slog.v(TAG, "notifications are disabled by AppOps for " + pkg);
            return false;
        }
        return true;
    }

    public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
        this.checkCallerIsSystem();
        Slog.v(TAG, (enabled ? "en" : "dis") + "abling notifications for " + pkg);
        this.mAppOps.setMode(11, uid, pkg, enabled ? 0 : 1);
        if (!enabled) {
            this.cancelAllNotificationsInt(pkg, 0, 0, true, UserHandle.getUserId(uid));
        }
    }

    private static String idDebugString(Context baseContext, String packageName, int id2) {
        Context c = null;
        if (packageName != null) {
            try {
                c = baseContext.createPackageContext(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                c = baseContext;
            }
        } else {
            c = baseContext;
        }
        Resources r = c.getResources();
        try {
            return r.getResourceName(id2);
        }
        catch (Resources.NotFoundException e) {
            return "<name unknown>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBarNotification[] getActiveNotifications(String callingPkg) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getActiveNotifications");
        StatusBarNotification[] tmp = null;
        int uid = Binder.getCallingUid();
        if (this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
            ArrayList<NotificationRecord> arrayList = this.mNotificationList;
            synchronized (arrayList) {
                tmp = new StatusBarNotification[this.mNotificationList.size()];
                int N = this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    tmp[i] = this.mNotificationList.get((int)i).sbn;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getHistoricalNotifications");
        StatusBarNotification[] tmp = null;
        int uid = Binder.getCallingUid();
        if (this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
            Archive archive = this.mArchive;
            synchronized (archive) {
                tmp = this.mArchive.getArray(count);
            }
        }
        return tmp;
    }

    void disableNonexistentListeners() {
        int currentUser = ActivityManager.getCurrentUser();
        String flatIn = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
        if (!TextUtils.isEmpty(flatIn)) {
            PackageManager pm = this.mContext.getPackageManager();
            List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(new Intent("android.service.notification.NotificationListenerService"), 132, currentUser);
            HashSet<ComponentName> installed = new HashSet<ComponentName>();
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                if (!"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(info.permission)) {
                    Slog.w(TAG, "Skipping notification listener service " + info.packageName + "/" + info.name + ": it does not require the permission " + "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
                    continue;
                }
                installed.add(new ComponentName(info.packageName, info.name));
            }
            String flatOut = "";
            if (!installed.isEmpty()) {
                String[] enabled = flatIn.split(ENABLED_NOTIFICATION_LISTENERS_SEPARATOR);
                ArrayList<String> remaining = new ArrayList<String>(enabled.length);
                for (int i = 0; i < enabled.length; ++i) {
                    ComponentName enabledComponent = ComponentName.unflattenFromString(enabled[i]);
                    if (!installed.contains(enabledComponent)) continue;
                    remaining.add(enabled[i]);
                }
                flatOut = TextUtils.join((CharSequence)ENABLED_NOTIFICATION_LISTENERS_SEPARATOR, remaining);
            }
            if (!flatIn.equals(flatOut)) {
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", flatOut, currentUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebindListenerServices() {
        ArrayList<ComponentName> toAdd;
        int currentUser = ActivityManager.getCurrentUser();
        String flat = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
        NotificationListenerInfo[] toRemove = new NotificationListenerInfo[this.mListeners.size()];
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            toRemove = this.mListeners.toArray(toRemove);
            toAdd = new ArrayList<ComponentName>();
            HashSet<ComponentName> newEnabled = new HashSet<ComponentName>();
            HashSet<String> newPackages = new HashSet<String>();
            if (flat != null) {
                String[] components = flat.split(ENABLED_NOTIFICATION_LISTENERS_SEPARATOR);
                for (int i = 0; i < components.length; ++i) {
                    ComponentName component = ComponentName.unflattenFromString(components[i]);
                    if (component == null) continue;
                    newEnabled.add(component);
                    toAdd.add(component);
                    newPackages.add(component.getPackageName());
                }
                this.mEnabledListenersForCurrentUser = newEnabled;
                this.mEnabledListenerPackageNames = newPackages;
            }
        }
        for (NotificationListenerInfo info : toRemove) {
            ComponentName component = info.component;
            int oldUser = info.userid;
            Slog.v(TAG, "disabling notification listener for user " + oldUser + ": " + component);
            this.unregisterListenerService(component, info.userid);
        }
        int N = toAdd.size();
        for (int i = 0; i < N; ++i) {
            ComponentName component = (ComponentName)toAdd.get(i);
            Slog.v(TAG, "enabling notification listener for user " + currentUser + ": " + component);
            this.registerListenerService(component, currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(INotificationListener listener, ComponentName component, int userid) {
        this.checkCallerIsSystem();
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            try {
                NotificationListenerInfo info = new NotificationListenerInfo(listener, component, userid, true);
                listener.asBinder().linkToDeath(info, 0);
                this.mListeners.add(info);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerService(ComponentName name, final int userid) {
        this.checkCallerIsSystem();
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            final String servicesBindingTag = name.toString() + "/" + userid;
            if (this.mServicesBinding.contains(servicesBindingTag)) {
                return;
            }
            this.mServicesBinding.add(servicesBindingTag);
            int N = this.mListeners.size();
            for (int i = N - 1; i >= 0; --i) {
                NotificationListenerInfo info = this.mListeners.get(i);
                if (!name.equals(info.component) || info.userid != userid) continue;
                this.mListeners.remove(i);
                if (info.connection == null) continue;
                this.mContext.unbindService(info.connection);
            }
            Intent intent = new Intent("android.service.notification.NotificationListenerService");
            intent.setComponent(name);
            intent.putExtra("android.intent.extra.client_label", 17040560);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(this.mContext, 0, new Intent("android.settings.NOTIFICATION_LISTENER_SETTINGS"), 0));
            try {
                if (!this.mContext.bindServiceAsUser(intent, new ServiceConnection(){
                    INotificationListener mListener;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onServiceConnected(ComponentName name, IBinder service) {
                        ArrayList arrayList = NotificationManagerService.this.mNotificationList;
                        synchronized (arrayList) {
                            NotificationManagerService.this.mServicesBinding.remove(servicesBindingTag);
                            try {
                                this.mListener = INotificationListener.Stub.asInterface(service);
                                NotificationListenerInfo info = new NotificationListenerInfo(this.mListener, name, userid, this);
                                service.linkToDeath(info, 0);
                                NotificationManagerService.this.mListeners.add(info);
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                        }
                    }

                    public void onServiceDisconnected(ComponentName name) {
                        Slog.v(NotificationManagerService.TAG, "notification listener connection lost: " + name);
                    }
                }, 1, new UserHandle(userid))) {
                    this.mServicesBinding.remove(servicesBindingTag);
                    Slog.w(TAG, "Unable to bind listener service: " + intent);
                    return;
                }
            }
            catch (SecurityException ex) {
                Slog.e(TAG, "Unable to bind listener service: " + intent, ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(INotificationListener listener, int userid) {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mListeners.size();
            for (int i = N - 1; i >= 0; --i) {
                NotificationListenerInfo info = this.mListeners.get(i);
                if (info.listener.asBinder() != listener.asBinder() || info.userid != userid) continue;
                this.mListeners.remove(i);
                if (info.connection == null) continue;
                this.mContext.unbindService(info.connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListenerService(ComponentName name, int userid) {
        this.checkCallerIsSystem();
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mListeners.size();
            for (int i = N - 1; i >= 0; --i) {
                NotificationListenerInfo info = this.mListeners.get(i);
                if (!name.equals(info.component) || info.userid != userid) continue;
                this.mListeners.remove(i);
                if (info.connection == null) continue;
                try {
                    this.mContext.unbindService(info.connection);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Slog.e(TAG, "Listener " + name + " could not be unbound: " + ex);
                }
            }
        }
    }

    private void notifyPostedLocked(NotificationRecord n) {
        final StatusBarNotification sbn = n.sbn.clone();
        for (final NotificationListenerInfo info : this.mListeners) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    info.notifyPostedIfUserMatch(sbn);
                }
            });
        }
    }

    private void notifyRemovedLocked(NotificationRecord n) {
        final StatusBarNotification sbn_light = n.sbn.cloneLight();
        for (final NotificationListenerInfo info : this.mListeners) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    info.notifyRemovedIfUserMatch(sbn_light);
                }
            });
        }
    }

    private NotificationListenerInfo checkListenerToken(INotificationListener listener) {
        IBinder token = listener.asBinder();
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            NotificationListenerInfo info = this.mListeners.get(i);
            if (info.listener.asBinder() != token) continue;
            return info;
        }
        throw new SecurityException("Disallowed call from unknown listener: " + listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllNotificationsFromListener(INotificationListener token) {
        NotificationListenerInfo info = this.checkListenerToken(token);
        long identity = Binder.clearCallingIdentity();
        try {
            this.cancelAll(info.userid);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) {
        NotificationListenerInfo info = this.checkListenerToken(token);
        long identity = Binder.clearCallingIdentity();
        try {
            this.cancelNotification(pkg, tag, id2, 0, 66, true, info.userid);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBarNotification[] getActiveNotificationsFromListener(INotificationListener token) {
        NotificationListenerInfo info = this.checkListenerToken(token);
        StatusBarNotification[] result = new StatusBarNotification[]{};
        ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>();
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            for (int i = 0; i < N; ++i) {
                StatusBarNotification sbn = this.mNotificationList.get((int)i).sbn;
                if (!info.enabledAndUserMatches(sbn)) continue;
                list.add(sbn);
            }
        }
        return list.toArray(result);
    }

    static long[] getLongArray(Resources r, int resid, int maxlen, long[] def) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return def;
        }
        int len = ar.length > maxlen ? maxlen : ar.length;
        long[] out = new long[len];
        for (int i = 0; i < len; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    NotificationManagerService(Context context, StatusBarManagerService statusBar, LightsService lights) {
        String[] notificationScorerNames;
        this.mContext = context;
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mAm = ActivityManagerNative.getDefault();
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mToastQueue = new ArrayList();
        this.mHandler = new WorkerHandler();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.importOldBlockDb();
        this.mStatusBar = statusBar;
        statusBar.setNotificationCallbacks(this.mNotificationCallbacks);
        this.mNotificationLight = lights.getLight(4);
        this.mAttentionLight = lights.getLight(5);
        Resources resources = this.mContext.getResources();
        this.mDefaultNotificationColor = resources.getColor(17170543);
        this.mDefaultNotificationLedOn = resources.getInteger(17694753);
        this.mDefaultNotificationLedOff = resources.getInteger(17694754);
        this.mDefaultVibrationPattern = NotificationManagerService.getLongArray(resources, 17236008, 17, DEFAULT_VIBRATE_PATTERN);
        this.mFallbackVibrationPattern = NotificationManagerService.getLongArray(resources, 17236009, 17, DEFAULT_VIBRATE_PATTERN);
        if (0 == Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0)) {
            this.mDisabledNotifications = 262144;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.intent.action.USER_PRESENT");
        filter.addAction("android.intent.action.USER_STOPPED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        this.mContext.registerReceiver(this.mIntentReceiver, filter);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme(TAG_PACKAGE);
        this.mContext.registerReceiver(this.mIntentReceiver, pkgFilter);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mIntentReceiver, sdFilter);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        for (String scorerName : notificationScorerNames = resources.getStringArray(17236011)) {
            try {
                Class<?> scorerClass = this.mContext.getClassLoader().loadClass(scorerName);
                NotificationScorer scorer = (NotificationScorer)scorerClass.newInstance();
                scorer.initialize(this.mContext);
                this.mScorers.add(scorer);
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find scorer " + scorerName + ".", e);
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate scorer " + scorerName + ".", e);
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing scorer " + scorerName + ".", e);
            }
        }
    }

    private void importOldBlockDb() {
        this.loadBlockDb();
        PackageManager pm = this.mContext.getPackageManager();
        for (String pkg : this.mBlockedPackages) {
            PackageInfo info = null;
            try {
                info = pm.getPackageInfo(pkg, 0);
                this.setNotificationsEnabledForPackage(pkg, info.applicationInfo.uid, false);
            }
            catch (PackageManager.NameNotFoundException e) {}
        }
        this.mBlockedPackages.clear();
        if (this.mPolicyFile != null) {
            this.mPolicyFile.delete();
        }
    }

    void systemReady() {
        this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        this.mSystemReady = true;
        this.rebindListenerServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueToast(String pkg, ITransientNotification callback, int duration) {
        boolean isSystemToast;
        if (pkg == null || callback == null) {
            Slog.e(TAG, "Not doing toast. pkg=" + pkg + " callback=" + callback);
            return;
        }
        boolean bl = isSystemToast = this.isCallerSystem() || "android".equals(pkg);
        if (!this.noteNotificationOp(pkg, Binder.getCallingUid()) && !isSystemToast) {
            Slog.e(TAG, "Suppressing toast from package " + pkg + " by user request.");
            return;
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            long callingId;
            block12: {
                block11: {
                    int callingPid = Binder.getCallingPid();
                    callingId = Binder.clearCallingIdentity();
                    try {
                        int index = this.indexOfToastLocked(pkg, callback);
                        if (index >= 0) {
                            ToastRecord record = this.mToastQueue.get(index);
                            record.update(duration);
                        } else {
                            if (!isSystemToast) {
                                int count = 0;
                                int N = this.mToastQueue.size();
                                for (int i = 0; i < N; ++i) {
                                    ToastRecord r = this.mToastQueue.get(i);
                                    if (!r.pkg.equals(pkg) || ++count < 50) continue;
                                    Slog.e(TAG, "Package has already posted " + count + " toasts. Not showing more. Package=" + pkg);
                                    Object var16_15 = null;
                                    break block11;
                                }
                            }
                            ToastRecord record = new ToastRecord(callingPid, pkg, callback, duration);
                            this.mToastQueue.add(record);
                            index = this.mToastQueue.size() - 1;
                            this.keepProcessAliveLocked(callingPid);
                        }
                        if (index == 0) {
                            this.showNextToastLocked();
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        Binder.restoreCallingIdentity(callingId);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(callingId);
                return;
            }
            Object var16_16 = null;
            Binder.restoreCallingIdentity(callingId);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelToast(String pkg, ITransientNotification callback) {
        Slog.i(TAG, "cancelToast pkg=" + pkg + " callback=" + callback);
        if (pkg == null || callback == null) {
            Slog.e(TAG, "Not cancelling notification. pkg=" + pkg + " callback=" + callback);
            return;
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            long callingId = Binder.clearCallingIdentity();
            try {
                int index = this.indexOfToastLocked(pkg, callback);
                if (index >= 0) {
                    this.cancelToastLocked(index);
                } else {
                    Slog.w(TAG, "Toast already cancelled. pkg=" + pkg + " callback=" + callback);
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private void showNextToastLocked() {
        ToastRecord record = this.mToastQueue.get(0);
        while (record != null) {
            try {
                record.callback.show();
                this.scheduleTimeoutLocked(record);
                return;
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Object died trying to show notification " + record.callback + " in package " + record.pkg);
                int index = this.mToastQueue.indexOf(record);
                if (index >= 0) {
                    this.mToastQueue.remove(index);
                }
                this.keepProcessAliveLocked(record.pid);
                if (this.mToastQueue.size() > 0) {
                    record = this.mToastQueue.get(0);
                    continue;
                }
                record = null;
            }
        }
    }

    private void cancelToastLocked(int index) {
        ToastRecord record = this.mToastQueue.get(index);
        try {
            record.callback.hide();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Object died trying to hide notification " + record.callback + " in package " + record.pkg);
        }
        this.mToastQueue.remove(index);
        this.keepProcessAliveLocked(record.pid);
        if (this.mToastQueue.size() > 0) {
            this.showNextToastLocked();
        }
    }

    private void scheduleTimeoutLocked(ToastRecord r) {
        this.mHandler.removeCallbacksAndMessages(r);
        Message m = Message.obtain(this.mHandler, 2, r);
        long delay = r.duration == 1 ? 3500L : 2000L;
        this.mHandler.sendMessageDelayed(m, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(ToastRecord record) {
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            int index = this.indexOfToastLocked(record.pkg, record.callback);
            if (index >= 0) {
                this.cancelToastLocked(index);
            }
        }
    }

    private int indexOfToastLocked(String pkg, ITransientNotification callback) {
        IBinder cbak = callback.asBinder();
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg) || r.callback.asBinder() != cbak) continue;
            return i;
        }
        return -1;
    }

    private void keepProcessAliveLocked(int pid) {
        int toastCount = 0;
        ArrayList<ToastRecord> list = this.mToastQueue;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ToastRecord r = list.get(i);
            if (r.pid != pid) continue;
            ++toastCount;
        }
        try {
            this.mAm.setProcessForeground(this.mForegroundToken, pid, toastCount > 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void enqueueNotificationWithTag(String pkg, String basePkg, String tag, int id2, Notification notification, int[] idOut, int userId) {
        this.enqueueNotificationInternal(pkg, basePkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id2, notification, idOut, userId);
    }

    private static final int clamp(int x, int low, int high) {
        return x < low ? low : (x > high ? high : x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNotificationInternal(final String pkg, String basePkg, final int callingUid, final int callingPid, final String tag, final int id2, final Notification notification, int[] idOut, int incomingUserId) {
        this.checkCallerIsSystemOrSameApp(pkg);
        final boolean isSystemNotification = this.isUidSystem(callingUid) || "android".equals(pkg);
        final int userId = ActivityManager.handleIncomingUser(callingPid, callingUid, incomingUserId, true, false, "enqueueNotification", pkg);
        final UserHandle user = new UserHandle(userId);
        if (!isSystemNotification) {
            ArrayList<NotificationRecord> arrayList = this.mNotificationList;
            synchronized (arrayList) {
                int count = 0;
                int N = this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    NotificationRecord r = this.mNotificationList.get(i);
                    if (!r.sbn.getPackageName().equals(pkg) || r.sbn.getUserId() != userId || ++count < 50) continue;
                    Slog.e(TAG, "Package has already posted " + count + " notifications.  Not showing more.  package=" + pkg);
                    return;
                }
            }
        }
        if (!pkg.equals("com.android.providers.downloads") || Log.isLoggable("DownloadManager", 2)) {
            EventLog.writeEvent(2750, pkg, id2, tag, userId, notification.toString());
        }
        if (pkg == null || notification == null) {
            throw new IllegalArgumentException("null not allowed: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        if (notification.icon != 0 && notification.contentView == null) {
            throw new IllegalArgumentException("contentView required: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                int score;
                notification.priority = NotificationManagerService.clamp(notification.priority, -2, 2);
                if (0 != (notification.flags & 0x80) && notification.priority < 2) {
                    notification.priority = 2;
                }
                int initialScore = score = notification.priority * 10;
                if (!NotificationManagerService.this.mScorers.isEmpty()) {
                    for (NotificationScorer scorer : NotificationManagerService.this.mScorers) {
                        try {
                            score = scorer.getScore(notification, score);
                        }
                        catch (Throwable t) {
                            Slog.w(NotificationManagerService.TAG, "Scorer threw on .getScore.", t);
                        }
                    }
                }
                notification.extras.putBoolean("android.scoreModified", score != initialScore);
                if (!NotificationManagerService.this.noteNotificationOp(pkg, callingUid) && !isSystemNotification) {
                    score = -1000;
                    Slog.e(NotificationManagerService.TAG, "Suppressing notification from package " + pkg + " by user request.");
                }
                if (score < -20) {
                    return;
                }
                boolean canInterrupt = score >= -10;
                ArrayList arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    long identity;
                    int currentUser;
                    StatusBarNotification n = new StatusBarNotification(pkg, id2, tag, callingUid, callingPid, score, notification, user);
                    NotificationRecord r = new NotificationRecord(n);
                    NotificationRecord old = null;
                    int index = NotificationManagerService.this.indexOfNotificationLocked(pkg, tag, id2, userId);
                    if (index < 0) {
                        NotificationManagerService.this.mNotificationList.add(r);
                    } else {
                        old = (NotificationRecord)NotificationManagerService.this.mNotificationList.remove(index);
                        NotificationManagerService.this.mNotificationList.add(index, r);
                        if (old != null) {
                            notification.flags |= old.getNotification().flags & 0x40;
                        }
                    }
                    if ((notification.flags & 0x40) != 0) {
                        notification.flags |= 0x22;
                    }
                    long token = Binder.clearCallingIdentity();
                    try {
                        currentUser = ActivityManager.getCurrentUser();
                        Object var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        Binder.restoreCallingIdentity(token);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(token);
                    if (notification.icon != 0) {
                        if (old != null && old.statusBarKey != null) {
                            r.statusBarKey = old.statusBarKey;
                            identity = Binder.clearCallingIdentity();
                            try {
                                NotificationManagerService.this.mStatusBar.updateNotification(r.statusBarKey, n);
                                Object var15_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_20 = null;
                                Binder.restoreCallingIdentity(identity);
                                throw throwable;
                            }
                            Binder.restoreCallingIdentity(identity);
                        } else {
                            identity = Binder.clearCallingIdentity();
                            try {
                                r.statusBarKey = NotificationManagerService.this.mStatusBar.addNotification(n);
                                if ((n.getNotification().flags & 1) != 0 && canInterrupt) {
                                    NotificationManagerService.this.mAttentionLight.pulse();
                                }
                                Object var17_24 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_25 = null;
                                Binder.restoreCallingIdentity(identity);
                                throw throwable;
                            }
                            Binder.restoreCallingIdentity(identity);
                        }
                        if (currentUser == userId) {
                            NotificationManagerService.this.sendAccessibilityEvent(notification, pkg);
                        }
                        NotificationManagerService.this.notifyPostedLocked(r);
                    } else {
                        Slog.e(NotificationManagerService.TAG, "Not posting notification with icon==0: " + notification);
                        if (old != null && old.statusBarKey != null) {
                            identity = Binder.clearCallingIdentity();
                            try {
                                NotificationManagerService.this.mStatusBar.removeNotification(old.statusBarKey);
                                Object var19_32 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_33 = null;
                                Binder.restoreCallingIdentity(identity);
                                throw throwable;
                            }
                            Binder.restoreCallingIdentity(identity);
                            NotificationManagerService.this.notifyRemovedLocked(r);
                        }
                        Slog.e(NotificationManagerService.TAG, "WARNING: In a future release this will crash the app: " + n.getPackageName());
                    }
                    if ((NotificationManagerService.this.mDisabledNotifications & 0x40000) == 0 && (old == null || (notification.flags & 8) == 0) && (r.getUserId() == -1 || r.getUserId() == userId && r.getUserId() == currentUser) && canInterrupt && NotificationManagerService.this.mSystemReady) {
                        boolean useDefaultVibrate;
                        boolean hasValidSound;
                        AudioManager audioManager;
                        block48: {
                            audioManager = (AudioManager)NotificationManagerService.this.mContext.getSystemService("audio");
                            boolean useDefaultSound = (notification.defaults & 1) != 0 || Settings.System.DEFAULT_NOTIFICATION_URI.equals(notification.sound);
                            Uri soundUri = null;
                            hasValidSound = false;
                            if (useDefaultSound) {
                                soundUri = Settings.System.DEFAULT_NOTIFICATION_URI;
                                ContentResolver resolver = NotificationManagerService.this.mContext.getContentResolver();
                                hasValidSound = Settings.System.getString(resolver, "notification_sound") != null;
                            } else if (notification.sound != null) {
                                soundUri = notification.sound;
                                boolean bl = hasValidSound = soundUri != null;
                            }
                            if (hasValidSound) {
                                boolean looping = (notification.flags & 4) != 0;
                                int audioStreamType = notification.audioStreamType >= 0 ? notification.audioStreamType : 5;
                                NotificationManagerService.this.mSoundNotification = r;
                                if (audioManager.getStreamVolume(audioStreamType) != 0 && !audioManager.isAudioFocusExclusive()) {
                                    long identity2 = Binder.clearCallingIdentity();
                                    try {
                                        block47: {
                                            try {
                                                IRingtonePlayer player = NotificationManagerService.this.mAudioService.getRingtonePlayer();
                                                if (player == null) break block47;
                                                player.playAsync(soundUri, user, looping, audioStreamType);
                                            }
                                            catch (RemoteException e) {
                                                Object var22_41 = null;
                                                Binder.restoreCallingIdentity(identity2);
                                                break block48;
                                            }
                                        }
                                        Object var22_40 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_42 = null;
                                        Binder.restoreCallingIdentity(identity2);
                                        throw throwable;
                                    }
                                    Binder.restoreCallingIdentity(identity2);
                                }
                            }
                        }
                        boolean hasCustomVibrate = notification.vibrate != null;
                        boolean convertSoundToVibration = !hasCustomVibrate && hasValidSound && audioManager.getRingerMode() == 1;
                        boolean bl = useDefaultVibrate = (notification.defaults & 2) != 0;
                        if ((useDefaultVibrate || convertSoundToVibration || hasCustomVibrate) && audioManager.getRingerMode() != 0) {
                            NotificationManagerService.this.mVibrateNotification = r;
                            if (useDefaultVibrate || convertSoundToVibration) {
                                long identity3 = Binder.clearCallingIdentity();
                                try {
                                    NotificationManagerService.this.mVibrator.vibrate(r.sbn.getUid(), r.sbn.getBasePkg(), useDefaultVibrate ? NotificationManagerService.this.mDefaultVibrationPattern : NotificationManagerService.this.mFallbackVibrationPattern, (notification.flags & 4) != 0 ? 0 : -1);
                                    Object var24_44 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var24_45 = null;
                                    Binder.restoreCallingIdentity(identity3);
                                    throw throwable;
                                }
                                Binder.restoreCallingIdentity(identity3);
                            } else if (notification.vibrate.length > 1) {
                                NotificationManagerService.this.mVibrator.vibrate(r.sbn.getUid(), r.sbn.getBasePkg(), notification.vibrate, (notification.flags & 4) != 0 ? 0 : -1);
                            }
                        }
                    }
                    NotificationManagerService.this.mLights.remove(old);
                    if (NotificationManagerService.this.mLedNotification == old) {
                        NotificationManagerService.this.mLedNotification = null;
                    }
                    if ((notification.flags & 1) != 0 && canInterrupt) {
                        NotificationManagerService.this.mLights.add(r);
                        NotificationManagerService.this.updateLightsLocked();
                    } else {
                        if (old == null) return;
                        if ((old.getFlags() & 1) == 0) return;
                        NotificationManagerService.this.updateLightsLocked();
                    }
                    return;
                }
            }
        });
        idOut[0] = id2;
    }

    private void sendAccessibilityEvent(Notification notification, CharSequence packageName) {
        AccessibilityManager manager = AccessibilityManager.getInstance(this.mContext);
        if (!manager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(64);
        event.setPackageName(packageName);
        event.setClassName(Notification.class.getName());
        event.setParcelableData(notification);
        CharSequence tickerText = notification.tickerText;
        if (!TextUtils.isEmpty(tickerText)) {
            event.getText().add(tickerText);
        }
        manager.sendAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelNotificationLocked(NotificationRecord r, boolean sendDelete) {
        block16: {
            if (sendDelete && r.getNotification().deleteIntent != null) {
                try {
                    r.getNotification().deleteIntent.send();
                }
                catch (PendingIntent.CanceledException ex) {
                    Slog.w(TAG, "canceled PendingIntent for " + r.sbn.getPackageName(), ex);
                }
            }
            if (r.getNotification().icon != 0) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mStatusBar.removeNotification(r.statusBarKey);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                r.statusBarKey = null;
                this.notifyRemovedLocked(r);
            }
            if (this.mSoundNotification == r) {
                this.mSoundNotification = null;
                long identity = Binder.clearCallingIdentity();
                try {
                    block15: {
                        try {
                            IRingtonePlayer player = this.mAudioService.getRingtonePlayer();
                            if (player == null) break block15;
                            player.stopAsync();
                        }
                        catch (RemoteException e) {
                            Object var8_13 = null;
                            Binder.restoreCallingIdentity(identity);
                            break block16;
                        }
                    }
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
            }
        }
        if (this.mVibrateNotification == r) {
            this.mVibrateNotification = null;
            long identity = Binder.clearCallingIdentity();
            try {
                this.mVibrator.cancel();
                Object var10_16 = null;
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
        }
        this.mLights.remove(r);
        if (this.mLedNotification == r) {
            this.mLedNotification = null;
        }
        this.mArchive.record(r.sbn);
    }

    private void cancelNotification(final String pkg, final String tag, final int id2, final int mustHaveFlags, final int mustNotHaveFlags, final boolean sendDelete, final int userId) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventLog.writeEvent(2751, pkg, id2, tag, userId, mustHaveFlags, mustNotHaveFlags);
                ArrayList arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    int index = NotificationManagerService.this.indexOfNotificationLocked(pkg, tag, id2, userId);
                    if (index >= 0) {
                        NotificationRecord r = (NotificationRecord)NotificationManagerService.this.mNotificationList.get(index);
                        if ((r.getNotification().flags & mustHaveFlags) != mustHaveFlags) {
                            return;
                        }
                        if ((r.getNotification().flags & mustNotHaveFlags) != 0) {
                            return;
                        }
                        NotificationManagerService.this.mNotificationList.remove(index);
                        NotificationManagerService.this.cancelNotificationLocked(r, sendDelete);
                        NotificationManagerService.this.updateLightsLocked();
                    }
                }
            }
        });
    }

    private boolean notificationMatchesUserId(NotificationRecord r, int userId) {
        return userId == -1 || r.getUserId() == -1 || r.getUserId() == userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelAllNotificationsInt(String pkg, int mustHaveFlags, int mustNotHaveFlags, boolean doit, int userId) {
        EventLog.writeEvent(2752, pkg, userId, mustHaveFlags, mustNotHaveFlags);
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            boolean canceledSomething = false;
            for (int i = N - 1; i >= 0; --i) {
                NotificationRecord r = this.mNotificationList.get(i);
                if (!this.notificationMatchesUserId(r, userId) || r.getUserId() == -1 && pkg == null || (r.getFlags() & mustHaveFlags) != mustHaveFlags || (r.getFlags() & mustNotHaveFlags) != 0 || pkg != null && !r.sbn.getPackageName().equals(pkg)) continue;
                canceledSomething = true;
                if (!doit) {
                    return true;
                }
                this.mNotificationList.remove(i);
                this.cancelNotificationLocked(r, false);
            }
            if (canceledSomething) {
                this.updateLightsLocked();
            }
            return canceledSomething;
        }
    }

    public void cancelNotificationWithTag(String pkg, String tag, int id2, int userId) {
        this.checkCallerIsSystemOrSameApp(pkg);
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelNotificationWithTag", pkg);
        this.cancelNotification(pkg, tag, id2, 0, Binder.getCallingUid() == 1000 ? 0 : 64, false, userId);
    }

    public void cancelAllNotifications(String pkg, int userId) {
        this.checkCallerIsSystemOrSameApp(pkg);
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelAllNotifications", pkg);
        this.cancelAllNotificationsInt(pkg, 0, 64, true, userId);
    }

    boolean isUidSystem(int uid) {
        int appid = UserHandle.getAppId(uid);
        return appid == 1000 || appid == 1001 || uid == 0;
    }

    boolean isCallerSystem() {
        return this.isUidSystem(Binder.getCallingUid());
    }

    void checkCallerIsSystem() {
        if (this.isCallerSystem()) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + Binder.getCallingUid());
    }

    void checkCallerIsSystemOrSameApp(String pkg) {
        if (this.isCallerSystem()) {
            return;
        }
        int uid = Binder.getCallingUid();
        try {
            ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package" + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(int userId) {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            for (int i = N - 1; i >= 0; --i) {
                NotificationRecord r = this.mNotificationList.get(i);
                if (!this.notificationMatchesUserId(r, userId) || (r.getFlags() & 0x22) != 0) continue;
                this.mNotificationList.remove(i);
                this.cancelNotificationLocked(r, true);
            }
            this.updateLightsLocked();
        }
    }

    private void updateLightsLocked() {
        int n;
        if (this.mLedNotification == null && (n = this.mLights.size()) > 0) {
            this.mLedNotification = this.mLights.get(n - 1);
        }
        if (this.mLedNotification == null || this.mInCall || this.mScreenOn) {
            this.mNotificationLight.turnOff();
        } else {
            Notification ledno = this.mLedNotification.sbn.getNotification();
            int ledARGB = ledno.ledARGB;
            int ledOnMS = ledno.ledOnMS;
            int ledOffMS = ledno.ledOffMS;
            if ((ledno.defaults & 4) != 0) {
                ledARGB = this.mDefaultNotificationColor;
                ledOnMS = this.mDefaultNotificationLedOn;
                ledOffMS = this.mDefaultNotificationLedOff;
            }
            if (this.mNotificationPulseEnabled) {
                this.mNotificationLight.setFlashing(ledARGB, 1, ledOnMS, ledOffMS);
            }
        }
    }

    private int indexOfNotificationLocked(String pkg, String tag, int id2, int userId) {
        ArrayList<NotificationRecord> list = this.mNotificationList;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || r.sbn.getId() != id2 || (tag != null ? !tag.equals(r.sbn.getTag()) : r.sbn.getTag() != null) || !r.sbn.getPackageName().equals(pkg)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationPulse() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.updateLightsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        int N;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump NotificationManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Current Notification Manager state:");
        pw.println("  Listeners (" + this.mEnabledListenersForCurrentUser.size() + ") enabled for current user:");
        for (ComponentName cmpt : this.mEnabledListenersForCurrentUser) {
            pw.println("    " + cmpt);
        }
        pw.println("  Live listeners (" + this.mListeners.size() + "):");
        for (NotificationListenerInfo info : this.mListeners) {
            pw.println("    " + info.component + " (user " + info.userid + "): " + info.listener + (info.isSystem ? " SYSTEM" : ""));
        }
        ArrayList<Object> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            N = this.mToastQueue.size();
            if (N > 0) {
                pw.println("  Toast Queue:");
                for (i = 0; i < N; ++i) {
                    this.mToastQueue.get(i).dump(pw, "    ");
                }
                pw.println("  ");
            }
        }
        arrayList = this.mNotificationList;
        synchronized (arrayList) {
            N = this.mNotificationList.size();
            if (N > 0) {
                pw.println("  Notification List:");
                for (i = 0; i < N; ++i) {
                    this.mNotificationList.get(i).dump(pw, "    ", this.mContext);
                }
                pw.println("  ");
            }
            if ((N = this.mLights.size()) > 0) {
                pw.println("  Lights List:");
                for (i = 0; i < N; ++i) {
                    pw.println("    " + this.mLights.get(i));
                }
                pw.println("  ");
            }
            pw.println("  mSoundNotification=" + this.mSoundNotification);
            pw.println("  mVibrateNotification=" + this.mVibrateNotification);
            pw.println("  mDisabledNotifications=0x" + Integer.toHexString(this.mDisabledNotifications));
            pw.println("  mSystemReady=" + this.mSystemReady);
            pw.println("  mArchive=" + this.mArchive.toString());
            Iterator<StatusBarNotification> iter = this.mArchive.descendingIterator();
            int i2 = 0;
            while (iter.hasNext()) {
                pw.println("    " + iter.next());
                if (++i2 < 5) continue;
                if (!iter.hasNext()) break;
                pw.println("    ...");
                break;
            }
        }
    }

    private final class WorkerHandler
    extends Handler {
        private WorkerHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    NotificationManagerService.this.handleTimeout((ToastRecord)msg.obj);
                }
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        private final Uri NOTIFICATION_LIGHT_PULSE_URI;
        private final Uri ENABLED_NOTIFICATION_LISTENERS_URI;

        SettingsObserver(Handler handler) {
            super(handler);
            this.NOTIFICATION_LIGHT_PULSE_URI = Settings.System.getUriFor("notification_light_pulse");
            this.ENABLED_NOTIFICATION_LISTENERS_URI = Settings.Secure.getUriFor("enabled_notification_listeners");
        }

        void observe() {
            ContentResolver resolver = NotificationManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.NOTIFICATION_LIGHT_PULSE_URI, false, this, -1);
            resolver.registerContentObserver(this.ENABLED_NOTIFICATION_LISTENERS_URI, false, this, -1);
            this.update(null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            ContentResolver resolver = NotificationManagerService.this.mContext.getContentResolver();
            if (uri == null || this.NOTIFICATION_LIGHT_PULSE_URI.equals(uri)) {
                boolean pulseEnabled;
                boolean bl = pulseEnabled = Settings.System.getInt(resolver, "notification_light_pulse", 0) != 0;
                if (NotificationManagerService.this.mNotificationPulseEnabled != pulseEnabled) {
                    NotificationManagerService.this.mNotificationPulseEnabled = pulseEnabled;
                    NotificationManagerService.this.updateNotificationPulse();
                }
            }
            if (uri == null || this.ENABLED_NOTIFICATION_LISTENERS_URI.equals(uri)) {
                NotificationManagerService.this.rebindListenerServices();
            }
        }
    }

    private static final class ToastRecord {
        final int pid;
        final String pkg;
        final ITransientNotification callback;
        int duration;

        ToastRecord(int pid, String pkg, ITransientNotification callback, int duration) {
            this.pid = pid;
            this.pkg = pkg;
            this.callback = callback;
            this.duration = duration;
        }

        void update(int duration) {
            this.duration = duration;
        }

        void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + this);
        }

        public final String toString() {
            return "ToastRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " callback=" + this.callback + " duration=" + this.duration;
        }
    }

    public static final class NotificationRecord {
        final StatusBarNotification sbn;
        IBinder statusBarKey;

        NotificationRecord(StatusBarNotification sbn) {
            this.sbn = sbn;
        }

        public Notification getNotification() {
            return this.sbn.getNotification();
        }

        public int getFlags() {
            return this.sbn.getNotification().flags;
        }

        public int getUserId() {
            return this.sbn.getUserId();
        }

        void dump(PrintWriter pw, String prefix, Context baseContext) {
            Notification notification = this.sbn.getNotification();
            pw.println(prefix + this);
            pw.println(prefix + "  uid=" + this.sbn.getUid() + " userId=" + this.sbn.getUserId());
            pw.println(prefix + "  icon=0x" + Integer.toHexString(notification.icon) + " / " + NotificationManagerService.idDebugString(baseContext, this.sbn.getPackageName(), notification.icon));
            pw.println(prefix + "  pri=" + notification.priority + " score=" + this.sbn.getScore());
            pw.println(prefix + "  contentIntent=" + notification.contentIntent);
            pw.println(prefix + "  deleteIntent=" + notification.deleteIntent);
            pw.println(prefix + "  tickerText=" + notification.tickerText);
            pw.println(prefix + "  contentView=" + notification.contentView);
            pw.println(prefix + String.format("  defaults=0x%08x flags=0x%08x", notification.defaults, notification.flags));
            pw.println(prefix + "  sound=" + notification.sound);
            pw.println(prefix + "  vibrate=" + Arrays.toString(notification.vibrate));
            pw.println(prefix + String.format("  led=0x%08x onMs=%d offMs=%d", notification.ledARGB, notification.ledOnMS, notification.ledOffMS));
            if (notification.actions != null && notification.actions.length > 0) {
                pw.println(prefix + "  actions={");
                int N = notification.actions.length;
                for (int i = 0; i < N; ++i) {
                    Notification.Action action = notification.actions[i];
                    pw.println(String.format("%s    [%d] \"%s\" -> %s", prefix, i, action.title, action.actionIntent.toString()));
                }
                pw.println(prefix + "  }");
            }
            if (notification.extras != null && notification.extras.size() > 0) {
                pw.println(prefix + "  extras={");
                for (String key : notification.extras.keySet()) {
                    pw.print(prefix + "    " + key + "=");
                    Object val = notification.extras.get(key);
                    if (val == null) {
                        pw.println("null");
                        continue;
                    }
                    pw.print(val.toString());
                    if (val instanceof Bitmap) {
                        pw.print(String.format(" (%dx%d)", ((Bitmap)val).getWidth(), ((Bitmap)val).getHeight()));
                    } else if (val.getClass().isArray()) {
                        pw.println(" {");
                        int N = Array.getLength(val);
                        for (int i = 0; i < N; ++i) {
                            if (i > 0) {
                                pw.println(",");
                            }
                            pw.print(prefix + "      " + Array.get(val, i));
                        }
                        pw.print("\n" + prefix + "    }");
                    }
                    pw.println();
                }
                pw.println(prefix + "  }");
            }
        }

        public final String toString() {
            return String.format("NotificationRecord(0x%08x: pkg=%s user=%s id=%d tag=%s score=%d: %s)", System.identityHashCode(this), this.sbn.getPackageName(), this.sbn.getUser(), this.sbn.getId(), this.sbn.getTag(), this.sbn.getScore(), this.sbn.getNotification());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Archive {
        static final int BUFFER_SIZE = 250;
        ArrayDeque<StatusBarNotification> mBuffer = new ArrayDeque(250);

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int N = this.mBuffer.size();
            sb.append("Archive (");
            sb.append(N);
            sb.append(" notification");
            sb.append(N == 1 ? ")" : "s)");
            return sb.toString();
        }

        public void record(StatusBarNotification nr) {
            if (this.mBuffer.size() == 250) {
                this.mBuffer.removeFirst();
            }
            this.mBuffer.addLast(nr.cloneLight());
        }

        public void clear() {
            this.mBuffer.clear();
        }

        public Iterator<StatusBarNotification> descendingIterator() {
            return this.mBuffer.descendingIterator();
        }

        public Iterator<StatusBarNotification> ascendingIterator() {
            return this.mBuffer.iterator();
        }

        public Iterator<StatusBarNotification> filter(final Iterator<StatusBarNotification> iter, final String pkg, final int userId) {
            return new Iterator<StatusBarNotification>(){
                StatusBarNotification mNext = this.findNext();

                private StatusBarNotification findNext() {
                    while (iter.hasNext()) {
                        StatusBarNotification nr = (StatusBarNotification)iter.next();
                        if (pkg != null && nr.getPackageName() != pkg || userId != -1 && nr.getUserId() != userId) continue;
                        return nr;
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.mNext == null;
                }

                @Override
                public StatusBarNotification next() {
                    StatusBarNotification next = this.mNext;
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    this.mNext = this.findNext();
                    return next;
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        public StatusBarNotification[] getArray(int count) {
            if (count == 0) {
                count = 250;
            }
            StatusBarNotification[] a = new StatusBarNotification[Math.min(count, this.mBuffer.size())];
            Iterator<StatusBarNotification> iter = this.descendingIterator();
            int i = 0;
            while (iter.hasNext() && i < count) {
                a[i++] = iter.next();
            }
            return a;
        }

        public StatusBarNotification[] getArray(int count, String pkg, int userId) {
            if (count == 0) {
                count = 250;
            }
            StatusBarNotification[] a = new StatusBarNotification[Math.min(count, this.mBuffer.size())];
            Iterator<StatusBarNotification> iter = this.filter(this.descendingIterator(), pkg, userId);
            int i = 0;
            while (iter.hasNext() && i < count) {
                a[i++] = iter.next();
            }
            return a;
        }
    }

    private class NotificationListenerInfo
    implements IBinder.DeathRecipient {
        INotificationListener listener;
        ComponentName component;
        int userid;
        boolean isSystem;
        ServiceConnection connection;

        public NotificationListenerInfo(INotificationListener listener, ComponentName component, int userid, boolean isSystem) {
            this.listener = listener;
            this.component = component;
            this.userid = userid;
            this.isSystem = isSystem;
            this.connection = null;
        }

        public NotificationListenerInfo(INotificationListener listener, ComponentName component, int userid, ServiceConnection connection) {
            this.listener = listener;
            this.component = component;
            this.userid = userid;
            this.isSystem = false;
            this.connection = connection;
        }

        boolean enabledAndUserMatches(StatusBarNotification sbn) {
            int nid = sbn.getUserId();
            if (!this.isEnabledForCurrentUser()) {
                return false;
            }
            if (this.userid == -1) {
                return true;
            }
            return nid == -1 || nid == this.userid;
        }

        public void notifyPostedIfUserMatch(StatusBarNotification sbn) {
            if (!this.enabledAndUserMatches(sbn)) {
                return;
            }
            try {
                this.listener.onNotificationPosted(sbn);
            }
            catch (RemoteException ex) {
                Log.e(NotificationManagerService.TAG, "unable to notify listener (posted): " + this.listener, ex);
            }
        }

        public void notifyRemovedIfUserMatch(StatusBarNotification sbn) {
            if (!this.enabledAndUserMatches(sbn)) {
                return;
            }
            try {
                this.listener.onNotificationRemoved(sbn);
            }
            catch (RemoteException ex) {
                Log.e(NotificationManagerService.TAG, "unable to notify listener (removed): " + this.listener, ex);
            }
        }

        public void binderDied() {
            if (this.connection == null) {
                NotificationManagerService.this.unregisterListener(this.listener, this.userid);
            }
        }

        public boolean isEnabledForCurrentUser() {
            if (this.isSystem) {
                return true;
            }
            if (this.connection == null) {
                return false;
            }
            return NotificationManagerService.this.mEnabledListenersForCurrentUser.contains(this.component);
        }
    }
}

