/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.LocalLog;
import android.util.Slog;
import com.android.server.FgThread;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import com.android.server.Watchdog;
import com.google.android.collect.Lists;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class NativeDaemonConnector
implements Runnable,
Handler.Callback,
Watchdog.Monitor {
    private static final boolean LOGD = false;
    private final String TAG;
    private String mSocket;
    private OutputStream mOutputStream;
    private LocalLog mLocalLog;
    private final ResponseQueue mResponseQueue;
    private INativeDaemonConnectorCallbacks mCallbacks;
    private Handler mCallbackHandler;
    private AtomicInteger mSequenceNumber;
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final long WARN_EXECUTE_DELAY_MS = 500L;
    private final Object mDaemonLock = new Object();
    private final int BUFFER_SIZE = 4096;

    NativeDaemonConnector(INativeDaemonConnectorCallbacks callbacks, String socket, int responseQueueSize, String logTag, int maxLogSize) {
        this.mCallbacks = callbacks;
        this.mSocket = socket;
        this.mResponseQueue = new ResponseQueue(responseQueueSize);
        this.mSequenceNumber = new AtomicInteger(0);
        this.TAG = logTag != null ? logTag : "NativeDaemonConnector";
        this.mLocalLog = new LocalLog(maxLogSize);
    }

    public void run() {
        this.mCallbackHandler = new Handler(FgThread.get().getLooper(), this);
        while (true) {
            try {
                while (true) {
                    this.listenToSocket();
                }
            }
            catch (Exception e) {
                this.loge("Error in NativeDaemonConnector: " + e);
                SystemClock.sleep(5000L);
                continue;
            }
            break;
        }
    }

    public boolean handleMessage(Message msg) {
        String event = (String)msg.obj;
        try {
            if (!this.mCallbacks.onEvent(msg.what, event, NativeDaemonEvent.unescapeArgs(event))) {
                this.log(String.format("Unhandled event '%s'", event));
            }
        }
        catch (Exception e) {
            this.loge("Error handling '" + event + "': " + e);
        }
        return true;
    }

    private LocalSocketAddress determineSocketAddress() {
        if (this.mSocket.startsWith("__test__") && Build.IS_DEBUGGABLE) {
            return new LocalSocketAddress(this.mSocket);
        }
        return new LocalSocketAddress(this.mSocket, LocalSocketAddress.Namespace.RESERVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listenToSocket() throws IOException {
        block32: {
            int count;
            LocalSocket socket = null;
            socket = new LocalSocket();
            LocalSocketAddress address = this.determineSocketAddress();
            socket.connect(address);
            InputStream inputStream = socket.getInputStream();
            Object object = this.mDaemonLock;
            synchronized (object) {
                this.mOutputStream = socket.getOutputStream();
            }
            this.mCallbacks.onDaemonConnected();
            byte[] buffer = new byte[4096];
            int start = 0;
            while (true) {
                if ((count = inputStream.read(buffer, start, 4096 - start)) < 0) break;
                count += start;
                start = 0;
                for (int i = 0; i < count; ++i) {
                    if (buffer[i] != 0) continue;
                    String rawEvent = new String(buffer, start, i - start, StandardCharsets.UTF_8);
                    this.log("RCV <- {" + rawEvent + "}");
                    try {
                        NativeDaemonEvent event = NativeDaemonEvent.parseRawEvent(rawEvent);
                        if (event.isClassUnsolicited()) {
                            this.mCallbackHandler.sendMessage(this.mCallbackHandler.obtainMessage(event.getCode(), event.getRawEvent()));
                        } else {
                            this.mResponseQueue.add(event.getCmdNumber(), event);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.log("Problem parsing message: " + rawEvent + " - " + e);
                    }
                    start = i + 1;
                }
                if (start == 0) {
                    String rawEvent = new String(buffer, start, count, StandardCharsets.UTF_8);
                    this.log("RCV incomplete <- {" + rawEvent + "}");
                }
                if (start != count) {
                    int remaining = 4096 - start;
                    System.arraycopy(buffer, start, buffer, 0, remaining);
                    start = remaining;
                    continue;
                }
                start = 0;
            }
            this.loge("got " + count + " reading with start = " + start);
            Object var11_14 = null;
            Object object2 = this.mDaemonLock;
            synchronized (object2) {
                if (this.mOutputStream != null) {
                    try {
                        this.loge("closing stream for " + this.mSocket);
                        this.mOutputStream.close();
                    }
                    catch (IOException e) {
                        this.loge("Failed closing output stream: " + e);
                    }
                    this.mOutputStream = null;
                }
            }
            try {
                if (socket != null) {
                    socket.close();
                }
                break block32;
            }
            catch (IOException ex) {
                this.loge("Failed closing socket: " + ex);
            }
            break block32;
            {
                catch (IOException ex) {
                    this.loge("Communications error: " + ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                Object object3 = this.mDaemonLock;
                synchronized (object3) {
                    if (this.mOutputStream != null) {
                        try {
                            this.loge("closing stream for " + this.mSocket);
                            this.mOutputStream.close();
                        }
                        catch (IOException e) {
                            this.loge("Failed closing output stream: " + e);
                        }
                        this.mOutputStream = null;
                    }
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException ex) {
                    this.loge("Failed closing socket: " + ex);
                }
                throw throwable;
            }
        }
    }

    static void makeCommand(StringBuilder rawBuilder, StringBuilder logBuilder, int sequenceNumber, String cmd, Object ... args) {
        if (cmd.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Unexpected command: " + cmd);
        }
        if (cmd.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Arguments must be separate from command");
        }
        rawBuilder.append(sequenceNumber).append(' ').append(cmd);
        logBuilder.append(sequenceNumber).append(' ').append(cmd);
        for (Object arg : args) {
            String argString = String.valueOf(arg);
            if (argString.indexOf(0) >= 0) {
                throw new IllegalArgumentException("Unexpected argument: " + arg);
            }
            rawBuilder.append(' ');
            logBuilder.append(' ');
            NativeDaemonConnector.appendEscaped(rawBuilder, argString);
            if (arg instanceof SensitiveArg) {
                logBuilder.append("[scrubbed]");
                continue;
            }
            NativeDaemonConnector.appendEscaped(logBuilder, argString);
        }
        rawBuilder.append('\u0000');
    }

    public NativeDaemonEvent execute(Command cmd) throws NativeDaemonConnectorException {
        return this.execute(cmd.mCmd, cmd.mArguments.toArray());
    }

    public NativeDaemonEvent execute(String cmd, Object ... args) throws NativeDaemonConnectorException {
        NativeDaemonEvent[] events = this.executeForList(cmd, args);
        if (events.length != 1) {
            throw new NativeDaemonConnectorException("Expected exactly one response, but received " + events.length);
        }
        return events[0];
    }

    public NativeDaemonEvent[] executeForList(Command cmd) throws NativeDaemonConnectorException {
        return this.executeForList(cmd.mCmd, cmd.mArguments.toArray());
    }

    public NativeDaemonEvent[] executeForList(String cmd, Object ... args) throws NativeDaemonConnectorException {
        return this.execute(60000, cmd, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeDaemonEvent[] execute(int timeout, String cmd, Object ... args) throws NativeDaemonConnectorException {
        long startTime = SystemClock.elapsedRealtime();
        ArrayList<NativeDaemonEvent> events = Lists.newArrayList();
        StringBuilder rawBuilder = new StringBuilder();
        StringBuilder logBuilder = new StringBuilder();
        int sequenceNumber = this.mSequenceNumber.incrementAndGet();
        NativeDaemonConnector.makeCommand(rawBuilder, logBuilder, sequenceNumber, cmd, args);
        String rawCmd = rawBuilder.toString();
        String logCmd = logBuilder.toString();
        this.log("SND -> {" + logCmd + "}");
        Object object = this.mDaemonLock;
        synchronized (object) {
            if (this.mOutputStream == null) {
                throw new NativeDaemonConnectorException("missing output stream");
            }
            try {
                this.mOutputStream.write(rawCmd.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new NativeDaemonConnectorException("problem sending command", e);
            }
        }
        NativeDaemonEvent event = null;
        do {
            if ((event = this.mResponseQueue.remove(sequenceNumber, timeout, logCmd)) == null) {
                this.loge("timed-out waiting for response to " + logCmd);
                throw new NativeDaemonFailureException(logCmd, event);
            }
            this.log("RMV <- {" + event + "}");
            events.add(event);
        } while (event.isClassContinue());
        long endTime = SystemClock.elapsedRealtime();
        if (endTime - startTime > 500L) {
            this.loge("NDC Command {" + logCmd + "} took too long (" + (endTime - startTime) + "ms)");
        }
        if (event.isClassClientError()) {
            throw new NativeDaemonArgumentException(logCmd, event);
        }
        if (event.isClassServerError()) {
            throw new NativeDaemonFailureException(logCmd, event);
        }
        return events.toArray(new NativeDaemonEvent[events.size()]);
    }

    static void appendEscaped(StringBuilder builder, String arg) {
        boolean hasSpaces;
        boolean bl = hasSpaces = arg.indexOf(32) >= 0;
        if (hasSpaces) {
            builder.append('\"');
        }
        int length = arg.length();
        for (int i = 0; i < length; ++i) {
            char c = arg.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            builder.append(c);
        }
        if (hasSpaces) {
            builder.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        Object object = this.mDaemonLock;
        synchronized (object) {
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mLocalLog.dump(fd, pw, args);
        pw.println();
        this.mResponseQueue.dump(fd, pw, args);
    }

    private void log(String logstring) {
        this.mLocalLog.log(logstring);
    }

    private void loge(String logstring) {
        Slog.e(this.TAG, logstring);
        this.mLocalLog.log(logstring);
    }

    private static class ResponseQueue {
        private final LinkedList<PendingCmd> mPendingCmds = new LinkedList();
        private int mMaxCount;

        ResponseQueue(int maxCount) {
            this.mMaxCount = maxCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int cmdNum, NativeDaemonEvent response) {
            PendingCmd found = null;
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    if (pendingCmd.cmdNum != cmdNum) continue;
                    found = pendingCmd;
                    break;
                }
                if (found == null) {
                    while (this.mPendingCmds.size() >= this.mMaxCount) {
                        Slog.e("NativeDaemonConnector.ResponseQueue", "more buffered than allowed: " + this.mPendingCmds.size() + " >= " + this.mMaxCount);
                        PendingCmd pendingCmd = this.mPendingCmds.remove();
                        Slog.e("NativeDaemonConnector.ResponseQueue", "Removing request: " + pendingCmd.logCmd + " (" + pendingCmd.cmdNum + ")");
                    }
                    found = new PendingCmd(cmdNum, null);
                    this.mPendingCmds.add(found);
                }
                ++found.availableResponseCount;
                if (found.availableResponseCount == 0) {
                    this.mPendingCmds.remove(found);
                }
            }
            try {
                found.responses.put(response);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeDaemonEvent remove(int cmdNum, int timeoutMs, String logCmd) {
            PendingCmd found = null;
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    if (pendingCmd.cmdNum != cmdNum) continue;
                    found = pendingCmd;
                    break;
                }
                if (found == null) {
                    found = new PendingCmd(cmdNum, logCmd);
                    this.mPendingCmds.add(found);
                }
                --found.availableResponseCount;
                if (found.availableResponseCount == 0) {
                    this.mPendingCmds.remove(found);
                }
            }
            NativeDaemonEvent result = null;
            try {
                result = found.responses.poll(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (result == null) {
                Slog.e("NativeDaemonConnector.ResponseQueue", "Timeout waiting for response");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            pw.println("Pending requests:");
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    pw.println("  Cmd " + pendingCmd.cmdNum + " - " + pendingCmd.logCmd);
                }
            }
        }

        private static class PendingCmd {
            public final int cmdNum;
            public final String logCmd;
            public BlockingQueue<NativeDaemonEvent> responses = new ArrayBlockingQueue<NativeDaemonEvent>(10);
            public int availableResponseCount;

            public PendingCmd(int cmdNum, String logCmd) {
                this.cmdNum = cmdNum;
                this.logCmd = logCmd;
            }
        }
    }

    public static class Command {
        private String mCmd;
        private ArrayList<Object> mArguments = Lists.newArrayList();

        public Command(String cmd, Object ... args) {
            this.mCmd = cmd;
            for (Object arg : args) {
                this.appendArg(arg);
            }
        }

        public Command appendArg(Object arg) {
            this.mArguments.add(arg);
            return this;
        }
    }

    private static class NativeDaemonFailureException
    extends NativeDaemonConnectorException {
        public NativeDaemonFailureException(String command, NativeDaemonEvent event) {
            super(command, event);
        }
    }

    private static class NativeDaemonArgumentException
    extends NativeDaemonConnectorException {
        public NativeDaemonArgumentException(String command, NativeDaemonEvent event) {
            super(command, event);
        }

        public IllegalArgumentException rethrowAsParcelableException() {
            throw new IllegalArgumentException(this.getMessage(), this);
        }
    }

    public static class SensitiveArg {
        private final Object mArg;

        public SensitiveArg(Object arg) {
            this.mArg = arg;
        }

        public String toString() {
            return String.valueOf(this.mArg);
        }
    }
}

