/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.telephony.IMms;
import com.android.server.SystemService;

public class MmsServiceBroker
extends SystemService {
    private static final String TAG = "MmsServiceBroker";
    private static final ComponentName MMS_SERVICE_COMPONENT = new ComponentName("com.android.mms.service", "com.android.mms.service.MmsService");
    private static final int MSG_TRY_CONNECTING = 1;
    private static final Uri FAKE_SMS_SENT_URI = Uri.parse("content://sms/sent/0");
    private static final Uri FAKE_MMS_SENT_URI = Uri.parse("content://mms/sent/0");
    private static final Uri FAKE_SMS_DRAFT_URI = Uri.parse("content://sms/draft/0");
    private static final Uri FAKE_MMS_DRAFT_URI = Uri.parse("content://mms/draft/0");
    private static final long SERVICE_CONNECTION_WAIT_TIME_MS = 4000L;
    private static final long RETRY_DELAY_ON_DISCONNECTION_MS = 3000L;
    private Context mContext;
    private volatile IMms mService;
    private volatile AppOpsManager mAppOpsManager = null;
    private volatile PackageManager mPackageManager = null;
    private volatile TelephonyManager mTelephonyManager = null;
    private final Handler mConnectionHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MmsServiceBroker.this.tryConnecting();
                    break;
                }
                default: {
                    Slog.e(MmsServiceBroker.TAG, "Unknown message");
                }
            }
        }
    };
    private ServiceConnection mConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Slog.i(MmsServiceBroker.TAG, "MmsService connected");
            MmsServiceBroker mmsServiceBroker = MmsServiceBroker.this;
            synchronized (mmsServiceBroker) {
                MmsServiceBroker.this.mService = IMms.Stub.asInterface(service);
                MmsServiceBroker.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Slog.i(MmsServiceBroker.TAG, "MmsService unexpectedly disconnected");
            MmsServiceBroker mmsServiceBroker = MmsServiceBroker.this;
            synchronized (mmsServiceBroker) {
                MmsServiceBroker.this.mService = null;
                MmsServiceBroker.this.notifyAll();
            }
            MmsServiceBroker.this.mConnectionHandler.sendMessageDelayed(MmsServiceBroker.this.mConnectionHandler.obtainMessage(1), 3000L);
        }
    };

    public MmsServiceBroker(Context context) {
        super(context);
        this.mContext = context;
        this.mService = null;
    }

    @Override
    public void onStart() {
        this.publishBinderService("imms", new BinderService());
    }

    public void systemRunning() {
        this.tryConnecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConnecting() {
        Slog.i(TAG, "Connecting to MmsService");
        MmsServiceBroker mmsServiceBroker = this;
        synchronized (mmsServiceBroker) {
            if (this.mService != null) {
                Slog.d(TAG, "Already connected");
                return;
            }
            Intent intent = new Intent();
            intent.setComponent(MMS_SERVICE_COMPONENT);
            try {
                if (!this.mContext.bindService(intent, this.mConnection, 1)) {
                    Slog.e(TAG, "Failed to bind to MmsService");
                }
            }
            catch (SecurityException e) {
                Slog.e(TAG, "Forbidden to bind to MmsService", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureService() {
        MmsServiceBroker mmsServiceBroker = this;
        synchronized (mmsServiceBroker) {
            if (this.mService == null) {
                Slog.w(TAG, "MmsService not connected. Try connecting...");
                this.mConnectionHandler.sendMessage(this.mConnectionHandler.obtainMessage(1));
                long shouldEnd = SystemClock.elapsedRealtime() + 4000L;
                long waitTime = 4000L;
                while (waitTime > 0L) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        Slog.w(TAG, "Connection wait interrupted", e);
                    }
                    if (this.mService != null) {
                        return;
                    }
                    waitTime = shouldEnd - SystemClock.elapsedRealtime();
                }
                Slog.e(TAG, "Can not connect to MmsService (timed out)");
                throw new RuntimeException("Timed out in connecting to MmsService");
            }
        }
    }

    private IMms getServiceGuarded() {
        this.ensureService();
        return this.mService;
    }

    private AppOpsManager getAppOpsManager() {
        if (this.mAppOpsManager == null) {
            this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
        }
        return this.mAppOpsManager;
    }

    private PackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            this.mPackageManager = this.mContext.getPackageManager();
        }
        return this.mPackageManager;
    }

    private TelephonyManager getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    private void enforceCarrierPrivilege() {
        String[] packages;
        for (String pkg : packages = this.getPackageManager().getPackagesForUid(Binder.getCallingUid())) {
            if (this.getTelephonyManager().checkCarrierPrivilegesForPackage(pkg) != 1) continue;
            return;
        }
        throw new SecurityException("No carrier privilege");
    }

    private final class BinderService
    extends IMms.Stub {
        private BinderService() {
        }

        @Override
        public void sendMessage(long subId, String callingPkg, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.SEND_SMS", "Send MMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(20, Binder.getCallingUid(), callingPkg) != 0) {
                return;
            }
            MmsServiceBroker.this.getServiceGuarded().sendMessage(subId, callingPkg, contentUri, locationUrl, configOverrides, sentIntent);
        }

        @Override
        public void downloadMessage(long subId, String callingPkg, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.RECEIVE_MMS", "Download MMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(18, Binder.getCallingUid(), callingPkg) != 0) {
                return;
            }
            MmsServiceBroker.this.getServiceGuarded().downloadMessage(subId, callingPkg, locationUrl, contentUri, configOverrides, downloadedIntent);
        }

        @Override
        public void updateMmsSendStatus(int messageRef, byte[] pdu, int status) throws RemoteException {
            MmsServiceBroker.this.enforceCarrierPrivilege();
            MmsServiceBroker.this.getServiceGuarded().updateMmsSendStatus(messageRef, pdu, status);
        }

        @Override
        public void updateMmsDownloadStatus(int messageRef, int status) throws RemoteException {
            MmsServiceBroker.this.enforceCarrierPrivilege();
            MmsServiceBroker.this.getServiceGuarded().updateMmsDownloadStatus(messageRef, status);
        }

        @Override
        public Bundle getCarrierConfigValues(long subId) throws RemoteException {
            return MmsServiceBroker.this.getServiceGuarded().getCarrierConfigValues(subId);
        }

        @Override
        public Uri importTextMessage(String callingPkg, String address, int type, String text, long timestampMillis, boolean seen, boolean read) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Import SMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return FAKE_SMS_SENT_URI;
            }
            return MmsServiceBroker.this.getServiceGuarded().importTextMessage(callingPkg, address, type, text, timestampMillis, seen, read);
        }

        @Override
        public Uri importMultimediaMessage(String callingPkg, Uri contentUri, String messageId, long timestampSecs, boolean seen, boolean read) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Import MMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return FAKE_MMS_SENT_URI;
            }
            return MmsServiceBroker.this.getServiceGuarded().importMultimediaMessage(callingPkg, contentUri, messageId, timestampSecs, seen, read);
        }

        @Override
        public boolean deleteStoredMessage(String callingPkg, Uri messageUri) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Delete SMS/MMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return false;
            }
            return MmsServiceBroker.this.getServiceGuarded().deleteStoredMessage(callingPkg, messageUri);
        }

        @Override
        public boolean deleteStoredConversation(String callingPkg, long conversationId) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Delete conversation");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return false;
            }
            return MmsServiceBroker.this.getServiceGuarded().deleteStoredConversation(callingPkg, conversationId);
        }

        @Override
        public boolean updateStoredMessageStatus(String callingPkg, Uri messageUri, ContentValues statusValues) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Update SMS/MMS message");
            return MmsServiceBroker.this.getServiceGuarded().updateStoredMessageStatus(callingPkg, messageUri, statusValues);
        }

        @Override
        public boolean archiveStoredConversation(String callingPkg, long conversationId, boolean archived) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Update SMS/MMS message");
            return MmsServiceBroker.this.getServiceGuarded().archiveStoredConversation(callingPkg, conversationId, archived);
        }

        @Override
        public Uri addTextMessageDraft(String callingPkg, String address, String text) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Add SMS draft");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return FAKE_SMS_DRAFT_URI;
            }
            return MmsServiceBroker.this.getServiceGuarded().addTextMessageDraft(callingPkg, address, text);
        }

        @Override
        public Uri addMultimediaMessageDraft(String callingPkg, Uri contentUri) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Add MMS draft");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return FAKE_MMS_DRAFT_URI;
            }
            return MmsServiceBroker.this.getServiceGuarded().addMultimediaMessageDraft(callingPkg, contentUri);
        }

        @Override
        public void sendStoredMessage(long subId, String callingPkg, Uri messageUri, Bundle configOverrides, PendingIntent sentIntent) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.SEND_SMS", "Send stored MMS message");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(20, Binder.getCallingUid(), callingPkg) != 0) {
                return;
            }
            MmsServiceBroker.this.getServiceGuarded().sendStoredMessage(subId, callingPkg, messageUri, configOverrides, sentIntent);
        }

        @Override
        public void setAutoPersisting(String callingPkg, boolean enabled) throws RemoteException {
            MmsServiceBroker.this.mContext.enforceCallingPermission("android.permission.WRITE_SMS", "Set auto persist");
            if (MmsServiceBroker.this.getAppOpsManager().noteOp(15, Binder.getCallingUid(), callingPkg) != 0) {
                return;
            }
            MmsServiceBroker.this.getServiceGuarded().setAutoPersisting(callingPkg, enabled);
        }

        @Override
        public boolean getAutoPersisting() throws RemoteException {
            return MmsServiceBroker.this.getServiceGuarded().getAutoPersisting();
        }
    }
}

