/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.SSLServerSocketImpl;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private SSLParametersImpl sslParameters;
    private IOException instantiationException;

    public SSLServerSocketFactoryImpl() {
        try {
            this.sslParameters = SSLParametersImpl.getDefault();
            this.sslParameters.setUseClientMode(false);
        }
        catch (KeyManagementException e) {
            this.instantiationException = new IOException("Delayed instantiation exception:");
            this.instantiationException.initCause(e);
        }
    }

    protected SSLServerSocketFactoryImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = (SSLParametersImpl)sslParameters.clone();
        this.sslParameters.setUseClientMode(false);
    }

    public String[] getDefaultCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return this.sslParameters.getEnabledCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return CipherSuite.getSupportedCipherSuiteNames();
    }

    public ServerSocket createServerSocket() throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLServerSocketImpl((SSLParametersImpl)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLServerSocketImpl(port, (SSLParametersImpl)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLServerSocketImpl(port, backlog, (SSLParametersImpl)this.sslParameters.clone());
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress iAddress) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLServerSocketImpl(port, backlog, iAddress, (SSLParametersImpl)this.sslParameters.clone());
    }
}

