/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import java.io.IOException;
import java.io.InputStream;

public abstract class SSLInputStream
extends InputStream {
    public abstract int available() throws IOException;

    public abstract int read() throws IOException;

    public int readUint8() throws IOException {
        return this.read() & 0xFF;
    }

    public int readUint16() throws IOException {
        return this.read() << 8 | this.read() & 0xFF;
    }

    public int readUint24() throws IOException {
        return this.read() << 16 | this.read() << 8 | this.read() & 0xFF;
    }

    public long readUint32() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read() & 0xFF;
    }

    public long readUint64() throws IOException {
        long hi = this.readUint32();
        long lo = this.readUint32();
        return hi << 32 | lo;
    }

    public byte[] read(int length) throws IOException {
        byte[] res = new byte[length];
        for (int i = 0; i < length; ++i) {
            res[i] = (byte)this.read();
        }
        return res;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        do {
            int read_b;
            if ((read_b = this.read()) == -1) {
                return i == 0 ? -1 : i;
            }
            b[off + i] = (byte)read_b;
        } while (this.available() != 0 && ++i < len);
        return i;
    }
}

